/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.border;

import org.eclipse.birt.report.designer.internal.ui.editors.ReportColorConstants;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.border.BorderUtil;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.border.LineBorder;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.ReportRootFigure;
import org.eclipse.birt.report.designer.util.ColorManager;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;

public class ReportDesignMarginBorder
extends LineBorder {
    private boolean needChangeStyle = true;
    private int backgroundColor = 0xFFFFFF;
    private Insets marginInsets;

    public ReportDesignMarginBorder(Insets insets) {
        this.setMarginInsets(insets);
    }

    public void setBackgroundColor(int color) {
        if (color != 0) {
            this.backgroundColor = color;
        }
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    @Override
    protected void drawBorder(IFigure figure, Graphics g, int side, int style, int[] width, int color, Insets insets) {
        Rectangle r = figure.getBounds().getCopy().crop(this.getMarginInsets()).crop(insets).crop(ReportRootFigure.DEFAULT_CROP).crop(new Insets(1, 1, 1, 1));
        if (style != 0 && this.needChangeStyle) {
            g.setForegroundColor(ColorManager.getColor((int)color));
            BorderUtil.drawBorderLine(g, side, style, width, r);
        } else {
            g.setForegroundColor(ReportColorConstants.MarginBorderColor);
            BorderUtil.drawDefaultLine(g, side, r);
        }
        g.restoreState();
    }

    @Override
    public Insets getBorderInsets() {
        return new Insets(this.marginInsets).add(super.getBorderInsets());
    }

    public void reInitStyle() {
        this.needChangeStyle = false;
    }

    public Insets getMarginInsets() {
        return new Insets(this.marginInsets);
    }

    @Override
    public Insets getInsets(IFigure figure) {
        return new Insets(this.marginInsets).add(super.getInsets(figure));
    }

    public void setMarginInsets(Insets marginInsets) {
        this.marginInsets = marginInsets;
    }
}

