/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.swt.custom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Listener;

public class MultiValueCombo
extends Combo {
    Map<Integer, ISelection> actionMap = new HashMap<Integer, ISelection>();
    SelectionListener selListener;
    ModifyListener modifyListener;
    VerifyListener verifyListener;
    KeyListener keyListener;
    boolean setTextBySelection = false;
    boolean addListenerLock = true;
    boolean keyPressed = false;
    boolean selected = false;
    String oldValue = null;
    boolean shouldSaveValue = false;
    boolean shouldClearValues = false;
    List<String> oldValueList = new ArrayList<String>();
    String[] selStrings = null;

    public String[] getSelStrings() {
        String[] ret = this.selStrings;
        if (ret == null) {
            return new String[0];
        }
        return ret;
    }

    protected void checkSubclass() {
    }

    public void setTextBySelection(boolean set) {
        this.setTextBySelection = set;
    }

    public MultiValueCombo(Composite parent, int style) {
        super(parent, style);
        this.actionMap.clear();
        this.initializeSelectionListener();
    }

    public void initializeSelectionListener() {
        this.keyListener = new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                MultiValueCombo combo = (MultiValueCombo)e.widget;
                String comboText = combo.getText();
                MultiValueCombo.this.oldValueList.clear();
                MultiValueCombo.this.oldValueList.add(comboText);
            }
        };
        this.selListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                String eText = e.text;
                MultiValueCombo combo = (MultiValueCombo)e.widget;
                String comboText = combo.getText();
                if (!MultiValueCombo.this.selected) {
                    return;
                }
                MultiValueCombo.this.selected = false;
                int index = combo.indexOf(comboText);
                if (index >= 0) {
                    ISelection action;
                    if (MultiValueCombo.this.oldValueList.size() > 0) {
                        MultiValueCombo.this.oldValue = MultiValueCombo.this.oldValueList.get(0);
                        MultiValueCombo.this.oldValueList.clear();
                    }
                    if ((action = MultiValueCombo.this.actionMap.get(index)) == null) {
                        MultiValueCombo.this.oldValue = comboText;
                        MultiValueCombo.this.oldValueList.add(MultiValueCombo.this.oldValue);
                        return;
                    }
                    MultiValueCombo.this.selStrings = action.doSelection(MultiValueCombo.this.oldValue);
                    String text = null;
                    if (MultiValueCombo.this.selStrings != null) {
                        if (MultiValueCombo.this.selStrings.length == 1) {
                            text = MultiValueCombo.this.selStrings[0];
                        } else if (MultiValueCombo.this.selStrings.length > 1) {
                            text = "";
                        }
                    }
                    if (text != null) {
                        MultiValueCombo.this.oldValue = text;
                    }
                    MultiValueCombo.this.oldValueList.add(MultiValueCombo.this.oldValue);
                    combo.select(-1);
                    combo.setText(MultiValueCombo.this.oldValue);
                    action.doAfterSelection(combo);
                }
            }
        };
        this.modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MultiValueCombo combo = (MultiValueCombo)e.widget;
                String comboText = combo.getText();
                if (MultiValueCombo.this.selected) {
                    return;
                }
                if (MultiValueCombo.this.shouldClearValues) {
                    MultiValueCombo.this.oldValueList.clear();
                    MultiValueCombo.this.shouldClearValues = false;
                }
                if (MultiValueCombo.this.shouldSaveValue) {
                    MultiValueCombo.this.oldValueList.add(comboText);
                    MultiValueCombo.this.shouldSaveValue = false;
                }
            }
        };
        this.verifyListener = new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                MultiValueCombo.this.selected = false;
                MultiValueCombo combo = (MultiValueCombo)e.widget;
                String eText = e.text;
                if (combo.indexOf(eText) >= 0) {
                    MultiValueCombo.this.selected = true;
                    if (combo.indexOf(combo.getText()) < 0) {
                        MultiValueCombo.this.oldValueList.add(combo.getText());
                        MultiValueCombo.this.shouldClearValues = false;
                        MultiValueCombo.this.shouldSaveValue = false;
                    }
                    return;
                }
                if (!eText.equals("")) {
                    MultiValueCombo.this.shouldClearValues = true;
                    MultiValueCombo.this.shouldSaveValue = true;
                }
            }
        };
        this.addListenerLock = false;
        super.addKeyListener(this.keyListener);
        super.addSelectionListener(this.selListener);
        this.addListenerLock = true;
        super.addModifyListener(this.modifyListener);
        super.addVerifyListener(this.verifyListener);
    }

    public void addSelectionListener(SelectionListener listener) {
    }

    public void addKeyListener(KeyListener listener) {
    }

    public void addListener(int eventType, Listener listener) {
        if (this.addListenerLock && (eventType == 13 || eventType == 2 || eventType == 1)) {
            return;
        }
        super.addListener(eventType, listener);
    }

    public void addSelectionListener(int index, ISelection selection) {
        this.actionMap.put(index, selection);
    }

    public void removeSelectionListener(int index) {
        this.actionMap.remove(index);
    }

    public static interface ISelection {
        public String[] doSelection(String var1);

        public void doAfterSelection(MultiValueCombo var1);
    }
}

