/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.swt.custom;

import org.eclipse.birt.report.designer.internal.ui.swt.custom.IBaseTableAreaModifier;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.ISortedTableAreaModifier;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.ITableAreaModifier;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class TableArea
extends Composite {
    private static final String BUTTON_NEW = Messages.getString((String)"TableArea.Button.New");
    private static final String BUTTON_EDIT = Messages.getString((String)"TableArea.Button.Edit");
    private static final String BUTTON_REMOVE = Messages.getString((String)"TableArea.Button.Remove");
    private static final String BUTTON_REMOVE_ALL = Messages.getString((String)"TableArea.Button.RemoveAll");
    private static final String BUTTON_UP = Messages.getString((String)"TableArea.Button.Up");
    private static final String BUTTON_DOWN = Messages.getString((String)"TableArea.Button.Down");
    private TableViewer tableViewer;
    private IBaseTableAreaModifier modifier;
    private Button newButton;
    private Button editButton;
    private Button removeButton;
    private Button upButton;
    private Button downButton;
    private Button removeAllButton;
    private Table table;
    private Composite buttonBar;

    public TableArea(Composite parent, int tableStyle, IBaseTableAreaModifier modifier) {
        super(parent, 0);
        Assert.isNotNull((Object)modifier);
        this.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin(2, false));
        this.modifier = modifier;
        this.createTableViewer(tableStyle);
        this.createButtonBar();
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        Point tableSize = this.table.computeSize(wHint, hHint, changed);
        Point buttonsSize = this.buttonBar.computeSize(wHint, hHint, changed);
        int x = tableSize.x + buttonsSize.x + 5;
        int y = Math.max(tableSize.y, buttonsSize.y);
        return new Point(x, y);
    }

    protected void createTableViewer(int tableStyle) {
        this.table = new Table((Composite)this, tableStyle | 0x10000 | 0x800);
        this.table.setLayoutData((Object)new GridData(1808));
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.tableViewer = (tableStyle & 0x20) != 0 ? new CheckboxTableViewer(this.table) : new TableViewer(this.table);
        if (this.modifier instanceof ITableAreaModifier) {
            this.table.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    if (e.keyCode == 127 && e.stateMask == 0 && !TableArea.this.getSelection().isEmpty()) {
                        TableArea.this.doRemove();
                    }
                }
            });
        }
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (TableArea.this.getSelection().size() == 1) {
                    TableArea.this.doEdit();
                }
            }
        });
    }

    protected Composite createButtonBar() {
        this.buttonBar = new Composite((Composite)this, 0);
        this.buttonBar.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin());
        GridData gd = new GridData();
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        this.buttonBar.setLayoutData((Object)gd);
        if (this.modifier instanceof ITableAreaModifier) {
            this.newButton = new Button(this.buttonBar, 8);
            this.newButton.setText(BUTTON_NEW);
            this.setButtonLayout(this.newButton);
            this.newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (((ITableAreaModifier)TableArea.this.modifier).newItem()) {
                        TableArea.this.tableViewer.refresh();
                        TableArea.this.updateButtons();
                    }
                }
            });
        }
        this.editButton = new Button(this.buttonBar, 8);
        this.editButton.setText(BUTTON_EDIT);
        this.setButtonLayout(this.editButton);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableArea.this.doEdit();
            }
        });
        this.editButton.setEnabled(false);
        if (this.modifier instanceof ITableAreaModifier) {
            this.removeButton = new Button(this.buttonBar, 8);
            this.removeButton.setText(BUTTON_REMOVE);
            this.setButtonLayout(this.removeButton);
            this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TableArea.this.doRemove();
                }
            });
            this.removeButton.setEnabled(false);
            this.removeAllButton = new Button(this.buttonBar, 8);
            this.removeAllButton.setText(BUTTON_REMOVE_ALL);
            this.setButtonLayout(this.removeAllButton);
            this.removeAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TableArea.this.doRemoveAll();
                }
            });
            this.removeButton.setEnabled(false);
        }
        if (this.modifier instanceof ISortedTableAreaModifier) {
            this.upButton = new Button(this.buttonBar, 8);
            this.upButton.setText(BUTTON_UP);
            this.setButtonLayout(this.upButton);
            this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IStructuredSelection selection = (IStructuredSelection)TableArea.this.tableViewer.getSelection();
                    if (((ISortedTableAreaModifier)TableArea.this.modifier).moveUp(selection.getFirstElement())) {
                        TableArea.this.tableViewer.refresh();
                        TableArea.this.updateButtons();
                    }
                }
            });
            this.upButton.setEnabled(false);
            this.downButton = new Button(this.buttonBar, 8);
            this.downButton.setText(BUTTON_DOWN);
            this.setButtonLayout(this.downButton);
            this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IStructuredSelection selection = (IStructuredSelection)TableArea.this.tableViewer.getSelection();
                    if (((ISortedTableAreaModifier)TableArea.this.modifier).moveDown(selection.getFirstElement())) {
                        TableArea.this.tableViewer.refresh();
                        TableArea.this.updateButtons();
                    }
                }
            });
            this.downButton.setEnabled(false);
        }
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TableArea.this.updateButtons();
            }
        });
        return this.buttonBar;
    }

    protected void setButtonLayout(Button button) {
        GridData gd = new GridData(768);
        button.setLayoutData((Object)gd);
    }

    private IStructuredSelection getSelection() {
        return (IStructuredSelection)this.tableViewer.getSelection();
    }

    public void updateButtons() {
        boolean enable = this.getSelection().size() == 1;
        this.editButton.setEnabled(enable);
        if (this.modifier instanceof ISortedTableAreaModifier) {
            int index = this.tableViewer.getTable().getSelectionIndex();
            this.upButton.setEnabled(enable && index != 0);
            this.downButton.setEnabled(enable && index != this.tableViewer.getTable().getItemCount() - 1);
        }
        if (this.modifier instanceof ITableAreaModifier) {
            this.removeButton.setEnabled(!this.getSelection().isEmpty());
            this.removeAllButton.setEnabled(this.tableViewer.getTable().getItemCount() > 0);
        }
    }

    public Table getTable() {
        if (this.tableViewer != null) {
            return this.tableViewer.getTable();
        }
        return null;
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public void setInput(Object input) {
        this.tableViewer.setInput(input);
        this.updateButtons();
    }

    private void doEdit() {
        if (this.modifier.editItem(this.getSelection().getFirstElement())) {
            this.tableViewer.refresh();
            this.updateButtons();
        }
    }

    private void doRemove() {
        int selectIndex = this.tableViewer.getTable().getSelectionIndex();
        if (((ITableAreaModifier)this.modifier).removeItem(this.getSelection().toArray())) {
            this.tableViewer.refresh();
            int count = this.tableViewer.getTable().getItemCount();
            if (count > 0) {
                if (selectIndex >= count) {
                    selectIndex = count - 1;
                }
                this.tableViewer.getTable().select(selectIndex);
            }
            this.updateButtons();
        }
    }

    private void doRemoveAll() {
        if (((ITableAreaModifier)this.modifier).removeItemAll()) {
            this.tableViewer.refresh();
            this.updateButtons();
        }
    }
}

