/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.font;

import com.lowagie.text.pdf.BaseFont;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.birt.report.engine.layout.pdf.font.CompositeFont;
import org.eclipse.birt.report.engine.layout.pdf.font.CompositeFontConfig;
import org.eclipse.birt.report.engine.layout.pdf.font.FontMappingConfig;
import org.eclipse.birt.report.engine.layout.pdf.font.FontMappingManagerFactory;

public class FontMappingManager {
    public static final String FONT_NAME_ALL_FONTS = "all-fonts";
    public static final String DEFAULT_FONT = "Times-Roman";
    private FontMappingManagerFactory factory;
    private FontMappingManager parent;
    private Map<String, String> fontEncodings = new HashMap<String, String>();
    private Map<String, String[]> searchSequences = new HashMap<String, String[]>();
    private Map<String, String> fontAliases = new HashMap<String, String>();
    private boolean fontKerningAndLigaturesUsage = false;
    private Map<String, CompositeFont> compositeFonts = new HashMap<String, CompositeFont>();

    FontMappingManager(FontMappingManagerFactory factory, FontMappingManager parent, FontMappingConfig config, Locale locale) {
        this.factory = factory;
        this.parent = parent;
        if (parent != null) {
            this.searchSequences.putAll(parent.getSearchSequences());
            this.fontAliases.putAll(parent.getFontAliases());
            this.fontEncodings.putAll(parent.getFontEncodings());
            this.compositeFonts.putAll(parent.getCompositeFonts());
            if (!this.fontKerningAndLigaturesUsage) {
                this.fontKerningAndLigaturesUsage = parent.fontKerningAndLigaturesUsage;
            }
        }
        this.fontEncodings.putAll(config.fontEncodings);
        this.searchSequences.putAll(config.searchSequences);
        this.fontAliases.putAll(config.fontAliases);
        if (!this.fontKerningAndLigaturesUsage) {
            this.fontKerningAndLigaturesUsage = config.fontKerningAndLigaturesUsage;
        }
        String[] sequence = this.getSearchSequence(locale);
        for (Map.Entry<String, CompositeFontConfig> entry : config.compositeFonts.entrySet()) {
            String fontName = entry.getKey();
            CompositeFontConfig fontConfig = entry.getValue();
            CompositeFont font = factory.createCompositeFont(this, fontConfig, sequence);
            this.compositeFonts.put(fontName, font);
        }
    }

    public FontMappingManager getParent() {
        return this.parent;
    }

    public Map<String, String> getFontEncodings() {
        return this.fontEncodings;
    }

    public Map<String, String> getFontAliases() {
        return this.fontAliases;
    }

    public Map<String, String[]> getSearchSequences() {
        return this.searchSequences;
    }

    public Map<String, CompositeFont> getCompositeFonts() {
        return this.compositeFonts;
    }

    public boolean useFontKerningAndLigatures() {
        return this.fontKerningAndLigaturesUsage;
    }

    protected String[] getSearchSequence(Locale locale) {
        StringBuilder sb = new StringBuilder();
        String[] localeKeys = new String[3];
        localeKeys[2] = sb.append(locale.getLanguage()).toString();
        localeKeys[1] = sb.append('_').append(locale.getCountry()).toString();
        localeKeys[0] = sb.append('_').append(locale.getVariant()).toString();
        int i = 0;
        while (i < localeKeys.length) {
            String[] sequence = this.searchSequences.get(localeKeys[i]);
            if (sequence != null) {
                return sequence;
            }
            ++i;
        }
        return null;
    }

    public CompositeFont getCompositeFont(String name) {
        return this.compositeFonts.get(name);
    }

    public String getDefaultPhysicalFont(char c) {
        CompositeFont compositeFont = this.compositeFonts.get(FONT_NAME_ALL_FONTS);
        if (compositeFont != null) {
            String font = compositeFont.getUsedFont(c);
            if (font != null) {
                return font;
            }
            return compositeFont.getDefaultFont();
        }
        return null;
    }

    public String getAliasedFont(String fontAlias) {
        String alias = this.fontAliases.get(fontAlias.toLowerCase());
        if (alias != null) {
            return alias;
        }
        return fontAlias;
    }

    public BaseFont createFont(String fontFamily, int fontStyle) {
        return this.factory.createFont(fontFamily, fontStyle);
    }
}

