/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.presentation;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.presentation.InstanceIndex;

public class PageSection {
    public static final int TYPE_AUTO_LAYOUT_PAGE_SECTION = 0;
    public static final int TYPE_FIXED_LAYOUT_PAGE_SECTION = 1;
    public long startOffset;
    public long endOffset;
    public InstanceIndex[] starts;
    public InstanceIndex[] ends;

    public void write(DataOutputStream out) throws IOException {
        IOUtil.writeInt((OutputStream)out, (int)0);
        this.writeInstanceIndex(out, this.starts);
        this.writeInstanceIndex(out, this.ends);
    }

    public void read(DataInputStream in) throws IOException {
        this.starts = this.readInstanceIndex(in);
        this.ends = this.readInstanceIndex(in);
        this.startOffset = this.starts[this.starts.length - 1].getOffset();
        this.endOffset = this.ends[this.ends.length - 1].getOffset();
    }

    protected void writeInstanceIndex(DataOutputStream out, InstanceIndex[] indexes) throws IOException {
        if (indexes == null) {
            IOUtil.writeInt((OutputStream)out, (int)0);
            return;
        }
        IOUtil.writeInt((OutputStream)out, (int)indexes.length);
        int i = 0;
        while (i < indexes.length) {
            IOUtil.writeString((DataOutputStream)out, (String)indexes[i].getInstanceID().toUniqueString());
            IOUtil.writeLong((DataOutputStream)out, (long)indexes[i].getOffset());
            ++i;
        }
    }

    protected InstanceIndex[] readInstanceIndex(DataInputStream in) throws IOException {
        int length = IOUtil.readInt((InputStream)in);
        InstanceIndex[] indexes = new InstanceIndex[length];
        int i = 0;
        while (i < length) {
            String id = IOUtil.readString((DataInputStream)in);
            long offset = IOUtil.readLong((DataInputStream)in);
            indexes[i] = new InstanceIndex(InstanceID.parse(id), offset);
            ++i;
        }
        return indexes;
    }
}

