/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.ISlotDefn;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.api.validators.StyleReferenceValidator;
import org.eclipse.birt.report.model.api.validators.UnsupportedElementValidator;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ExtensionPropertyDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.MetaDataException;
import org.eclipse.birt.report.model.metadata.MetaLogManager;
import org.eclipse.birt.report.model.metadata.NameConfig;
import org.eclipse.birt.report.model.metadata.ObjectDefn;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.SemanticTriggerDefn;
import org.eclipse.birt.report.model.metadata.SemanticTriggerDefnSet;
import org.eclipse.birt.report.model.metadata.SlotDefn;
import org.eclipse.birt.report.model.metadata.SystemPropertyDefn;
import org.eclipse.birt.report.model.validators.AbstractElementValidator;

public class ElementDefn
extends ObjectDefn
implements IElementDefn {
    private static Logger logger = Logger.getLogger(ElementDefn.class.getName());
    protected static final String HIDDEN_IN_PROPERTY_SHEET = "hide";
    protected static final String UNHIDDEN_IN_PROPERTY_SHEET = "unhide";
    protected static final String READONLY_IN_PROPERTY_SHEET = "readonly";
    protected static final int NO_VISIBILITY_KEY = 0;
    protected static final int HIDDEN_IN_PROPERTY_SHEET_KEY = 1;
    protected static final int READONLY_KEY = 2;
    protected static final String VISIBILITY_SEPERATOR = ",";
    protected boolean abstractElement = false;
    protected String extendsFrom = null;
    protected ElementDefn parent = null;
    protected boolean hasStyle = false;
    protected boolean isBuilt = false;
    protected String selector = null;
    protected boolean supportsUserProperties = true;
    protected ArrayList<String> stylePropertyNames = null;
    protected List<ISlotDefn> slots = null;
    protected boolean allowExtend = true;
    protected String javaClass = null;
    private SemanticTriggerDefnSet triggerDefnSet = null;
    protected Map<String, Integer> propVisibilites = null;
    protected Map<String, Integer> cachedPropVisibilites = null;
    protected String xmlName;
    protected Map<String, IElementPropertyDefn> cachedProperties = new LinkedHashMap<String, IElementPropertyDefn>();
    protected boolean isContainer = false;
    protected List<IElementPropertyDefn> cachedContainerProperties = null;
    protected NameConfig nameConfig = new NameConfig();
    private boolean isSlotIDSpecifiedByROM = false;

    public void setJavaClass(String theClass) {
        assert (!this.isBuilt);
        this.javaClass = theClass;
    }

    public void setSelector(String value) {
        this.selector = value;
    }

    public void setExtends(String base) {
        assert (!this.isBuilt);
        this.extendsFrom = base;
    }

    public void setSupportsUserProperties(boolean flag) {
        assert (!this.isBuilt);
        this.supportsUserProperties = flag;
    }

    public String getExtends() {
        return this.extendsFrom;
    }

    public String getJavaClass() {
        return this.javaClass;
    }

    @Override
    public boolean hasStyle() {
        return this.hasStyle;
    }

    public void setHasStyle(boolean flag) {
        assert (!this.isBuilt);
        this.hasStyle = flag;
    }

    @Override
    public List<IElementPropertyDefn> getLocalProperties() {
        return new ArrayList<IElementPropertyDefn>(this.properties.values());
    }

    @Override
    public List<IElementPropertyDefn> getProperties() {
        return new ArrayList<IElementPropertyDefn>(this.cachedProperties.values());
    }

    @Override
    public IElementPropertyDefn getProperty(String propName) {
        assert (propName != null);
        return this.cachedProperties.get(propName);
    }

    @Override
    public List<IElementPropertyDefn> getContents() {
        return this.cachedContainerProperties;
    }

    protected final void buildContainerProperties() {
        this.cachedContainerProperties = new ArrayList<IElementPropertyDefn>();
        for (IElementPropertyDefn defn : this.cachedProperties.values()) {
            if (defn.getTypeCode() != 23) continue;
            this.cachedContainerProperties.add(defn);
        }
        if (this.cachedContainerProperties.isEmpty()) {
            this.cachedContainerProperties = Collections.emptyList();
        }
    }

    @Override
    public List<IElementPropertyDefn> getMethods() {
        return this.getPropertyListWithType(this.getProperties(), 18);
    }

    @Override
    public List<IElementPropertyDefn> getLocalMethods() {
        return this.getPropertyListWithType(this.getLocalProperties(), 18);
    }

    @Override
    public List<IElementPropertyDefn> getExpressions() {
        return this.getPropertyListWithType(this.getProperties(), 7);
    }

    @Override
    public List<IElementPropertyDefn> getLocalExpressions() {
        return this.getPropertyListWithType(this.getLocalProperties(), 7);
    }

    private List<IElementPropertyDefn> getPropertyListWithType(List<IElementPropertyDefn> propList, int type) {
        ArrayList<IElementPropertyDefn> props = new ArrayList<IElementPropertyDefn>();
        for (IElementPropertyDefn propDefn : propList) {
            if (propDefn.getTypeCode() != type) continue;
            props.add(propDefn);
        }
        return props;
    }

    protected void build() throws MetaDataException {
        if (this.isBuilt) {
            return;
        }
        this.buildDefn();
        this.buildProperties();
        this.buildPropertiesVisibility();
        if (!this.isAbstract()) {
            this.checkJavaClass();
            this.checkXmlName();
        }
        this.buildContainerProperties();
        this.buildSlots();
        this.buildTriggerDefnSet();
        this.isBuilt = true;
    }

    @Override
    protected void buildDefn() throws MetaDataException {
        MetaDataDictionary dd = MetaDataDictionary.getInstance();
        if (this.extendsFrom != null) {
            this.parent = (ElementDefn)dd.getElement(this.extendsFrom);
            if (this.parent == null) {
                throw new MetaDataException(new String[]{this.extendsFrom, this.name}, "ELEMENT_PARENT_NOT_FOUND");
            }
            this.parent.build();
            if (this.parent.hasStyle() && !this.isExtendedElement()) {
                this.hasStyle = true;
            }
        }
        if ((this.parent == null || !this.parent.hasStyle()) && this.hasStyle) {
            SystemPropertyDefn prop = new SystemPropertyDefn();
            prop.setName("style");
            prop.setType(dd.getPropertyType(15));
            prop.setDisplayNameID("Element.ReportElement.style");
            prop.setDetails("Style");
            prop.setIntrinsic(true);
            this.addProperty(prop);
        }
        if (this.parent != null && this.parent.allowsUserProperties()) {
            this.supportsUserProperties = true;
        }
        if (this.parent != null && this.parent.isContainer) {
            this.isContainer = true;
        }
        if (this.isAbstract() && this.parent != null && !this.parent.isAbstract()) {
            throw new MetaDataException(new String[]{this.name, this.parent.getName()}, "ILLEGAL_ABSTRACT_ELEMENT");
        }
        this.buildNameConfig();
        if (this.nameConfig.nameOption == 0 || this.isAbstract()) {
            this.allowExtend = false;
        }
    }

    private void buildNameConfig() throws MetaDataException {
        if (this.nameConfig.nameSpaceID != "NONE") {
            if (this.nameConfig.holder == null) {
                this.nameConfig.holder = MetaDataDictionary.getInstance().getElement("Module");
            }
            if (this.nameConfig.targetPropertyName != null) {
                this.nameConfig.targetProperty = (ElementPropertyDefn)MetaDataDictionary.getInstance().getElement("ReportDesign").getProperty(this.nameConfig.targetPropertyName);
                if (this.nameConfig.targetProperty == null) {
                    throw new MetaDataException("INVALID_NAME_SPACE");
                }
            }
        } else if (this.parent != null) {
            this.nameConfig.nameSpaceID = this.parent.getNameSpaceID();
            this.nameConfig.holder = this.parent.nameConfig.holder;
            this.nameConfig.targetProperty = this.parent.nameConfig.targetProperty;
        }
        if (!this.isAbstract() && this.nameConfig.nameSpaceID != "NONE" && this.nameConfig.holder == null) {
            throw new MetaDataException(new String[]{this.name}, "INVALID_NAME_OPTION");
        }
    }

    private void buildStyleProperties() throws MetaDataException {
        this.addStyleProperties();
        if (this.isExtendedElement()) {
            if (this.hasStyle) {
                List<IElementPropertyDefn> styles = MetaDataDictionary.getInstance().getStyle().getLocalProperties();
                int i = 0;
                while (i < styles.size()) {
                    String propName = ((SystemPropertyDefn)styles.get(i)).getName();
                    this.properties.put(propName, (IPropertyDefn)styles.get(i));
                    ++i;
                }
            }
        } else if (!this.hasStyle && this.stylePropertyNames != null || this.hasStyle && this.isContainer() && this.stylePropertyNames != null) {
            throw new MetaDataException(new String[]{this.name}, "ILLEGAL_STYLE_PROPS");
        }
    }

    protected void buildTriggerDefnSet() {
        AbstractElementValidator validator = UnsupportedElementValidator.getInstance();
        SemanticTriggerDefn triggerDefn = new SemanticTriggerDefn(validator.getName());
        triggerDefn.setValidator(validator);
        this.getTriggerDefnSet().add(triggerDefn);
        if (this.hasStyle) {
            validator = StyleReferenceValidator.getInstance();
            triggerDefn = new SemanticTriggerDefn("StyleReferenceValidator");
            triggerDefn.setValidator(validator);
            this.getTriggerDefnSet().add(triggerDefn);
        }
        List<IElementPropertyDefn> propList = this.getProperties();
        for (PropertyDefn propertyDefn : propList) {
            this.mergeTriggerDefnSet(propertyDefn.getTriggerDefnSet());
        }
        Iterator<ISlotDefn> iterator = this.slotsIterator();
        while (iterator.hasNext()) {
            SlotDefn slotDefn = (SlotDefn)iterator.next();
            this.mergeTriggerDefnSet(slotDefn.getTriggerDefnSet());
        }
    }

    private void mergeTriggerDefnSet(SemanticTriggerDefnSet toMerge) {
        List<SemanticTriggerDefn> triggerDefns = toMerge.getTriggerList();
        if (triggerDefns == null || triggerDefns.isEmpty()) {
            return;
        }
        for (SemanticTriggerDefn triggerDefn : triggerDefns) {
            String targetName = triggerDefn.getTargetElement();
            if (StringUtil.isBlank(targetName)) {
                this.getTriggerDefnSet().add(triggerDefn);
                continue;
            }
            ElementDefn targetDefn = (ElementDefn)MetaDataDictionary.getInstance().getElement(targetName);
            if (!this.isKindOf(targetDefn)) continue;
            this.getTriggerDefnSet().add(triggerDefn);
        }
    }

    private void checkXmlName() throws MetaDataException {
        if (StringUtil.isBlank(this.xmlName)) {
            throw new MetaDataException(new String[]{this.name}, "MISSING_XML_NAME");
        }
    }

    private void checkJavaClass() throws MetaDataException {
        if (StringUtil.isBlank(this.javaClass)) {
            throw new MetaDataException(new String[]{this.name}, "MISSING_JAVA_CLASS");
        }
        try {
            Class<?> c;
            Class<?> clazz = c = Class.forName(this.javaClass);
            while (clazz.getSuperclass() != null) {
                if (clazz == DesignElement.class) break;
                clazz = clazz.getSuperclass();
            }
            if (clazz != DesignElement.class) {
                throw new MetaDataException(new String[]{this.javaClass}, "INVALID_ELEMENT_JAVA_CLASS");
            }
        }
        catch (ClassNotFoundException e) {
            throw new MetaDataException(new String[]{this.name, this.javaClass}, "JAVA_CLASS_LOAD_ERROR");
        }
    }

    protected void buildProperties() throws MetaDataException {
        this.buildLocalProperties();
        this.buildStyleProperties();
        this.buildCachedPropertyDefns();
        this.buildOdaDataSetProperties();
    }

    private void buildOdaDataSetProperties() {
        if ("OdaDataSet".equalsIgnoreCase(this.name)) {
            ElementPropertyDefn resultSetHints = (ElementPropertyDefn)this.cachedProperties.get("resultSetHints");
            if (resultSetHints == null) {
                return;
            }
            ElementPropertyDefn clonedDefn = (ElementPropertyDefn)this.reflectClass(resultSetHints);
            if (clonedDefn == null) {
                return;
            }
            clonedDefn.details = MetaDataDictionary.getInstance().getStructure("OdaResultSetColumn");
            clonedDefn.definedBy = this;
            this.cachedProperties.put("resultSetHints", clonedDefn);
            ElementPropertyDefn params = (ElementPropertyDefn)this.cachedProperties.get("parameters");
            if (params == null) {
                return;
            }
            clonedDefn = (ElementPropertyDefn)this.reflectClass(params);
            if (clonedDefn == null) {
                return;
            }
            clonedDefn.details = MetaDataDictionary.getInstance().getStructure("OdaDataSetParam");
            clonedDefn.definedBy = this;
            this.cachedProperties.put("parameters", clonedDefn);
        }
    }

    protected PropertyDefn reflectClass(PropertyDefn defn) {
        ElementPropertyDefn retDefn = null;
        String className = defn.getClass().getName();
        try {
            Class<?> clazz = Class.forName(className);
            retDefn = (ElementPropertyDefn)clazz.newInstance();
            Class<?> ownerClass = defn.getClass();
            Class<?> clonedClass = retDefn.getClass();
            this.shadowCopyProperties(defn, retDefn, ownerClass, clonedClass);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            logger.log(Level.WARNING, e.getMessage());
            MetaLogManager.log("Overrides property error", e);
        }
        if (retDefn == null) {
            return null;
        }
        this.shadowCopyProperties(defn, retDefn, defn.getClass(), ExtensionPropertyDefn.class);
        return retDefn;
    }

    private void shadowCopyProperties(PropertyDefn defn, PropertyDefn clonedDefn, Class<? extends Object> ownerClass, Class<? extends Object> clonedClass) {
        if (ownerClass == null || clonedClass == null) {
            return;
        }
        Field[] fields = ownerClass.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            Field field = fields[i];
            if ((field.getModifiers() & 8) == 0) {
                try {
                    Object property = field.get(defn);
                    Field clonedField = ownerClass.getDeclaredField(field.getName());
                    clonedField.set(clonedDefn, property);
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                    logger.log(Level.WARNING, e.getMessage());
                    MetaLogManager.log("Overrides property error", e);
                }
            }
            ++i;
        }
        this.shadowCopyProperties(defn, clonedDefn, ownerClass.getSuperclass(), clonedClass.getSuperclass());
    }

    protected void buildLocalProperties() throws MetaDataException {
        boolean isStyle = "Style".equals(this.name);
        for (ElementPropertyDefn prop : this.properties.values()) {
            if (prop.isStyleProperty() && !isStyle) {
                throw new MetaDataException(new String[]{this.name, prop.getName()}, "INVALID_STYLE_PROP_OPTION");
            }
            prop.build();
        }
    }

    private void buildCachedPropertyDefns() {
        ElementDefn tmpDefn = this;
        while (tmpDefn != null) {
            this.cachedProperties.putAll(tmpDefn.properties);
            tmpDefn = tmpDefn.parent;
        }
        if (this.hasStyle()) {
            ElementDefn style;
            IPropertyDefn sourcePropertyDefn;
            if (this.cachedProperties.get("height") != null && (sourcePropertyDefn = (IPropertyDefn)this.cachedProperties.get("height")) instanceof IElementPropertyDefn && !((IElementPropertyDefn)sourcePropertyDefn).isStyleProperty() && (style = (ElementDefn)MetaDataDictionary.getInstance().getStyle()).getProperty("height") != null && !"masterPage".equalsIgnoreCase(this.getName())) {
                this.cachedProperties.put("height", style.getProperty("height"));
            }
            if (this.cachedProperties.get("width") != null && (sourcePropertyDefn = (IPropertyDefn)this.cachedProperties.get("width")) instanceof IElementPropertyDefn && !((IElementPropertyDefn)sourcePropertyDefn).isStyleProperty() && (style = (ElementDefn)MetaDataDictionary.getInstance().getStyle()).getProperty("width") != null && !"masterPage".equalsIgnoreCase(this.getName())) {
                this.cachedProperties.put("width", style.getProperty("width"));
            }
        }
    }

    private void addStyleProperties() throws MetaDataException {
        if (!this.hasStyle()) {
            return;
        }
        if (this.isContainer()) {
            List<IElementPropertyDefn> styleProperties = MetaDataDictionary.getInstance().getStyle().getLocalProperties();
            int i = 0;
            while (i < styleProperties.size()) {
                PropertyDefn prop = (PropertyDefn)((Object)styleProperties.get(i));
                if (!("Row".equals(this.getName()) && "width".equalsIgnoreCase(prop.getName()) || "Column".equals(this.getName()) && "height".equalsIgnoreCase(prop.getName()))) {
                    this.properties.put(prop.getName(), prop);
                }
                ++i;
            }
        } else {
            if (this.stylePropertyNames == null) {
                return;
            }
            ElementDefn style = (ElementDefn)MetaDataDictionary.getInstance().getStyle();
            int i = 0;
            while (i < this.stylePropertyNames.size()) {
                String propName = this.stylePropertyNames.get(i);
                if (this.cachedProperties.get(propName) == null) {
                    SystemPropertyDefn prop = (SystemPropertyDefn)style.cachedProperties.get(propName);
                    if (prop == null) {
                        throw new MetaDataException(new String[]{propName, this.name}, "STYLE_PROP_NOT_FOUND");
                    }
                    assert (prop.isStyleProperty());
                    this.properties.put(prop.getName(), prop);
                }
                ++i;
            }
        }
    }

    protected void buildPropertiesVisibility() {
        if (this.parent != null && this.parent.cachedPropVisibilites != null) {
            if (this.cachedPropVisibilites == null) {
                this.cachedPropVisibilites = new HashMap<String, Integer>();
            }
            this.cachedPropVisibilites.putAll(this.parent.cachedPropVisibilites);
        }
        if (this.propVisibilites != null) {
            if (this.cachedPropVisibilites == null) {
                this.cachedPropVisibilites = new HashMap<String, Integer>();
            }
            for (String propName : this.propVisibilites.keySet()) {
                if (this.cachedProperties.get(propName) == null) {
                    String message = new MetaDataException(new String[]{this.name, propName}, "VISIBILITY_PROPERTY_NOT_FOUND").getMessage();
                    logger.log(Level.WARNING, message);
                    MetaLogManager.log(message);
                    continue;
                }
                Integer visibility = this.propVisibilites.get(propName);
                this.cachedPropVisibilites.put(propName, visibility);
            }
            this.propVisibilites = null;
        }
    }

    protected void buildSlots() throws MetaDataException {
        if (this.slots != null && this.slots.size() == 0) {
            this.slots = null;
        }
        if (this.slots == null) {
            return;
        }
        int i = 0;
        while (i < this.slots.size()) {
            SlotDefn slot = (SlotDefn)this.slots.get(i);
            if (slot.getSlotID() == -1) {
                slot.setSlotID(i);
            } else {
                this.isSlotIDSpecifiedByROM = true;
            }
            slot.build();
            ++i;
        }
    }

    @Override
    public List<String> getGroupNames() {
        ArrayList<String> groupNames = new ArrayList<String>();
        for (SystemPropertyDefn systemPropertyDefn : this.getProperties()) {
            String groupName = systemPropertyDefn.getGroupName();
            if (groupName == null || groupNames.contains(groupName)) continue;
            groupNames.add(groupName);
        }
        return groupNames;
    }

    @Override
    public boolean allowsUserProperties() {
        return this.supportsUserProperties;
    }

    public void setAllowsUserProperties(boolean flag) {
        assert (!this.isBuilt);
        this.supportsUserProperties = flag;
    }

    public boolean isAbstract() {
        return this.abstractElement;
    }

    public String getSelector() {
        return this.selector;
    }

    public IElementDefn getParent() {
        return this.parent;
    }

    public void setParent(ElementDefn parent) {
        this.parent = parent;
    }

    void addStyleProperty(String propName) {
        assert (!this.isBuilt);
        if (this.stylePropertyNames == null) {
            this.stylePropertyNames = new ArrayList();
        }
        this.stylePropertyNames.add(propName);
    }

    public String getNameSpaceID() {
        return this.nameConfig.nameSpaceID;
    }

    @Override
    public int getNameOption() {
        return this.nameConfig.nameOption;
    }

    @Override
    public boolean isContainer() {
        return this.slots != null || this.isContainer;
    }

    @Override
    public int getSlotCount() {
        if (this.slots == null) {
            return 0;
        }
        return this.slots.size();
    }

    @Override
    public boolean hasSlot(int slotID) {
        return this.getSlot(slotID) != null;
    }

    public Iterator<ISlotDefn> slotsIterator() {
        if (this.slots == null) {
            return Collections.emptyList().iterator();
        }
        return this.slots.iterator();
    }

    @Override
    public ISlotDefn getSlot(int slotID) {
        if (this.slots == null || slotID < 0) {
            return null;
        }
        if (!this.isSlotIDSpecifiedByROM) {
            if (slotID >= this.slots.size()) {
                return null;
            }
            return this.slots.get(slotID);
        }
        int i = 0;
        while (i < this.slots.size()) {
            ISlotDefn tmpSlotDefn = this.slots.get(i);
            if (tmpSlotDefn.getSlotID() == slotID) {
                return tmpSlotDefn;
            }
            ++i;
        }
        assert (false);
        return null;
    }

    @Override
    public boolean canContain(int slot, IElementDefn type) {
        if (this.slots == null || slot < 0 || slot > this.slots.size() - 1) {
            return false;
        }
        return ((SlotDefn)this.slots.get(slot)).canContain(type);
    }

    @Override
    public boolean isKindOf(IElementDefn type) {
        if (type == this) {
            return true;
        }
        if (type == null) {
            return false;
        }
        ElementDefn obj = this.parent;
        while (obj != null) {
            if (obj == type) {
                return true;
            }
            obj = obj.parent;
        }
        return false;
    }

    void addSlot(SlotDefn slot) {
        if (slot == null) {
            return;
        }
        if (this.slots == null) {
            this.slots = new ArrayList<ISlotDefn>();
        }
        this.slots.add(slot);
    }

    void setNameSpaceID(String ns) {
        assert (!this.isBuilt);
        this.nameConfig.nameSpaceID = ns;
        if ("NONE".equals(this.nameConfig.nameSpaceID)) {
            this.nameConfig.nameOption = 0;
        }
    }

    void setNameOption(int choice) {
        this.nameConfig.nameOption = choice;
    }

    public void setCanExtend(boolean flag) {
        this.allowExtend = flag;
    }

    @Override
    public boolean canExtend() {
        if (this.nameConfig.getNameSpaceID() == "NONE") {
            return this.allowExtend;
        }
        IElementDefn holderDefn = this.getNameConfig().getNameContainer();
        return this.allowExtend && holderDefn != null && holderDefn.isKindOf(MetaDataDictionary.getInstance().getElement("Module"));
    }

    public void setAbstract(boolean flag) {
        this.abstractElement = flag;
    }

    @Override
    public IPropertyDefn findProperty(String propName) {
        return this.cachedProperties.get(propName);
    }

    @Override
    public void addProperty(PropertyDefn property) throws MetaDataException {
        if (property == null) {
            return;
        }
        MetaDataDictionary dd = MetaDataDictionary.getInstance();
        if (dd.getElement(this.extendsFrom) != null) {
            ElementDefn parentTemp = (ElementDefn)dd.getElement(this.extendsFrom);
            while (parentTemp != null) {
                if (parentTemp.properties.containsKey(property.getName())) {
                    throw new MetaDataException(new String[]{property.getName(), this.name}, "DUPLICATE_PROPERTY");
                }
                parentTemp = (ElementDefn)dd.getElement(parentTemp.getExtends());
            }
        }
        if (this.hasStyle()) {
            ElementDefn styleDefn = (ElementDefn)dd.getElement("Style");
            if (styleDefn == null) {
                throw new MetaDataException(new String[]{this.name}, "STYLE_NOT_DEFINED");
            }
            if (styleDefn.properties.containsKey(property.getName()) && !"height".equals(property.getName()) && !"width".equals(property.getName())) {
                throw new MetaDataException(new String[]{property.getName(), this.name}, "DUPLICATE_PROPERTY");
            }
        }
        super.addProperty(property);
        if (property.getType() != null && property.isElementType() && !"multiViews".equalsIgnoreCase(property.getName()) && !this.isContainer) {
            this.isContainer = true;
        }
    }

    public SemanticTriggerDefnSet getTriggerDefnSet() {
        if (this.triggerDefnSet == null) {
            this.triggerDefnSet = new SemanticTriggerDefnSet();
        }
        return this.triggerDefnSet;
    }

    public void addPropertyVisibility(String propName, String propVisibility) {
        if (this.propVisibilites == null) {
            this.propVisibilites = new HashMap<String, Integer>();
        }
        this.propVisibilites.put(propName, this.getIntVisibility(propVisibility));
    }

    private Integer getIntVisibility(String propVisibility) {
        if ((propVisibility = StringUtil.trimString(propVisibility)) == null) {
            return 0;
        }
        int intVisibility = 0;
        String[] values = propVisibility.split(VISIBILITY_SEPERATOR);
        int i = 0;
        while (i < values.length) {
            if (HIDDEN_IN_PROPERTY_SHEET.equalsIgnoreCase(values[i])) {
                intVisibility |= 1;
            } else if (UNHIDDEN_IN_PROPERTY_SHEET.equalsIgnoreCase(values[i])) {
                intVisibility &= 0xFFFFFFFE;
            } else if (READONLY_IN_PROPERTY_SHEET.equalsIgnoreCase(values[i])) {
                intVisibility |= 2;
            }
            ++i;
        }
        return intVisibility;
    }

    @Override
    public boolean isPropertyReadOnly(String propName) {
        IPropertyDefn propDefn = this.cachedProperties.get(propName);
        if (propDefn == null) {
            return true;
        }
        int visibility = this.getPropertyVisibility(propDefn.getName());
        return (visibility & 2) != 0;
    }

    @Override
    public boolean isPropertyVisible(String propName) {
        IPropertyDefn propDefn = this.cachedProperties.get(propName);
        if (propDefn == null || propDefn.getTypeCode() == 16 || ((PropertyDefn)propDefn).isElementType()) {
            return false;
        }
        int visibility = this.getPropertyVisibility(propDefn.getName());
        return (1 & visibility) == 0;
    }

    private int getPropertyVisibility(String propName) {
        if (this.cachedPropVisibilites == null) {
            return 0;
        }
        return this.cachedPropVisibilites.get(propName) == null ? 0 : this.cachedPropVisibilites.get(propName);
    }

    public void setXmlName(String value) {
        this.xmlName = value;
    }

    public String getXmlName() {
        return this.xmlName;
    }

    @Override
    public boolean isExtendedElement() {
        return this.name.equalsIgnoreCase("ExtendedItem") || MetaDataDictionary.getInstance().getExtension(this.name) != null;
    }

    public NameConfig getNameConfig() {
        return this.nameConfig;
    }
}

