/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.chart.regression;

import com.ibm.icu.util.ULocale;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.GeneratedChartState;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.DialChart;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.model.attribute.LineDecorator;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.NumberFormatSpecifier;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.GradientImpl;
import org.eclipse.birt.chart.model.attribute.impl.LineAttributesImpl;
import org.eclipse.birt.chart.model.attribute.impl.NumberFormatSpecifierImpl;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.DataElement;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.TextDataSet;
import org.eclipse.birt.chart.model.data.impl.NumberDataElementImpl;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.data.impl.TextDataSetImpl;
import org.eclipse.birt.chart.model.impl.DialChartImpl;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.type.DialSeries;
import org.eclipse.birt.chart.model.type.impl.DialSeriesImpl;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.birt.report.tests.chart.ChartTestCase;

public class Regression_132783
extends ChartTestCase {
    private static String GOLDEN = "Regression_132783.jpg";
    private static String OUTPUT = "Regression_132783.jpg";
    private Chart cm = null;
    private IDeviceRenderer dRenderer = null;
    private GeneratedChartState gcs = null;

    public static void main(String[] args) {
        new Regression_132783();
    }

    public Regression_132783() {
        PluginSettings ps = PluginSettings.instance();
        try {
            this.dRenderer = ps.getDevice("dv.JPG");
        }
        catch (ChartException ex) {
            ex.printStackTrace();
        }
        this.cm = Regression_132783.createMeterChart();
        BufferedImage img = new BufferedImage(500, 500, 2);
        Graphics g = img.getGraphics();
        Graphics2D g2d = (Graphics2D)g;
        this.dRenderer.setProperty("device.output.context", (Object)g2d);
        this.dRenderer.setProperty("device.file.identifier", (Object)this.genOutputFile(OUTPUT));
        Bounds bo = BoundsImpl.create((double)0.0, (double)0.0, (double)500.0, (double)500.0);
        bo.scale(72.0 / (double)this.dRenderer.getDisplayServer().getDpiResolution());
        Generator gr = Generator.instance();
        try {
            RunTimeContext rtc = new RunTimeContext();
            rtc.setRightToLeft(true);
            this.gcs = gr.build(this.dRenderer.getDisplayServer(), this.cm, bo, null, rtc, null);
            gr.render(this.dRenderer, this.gcs);
        }
        catch (ChartException e) {
            e.printStackTrace();
        }
        ULocale.setDefault((ULocale)new ULocale("en_US"));
    }

    public void test_regression_132783() throws Exception {
        Regression_132783 st = new Regression_132783();
        Regression_132783.assertTrue((boolean)st.compareImages(GOLDEN, OUTPUT));
    }

    public static final Chart createMeterChart() {
        DialChart dChart = (DialChart)DialChartImpl.create();
        dChart.setDialSuperimposition(false);
        dChart.setGridColumnCount(2);
        dChart.setSeriesThickness(25.0);
        dChart.getBlock().setBackground((Fill)ColorDefinitionImpl.WHITE());
        dChart.getTitle().getLabel().getCaption().setValue("City Temperature");
        dChart.getTitle().getOutline().setVisible(false);
        Legend lg = dChart.getLegend();
        lg.setVisible(false);
        TextDataSet categoryValues = TextDataSetImpl.create((Object)new String[]{"London", "Madrid", "Rome", "Moscow"});
        NumberDataSet seriesValues = NumberDataSetImpl.create((Object)new double[]{21.0, 39.0, 30.0, 10.0});
        SeriesDefinition sd = SeriesDefinitionImpl.create();
        dChart.getSeriesDefinitions().add((Object)sd);
        Series seCategory = SeriesImpl.create();
        Fill[] fiaBase = new Fill[]{ColorDefinitionImpl.ORANGE(), GradientImpl.create((ColorDefinition)ColorDefinitionImpl.create((int)225, (int)225, (int)255), (ColorDefinition)ColorDefinitionImpl.create((int)255, (int)255, (int)225), (double)-35.0, (boolean)false), ColorDefinitionImpl.CREAM(), ColorDefinitionImpl.RED(), ColorDefinitionImpl.GREEN(), ColorDefinitionImpl.BLUE().brighter(), ColorDefinitionImpl.CYAN().darker()};
        sd.getSeriesPalette().getEntries().clear();
        int i = 0;
        while (i < fiaBase.length) {
            sd.getSeriesPalette().getEntries().add((Object)fiaBase[i]);
            ++i;
        }
        seCategory.setDataSet((DataSet)categoryValues);
        sd.getSeries().add((Object)seCategory);
        SeriesDefinition sdCity = SeriesDefinitionImpl.create();
        DialSeries seDial = (DialSeries)DialSeriesImpl.create();
        seDial.setDataSet((DataSet)seriesValues);
        seDial.getDial().setFill((Fill)GradientImpl.create((ColorDefinition)ColorDefinitionImpl.create((int)225, (int)255, (int)225), (ColorDefinition)ColorDefinitionImpl.create((int)225, (int)225, (int)255), (double)45.0, (boolean)false));
        NumberFormatSpecifier nfs = NumberFormatSpecifierImpl.create();
        nfs.setSuffix("`C");
        nfs.setFractionDigits(0);
        seDial.getDial().setFormatSpecifier((FormatSpecifier)nfs);
        seDial.setSeriesIdentifier((Object)"Temperature");
        seDial.getNeedle().setDecorator(LineDecorator.CIRCLE_LITERAL);
        seDial.getDial().setStartAngle(-45.0);
        seDial.getDial().setStopAngle(225.0);
        seDial.getDial().getMajorGrid().getTickAttributes().setVisible(true);
        seDial.getDial().getMajorGrid().getTickAttributes().setColor(ColorDefinitionImpl.BLACK());
        seDial.getDial().getScale().setMin((DataElement)NumberDataElementImpl.create((double)0.0));
        seDial.getDial().getScale().setMax((DataElement)NumberDataElementImpl.create((double)100.0));
        seDial.getDial().getScale().setStep(30.0);
        seDial.getLabel().setOutline(LineAttributesImpl.create((ColorDefinition)ColorDefinitionImpl.GREY().darker(), (LineStyle)LineStyle.SOLID_LITERAL, (int)1));
        seDial.getLabel().setBackground((Fill)ColorDefinitionImpl.GREY().brighter());
        sd.getSeriesDefinitions().add((Object)sdCity);
        sdCity.getSeries().add((Object)seDial);
        return dChart;
    }
}

