/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.wst.xml.core.internal.provisional.contenttype.ContentTypeIdForXML;
import org.eclipse.wst.xml.ui.internal.wizards.XMLWizardsMessages;

public class NewModelWizard
extends Wizard
implements INewWizard {
    protected IStructuredSelection fSelection;
    protected IWorkbench fWorkbench;
    protected String fCurrentDirectory;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.fWorkbench = workbench;
        this.fSelection = selection;
    }

    public boolean performFinish() {
        boolean result = true;
        WizardPage currentPage = (WizardPage)this.getContainer().getCurrentPage();
        if (currentPage != null) {
            result = currentPage.isPageComplete();
        }
        return result;
    }

    public FileDialog showFileDialog(Shell shell, String defaultDirectory, String defaultFile, String[] filterExtensions) {
        FileDialog fileDialog = new FileDialog(shell, 4096);
        if (defaultDirectory != null) {
            defaultDirectory.length();
        }
        if (defaultDirectory != null && defaultDirectory.length() != 0) {
            fileDialog.setFilterPath(defaultDirectory);
        }
        fileDialog.setFileName(defaultFile);
        fileDialog.setFilterExtensions(filterExtensions);
        fileDialog.open();
        return fileDialog;
    }

    public void setCurrentDirectory(String currentDirectory1) {
        this.fCurrentDirectory = currentDirectory1;
    }

    public void createWorkbenchResource(IContainer container, String fileName) {
        IPath path = container.getFullPath();
        path = path.append(fileName);
        IFile file = container.getWorkspace().getRoot().getFile(path);
        if (!file.exists()) {
            try {
                file.create(null, true, null);
            }
            catch (CoreException coreException) {}
        }
    }

    public class NewFilePage
    extends WizardNewFileCreationPage {
        public String defaultName;
        public String defaultFileExtension;
        public String[] filterExtensions;
        private List fValidExtensions;

        public NewFilePage(IStructuredSelection selection) {
            super("", selection);
            this.defaultName = "NewFile";
            this.defaultFileExtension = ".txt";
            this.filterExtensions = new String[]{"*.txt"};
            this.fValidExtensions = null;
        }

        protected String computeDefaultFileName() {
            int count = 0;
            String fileName = String.valueOf(this.defaultName) + this.defaultFileExtension;
            IPath containerFullPath = this.getContainerFullPath();
            if (containerFullPath != null) {
                while (true) {
                    IPath path = containerFullPath.append(fileName);
                    if (!ResourcesPlugin.getWorkspace().getRoot().exists(path)) break;
                    fileName = String.valueOf(this.defaultName) + ++count + this.defaultFileExtension;
                }
            }
            return fileName;
        }

        protected String existsFileAnyCase(String fileName) {
            IResource parent;
            if (this.getContainerFullPath() != null && !this.getContainerFullPath().isEmpty() && fileName.compareTo("") != 0 && (parent = ResourcesPlugin.getWorkspace().getRoot().findMember(this.getContainerFullPath())) instanceof IContainer) {
                IContainer container = (IContainer)parent;
                try {
                    IResource[] members = container.members();
                    String enteredFileUpper = fileName.toUpperCase();
                    int i = 0;
                    while (i < members.length) {
                        String resourceUpperName = members[i].getName().toUpperCase();
                        if (resourceUpperName.equals(enteredFileUpper)) {
                            return members[i].getName();
                        }
                        ++i;
                    }
                }
                catch (CoreException coreException) {}
            }
            return null;
        }

        protected boolean validatePage() {
            String sameName;
            String fullFileName = this.getFileName();
            if (!this.extensionValidForContentType(fullFileName)) {
                this.setErrorMessage(NLS.bind((String)XMLWizardsMessages._ERROR_BAD_FILENAME_EXTENSION, (Object)this.getValidExtensions().toString()));
                return false;
            }
            if (fullFileName.lastIndexOf(46) == -1) {
                fullFileName = String.valueOf(fullFileName) + this.defaultFileExtension;
            }
            if (this.getContainerFullPath() != null && !this.getContainerFullPath().isEmpty() && this.getFileName().compareTo("") != 0) {
                Path fullPath = new Path(String.valueOf(this.getContainerFullPath().toString()) + '/' + fullFileName);
                IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)fullPath);
                if (resource != null) {
                    this.setErrorMessage(XMLWizardsMessages._ERROR_FILE_ALREADY_EXISTS);
                    return false;
                }
            }
            if ((sameName = this.existsFileAnyCase(fullFileName)) != null) {
                this.setErrorMessage(String.valueOf(XMLWizardsMessages._ERROR_FILE_ALREADY_EXISTS) + " " + sameName);
                return false;
            }
            return super.validatePage();
        }

        public void createControl(Composite parent) {
            super.createControl(parent);
            this.setFileName(this.computeDefaultFileName());
            this.setPageComplete(this.validatePage());
        }

        List getValidExtensions() {
            if (this.fValidExtensions == null) {
                IContentType type = Platform.getContentTypeManager().getContentType(ContentTypeIdForXML.ContentTypeID_XML);
                this.fValidExtensions = new ArrayList<String>(Arrays.asList(type.getFileSpecs(8)));
            }
            return this.fValidExtensions;
        }

        boolean extensionValidForContentType(String fileName) {
            boolean valid = false;
            IContentType type = Platform.getContentTypeManager().getContentType(ContentTypeIdForXML.ContentTypeID_XML);
            if (fileName.lastIndexOf(46) != -1) {
                IContentType[] types = Platform.getContentTypeManager().findContentTypesFor(fileName);
                int i = 0;
                while (i < types.length && !valid) {
                    valid = types[i].isKindOf(type);
                    ++i;
                }
            } else {
                valid = true;
            }
            return valid;
        }
    }

    public class StartPage
    extends WizardPage
    implements Listener {
        protected int selectedButton;
        protected String[] radioButtonLabel;
        protected Button[] radioButton;
        private String preferenceMessage;
        private String[] preferencePageIds;

        public StartPage(String pageName, String[] radioButtonLabel) {
            super(pageName);
            this.radioButtonLabel = radioButtonLabel;
            this.radioButton = new Button[radioButtonLabel.length];
        }

        public StartPage(String pageName, String[] radioButtonLabel, String[] preferencePageIds, String message) {
            super(pageName);
            this.radioButtonLabel = radioButtonLabel;
            this.radioButton = new Button[radioButtonLabel.length];
            this.preferencePageIds = preferencePageIds;
            this.preferenceMessage = message;
        }

        public Button getRadioButtonAtIndex(int i) {
            Button result = null;
            if (i >= 0 && i < this.radioButton.length) {
                result = this.radioButton[i];
            }
            return result;
        }

        public int getSelectedRadioButtonIndex() {
            int result = -1;
            int i = 0;
            while (i < this.radioButton.length) {
                if (this.radioButton[i].getSelection()) {
                    result = i;
                }
                ++i;
            }
            return result;
        }

        public void createControl(Composite parent) {
            Composite base = new Composite(parent, 0);
            base.setLayout((Layout)new GridLayout());
            Composite radioButtonsGroup = new Composite(base, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            layout.makeColumnsEqualWidth = true;
            layout.marginWidth = 0;
            radioButtonsGroup.setLayout((Layout)layout);
            GridData gd = new GridData(768);
            gd.widthHint = 400;
            radioButtonsGroup.setLayoutData((Object)gd);
            int i = 0;
            while (i < this.radioButtonLabel.length) {
                this.radioButton[i] = new Button(radioButtonsGroup, 16);
                this.radioButton[i].setText(this.radioButtonLabel[i]);
                this.radioButton[i].setLayoutData((Object)new GridData(768));
                ++i;
            }
            if (this.preferenceMessage != null && this.preferencePageIds != null) {
                new Label(base, 0).setLayoutData((Object)new GridData(768));
                Link link = new Link(base, 0);
                link.setText(this.preferenceMessage);
                link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        PreferencesUtil.createPreferenceDialogOn(null, (String)StartPage.this.preferencePageIds[0], (String[])StartPage.this.preferencePageIds, null).open();
                    }
                });
            }
            this.setControl((Control)base);
            this.setPageComplete(this.isPageComplete());
            Dialog.applyDialogFont((Control)parent);
        }

        public void handleEvent(Event event) {
            if (event.type == 24) {
                this.setPageComplete(this.isPageComplete());
            }
        }
    }
}

