/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.schema;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IEditable;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.internal.core.AbstractModel;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.schema.EditableSchema;
import org.eclipse.pde.internal.core.schema.Schema;
import org.eclipse.pde.internal.core.schema.SchemaDescriptor;
import org.eclipse.pde.internal.core.schema.StorageSchemaDescriptor;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.context.XMLInputContext;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class SchemaInputContext
extends XMLInputContext {
    public static final String CONTEXT_ID = "schema-context";

    public SchemaInputContext(PDEFormEditor editor, IEditorInput input, boolean primary) {
        super(editor, input, primary);
        this.create();
    }

    @Override
    public String getId() {
        return CONTEXT_ID;
    }

    @Override
    protected IBaseModel createModel(IEditorInput input) throws CoreException {
        if (input instanceof FileStoreEditorInput) {
            return this.createExternalModel((FileStoreEditorInput)input);
        }
        if (!(input instanceof IFileEditorInput)) {
            if (input instanceof IStorageEditorInput) {
                return this.createStorageModel((IStorageEditorInput)input);
            }
            return null;
        }
        IFile file = ((IFileEditorInput)input).getFile();
        SchemaDescriptor sd = new SchemaDescriptor(file, true);
        ISchema schema = sd.getSchema(false);
        if (schema instanceof EditableSchema) {
            ((EditableSchema)schema).setNotificationEnabled(true);
        }
        return schema;
    }

    private IBaseModel createExternalModel(FileStoreEditorInput input) {
        SchemaDescriptor sd;
        ISchema schema;
        File file = (File)input.getAdapter(File.class);
        if (file == null) {
            URI uri = input.getURI();
            if (uri != null) {
                file = new File(uri);
            } else {
                return null;
            }
        }
        if ((schema = (sd = new SchemaDescriptor(file)).getSchema(false)) instanceof EditableSchema) {
            ((EditableSchema)schema).setNotificationEnabled(true);
        }
        return schema;
    }

    private IBaseModel createStorageModel(IStorageEditorInput input) {
        try {
            IStorage storage = input.getStorage();
            StorageSchemaDescriptor sd = new StorageSchemaDescriptor(storage);
            ISchema schema = sd.getSchema(false);
            return schema;
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
            return null;
        }
    }

    @Override
    protected void addTextEditOperation(ArrayList<TextEdit> ops, IModelChangedEvent event) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void flushModel(IDocument doc) {
        if (!(this.getModel() instanceof IEditable)) {
            return;
        }
        IEditable editableModel = (IEditable)this.getModel();
        if (!editableModel.isDirty()) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                StringWriter swriter = new StringWriter();
                try {
                    try (PrintWriter writer = new PrintWriter(swriter);){
                        editableModel.save(writer);
                        writer.flush();
                        String content = swriter.toString();
                        if (this.getInput() instanceof IFileEditorInput) {
                            IFile file = ((IFileEditorInput)this.getInput()).getFile();
                            content = AbstractModel.fixLineDelimiter((String)content, (IFile)file);
                        }
                        doc.set(content);
                    }
                    if (swriter == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (swriter == null) throw throwable;
                    swriter.close();
                    throw throwable;
                }
                swriter.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            PDEPlugin.logException(e);
        }
    }

    @Override
    public void flushEditorInput() {
        IDocumentProvider provider = this.getDocumentProvider();
        IEditorInput input = this.getInput();
        IDocument doc = provider.getDocument((Object)input);
        provider.aboutToChange((Object)input);
        this.flushModel(doc);
        provider.changed((Object)input);
        this.setValidated(false);
    }

    @Override
    protected boolean synchronizeModel(IDocument doc) {
        Schema schema = (Schema)this.getModel();
        if (schema == null) {
            this.create();
            return this.getModel() == null;
        }
        String text = doc.get();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (ByteArrayInputStream stream = new ByteArrayInputStream(text.getBytes(StandardCharsets.UTF_8));){
                schema.reload((InputStream)stream);
                if (schema instanceof IEditable) {
                    ((IEditable)schema).setDirty(false);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    @Override
    protected void reorderInsertEdits(ArrayList<TextEdit> ops) {
    }

    @Override
    protected String getPartitionName() {
        return "___schema_partition";
    }
}

