/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.validators;

import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.SimpleMasterPageHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.SemanticError;
import org.eclipse.birt.report.model.api.validators.IValidationListener;
import org.eclipse.birt.report.model.api.validators.MasterPageTypeValidator;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.validators.ValidatorTestCase;

public class MasterPageTypeValidatorTest
extends ValidatorTestCase {
    ValidatorTestCase.MyListener listener = new ValidatorTestCase.MyListener(this);

    public void testTriggers() throws Exception {
        this.createDesign();
        MetaDataDictionary.getInstance().setUseValidationTrigger(true);
        SimpleMasterPageHandle pageHandle = this.designHandle.getElementFactory().newSimpleMasterPage("masterPage1");
        this.designHandle.getMasterPages().add((DesignElementHandle)pageHandle);
        this.designHandle.addValidationListener((IValidationListener)this.listener);
        MasterPageTypeValidatorTest.assertEquals((String)"us-letter", (String)pageHandle.getPageType());
        DimensionHandle width = pageHandle.getWidth();
        this.assertDimensionUnsettable(width, "8in");
        DimensionHandle height = pageHandle.getHeight();
        this.assertDimensionUnsettable(height, "10in");
        pageHandle.setPageType("custom");
        MasterPageTypeValidatorTest.assertFalse((boolean)this.listener.hasError((DesignElementHandle)pageHandle, MasterPageTypeValidator.getInstance().getName(), "Error.SemanticError.CANNOT_SPECIFY_PAGE_SIZE"));
    }

    private void assertDimensionUnsettable(DimensionHandle handle, String value) throws SemanticException {
        try {
            handle.setStringValue(value);
            MasterPageTypeValidatorTest.fail();
        }
        catch (SemanticError expected) {
            MasterPageTypeValidatorTest.assertEquals((String)expected.getErrorCode(), (String)"Error.SemanticError.CANNOT_SPECIFY_PAGE_SIZE");
        }
    }
}

