/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.engine.api;

import java.util.HashMap;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.birt.report.engine.api.HTMLRenderContext;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.RenderOptionBase;
import org.eclipse.birt.report.tests.engine.EngineCase;

public class HTMLRenderContextTest
extends EngineCase {
    public HTMLRenderContextTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(HTMLRenderContextTest.class);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetBaseImageURL() {
        HTMLRenderContext context = new HTMLRenderContext();
        String baseURL = "image";
        context.setBaseImageURL(baseURL);
        String baseURLGet = context.getBaseImageURL();
        HTMLRenderContextTest.assertEquals((String)"getBaseImageURL() fail", (String)baseURL, (String)baseURLGet);
    }

    public void testGetBaseURL() {
        HTMLRenderContext context = new HTMLRenderContext();
        String baseURL = "image";
        context.setBaseURL(baseURL);
        String baseURLGet = context.getBaseURL();
        HTMLRenderContextTest.assertEquals((String)"getBaseURL() fail", (String)baseURL, (String)baseURLGet);
    }

    public void testGetImageDirectory() {
        HTMLRenderContext context = new HTMLRenderContext();
        Object dir = "image";
        context.setImageDirectory((String)dir);
        String dirGet = context.getImageDirectory();
        HTMLRenderContextTest.assertEquals((String)"getBaseURL() fail", (String)dir, (String)dirGet);
        String separator = "/";
        dir = "image" + separator + "doc";
        context.setImageDirectory((String)dir);
        HTMLRenderContextTest.assertEquals((String)"image/doc", (String)context.getImageDirectory());
    }

    public void testGetRenderOption() {
        RenderOptionBase rendop = new RenderOptionBase();
        rendop.setOutputFormat("fo");
        rendop.setOutputFileName("outputfile");
        HTMLRenderContext context = new HTMLRenderContext();
        context.setRenderOption((IRenderOption)rendop);
        RenderOptionBase ropb = (RenderOptionBase)context.getRenderOption();
        HTMLRenderContextTest.assertEquals((String)"fo", (String)ropb.getOutputFormat());
        Map outsetting = new HashMap();
        outsetting = ropb.getOutputSetting();
        HTMLRenderContextTest.assertFalse((boolean)outsetting.isEmpty());
        HTMLRenderContextTest.assertEquals((int)2, (int)outsetting.size());
        ropb.getOutputSetting().put("url-encoding", "UTF-8");
        HTMLRenderContextTest.assertEquals((int)3, (int)outsetting.size());
    }

    public void testGetSupportedImageFormats() {
        HTMLRenderContext context = new HTMLRenderContext();
        String baseURL = "Format";
        context.setBaseImageURL(baseURL);
        String baseURLGet = context.getBaseImageURL();
        HTMLRenderContextTest.assertEquals((String)"getBaseImageURL() fail", (String)baseURL, (String)baseURLGet);
    }
}

