/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.util.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.dialogs.provider.FilterHandleProvider;
import org.eclipse.birt.report.designer.internal.ui.views.dialogs.provider.GroupHandleProvider;
import org.eclipse.birt.report.designer.internal.ui.views.dialogs.provider.ISortingFormHandleProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class SortingFormPage
extends Composite
implements org.eclipse.birt.report.model.api.core.Listener {
    public static final int SIMPLE_FUNCTION = 1;
    public static final int NORMAL_FUNCTION = 2;
    public static final int FULL_FUNCTION = 3;
    public static final int FULL_FUNCTION_HORIZONTAL = 4;
    private int style;
    private boolean bAddWithDialog;
    protected Label title;
    protected Button btnAdd;
    protected Button btnDel;
    protected Button btnEdit;
    protected Table table;
    private TableViewer tableViewer;
    protected ISortingFormHandleProvider provider;
    private int selectIndex;
    protected List input = new ArrayList();
    public static final int QUICK_BUTTON_HEIGHT = Platform.getOS().equals("win32") ? 20 : 22;

    public SortingFormPage(Composite parent, int style, ISortingFormHandleProvider provider, boolean bAddWithDialog) {
        super(parent, 0);
        assert (provider != null);
        this.provider = provider;
        this.style = style;
        this.bAddWithDialog = bAddWithDialog;
        this.createControl();
    }

    protected TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public SortingFormPage(Composite parent, int style, ISortingFormHandleProvider provider) {
        this(parent, style, provider, false);
    }

    private void enableUI(boolean enabled) {
        if (this.tableViewer != null) {
            this.table.setEnabled(enabled);
            this.btnAdd.setEnabled(enabled);
            this.btnDel.setEnabled(enabled);
            if (this.style == 3 || this.style == 4) {
                this.btnEdit.setEnabled(enabled);
            }
            if (enabled) {
                this.updateArraw();
            }
        }
    }

    private void editableUI(boolean editable) {
        if (this.tableViewer != null) {
            this.btnAdd.setEnabled(editable);
            this.btnDel.setEnabled(editable);
            if (this.style == 3 || this.style == 4) {
                this.btnEdit.setEnabled(editable);
            }
            if (editable) {
                this.updateArraw();
            }
        }
    }

    public void setInput(List elements) {
        if (elements.size() != 1) {
            this.enableUI(false);
            return;
        }
        this.enableUI(true);
        this.editableUI(this.provider.isEditable());
        this.deRegisterListeners();
        this.input = elements;
        this.tableViewer.setInput((Object)elements);
        this.refresh();
        this.registerListeners();
        this.updateArraw();
        this.updateBindingParameters();
    }

    protected void createControl() {
        this.title = new Label((Composite)this, 0);
        this.title.setText(this.provider.getTitle());
        this.table = new Table((Composite)this, 68356);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        Listener sortListener = new Listener(){

            public void handleEvent(Event e) {
                int modelPos = -1;
                if (SortingFormPage.this.table.getSelectionIndex() > -1) {
                    modelPos = SortingFormPage.this.provider.getOriginalIndex(SortingFormPage.this.table.getSelectionIndex());
                }
                TableColumn sortColumn = SortingFormPage.this.table.getSortColumn();
                TableColumn currentColumn = (TableColumn)e.widget;
                int dir = SortingFormPage.this.table.getSortDirection();
                if (sortColumn == currentColumn) {
                    dir = dir == 128 ? 1024 : 128;
                } else {
                    SortingFormPage.this.table.setSortColumn(currentColumn);
                    dir = 128;
                    int i = 0;
                    while (i < SortingFormPage.this.table.getColumnCount()) {
                        if (currentColumn == SortingFormPage.this.table.getColumn(i)) {
                            SortingFormPage.this.provider.setSortingColumnIndex(i);
                            break;
                        }
                        ++i;
                    }
                }
                SortingFormPage.this.provider.setSortDirection(dir);
                SortingFormPage.this.table.setSortDirection(dir);
                SortingFormPage.this.tableViewer.refresh();
                if (modelPos > -1) {
                    SortingFormPage.this.table.setSelection(SortingFormPage.this.provider.getShowIndex(modelPos));
                }
            }
        };
        String[] columnNames = this.provider.getColumnNames();
        int i = 0;
        while (i < columnNames.length) {
            TableColumn column = new TableColumn(this.table, 16384);
            if (i == 0) {
                this.table.setSortColumn(column);
            }
            column.setText(columnNames[i]);
            column.setWidth(this.provider.getColumnWidths()[i]);
            column.addListener(13, sortListener);
            ++i;
        }
        this.table.setSortDirection(128);
        this.table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (!SortingFormPage.this.provider.isEditable()) {
                    return;
                }
                if (e.keyCode == 127) {
                    int itemCount = SortingFormPage.this.table.getItemCount();
                    int pos = SortingFormPage.this.table.getSelectionIndex();
                    if (SortingFormPage.this.selectIndex == itemCount - 1) {
                        --SortingFormPage.this.selectIndex;
                    }
                    try {
                        SortingFormPage.this.provider.doDeleteItem(pos);
                    }
                    catch (Exception e1) {
                        WidgetUtil.processError(SortingFormPage.this.getShell(), e1);
                    }
                } else if (e.character == '\r' && (SortingFormPage.this.style == 3 || SortingFormPage.this.style == 4)) {
                    SortingFormPage.this.edit();
                }
            }
        });
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SortingFormPage.this.selectIndex = SortingFormPage.this.table.getSelectionIndex();
                SortingFormPage.this.updateArraw();
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (!SortingFormPage.this.provider.isEditable()) {
                    return;
                }
                if (SortingFormPage.this.style == 3 || SortingFormPage.this.style == 4) {
                    SortingFormPage.this.edit();
                }
            }
        });
        this.createTableViewer();
        this.btnDel = new Button((Composite)this, 8);
        this.btnDel.setText(Messages.getString((String)"FormPage.Button.Delete"));
        this.btnDel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int pos;
                if (SortingFormPage.this.tableViewer.isCellEditorActive()) {
                    SortingFormPage.this.tableViewer.cancelEditing();
                }
                if ((pos = SortingFormPage.this.table.getSelectionIndex()) == -1) {
                    SortingFormPage.this.table.setFocus();
                    return;
                }
                SortingFormPage.this.selectIndex = pos;
                int itemCount = SortingFormPage.this.table.getItemCount();
                if (SortingFormPage.this.selectIndex == itemCount - 1) {
                    --SortingFormPage.this.selectIndex;
                }
                try {
                    SortingFormPage.this.provider.doDeleteItem(pos);
                }
                catch (Exception e1) {
                    WidgetUtil.processError(SortingFormPage.this.getShell(), e1);
                }
                SortingFormPage.this.updateArraw();
            }
        });
        this.btnAdd = new Button((Composite)this, 8);
        if (this.bAddWithDialog) {
            this.btnAdd.setText(Messages.getString((String)"FormPage.Button.AddWithDialog"));
        } else {
            this.btnAdd.setText(Messages.getString((String)"FormPage.Button.Add"));
        }
        this.btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommandStack stack = SortingFormPage.this.getActionStack();
                stack.startTrans(Messages.getString((String)"FormPage.Menu.ModifyProperty"));
                int pos = SortingFormPage.this.table.getSelectionIndex();
                boolean sucess = false;
                try {
                    sucess = SortingFormPage.this.provider.doAddItem(pos);
                }
                catch (Exception e1) {
                    stack.rollback();
                    WidgetUtil.processError(SortingFormPage.this.getShell(), e1);
                    return;
                }
                if (sucess) {
                    stack.commit();
                } else {
                    stack.rollback();
                }
                SortingFormPage.this.table.setSelection(SortingFormPage.this.provider.getShowIndex(SortingFormPage.this.table.getItemCount() - 1));
                SortingFormPage.this.updateArraw();
            }
        });
        if (this.style == 3 || this.style == 4) {
            this.btnEdit = new Button((Composite)this, 8);
            if (this.bAddWithDialog) {
                this.btnEdit.setText(Messages.getString((String)"FormPage.Button.EditWithDialog"));
            } else {
                this.btnEdit.setText(Messages.getString((String)"FormPage.Button.Edit"));
            }
            this.btnEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SortingFormPage.this.edit();
                }
            });
        }
        switch (this.style) {
            case 1: {
                this.simpleLayout();
                break;
            }
            case 2: {
                this.normallLayout();
                break;
            }
            case 3: {
                this.fullLayout();
                break;
            }
            case 4: {
                this.fullLayoutHorizontal();
            }
        }
    }

    private void edit() {
        int pos = this.table.getSelectionIndex();
        int modelPos = this.provider.getOriginalIndex(pos);
        if (pos == -1) {
            this.table.setFocus();
            return;
        }
        CommandStack stack = this.getActionStack();
        stack.startTrans(Messages.getString((String)"FormPage.Menu.ModifyProperty"));
        if (!this.provider.doEditItem(pos)) {
            stack.rollback();
            return;
        }
        stack.commit();
        this.table.setSelection(this.provider.getShowIndex(modelPos));
    }

    private void updateArraw() {
        if (!this.provider.isEditable() || this.style == 1) {
            return;
        }
        int selectIndex = this.table.getSelectionIndex();
        int min = 0;
        int max = this.table.getItemCount() - 1;
        if (min <= selectIndex && selectIndex <= max) {
            this.btnDel.setEnabled(true);
            if (this.btnEdit != null) {
                this.btnEdit.setEnabled(true);
            }
        } else {
            this.btnDel.setEnabled(false);
            if (this.btnEdit != null) {
                this.btnEdit.setEnabled(false);
            }
        }
    }

    private void updateBindingParameters() {
        if (this.provider instanceof FilterHandleProvider) {
            ParamBindingHandle[] bindingParams = null;
            if (this.input.get(0) instanceof ReportItemHandle) {
                ReportItemHandle inputHandle = (ReportItemHandle)this.input.get(0);
                ArrayList<ParamBindingHandle> list = new ArrayList<ParamBindingHandle>();
                Iterator iterator = inputHandle.paramBindingsIterator();
                while (iterator.hasNext()) {
                    ParamBindingHandle handle = (ParamBindingHandle)iterator.next();
                    list.add(handle);
                }
                bindingParams = new ParamBindingHandle[list.size()];
                list.toArray(bindingParams);
            }
            ((FilterHandleProvider)((Object)this.provider)).setBindingParams(bindingParams);
        }
    }

    private void createTableViewer() {
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setColumnProperties(this.provider.getColumnNames());
        this.tableViewer.setContentProvider((IContentProvider)new FormContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new FormLabelProvider());
    }

    protected void simpleLayout() {
        FormLayout layout = new FormLayout();
        layout.marginHeight = 8;
        layout.marginWidth = 8;
        layout.spacing = 8;
        this.setLayout((Layout)layout);
        FormData data = new FormData();
        data.left = new FormAttachment((Control)this.title, 50, 131072);
        this.btnAdd.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)this.btnAdd, 0, 131072);
        this.btnDel.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.btnAdd, 0, 1024);
        data.left = new FormAttachment((Control)this.title, 0, 16384);
        int[] width = this.provider.getColumnWidths();
        int dataWidth = 0;
        int i = 0;
        while (i < width.length) {
            dataWidth += width[i];
            ++i;
        }
        data.right = new FormAttachment((Control)this.title, dataWidth + 15, 16384);
        data.bottom = new FormAttachment(100);
        this.table.setLayoutData((Object)data);
    }

    protected void normallLayout() {
        FormLayout layout = new FormLayout();
        layout.marginHeight = 8;
        layout.marginWidth = 8;
        layout.spacing = 8;
        this.setLayout((Layout)layout);
        FormData data = new FormData();
        data.right = new FormAttachment(100);
        this.btnDel.setLayoutData((Object)data);
        data = new FormData();
        data.right = new FormAttachment((Control)this.btnDel, 0, 16384);
        this.btnAdd.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.btnDel, 0, 1024);
        data.left = new FormAttachment((Control)this.title, 0, 16384);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        this.table.setLayoutData((Object)data);
    }

    protected void fullLayoutHorizontal() {
        FormLayout layout = new FormLayout();
        layout.marginHeight = 8;
        layout.marginWidth = 8;
        layout.spacing = 8;
        this.setLayout((Layout)layout);
        FormData data = new FormData();
        data.right = new FormAttachment(100);
        this.btnEdit.setLayoutData((Object)data);
        data = new FormData();
        data.right = new FormAttachment((Control)this.btnEdit, 0, 16384);
        this.btnDel.setLayoutData((Object)data);
        data = new FormData();
        data.right = new FormAttachment((Control)this.btnDel, 0, 16384);
        this.btnAdd.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.btnEdit, 0, 1024);
        data.left = new FormAttachment((Control)this.title, 0, 16384);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        this.table.setLayoutData((Object)data);
    }

    protected void fullLayout() {
        FormLayout layout = new FormLayout();
        layout.marginHeight = 8;
        layout.marginWidth = 8;
        layout.spacing = 8;
        this.setLayout((Layout)layout);
        int btnWidth = 60;
        int height = QUICK_BUTTON_HEIGHT - 2;
        FormData data = new FormData();
        data.right = new FormAttachment(90);
        data.top = new FormAttachment(0, height + 16);
        data.width = Math.max(btnWidth, this.btnAdd.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.btnAdd.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.btnAdd, 0, 1024);
        data.left = new FormAttachment((Control)this.btnAdd, 0, 16384);
        data.width = Math.max(btnWidth, this.btnEdit.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.btnEdit.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.btnEdit, 0, 1024);
        data.left = new FormAttachment((Control)this.btnEdit, 0, 16384);
        data.width = Math.max(btnWidth, this.btnDel.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.btnDel.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.btnAdd, 0, 128);
        data.bottom = new FormAttachment(100);
        data.left = new FormAttachment((Control)this.title, 0, 16384);
        data.right = new FormAttachment((Control)this.btnAdd, 0, 16384);
        this.table.setLayoutData((Object)data);
    }

    public void elementChanged(DesignElementHandle arg0, NotificationEvent event) {
        if (this.provider.needRefreshed(event) && !this.isDisposed()) {
            this.refresh();
        }
    }

    public void refresh() {
        this.tableViewer.refresh();
        this.table.select(this.selectIndex);
        this.table.setFocus();
        this.updateArraw();
        this.updateBindingParameters();
        this.editableUI(this.provider.isEditable());
        this.title.setText(this.provider.getTitle());
    }

    protected void buildUI() {
    }

    private CommandStack getActionStack() {
        return SessionHandleAdapter.getInstance().getCommandStack();
    }

    protected void registerListeners() {
        if (this.input == null) {
            return;
        }
        int i = 0;
        while (i < this.input.size()) {
            Object obj = this.input.get(i);
            if (obj instanceof DesignElementHandle) {
                DesignElementHandle element = (DesignElementHandle)obj;
                element.addListener((org.eclipse.birt.report.model.api.core.Listener)this);
            }
            ++i;
        }
    }

    protected void deRegisterListeners() {
        if (this.input == null) {
            return;
        }
        int i = 0;
        while (i < this.input.size()) {
            Object obj = this.input.get(i);
            if (obj instanceof DesignElementHandle) {
                DesignElementHandle element = (DesignElementHandle)obj;
                element.removeListener((org.eclipse.birt.report.model.api.core.Listener)this);
            }
            ++i;
        }
    }

    private class FormContentProvider
    implements IStructuredContentProvider {
        private FormContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Object[] elements = SortingFormPage.this.provider.getElements(inputElement);
            int i = 0;
            while (i < elements.length) {
                if (elements[i] instanceof DesignElementHandle) {
                    DesignElementHandle element = (DesignElementHandle)elements[i];
                    element.removeListener((org.eclipse.birt.report.model.api.core.Listener)SortingFormPage.this);
                    element.addListener((org.eclipse.birt.report.model.api.core.Listener)SortingFormPage.this);
                }
                ++i;
            }
            return elements;
        }

        public void dispose() {
            if (!(SortingFormPage.this.provider instanceof GroupHandleProvider)) {
                return;
            }
            Object[] elements = SortingFormPage.this.provider.getElements(SortingFormPage.this.input);
            if (elements == null) {
                return;
            }
            int i = 0;
            while (i < elements.length) {
                if (elements[i] instanceof DesignElementHandle) {
                    DesignElementHandle element = (DesignElementHandle)elements[i];
                    element.removeListener((org.eclipse.birt.report.model.api.core.Listener)SortingFormPage.this);
                }
                ++i;
            }
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class FormLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private FormLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            return SortingFormPage.this.provider.getColumnText(element, columnIndex);
        }
    }
}

