/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dnd;

import org.eclipse.birt.report.designer.internal.ui.dnd.DNDLocation;
import org.eclipse.birt.report.designer.internal.ui.dnd.DNDService;
import org.eclipse.birt.report.designer.internal.ui.util.Policy;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.gef.dnd.TemplateTransfer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;

public abstract class DesignElementDropAdapter
extends ViewerDropAdapter {
    public DesignElementDropAdapter(TreeViewer viewer) {
        super((Viewer)viewer);
    }

    public void dragOver(DropTargetEvent event) {
        super.dragOver(event);
        if (event.detail == 0) {
            return;
        }
        if (!this.validateTarget(this.getCurrentTarget()) || !this.validateTarget(this.getCurrentTarget(), TemplateTransfer.getInstance().getTemplate())) {
            event.detail = 0;
            if (Policy.TRACING_DND_DRAG) {
                System.out.println("DND >> Drag over " + String.valueOf(event.getSource()));
            }
        }
    }

    public boolean performDrop(Object data) {
        if (DNDService.getInstance().performDrop(data, this.getCurrentTarget(), this.getCurrentOperation(), new DNDLocation(this.getCurrentLocation()))) {
            return true;
        }
        if (data instanceof Object[] && ((Object[])data)[0] instanceof ThemeHandle) {
            if (this.getCurrentTarget() instanceof ModuleHandle) {
                if (Policy.TRACING_DND_DRAG) {
                    System.out.println("DND >> Dropped. Operation: Apply Theme, Target: " + String.valueOf(this.getCurrentTarget()));
                }
                return this.applyTheme((ThemeHandle)((Object[])data)[0], (ModuleHandle)this.getCurrentTarget());
            }
            return false;
        }
        if (this.getCurrentOperation() == 2) {
            if (Policy.TRACING_DND_DRAG) {
                System.out.println("DND >> Dropped. Operation: Copy, Target: " + String.valueOf(this.getCurrentTarget()));
            }
            return this.moveData(data, this.getCurrentTarget());
        }
        if (this.getCurrentOperation() == 1 || this.getCurrentOperation() == 4) {
            if (Policy.TRACING_DND_DRAG) {
                System.out.println("DND >> Dropped. Operation: Move, Target: " + String.valueOf(this.getCurrentTarget()));
            }
            return this.copyData(data, this.getCurrentTarget());
        }
        return false;
    }

    public boolean validateDrop(Object target, int op, TransferData type) {
        return TemplateTransfer.getInstance().isSupportedType(type);
    }

    protected abstract boolean validateTarget(Object var1);

    protected abstract boolean validateTarget(Object var1, Object var2);

    protected abstract boolean moveData(Object var1, Object var2);

    protected abstract boolean applyTheme(ThemeHandle var1, ModuleHandle var2);

    protected abstract boolean copyData(Object var1, Object var2);
}

