/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.extensions;

import org.eclipse.birt.report.designer.internal.ui.command.CommandUtils;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools.AbstractToolHandleExtends;
import org.eclipse.birt.report.designer.internal.ui.extension.ExtendedElementUIPoint;
import org.eclipse.birt.report.designer.internal.ui.extension.ExtensionPointManager;
import org.eclipse.birt.report.designer.internal.ui.extension.experimental.EditpartExtensionManager;
import org.eclipse.birt.report.designer.internal.ui.extension.experimental.PaletteEntryExtension;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.ui.extensions.IReportItemBuilderUI;
import org.eclipse.birt.report.designer.ui.newelement.DesignElementFactory;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;

public class ExtendedElementToolExtends
extends AbstractToolHandleExtends {
    private String extensionName;

    public ExtendedElementToolExtends(String extensionName) {
        this.extensionName = extensionName;
    }

    @Override
    public boolean postHandleCreation() {
        IReportItemBuilderUI builder = this.getbuilder();
        if (builder != null) {
            if (builder.open((ExtendedItemHandle)this.getModel()) == 1) {
                return false;
            }
        } else {
            PaletteEntryExtension[] extensions = EditpartExtensionManager.getPaletteEntries();
            int i = 0;
            while (i < extensions.length) {
                if (extensions[i].getLabel().equals(this.extensionName)) {
                    try {
                        CommandUtils.setVariable("targetEditPart", this.getTargetEditPart());
                        this.setModel(extensions[i].executeCreate());
                        return super.preHandleMouseUp();
                    }
                    catch (Exception e) {
                        ExceptionHandler.handle(e);
                        return false;
                    }
                }
                ++i;
            }
        }
        return super.postHandleCreation();
    }

    @Override
    public boolean preHandleMouseUp() {
        ExtendedItemHandle handle = DesignElementFactory.getInstance().newExtendedItem(null, this.extensionName);
        if (handle == null) {
            return false;
        }
        this.setModel(handle);
        return super.preHandleMouseUp();
    }

    @Override
    public boolean preHandleMouseDown() {
        return false;
    }

    private IReportItemBuilderUI getbuilder() {
        ExtendedElementUIPoint point = ExtensionPointManager.getInstance().getExtendedElementPoint(this.extensionName);
        if (point != null) {
            return point.getReportItemBuilderUI();
        }
        return null;
    }
}

