/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.preferences;

import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.preferences.ElementNamesConfigurationBlock;
import org.eclipse.birt.report.designer.ui.preferences.ItemContent;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.widgets.TableItem;

public class ElementNamesCellModifier
implements ICellModifier {
    private ElementNamesConfigurationBlock elementPreferPage;
    private static final String[] columnModifyEnabled = new String[]{Messages.getString((String)"designer.preview.preference.elementname.defaultname.Enabled").trim(), Messages.getString((String)"designer.preview.preference.elementname.customname.Enabled").trim(), Messages.getString((String)"designer.preview.preference.elementname.description.Enabled").trim()};
    private static final String enabledFlag = Messages.getString((String)"designer.preview.preference.elementname.Enabled").trim();

    public ElementNamesCellModifier(ElementNamesConfigurationBlock elementPreferPage) {
        this.elementPreferPage = elementPreferPage;
    }

    public boolean canModify(Object element, String property) {
        int columnIndex = this.elementPreferPage.getElementNames().indexOf(property);
        if (columnIndex < 0 && columnIndex >= columnModifyEnabled.length) {
            return false;
        }
        return columnModifyEnabled[columnIndex].equalsIgnoreCase(enabledFlag);
    }

    public Object getValue(Object element, String property) {
        int columnIndex = this.elementPreferPage.getElementNames().indexOf(property);
        String result = null;
        ItemContent content = (ItemContent)element;
        switch (columnIndex) {
            case 0: {
                result = content.getDefaultName();
                break;
            }
            case 1: {
                result = content.getCustomName();
                break;
            }
            case 2: {
                result = content.getDescription();
                break;
            }
            default: {
                result = "";
            }
        }
        return result;
    }

    public void modify(Object element, String property, Object value) {
        int columnIndex = this.elementPreferPage.getElementNames().indexOf(property);
        TableItem item = (TableItem)element;
        ItemContent content = (ItemContent)item.getData();
        String valueString = ((String)value).trim();
        switch (columnIndex) {
            case 0: {
                content.setDefaultName(valueString);
                break;
            }
            case 1: {
                content.setCustomName(valueString);
                break;
            }
            case 2: {
                content.setDescription(valueString);
            }
        }
        this.elementPreferPage.getContentList().contentChanged(content);
    }
}

