/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.editparts;

import java.util.List;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.TreeEditPart;
import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractTreeEditPart
extends AbstractEditPart
implements TreeEditPart {
    protected Widget widget;
    private boolean expanded;

    public AbstractTreeEditPart(Object model) {
        this.setModel(model);
    }

    public AbstractTreeEditPart() {
    }

    @Override
    protected void addChildVisual(EditPart childEditPart, int index) {
        TreeItem item;
        Widget curWidget = this.getWidget();
        if (curWidget instanceof Tree) {
            Tree tree = (Tree)curWidget;
            item = new TreeItem(tree, 0, index);
        } else {
            item = new TreeItem((TreeItem)curWidget, 0, index);
        }
        ((TreeEditPart)childEditPart).setWidget((Widget)item);
    }

    protected final boolean checkTreeItem() {
        return this.widget != null && !this.widget.isDisposed() && !(this.widget instanceof Tree);
    }

    @Override
    protected void createEditPolicies() {
    }

    public List<? extends TreeEditPart> getChildren() {
        return super.getChildren();
    }

    @Override
    public DragTracker getDragTracker(Request req) {
        return null;
    }

    protected Image getImage() {
        return null;
    }

    protected String getText() {
        return this.getClass().getName();
    }

    @Override
    public Widget getWidget() {
        return this.widget;
    }

    @Override
    protected void refreshVisuals() {
        this.setWidgetImage(this.getImage());
        this.setWidgetText(this.getText());
    }

    @Override
    protected void removeChildVisual(EditPart childEditPart) {
        TreeEditPart treeEditPart = (TreeEditPart)childEditPart;
        treeEditPart.getWidget().dispose();
        treeEditPart.setWidget(null);
    }

    @Override
    protected void reorderChild(EditPart editpart, int index) {
        super.reorderChild(editpart, index);
        editpart.refresh();
    }

    @Override
    public void setWidget(Widget widget) {
        if (widget != null) {
            widget.setData((Object)this);
            if (widget instanceof TreeItem) {
                TreeItem item = (TreeItem)widget;
                item.addDisposeListener(e -> {
                    boolean bl = this.expanded = item.getExpanded();
                });
            }
            for (TreeEditPart treeEditPart : this.getChildren()) {
                if (widget instanceof TreeItem) {
                    TreeItem ti = (TreeItem)widget;
                    treeEditPart.setWidget((Widget)new TreeItem(ti, 0));
                } else {
                    treeEditPart.setWidget((Widget)new TreeItem((Tree)widget, 0));
                }
                treeEditPart.refresh();
            }
            if (widget instanceof TreeItem) {
                TreeItem treeItem = (TreeItem)widget;
                treeItem.setExpanded(this.expanded);
            }
        } else {
            this.getChildren().forEach(child -> child.setWidget(null));
        }
        this.widget = widget;
    }

    protected final void setWidgetImage(Image image) {
        if (this.checkTreeItem()) {
            ((TreeItem)this.getWidget()).setImage(image);
        }
    }

    protected final void setWidgetText(String text) {
        if (this.checkTreeItem()) {
            ((TreeItem)this.getWidget()).setText(text);
        }
    }
}

