/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.dialogs;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;

public class TypeJavaSearchScope
implements IJavaSearchScope {
    private boolean includeExportedClassPathEntriesOnly = true;
    private ArrayList elements;
    private IPath[] paths;
    private boolean[] pathWithSubFolders;
    private int pathsCount;
    private IPath[] enclosingProjectsAndJars;

    public TypeJavaSearchScope() {
        this.initialize();
    }

    private void addEnclosingProjectOrJar(IPath path) {
        int length = this.enclosingProjectsAndJars.length;
        int i = 0;
        while (i < length) {
            if (this.enclosingProjectsAndJars[i].equals((Object)path)) {
                return;
            }
            ++i;
        }
        this.enclosingProjectsAndJars = new IPath[length + 1];
        System.arraycopy(this.enclosingProjectsAndJars, 0, this.enclosingProjectsAndJars, 0, length);
        this.enclosingProjectsAndJars[length] = path;
    }

    public void addProject(IJavaProject javaProject, boolean includesPrereqProjects, HashSet visitedProjects) throws JavaModelException {
        IProject project = javaProject.getProject();
        if (!project.isAccessible() || !visitedProjects.add(project)) {
            return;
        }
        this.addEnclosingProjectOrJar(project.getFullPath());
        IClasspathEntry[] entries = javaProject.getResolvedClasspath(true);
        IJavaModel model = javaProject.getJavaModel();
        int i = 0;
        int length = entries.length;
        while (i < length) {
            IClasspathEntry entry = entries[i];
            switch (entry.getEntryKind()) {
                case 1: {
                    IPath path = entry.getPath();
                    this.add(path, true);
                    this.addEnclosingProjectOrJar(path);
                    break;
                }
                case 2: {
                    if (!includesPrereqProjects) break;
                    this.add(model.getJavaProject(entry.getPath().lastSegment()), true, visitedProjects);
                    break;
                }
                case 3: {
                    this.add(entry.getPath(), true);
                }
            }
            ++i;
        }
    }

    public void add(IJavaProject javaProject, boolean includesPrereqProjects, HashSet visitedProjects) throws JavaModelException {
        IProject project = javaProject.getProject();
        if (!project.isAccessible() || !visitedProjects.add(project)) {
            return;
        }
        this.addEnclosingProjectOrJar(project.getFullPath());
        IClasspathEntry[] entries = javaProject.getResolvedClasspath(true);
        IJavaModel model = javaProject.getJavaModel();
        int i = 0;
        int length = entries.length;
        while (i < length) {
            IClasspathEntry entry = entries[i];
            if (!this.includeExportedClassPathEntriesOnly() || entry.isExported() || entry.getEntryKind() == 3) {
                switch (entry.getEntryKind()) {
                    case 1: {
                        IPath path = entry.getPath();
                        this.add(path, true);
                        this.addEnclosingProjectOrJar(path);
                        break;
                    }
                    case 2: {
                        if (!includesPrereqProjects) break;
                        this.add(model.getJavaProject(entry.getPath().lastSegment()), true, visitedProjects);
                        break;
                    }
                    case 3: {
                        this.add(entry.getPath(), true);
                    }
                }
            }
            ++i;
        }
    }

    public void add(IJavaElement element) throws JavaModelException {
        IPackageFragmentRoot root = null;
        switch (element.getElementType()) {
            case 1: {
                break;
            }
            case 2: {
                this.add((IJavaProject)element, true, new HashSet(2));
                break;
            }
            case 3: {
                root = (IPackageFragmentRoot)element;
                this.add(root.getPath(), true);
                break;
            }
            case 4: {
                root = (IPackageFragmentRoot)element.getParent();
                if (root.isArchive()) {
                    this.add(root.getPath().append((IPath)new Path(element.getElementName().replace('.', '/'))), false);
                    break;
                }
                IResource resource = element.getUnderlyingResource();
                if (resource == null || !resource.isAccessible()) break;
                this.add(resource.getFullPath(), false);
                break;
            }
            default: {
                if (element instanceof IMember) {
                    if (this.elements == null) {
                        this.elements = new ArrayList();
                    }
                    this.elements.add(element);
                }
                this.add(this.fullPath(element), true);
                IJavaElement parent = element.getParent();
                while (parent != null && !(parent instanceof IPackageFragmentRoot)) {
                    parent = parent.getParent();
                }
                if (!(parent instanceof IPackageFragmentRoot)) break;
                root = (IPackageFragmentRoot)parent;
            }
        }
        if (root != null) {
            if (root.getKind() == 2) {
                this.addEnclosingProjectOrJar(root.getPath());
            } else {
                this.addEnclosingProjectOrJar(root.getJavaProject().getProject().getFullPath());
            }
        }
    }

    private void add(IPath path, boolean withSubFolders) {
        if (this.paths.length == this.pathsCount) {
            this.paths = new IPath[this.pathsCount * 2];
            System.arraycopy(this.paths, 0, this.paths, 0, this.pathsCount);
            this.pathWithSubFolders = new boolean[this.pathsCount * 2];
            System.arraycopy(this.pathWithSubFolders, 0, this.pathWithSubFolders, 0, this.pathsCount);
        }
        this.paths[this.pathsCount] = path;
        this.pathWithSubFolders[this.pathsCount++] = withSubFolders;
    }

    public boolean encloses(String resourcePathString) {
        int separatorIndex = resourcePathString.indexOf("|");
        Object resourcePath = separatorIndex != -1 ? new Path(resourcePathString.substring(0, separatorIndex)).append((IPath)new Path(resourcePathString.substring(separatorIndex + 1))) : new Path(resourcePathString);
        return this.encloses((IPath)resourcePath);
    }

    private boolean encloses(IPath path) {
        int i = 0;
        while (i < this.pathsCount) {
            IPath scopePath;
            if (this.pathWithSubFolders[i] ? this.paths[i].isPrefixOf(path) : (scopePath = this.paths[i]).isPrefixOf(path) && scopePath.segmentCount() == path.segmentCount() - 1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean encloses(IJavaElement element) {
        if (this.elements != null) {
            int i = 0;
            int length = this.elements.size();
            while (i < length) {
                IJavaElement scopeElement = (IJavaElement)this.elements.get(i);
                IJavaElement searchedElement = element;
                while (searchedElement != null) {
                    if (searchedElement.equals(scopeElement)) {
                        return true;
                    }
                    searchedElement = searchedElement.getParent();
                }
                ++i;
            }
            return false;
        }
        return this.encloses(this.fullPath(element));
    }

    public IPath[] enclosingProjectsAndJars() {
        return this.enclosingProjectsAndJars;
    }

    private IPath fullPath(IJavaElement element) {
        Path childPath;
        IPath parentPath;
        if (element instanceof IPackageFragmentRoot) {
            return element.getPath();
        }
        IJavaElement parent = element.getParent();
        IPath iPath = parentPath = parent == null ? null : this.fullPath(parent);
        if (element instanceof IPackageFragment) {
            childPath = new Path(element.getElementName().replace('.', '/'));
        } else if (element instanceof IOpenable) {
            childPath = new Path(element.getElementName());
        } else {
            return parentPath;
        }
        return parentPath == null ? childPath : parentPath.append((IPath)childPath);
    }

    protected void initialize() {
        this.paths = new IPath[1];
        this.pathWithSubFolders = new boolean[1];
        this.pathsCount = 0;
        this.enclosingProjectsAndJars = new IPath[0];
    }

    public boolean includeExportedClassPathEntriesOnly() {
        return this.includeExportedClassPathEntriesOnly;
    }

    public void setIncludeExportedClassPathEntriesOnly(boolean includeExportedClassPathEntriesOnly) {
        this.includeExportedClassPathEntriesOnly = includeExportedClassPathEntriesOnly;
    }

    public boolean includesBinaries() {
        return true;
    }

    public boolean includesClasspaths() {
        return true;
    }

    public void setIncludesBinaries(boolean includesBinaries) {
    }

    public void setIncludesClasspaths(boolean includesClasspaths) {
    }
}

