/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.bnd;

import aQute.bnd.service.clipboard.Clipboard;
import java.util.Optional;
import java.util.function.Supplier;

public class SupplierClipboard
implements Clipboard {
    private final Supplier<Clipboard> supplier;

    public SupplierClipboard(Supplier<Clipboard> supplier) {
        this.supplier = supplier;
    }

    public <T> boolean copy(T content) {
        Clipboard clipboard = this.supplier.get();
        if (clipboard != null) {
            return clipboard.copy(content);
        }
        return false;
    }

    public <T> Optional<T> paste(Class<T> type) {
        return Optional.ofNullable(this.supplier.get()).flatMap(clipboard -> clipboard.paste(type));
    }
}

