/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.views.features;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.feature.FeatureEditor;
import org.eclipse.pde.internal.ui.editor.plugin.ManifestEditor;
import org.eclipse.pde.internal.ui.views.dependencies.OpenPluginDependenciesAction;
import org.eclipse.pde.internal.ui.views.features.action.CollapseAllAction;
import org.eclipse.pde.internal.ui.views.features.action.ContentProviderAction;
import org.eclipse.pde.internal.ui.views.features.action.FeatureAndPluginCopyAction;
import org.eclipse.pde.internal.ui.views.features.action.FilterFeatureChildAction;
import org.eclipse.pde.internal.ui.views.features.action.ShowCalleesContentProviderAction;
import org.eclipse.pde.internal.ui.views.features.action.ShowCallersContentProviderAction;
import org.eclipse.pde.internal.ui.views.features.action.ShowPluginsAction;
import org.eclipse.pde.internal.ui.views.features.action.ShowProductsAction;
import org.eclipse.pde.internal.ui.views.features.action.ViewerFilterAction;
import org.eclipse.pde.internal.ui.views.features.support.FeaturesViewInput;
import org.eclipse.pde.internal.ui.views.features.viewer.DeferredFeaturesViewInput;
import org.eclipse.pde.internal.ui.views.features.viewer.FeatureElementComparer;
import org.eclipse.pde.internal.ui.views.features.viewer.FeatureViewerComparator;
import org.eclipse.pde.internal.ui.views.features.viewer.RootElementsFilteredTree;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.part.ViewPart;

public class FeaturesView
extends ViewPart {
    private final Action fOpenAction = new Action(PDEUIMessages.FeaturesView_OpenAction_label){

        public void run() {
            FeaturesView.this.handleOpen();
        }
    };
    private final Collection<ViewerFilter> fViewerFilters = new ArrayList<ViewerFilter>();
    private PatternFilter fPatternFilter;
    private ViewerFilterAction fFilterFeatureChildAction;
    private ViewerFilterAction fShowPluginsAction;
    private ViewerFilterAction fShowProductsAction;
    private TreeViewer fViewer;
    private Clipboard fClipboard;
    private Action fCopyAction;
    private FeaturesViewInput fInput;

    public void createPartControl(Composite parent) {
        this.fInput = new FeaturesViewInput();
        FilteredTree filteredTree = this.createFilteredTree(parent);
        this.fViewer = filteredTree.getViewer();
        this.fPatternFilter = filteredTree.getPatternFilter();
        this.fClipboard = new Clipboard(parent.getDisplay());
        this.fCopyAction = new FeatureAndPluginCopyAction((StructuredViewer)this.fViewer, this.fClipboard, this.fInput);
        this.registerGlobalActions();
        this.contributeToActionBar();
        this.hookContextMenu();
        this.initializeViewer();
    }

    public void setFocus() {
        this.fViewer.getControl().setFocus();
    }

    public void dispose() {
        super.dispose();
        this.fInput.dispose();
        this.fClipboard.dispose();
    }

    private FilteredTree createFilteredTree(Composite parent) {
        RootElementsFilteredTree filteredTree = new RootElementsFilteredTree(parent, 770);
        filteredTree.setInitialText(PDEUIMessages.FeaturesView_searchPlaceholder);
        PatternFilter patternFilter = filteredTree.getPatternFilter();
        patternFilter.setIncludeLeadingWildcard(true);
        TreeViewer viewer = filteredTree.getViewer();
        viewer.setExpandPreCheckFilters(true);
        viewer.setComparer((IElementComparer)new FeatureElementComparer());
        viewer.setLabelProvider((IBaseLabelProvider)new PDELabelProvider());
        viewer.addDoubleClickListener(event -> this.handleOpen());
        viewer.addSelectionChangedListener(event -> {
            Collection<?> selection = this.getViewerSelection();
            this.fOpenAction.setEnabled(!selection.isEmpty());
            this.fCopyAction.setEnabled(!selection.isEmpty());
        });
        return filteredTree;
    }

    private void initializeViewer() {
        this.resetViewerFilters();
        this.fViewer.setComparator((ViewerComparator)new FeatureViewerComparator(this.fInput));
        this.fViewer.setInput((Object)new DeferredFeaturesViewInput(this.fInput));
    }

    private void resetViewerFilters() {
        this.fViewerFilters.clear();
        this.fViewerFilters.add((ViewerFilter)this.fPatternFilter);
        this.addViewerFilter(this.fViewerFilters, this.fFilterFeatureChildAction);
        this.addViewerFilter(this.fViewerFilters, this.fShowPluginsAction);
        this.addViewerFilter(this.fViewerFilters, this.fShowProductsAction);
        this.fViewer.setFilters(this.fViewerFilters.toArray(new ViewerFilter[this.fViewerFilters.size()]));
    }

    private void addViewerFilter(Collection<ViewerFilter> viewerFilters, ViewerFilterAction viewerFilterAction) {
        if (viewerFilterAction.isEnabled() && !viewerFilterAction.isChecked()) {
            viewerFilters.add(viewerFilterAction.getViewerFilter());
        }
    }

    public void toggle(ViewerFilter filter) {
        if (this.fViewerFilters.contains(filter)) {
            this.fViewerFilters.remove(filter);
        } else {
            this.fViewerFilters.add(filter);
        }
        this.resetViewerFilters();
    }

    public boolean isActive(ViewerFilter filter) {
        return this.fViewerFilters.contains(filter);
    }

    private void setContentProvider(IContentProvider contentProvider, boolean supportsFeatureChildFilter, boolean supportsPlugins, boolean supportsProducts) {
        this.fViewer.setContentProvider(contentProvider);
        this.fFilterFeatureChildAction.setEnabled(supportsFeatureChildFilter);
        this.fShowPluginsAction.setEnabled(supportsPlugins);
        this.fShowProductsAction.setEnabled(supportsProducts);
        this.resetViewerFilters();
    }

    public void configureContent(Consumer<FeaturesViewInput> configurator) {
        DeferredFeaturesViewInput deferredInput = (DeferredFeaturesViewInput)((Object)this.fViewer.getInput());
        configurator.accept(deferredInput.getFeaturesViewInput());
        this.fViewer.refresh();
    }

    private void registerGlobalActions() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.fCopyAction);
    }

    private void contributeToActionBar() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        toolBarManager.add((IAction)new CollapseAllAction(this.fViewer));
        toolBarManager.add((IContributionItem)new Separator());
        ShowCalleesContentProviderAction calleesAction = new ShowCalleesContentProviderAction(this, this.fInput);
        calleesAction.setChecked(true);
        toolBarManager.add((IAction)calleesAction);
        ShowCallersContentProviderAction callersAction = new ShowCallersContentProviderAction(this, this.fInput);
        toolBarManager.add((IAction)callersAction);
        toolBarManager.add((IContributionItem)new Separator());
        this.fFilterFeatureChildAction = new FilterFeatureChildAction(this);
        this.fFilterFeatureChildAction.setChecked(true);
        toolBarManager.add((IAction)this.fFilterFeatureChildAction);
        this.fShowPluginsAction = new ShowPluginsAction(this, this.fInput);
        toolBarManager.add((IAction)this.fShowPluginsAction);
        this.fShowProductsAction = new ShowProductsAction(this, this.fInput);
        toolBarManager.add((IAction)this.fShowProductsAction);
        this.setContentProvider(calleesAction);
        this.setContentProvider(callersAction);
        actionBars.updateActionBars();
    }

    private void hookContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(this::fillContextMenu);
        Menu menu = menuManager.createContextMenu(this.fViewer.getControl());
        this.fViewer.getControl().setMenu(menu);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.fOpenAction);
        IPluginModelBase selectedPluginModel = this.getSelectedPluginModel();
        if (selectedPluginModel != null) {
            OpenPluginDependenciesAction dependenciesAction = new OpenPluginDependenciesAction(selectedPluginModel);
            manager.add((IAction)dependenciesAction);
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.fCopyAction);
    }

    public void setContentProvider(ContentProviderAction contentProviderAction) {
        if (contentProviderAction.isChecked()) {
            this.setContentProvider(contentProviderAction.createContentProvider(), contentProviderAction.isSupportsFeatureChildFilter(), contentProviderAction.isSupportsPlugins(), contentProviderAction.isSupportsProducts());
        }
    }

    private void handleOpen() {
        for (Object selection : this.getViewerSelection()) {
            IFeatureModel featureModel = this.fInput.getFeatureSupport().toFeatureModel(selection);
            if (featureModel != null) {
                FeatureEditor.openFeatureEditor(featureModel);
                continue;
            }
            IPluginModelBase pluginModel = this.fInput.getPluginSupport().toPluginModel(selection);
            if (pluginModel != null) {
                ManifestEditor.openPluginEditor(pluginModel);
                continue;
            }
            IProductModel productModel = this.fInput.getProductSupport().toProductModel(selection);
            if (productModel == null) continue;
            this.fInput.getProductSupport().openProductEditor(productModel);
        }
    }

    private Collection<?> getViewerSelection() {
        return this.fViewer.getStructuredSelection().toList();
    }

    private IPluginModelBase getSelectedPluginModel() {
        return this.fInput.getPluginSupport().toSinglePluginModel((IStructuredSelection)this.fViewer.getStructuredSelection());
    }
}

