/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ExpandListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk4.GTK4;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.ScrollBar;

public class ExpandBar
extends Composite {
    ExpandItem[] items;
    ExpandItem lastFocus;
    int itemCount;
    int spacing;

    public ExpandBar(Composite parent, int style) {
        super(parent, style);
    }

    public void addExpandListener(ExpandListener listener) {
        this.addTypedListener(listener, 17, 18);
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    Point computeSizeInPixels(int wHint, int hHint, boolean changed) {
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        Point size = this.computeNativeSize(this.handle, wHint, hHint, changed);
        if (size.x == 0 && wHint == -1) {
            size.x = 64;
        }
        if (size.y == 0 && hHint == -1) {
            size.y = 64;
        }
        int border = this.gtk_container_get_border_width_or_margin(this.handle);
        size.x += 2 * border;
        size.y += 2 * border;
        return size;
    }

    @Override
    void createHandle(int index) {
        this.state |= 8;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.fixedHandle == 0L) {
            this.error(2);
        }
        if (!GTK.GTK4) {
            GTK3.gtk_widget_set_has_window(this.fixedHandle, true);
        }
        this.handle = this.gtk_box_new(1, false, 0);
        if (this.handle == 0L) {
            this.error(2);
        }
        if ((this.style & 0x200) != 0) {
            this.scrolledHandle = GTK.GTK4 ? GTK4.gtk_scrolled_window_new() : GTK3.gtk_scrolled_window_new(0L, 0L);
            if (this.scrolledHandle == 0L) {
                this.error(2);
            }
            GTK.gtk_scrolled_window_set_policy(this.scrolledHandle, 2, 1);
            if (GTK.GTK4) {
                OS.swt_fixed_add(this.fixedHandle, this.scrolledHandle);
                GTK4.gtk_scrolled_window_set_child(this.scrolledHandle, this.handle);
            } else {
                GTK3.gtk_container_add(this.fixedHandle, this.scrolledHandle);
                GTK3.gtk_container_add(this.scrolledHandle, this.handle);
            }
            if (!GTK.GTK4) {
                long viewport = GTK3.gtk_bin_get_child(this.scrolledHandle);
                GTK3.gtk_viewport_set_shadow_type(viewport, 0);
            }
        } else if (GTK.GTK4) {
            OS.swt_fixed_add(this.fixedHandle, this.handle);
        } else {
            GTK3.gtk_container_add(this.fixedHandle, this.handle);
        }
        this.gtk_container_set_border_width(this.handle, 0);
        this.setFontDescription(this.defaultFont().handle);
    }

    void createItem(ExpandItem item, int style, int index) {
        if (index < 0 || index > this.itemCount) {
            this.error(6);
        }
        if (this.itemCount == this.items.length) {
            ExpandItem[] newItems = new ExpandItem[this.itemCount + 4];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        System.arraycopy(this.items, index, this.items, index + 1, this.itemCount - index);
        this.items[index] = item;
        ++this.itemCount;
        item.width = Math.max(0, this.getClientAreaInPixels().width - this.spacing * 2);
        this.layoutItems();
    }

    @Override
    void createWidget(int index) {
        super.createWidget(index);
        this.items = new ExpandItem[4];
    }

    void destroyItem(ExpandItem item) {
        int index = 0;
        while (index < this.itemCount) {
            if (this.items[index] == item) break;
            ++index;
        }
        if (index == this.itemCount) {
            return;
        }
        System.arraycopy(this.items, index + 1, this.items, index, --this.itemCount - index);
        this.items[this.itemCount] = null;
        this.layoutItems();
    }

    @Override
    long eventHandle() {
        return this.fixedHandle;
    }

    @Override
    boolean forceFocus(long focusHandle) {
        if (this.lastFocus != null && this.lastFocus.setFocus()) {
            return true;
        }
        int i = 0;
        while (i < this.itemCount) {
            ExpandItem item = this.items[i];
            if (item.setFocus()) {
                return true;
            }
            ++i;
        }
        return super.forceFocus(focusHandle);
    }

    @Override
    boolean hasFocus() {
        int i = 0;
        while (i < this.itemCount) {
            ExpandItem item = this.items[i];
            if (item.hasFocus()) {
                return true;
            }
            ++i;
        }
        return super.hasFocus();
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        if (!GTK.GTK4 && this.scrolledHandle != 0L) {
            OS.g_signal_connect_closure(this.scrolledHandle, OS.size_allocate, this.display.getClosure(47), true);
        }
    }

    public ExpandItem getItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            this.error(6);
        }
        return this.items[index];
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public ExpandItem[] getItems() {
        this.checkWidget();
        ExpandItem[] result = new ExpandItem[this.itemCount];
        System.arraycopy(this.items, 0, result, 0, this.itemCount);
        return result;
    }

    public int getSpacing() {
        this.checkWidget();
        return this.spacing;
    }

    @Override
    long gtk3_key_press_event(long widget, long event) {
        if (!this.hasFocus()) {
            return 0L;
        }
        long result = super.gtk3_key_press_event(widget, event);
        if (result != 0L) {
            return result;
        }
        int index = 0;
        while (index < this.itemCount) {
            if (this.items[index].hasFocus()) break;
            ++index;
        }
        int[] key = new int[1];
        if (GTK.GTK4) {
            key[0] = GDK.gdk_key_event_get_keyval(event);
        } else {
            GDK.gdk_event_get_keyval(event, key);
        }
        boolean next = false;
        switch (key[0]) {
            case 65361: 
            case 65362: {
                next = false;
                break;
            }
            case 65363: 
            case 65364: {
                next = true;
                break;
            }
            default: {
                return result;
            }
        }
        int start = index;
        int offset = next ? 1 : -1;
        while ((index = (index + offset + this.itemCount) % this.itemCount) != start) {
            ExpandItem item = this.items[index];
            if (!item.setFocus()) continue;
            return result;
        }
        return result;
    }

    public int indexOf(ExpandItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        int i = 0;
        while (i < this.itemCount) {
            if (this.items[i] == item) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    void layoutItems() {
        int i = 0;
        while (i < this.itemCount) {
            ExpandItem item = this.items[i];
            if (item != null) {
                item.resizeControl();
            }
            ++i;
        }
    }

    @Override
    long gtk_size_allocate(long widget, long allocation) {
        long result = super.gtk_size_allocate(widget, allocation);
        this.layoutItems();
        return result;
    }

    @Override
    long parentingHandle() {
        return this.fixedHandle;
    }

    @Override
    void releaseChildren(boolean destroy) {
        int i = 0;
        while (i < this.itemCount) {
            ExpandItem item = this.items[i];
            if (item != null && !item.isDisposed()) {
                item.release(false);
            }
            ++i;
        }
        super.releaseChildren(destroy);
    }

    public void removeExpandListener(ExpandListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(17, listener);
        this.eventTable.unhook(18, listener);
    }

    @Override
    void reskinChildren(int flags) {
        if (this.items != null) {
            int i = 0;
            while (i < this.items.length) {
                ExpandItem item = this.items[i];
                if (item != null) {
                    item.reskin(flags);
                }
                ++i;
            }
        }
        super.reskinChildren(flags);
    }

    @Override
    void setWidgetBackground() {
        GdkRGBA rgba = (this.state & 0x2000) != 0 ? this.getBackgroundGdkRGBA() : null;
        super.setBackgroundGdkRGBA(this.handle, rgba);
    }

    @Override
    void setFontDescription(long font) {
        super.setFontDescription(font);
        int i = 0;
        while (i < this.itemCount) {
            this.items[i].setFontDescription(font);
            ++i;
        }
        this.layoutItems();
    }

    @Override
    void setForegroundGdkRGBA(GdkRGBA rgba) {
        super.setForegroundGdkRGBA(rgba);
        int i = 0;
        while (i < this.itemCount) {
            this.items[i].setForegroundRGBA(rgba);
            ++i;
        }
    }

    @Override
    void setOrientation(boolean create) {
        super.setOrientation(create);
        if (this.items != null) {
            int i = 0;
            while (i < this.items.length) {
                if (this.items[i] != null) {
                    this.items[i].setOrientation(create);
                }
                ++i;
            }
        }
    }

    public void setSpacing(int spacing) {
        this.checkWidget();
        if (spacing < 0) {
            return;
        }
        if (spacing == this.spacing) {
            return;
        }
        this.spacing = spacing;
        GTK.gtk_box_set_spacing(this.handle, spacing);
        this.gtk_container_set_border_width(this.handle, spacing);
    }

    @Override
    void updateScrollBarValue(ScrollBar bar) {
        this.layoutItems();
    }
}

