/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.parameters.parameters;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Priority implements Enumerator
{
    MEDIUM(0, "medium", "medium"),
    LOW(1, "low", "low"),
    HIGH(2, "high", "high");

    public static final int MEDIUM_VALUE = 0;
    public static final int LOW_VALUE = 1;
    public static final int HIGH_VALUE = 2;
    private static final Priority[] VALUES_ARRAY;
    public static final List<Priority> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Priority[]{MEDIUM, LOW, HIGH};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Priority get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Priority result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Priority getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Priority result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Priority get(int value) {
        switch (value) {
            case 0: {
                return MEDIUM;
            }
            case 1: {
                return LOW;
            }
            case 2: {
                return HIGH;
            }
        }
        return null;
    }

    private Priority(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

