/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.schema;

import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.internal.core.ischema.ISchemaComplexType;
import org.eclipse.pde.internal.core.ischema.ISchemaElement;
import org.eclipse.pde.internal.core.ischema.ISchemaObject;
import org.eclipse.pde.internal.core.schema.Schema;
import org.eclipse.pde.internal.core.schema.SchemaElement;
import org.eclipse.pde.internal.core.schema.SchemaElementReference;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.schema.AbstractSchemaDetails;
import org.eclipse.pde.internal.ui.editor.schema.ElementSection;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SchemaElementDetails
extends AbstractSchemaDetails {
    private SchemaElement fElement;
    private FormEntry fName;
    private Button fDepTrue;
    private Button fDepFalse;
    private Button fTransTrue;
    private Button fTransFalse;

    public SchemaElementDetails(ElementSection section) {
        super(section, true, true);
    }

    @Override
    public void createDetails(Composite parent) {
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        Color foreground = toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE");
        this.fName = new FormEntry(parent, toolkit, PDEUIMessages.SchemaDetails_name, 0);
        ((GridData)this.fName.getLabel().getLayoutData()).widthHint = this.minLabelWeight;
        Label label = toolkit.createLabel(parent, PDEUIMessages.SchemaDetails_deprecated);
        label.setForeground(foreground);
        Button[] buttons = this.createTrueFalseButtons(parent, toolkit, 2);
        this.fDepTrue = buttons[0];
        this.fDepFalse = buttons[1];
        label = toolkit.createLabel(parent, PDEUIMessages.SchemaDetails_translatable);
        label.setForeground(foreground);
        buttons = this.createTrueFalseButtons(parent, toolkit, 2);
        this.fTransTrue = buttons[0];
        this.fTransFalse = buttons[1];
        this.setText(PDEUIMessages.SchemaElementDetails_title);
    }

    @Override
    public void updateFields(ISchemaObject object) {
        if (object instanceof SchemaElementReference) {
            object = ((SchemaElementReference)object).getReferencedObject();
        }
        this.fElement = (SchemaElement)object;
        if (this.fElement == null) {
            return;
        }
        this.setDecription(NLS.bind((String)PDEUIMessages.SchemaElementDetails_description, (Object)this.fElement.getName()));
        this.fName.setValue(this.fElement.getName(), true);
        this.fDepTrue.setSelection(this.fElement.isDeprecated());
        this.fDepFalse.setSelection(!this.fElement.isDeprecated());
        boolean isTranslatable = true;
        if (this.fElement.getType() instanceof ISchemaComplexType && ((ISchemaComplexType)this.fElement.getType()).getCompositor() != null || this.fElement.getAttributeCount() != 0) {
            isTranslatable = false;
        }
        this.fTransTrue.setSelection(this.fElement.hasTranslatableContent());
        this.fTransFalse.setSelection(!this.fElement.hasTranslatableContent());
        boolean editable = this.isEditableElement();
        this.fName.setEditable(editable);
        this.fDepTrue.setEnabled(editable);
        this.fDepFalse.setEnabled(editable);
        this.fTransTrue.setEnabled(editable && isTranslatable);
        this.fTransFalse.setEnabled(editable && isTranslatable);
    }

    @Override
    public void hookListeners() {
        this.fName.setFormEntryListener(new FormEntryAdapter(this){

            @Override
            public void textValueChanged(FormEntry entry) {
                if (SchemaElementDetails.this.blockListeners()) {
                    return;
                }
                boolean revert = false;
                if (SchemaElementDetails.this.fName.getValue().length() == 0) {
                    revert = true;
                } else {
                    ISchemaElement[] elements;
                    ISchemaElement[] iSchemaElementArray = elements = SchemaElementDetails.this.fElement.getSchema().getElements();
                    int n = elements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ISchemaElement element = iSchemaElementArray[n2];
                        if (element != SchemaElementDetails.this.fElement && element.getName().equalsIgnoreCase(SchemaElementDetails.this.fName.getValue())) {
                            revert = true;
                            break;
                        }
                        ++n2;
                    }
                }
                if (revert) {
                    SchemaElementDetails.this.fName.setValue(SchemaElementDetails.this.fElement.getName(), true);
                } else {
                    SchemaElementDetails.this.fElement.setName(SchemaElementDetails.this.fName.getValue());
                    ((Schema)SchemaElementDetails.this.fElement.getSchema()).updateReferencesFor((ISchemaElement)SchemaElementDetails.this.fElement, 3);
                    SchemaElementDetails.this.setDecription(NLS.bind((String)PDEUIMessages.SchemaElementDetails_description, (Object)SchemaElementDetails.this.fElement.getName()));
                }
            }
        });
        this.fDepTrue.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (this.blockListeners()) {
                return;
            }
            this.fElement.setDeprecatedProperty(this.fDepTrue.getSelection());
        }));
        this.fTransTrue.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (this.blockListeners()) {
                return;
            }
            this.fElement.setTranslatableProperty(this.fTransTrue.getSelection());
        }));
    }

    @Override
    public void modelChanged(IModelChangedEvent event) {
        Object[] changedObjs = event.getChangedObjects();
        if (event.getChangeType() == 1 && changedObjs.length > 0 && changedObjs[0] instanceof SchemaElement) {
            this.fName.getText().setFocus();
        }
        super.modelChanged(event);
    }

    public void commit(boolean onSave) {
        super.commit(onSave);
        this.fName.commit();
    }
}

