/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.workspace.wizard.project.create;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.dirigible.ide.common.status.StatusLineManagerUtil;
import org.eclipse.dirigible.ide.workspace.wizard.project.create.Messages;
import org.eclipse.dirigible.ide.workspace.wizard.project.create.NewProjectWizardMainPage;
import org.eclipse.dirigible.ide.workspace.wizard.project.create.NewProjectWizardModel;
import org.eclipse.dirigible.ide.workspace.wizard.project.create.NewProjectWizardTemplateTypePage;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class NewProjectWizard
extends Wizard {
    private static final String COULD_NOT_CREATE_PROJECT = Messages.NewProjectWizard_COULD_NOT_CREATE_PROJECT;
    private static final String OPERATION_FAILED = Messages.NewProjectWizard_OPERATION_FAILED;
    private static final String PROJECT_S_CREATED_SUCCESSFULLY = Messages.NewProjectWizard_PROJECT_S_CREATED_SUCCESSFULLY;
    private static final String WINDOW_TITLE = Messages.NewProjectWizard_WINDOW_TITLE;
    private final NewProjectWizardModel model;
    private final NewProjectWizardMainPage mainPage;
    private final NewProjectWizardTemplateTypePage templatesPage;
    private static final Logger logger = Logger.getLogger(NewProjectWizard.class);

    public NewProjectWizard() {
        this.setWindowTitle(WINDOW_TITLE);
        this.model = new NewProjectWizardModel();
        this.mainPage = new NewProjectWizardMainPage(this.model);
        this.templatesPage = new NewProjectWizardTemplateTypePage(this.model);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.mainPage);
        this.addPage((IWizardPage)this.templatesPage);
    }

    public boolean performFinish() {
        logger.info(String.format(PROJECT_S_CREATED_SUCCESSFULLY, this.mainPage.getProjectName()));
        boolean result = this.onFinish();
        if (result) {
            StatusLineManagerUtil.setInfoMessage((String)String.format(StatusLineManagerUtil.ARTIFACT_HAS_BEEN_CREATED, this.mainPage.getProjectName()));
        }
        return result;
    }

    public void showErrorDialog(String title, String message) {
        logger.error(message);
        MessageDialog.openError(null, (String)title, (String)message);
    }

    public boolean onFinish() {
        try {
            this.model.execute();
            return true;
        }
        catch (CoreException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            this.showErrorDialog(OPERATION_FAILED, String.format(COULD_NOT_CREATE_PROJECT, ex.getMessage()));
            return false;
        }
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (this.model.isUseTemplate()) {
            return super.getNextPage(page);
        }
        return null;
    }
}

