/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.registry;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.MissingResourceException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.eclipse.dirigible.repository.api.ContentTypeHelper;
import org.eclipse.dirigible.repository.api.ICollection;
import org.eclipse.dirigible.repository.api.IEntity;
import org.eclipse.dirigible.repository.api.IEntityInformation;
import org.eclipse.dirigible.repository.api.IResource;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.registry.AbstractRegistryServlet;
import org.eclipse.dirigible.runtime.registry.Messages;

public class RegistryServlet
extends AbstractRegistryServlet {
    private static final String CONTENT_LENGTH_HEADER = "Content-Length";
    private static final String LAST_MODIFIED_HEADER = "Last-Modified";
    private static final String EXPIRES_HEADER = "Expires";
    private static final String IF_MODIFIED_SINCE_HEADER = "If-Modified-Since";
    private static final String ACCEPT_HEADER = "Accept";
    private static final String INDEX_HTML = "index.html";
    private static final String LISTING_OF_FOLDERS_IS_FORBIDDEN = Messages.getString("RegistryServlet.LISTING_OF_FOLDERS_IS_FORBIDDEN");
    private static final String JSON = "json";
    private static final String JSON_FOLDER = "folder";
    private static final String JSON_ROOT = "root";
    private static final String JSON_PATH = "path";
    private static final String JSON_NAME = "name";
    private static final String JSON_FILES = "files";
    private static final String REQUEST_PROCESSING_FAILED_S = "";
    private static final long serialVersionUID = 7435479651482177443L;
    private static final Logger logger = Logger.getLogger(RegistryServlet.class);
    public static final String PATTERN_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public static final String PATTERN_RFC1036 = "EEE, dd-MMM-yy HH:mm:ss zzz";
    public static final String PATTERN_ASCTIME = "EEE MMM d HH:mm:ss yyyy";
    public static final String[] DATE_FORMATS = new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz", "EEE, dd-MMM-yy HH:mm:ss zzz", "EEE MMM d HH:mm:ss yyyy"};
    private static final String SINGLE_QUOTE = "'";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String repositoryPath = null;
        String requestPath = request.getPathInfo();
        boolean deep = false;
        if (requestPath == null) {
            deep = true;
        }
        ServletOutputStream out = response.getOutputStream();
        try {
            byte[] data;
            repositoryPath = this.extractRepositoryPath(request);
            IEntity entity = this.getEntity(repositoryPath, request);
            if (entity == null) {
                this.exceptionHandler(response, repositoryPath, 404, String.format("Resource at [%s] does not exist", requestPath));
                return;
            }
            if (entity instanceof IResource) {
                data = this.buildResourceData(entity, request, response);
            } else {
                if (!(entity instanceof ICollection)) {
                    this.exceptionHandler(response, repositoryPath, 403, LISTING_OF_FOLDERS_IS_FORBIDDEN);
                    return;
                }
                String collectionPath = request.getRequestURI().toString();
                String acceptHeader = request.getHeader(ACCEPT_HEADER);
                if (acceptHeader != null && acceptHeader.contains(JSON)) {
                    if (!collectionPath.endsWith("/")) {
                        collectionPath = String.valueOf(collectionPath) + "/";
                    }
                    data = this.buildCollectionData(deep, entity, collectionPath);
                } else {
                    IResource index = ((ICollection)entity).getResource(INDEX_HTML);
                    if (index.exists() && collectionPath.endsWith("/")) {
                        data = this.buildResourceData((IEntity)index, request, response);
                    } else {
                        this.exceptionHandler(response, repositoryPath, 403, LISTING_OF_FOLDERS_IS_FORBIDDEN);
                        return;
                    }
                }
            }
            if (entity instanceof IResource) {
                IResource resource = (IResource)entity;
                String mimeType = null;
                String extension = ContentTypeHelper.getExtension((String)resource.getName());
                mimeType = ContentTypeHelper.getContentType((String)extension);
                if (mimeType != null) {
                    response.setContentType(mimeType);
                } else {
                    response.setContentType(resource.getContentType());
                }
            }
            this.sendData((OutputStream)out, data);
            this.setContentLengthHeader(entity, data.length, request, response);
            return;
        }
        catch (IllegalArgumentException ex) {
            this.exceptionHandler(response, repositoryPath, 400, ex.getMessage());
            return;
        }
        catch (MissingResourceException ex) {
            this.exceptionHandler(response, repositoryPath, 204, ex.getMessage());
            return;
        }
        catch (RuntimeException ex) {
            this.exceptionHandler(response, repositoryPath, 500, ex.getMessage());
            return;
        }
        finally {
            out.flush();
            out.close();
        }
    }

    private void exceptionHandler(HttpServletResponse response, String repositoryPath, int errorMessage, String exceptionMessage) throws IOException {
        logger.error(String.valueOf(String.format(REQUEST_PROCESSING_FAILED_S, repositoryPath)) + exceptionMessage);
        response.sendError(errorMessage, exceptionMessage);
    }

    protected byte[] buildCollectionData(boolean deep, IEntity entity, String collectionPath) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(baos);
        JsonObject rootObject = new JsonObject();
        rootObject.addProperty(JSON_NAME, JSON_ROOT);
        rootObject.addProperty(JSON_PATH, "/");
        rootObject.add(JSON_FILES, (JsonElement)this.enumerateCollectionData(collectionPath, (ICollection)entity, deep));
        writer.println(new Gson().toJson((JsonElement)rootObject));
        writer.flush();
        byte[] data = baos.toByteArray();
        return data;
    }

    protected byte[] buildResourceData(IEntity entity, HttpServletRequest request, HttpServletResponse response) throws IOException {
        byte[] data = new byte[]{};
        if (!this.setCacheHeaders(entity, request, response)) {
            data = this.readResourceData((IResource)entity);
        }
        return data;
    }

    private void setContentLengthHeader(IEntity entity, int contentLength, HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setHeader(CONTENT_LENGTH_HEADER, Integer.toString(contentLength));
    }

    private boolean setCacheHeaders(IEntity entity, HttpServletRequest request, HttpServletResponse response) throws IOException {
        boolean cached = false;
        IEntityInformation entityInformation = entity.getInformation();
        String modifiedSinceHeader = request.getHeader(IF_MODIFIED_SINCE_HEADER);
        if (entityInformation != null) {
            Calendar modifiedSince;
            Calendar lastModified = this.getCalendar(entityInformation.getModifiedAt());
            if (!StringUtils.isEmpty((String)modifiedSinceHeader) && lastModified.compareTo(modifiedSince = this.getCalendar(this.parseDate(modifiedSinceHeader))) <= 0) {
                Calendar expires = this.getCalendar(lastModified);
                expires.add(2, 1);
                response.setDateHeader(EXPIRES_HEADER, expires.getTimeInMillis());
                response.setStatus(304);
                cached = true;
            }
            response.setDateHeader(LAST_MODIFIED_HEADER, lastModified.getTimeInMillis());
        }
        return cached;
    }

    private Date parseDate(String modifiedSinceHeader) {
        Calendar calendar = Calendar.getInstance();
        if (modifiedSinceHeader.length() > 1 && modifiedSinceHeader.startsWith(SINGLE_QUOTE) && modifiedSinceHeader.endsWith(SINGLE_QUOTE)) {
            modifiedSinceHeader = modifiedSinceHeader.substring(1, modifiedSinceHeader.length() - 1);
        }
        String[] stringArray = DATE_FORMATS;
        int n = DATE_FORMATS.length;
        int n2 = 0;
        while (n2 < n) {
            String format = stringArray[n2];
            SimpleDateFormat dateParser = new SimpleDateFormat(format);
            dateParser.set2DigitYearStart(calendar.getTime());
            ParsePosition pos = new ParsePosition(0);
            Date result = dateParser.parse(modifiedSinceHeader, pos);
            if (pos.getIndex() != 0) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    private Calendar getCalendar(Calendar calendar) {
        return this.getCalendar(calendar.getTime());
    }

    private Calendar getCalendar(Date time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(time);
        calendar.clear(14);
        return calendar;
    }

    private JsonArray enumerateCollectionData(String collectionPath, ICollection collection, boolean deep) throws IOException {
        JsonArray arr = new JsonArray();
        this.childItterate(arr, collectionPath, collection, deep, collection.getCollectionsNames(), true);
        this.childItterate(arr, collectionPath, collection, deep, collection.getResourcesNames(), false);
        return arr;
    }

    private void childItterate(JsonArray arr, String collectionPath, ICollection collection, boolean deep, List<String> collections, Boolean isFolder) throws IOException {
        for (String collectionName : collections) {
            JsonArray children;
            String path = String.valueOf(collectionPath) + collectionName + (isFolder != false ? "/" : REQUEST_PROCESSING_FAILED_S);
            JsonObject elementObject = new JsonObject();
            elementObject.addProperty(JSON_NAME, collectionName);
            elementObject.addProperty(JSON_PATH, path);
            if (isFolder.booleanValue()) {
                elementObject.addProperty(JSON_FOLDER, isFolder);
            }
            if (deep && isFolder.booleanValue() && (children = this.enumerateCollectionData(path, collection.getCollection(collectionName), deep)).size() != 0) {
                elementObject.add(JSON_FILES, (JsonElement)children);
            }
            arr.add((JsonElement)elementObject);
        }
    }
}

