/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.listener;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import java.util.Set;
import org.eclipse.dirigible.repository.ext.utils.InstanceUtils;
import org.eclipse.dirigible.repository.ext.utils.JsonUtils;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.listener.Listener;
import org.eclipse.dirigible.runtime.listener.log.ListenerLog;
import org.eclipse.dirigible.runtime.listener.log.ListenerLogRecordDAO;
import org.eclipse.dirigible.runtime.scripting.IScriptExecutor;
import org.eclipse.dirigible.runtime.scripting.utils.EngineUtils;

public class ListenerProcessor {
    private static final Logger logger = Logger.getLogger(ListenerProcessor.class);

    public static void executeByEngineType(String module, Map<Object, Object> executionContext, Listener listener) {
        ListenerProcessor.logListener(listener, executionContext, 1, "");
        try {
            Set types = EngineUtils.getTypes();
            for (String type : types) {
                if (type == null || !type.equalsIgnoreCase(listener.getType())) continue;
                IScriptExecutor scriptExecutor = EngineUtils.createExecutor((String)type, null);
                scriptExecutor.executeServiceModule(null, null, module, executionContext);
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            ListenerProcessor.logListener(listener, executionContext, 2, e.getMessage());
        }
        ListenerProcessor.logListener(listener, executionContext, 3, "");
    }

    private static void logListener(Listener listener, Map<Object, Object> executionContext, int status, String message) {
        ListenerLog listenerLog = new ListenerLog();
        listenerLog.setInstance(InstanceUtils.getInstanceName());
        listenerLog.setListenerName(listener.getName());
        listenerLog.setListenerUUID(listener.getListenerUUID());
        listenerLog.setStatus(status);
        listenerLog.setMessage(message);
        listenerLog.setContext(JsonUtils.mapToJson(executionContext));
        try {
            ListenerLogRecordDAO.insert(listenerLog);
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

