/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.lifecycle;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.rap.rwt.internal.lifecycle.ILifeCycle;
import org.eclipse.rap.rwt.internal.lifecycle.PhaseEvent;
import org.eclipse.rap.rwt.internal.lifecycle.PhaseId;
import org.eclipse.rap.rwt.internal.lifecycle.PhaseListener;
import org.eclipse.rap.rwt.internal.service.ServletLog;
import org.eclipse.rap.rwt.internal.util.ParamCheck;

public class PhaseListenerManager {
    private final Object lock = new Object();
    private final Set<PhaseListener> phaseListeners = new HashSet<PhaseListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPhaseListener(PhaseListener phaseListener) {
        ParamCheck.notNull(phaseListener, "phaseListener");
        Object object = this.lock;
        synchronized (object) {
            this.phaseListeners.add(phaseListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePhaseListener(PhaseListener phaseListener) {
        ParamCheck.notNull(phaseListener, "phaseListener");
        Object object = this.lock;
        synchronized (object) {
            this.phaseListeners.remove(phaseListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PhaseListener[] getPhaseListeners() {
        Object object = this.lock;
        synchronized (object) {
            return this.phaseListeners.toArray(new PhaseListener[0]);
        }
    }

    void notifyBeforePhase(PhaseId phase, ILifeCycle eventSource) {
        PhaseListener[] phaseListeners = this.getPhaseListeners();
        PhaseEvent event = new PhaseEvent(eventSource, phase);
        int i = 0;
        while (i < phaseListeners.length) {
            PhaseListener phaseListener = phaseListeners[i];
            if (PhaseListenerManager.mustNotify(phase, phaseListener.getPhaseId())) {
                try {
                    phaseListener.beforePhase(event);
                }
                catch (Exception exception) {
                    PhaseListenerManager.logBeforePhaseException(phase, exception);
                }
            }
            ++i;
        }
    }

    void notifyAfterPhase(PhaseId phase, ILifeCycle eventSource) {
        PhaseListener[] phaseListeners = this.getPhaseListeners();
        PhaseEvent event = new PhaseEvent(eventSource, phase);
        int i = 0;
        while (i < phaseListeners.length) {
            PhaseListener phaseListener = phaseListeners[i];
            if (PhaseListenerManager.mustNotify(phase, phaseListener.getPhaseId())) {
                try {
                    phaseListener.afterPhase(event);
                }
                catch (Exception exception) {
                    PhaseListenerManager.logAfterPhaseException(phase, exception);
                }
            }
            ++i;
        }
    }

    public void clear() {
        this.phaseListeners.clear();
    }

    private static boolean mustNotify(PhaseId phase, PhaseId listenerPhase) {
        return listenerPhase == PhaseId.ANY || listenerPhase == phase;
    }

    private static void logBeforePhaseException(PhaseId phase, Exception exception) {
        String text = "Failed to execute PhaseListener before phase ''{0}''.";
        String msg = MessageFormat.format(text, phase);
        ServletLog.log(msg, exception);
    }

    private static void logAfterPhaseException(PhaseId phase, Exception exception) {
        String text = "Failed to execute PhaseListener after phase ''{0}''.";
        String msg = MessageFormat.format(text, phase);
        ServletLog.log(msg, exception);
    }
}

