/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.registry.conf;

import java.io.IOException;
import org.eclipse.dirigible.ide.repository.RepositoryFacade;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.api.IResource;
import org.eclipse.dirigible.repository.api.RepositoryException;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class HomeLocationPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final Logger logger = Logger.getLogger(HomeLocationPreferencePage.class);
    private StringFieldEditor homeUrlField;

    public HomeLocationPreferencePage() {
        super(1);
    }

    public void init(IWorkbench workbench) {
        super.initialize();
    }

    protected void createFieldEditors() {
        this.homeUrlField = new StringFieldEditor("home.location", "&Home Location:", this.getFieldEditorParent());
        Text text = this.homeUrlField.getTextControl(this.getFieldEditorParent());
        String homeUrl = this.getHomeUrl();
        text.setText(homeUrl != null ? homeUrl : "");
        this.addField((FieldEditor)this.homeUrlField);
    }

    private String getHomeUrl() {
        try {
            IRepository repository = RepositoryFacade.getInstance().getRepository();
            IResource resource = repository.getResource("/db/dirigible/registry/conf/registry/ui/home.location");
            if (resource.exists()) {
                return new String(resource.getContent());
            }
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return "services/ui/index.html";
    }

    private void setHomeUrl(String url) {
        try {
            IRepository repository = RepositoryFacade.getInstance().getRepository();
            IResource resource = repository.getResource("/db/dirigible/registry/conf/registry/ui/home.location");
            resource.setContent(url.getBytes());
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void storeValues() {
        String url = this.homeUrlField.getStringValue();
        this.setHomeUrl(url);
    }

    protected void performApply() {
        super.performApply();
        this.storeValues();
    }

    public boolean performOk() {
        this.storeValues();
        return super.performOk();
    }
}

