/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.ws;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.websocket.Session;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.scripting.IScriptExecutor;
import org.eclipse.dirigible.runtime.scripting.utils.EngineUtils;
import org.eclipse.dirigible.runtime.ws.WebSocketRequest;
import org.eclipse.dirigible.runtime.ws.WebSocketRequestParser;

public class WebSocketServiceBridgeServletInternal {
    private static final Logger logger = Logger.getLogger(WebSocketServiceBridgeServletInternal.class);
    private static final String PARAM_SESSION = "websocket-session";
    private static final String PARAM_SESSIONS = "websocket-sessions";
    public static Map<String, Session> openSessions = new ConcurrentHashMap<String, Session>();

    public void onOpen(Session session) throws IOException {
        openSessions.put(session.getId(), session);
        logger.debug("[ws:exec] onOpen: " + session.getId());
    }

    public void onMessage(String message, Session session, String type) {
        logger.debug("[ws:exec] onMessage: " + message + ", type: " + type);
        WebSocketRequest webSocketRequest = null;
        try {
            webSocketRequest = WebSocketRequestParser.parseRequest(message);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            try {
                session.getBasicRemote().sendText("Wrong format of the request");
            }
            catch (IOException iOException) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            return;
        }
        HashMap<Object, Object> executionContext = new HashMap<Object, Object>();
        executionContext.put(PARAM_SESSION, session);
        executionContext.put(PARAM_SESSIONS, openSessions);
        executionContext.putAll(webSocketRequest.getParams());
        Object result = WebSocketServiceBridgeServletInternal.executeByEngineType(webSocketRequest.getModule(), executionContext, type);
        if (result != null) {
            try {
                session.getBasicRemote().sendText(result.toString());
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private static Object executeByEngineType(String module, Map<Object, Object> executionContext, String serviceType) {
        try {
            Set types = EngineUtils.getAliases();
            for (String type : types) {
                if (type == null || !type.equalsIgnoreCase(serviceType)) continue;
                IScriptExecutor scriptExecutor = EngineUtils.createExecutorByAlias((String)type, null);
                return scriptExecutor.executeServiceModule(null, null, module, executionContext);
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public void onError(Session session, String error) {
        logger.debug("[ws:exec] onError: " + error);
    }

    public void onClose(Session session) {
        openSessions.remove(session.getId());
        logger.debug("[ws:exec] onClose: Session " + session.getId() + " has ended");
    }
}

