/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.ext.conf;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.dirigible.repository.api.ICollection;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.api.IResource;
import org.eclipse.dirigible.repository.ext.conf.IConfigurationStore;

public class ConfigurationStore
implements IConfigurationStore {
    private static final String REPOSITORY_OBJECT_IS_NULL_WHEN_SETTING_PROPERTIES = "Repository object is null, when setting properties";
    private static final String PROPERTIES_EXT = ".properties";
    private IRepository repository;

    public ConfigurationStore(IRepository repository) {
        this.repository = repository;
    }

    @Override
    public Properties getGlobalSettings(String path, String name) throws IOException {
        return this.getSettingsByRoot("/db/dirigible/registry/conf", path, name);
    }

    @Override
    public byte[] getGlobalSettingsAsBytes(String path, String name) throws IOException {
        return this.getSettingsByRootAsBytes("/db/dirigible/registry/conf", path, name);
    }

    @Override
    public void setGlobalSettings(String path, String name, Properties properties) throws IOException {
        this.setSettingsByRoot("/db/dirigible/registry/conf", path, name, properties);
    }

    @Override
    public void setGlobalSettingsAsBytes(String path, String name, byte[] bytes) throws IOException {
        this.setSettingsByRootAsBytes("/db/dirigible/registry/conf", path, name, bytes);
    }

    @Override
    public Properties getUserSettings(String path, String name, String userName) throws IOException {
        String root = this.getUserPath(userName);
        return this.getSettingsByRoot(root, path, name);
    }

    @Override
    public byte[] getUserSettingsAsBytes(String path, String name, String userName) throws IOException {
        String root = this.getUserPath(userName);
        return this.getSettingsByRootAsBytes(root, path, name);
    }

    @Override
    public void setUserSettings(String path, String name, Properties properties, String userName) throws IOException {
        String root = this.getUserPath(userName);
        this.setSettingsByRoot(root, path, name, properties);
    }

    @Override
    public void setUserSettingsAsBytes(String path, String name, byte[] bytes, String userName) throws IOException {
        String root = this.getUserPath(userName);
        this.setSettingsByRootAsBytes(root, path, name, bytes);
    }

    private String getUserPath(String userName) {
        return "/db/dirigible/users/" + userName + "conf" + "/";
    }

    private Properties getSettingsByRoot(String root, String path, String name) throws IOException {
        String normalizedPath = this.normalizePath(path);
        String resourcePath = String.valueOf(root) + normalizedPath + "/" + name + PROPERTIES_EXT;
        if (this.repository != null && this.repository.hasResource(resourcePath)) {
            IResource resource = this.repository.getResource(resourcePath);
            Properties properties = new Properties();
            properties.load(new ByteArrayInputStream(resource.getContent()));
            return properties;
        }
        return new Properties();
    }

    private byte[] getSettingsByRootAsBytes(String root, String path, String name) throws IOException {
        String normalizedPath = this.normalizePath(path);
        String resourcePath = String.valueOf(root) + normalizedPath + "/" + name + PROPERTIES_EXT;
        if (this.repository != null && this.repository.hasResource(resourcePath)) {
            IResource resource = this.repository.getResource(resourcePath);
            return resource.getContent();
        }
        return new byte[0];
    }

    private void setSettingsByRoot(String root, String path, String name, Properties properties) throws IOException {
        String normalizedPath = this.normalizePath(path);
        String resourcePath = String.valueOf(root) + normalizedPath + "/" + name + PROPERTIES_EXT;
        IResource resource = null;
        if (this.repository != null) {
            resource = this.repository.hasResource(resourcePath) ? this.repository.getResource(resourcePath) : this.repository.createResource(resourcePath);
        } else {
            throw new IOException(REPOSITORY_OBJECT_IS_NULL_WHEN_SETTING_PROPERTIES);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        properties.store(baos, resource.getPath());
        resource.setContent(baos.toByteArray());
    }

    private String normalizePath(String path) {
        if (path != null && !path.startsWith("/")) {
            String normalizedPath = "/" + path;
            return normalizedPath;
        }
        return path;
    }

    private void setSettingsByRootAsBytes(String root, String path, String name, byte[] bytes) throws IOException {
        String normalizedPath = this.normalizePath(path);
        String resourcePath = String.valueOf(root) + normalizedPath + "/" + name + PROPERTIES_EXT;
        IResource resource = null;
        if (this.repository != null) {
            resource = this.repository.hasResource(resourcePath) ? this.repository.getResource(resourcePath) : this.repository.createResource(resourcePath);
        } else {
            throw new IOException(REPOSITORY_OBJECT_IS_NULL_WHEN_SETTING_PROPERTIES);
        }
        resource.setContent(bytes);
    }

    @Override
    public List<String> listGlobalSettingsNames(String path) throws IOException {
        return this.listSettingsByRoot("/db/dirigible/registry/conf", path);
    }

    @Override
    public List<String> listUserSettingsNames(String path, String userName) throws IOException {
        String root = this.getUserPath(userName);
        return this.listSettingsByRoot(root, path);
    }

    private List<String> listSettingsByRoot(String root, String path) throws IOException {
        String normalizedPath = this.normalizePath(path);
        String collectionPath = String.valueOf(root) + normalizedPath;
        if (this.repository != null && this.repository.hasCollection(collectionPath)) {
            ICollection collection = this.repository.getCollection(collectionPath);
            return collection.getResourcesNames();
        }
        return new ArrayList<String>();
    }

    @Override
    public void removeGlobalSettings(String path, String name) throws IOException {
        this.removeSettingsByRoot("/db/dirigible/registry/conf", path, name);
    }

    @Override
    public void removeUserSettings(String path, String userName, String name) throws IOException {
        String root = this.getUserPath(userName);
        this.removeSettingsByRoot(root, path, name);
    }

    public void removeSettingsByRoot(String root, String path, String name) throws IOException {
        String normalizedPath = this.normalizePath(path);
        String resourcePath = String.valueOf(root) + normalizedPath + "/" + name + PROPERTIES_EXT;
        if (this.repository != null && this.repository.hasResource(resourcePath)) {
            this.repository.removeResource(resourcePath);
        }
    }

    @Override
    public boolean existsGlobalSettings(String path, String name) throws IOException {
        return this.existsSettingsByRoot("/db/dirigible/registry/conf", path, name);
    }

    @Override
    public boolean existsUserSettings(String path, String userName, String name) throws IOException {
        String root = this.getUserPath(userName);
        return this.existsSettingsByRoot(root, path, name);
    }

    public boolean existsSettingsByRoot(String root, String path, String name) throws IOException {
        String normalizedPath = this.normalizePath(path);
        String resourcePath = String.valueOf(root) + normalizedPath + "/" + name + PROPERTIES_EXT;
        return this.repository != null && this.repository.hasResource(resourcePath);
    }
}

