/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.local;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.dirigible.repository.api.ICollection;
import org.eclipse.dirigible.repository.api.IEntity;
import org.eclipse.dirigible.repository.api.IEntityInformation;
import org.eclipse.dirigible.repository.api.RepositoryPath;
import org.eclipse.dirigible.repository.local.FileSystemRepository;
import org.eclipse.dirigible.repository.local.LocalBaseException;
import org.eclipse.dirigible.repository.local.LocalCollection;
import org.eclipse.dirigible.repository.local.LocalEntityInformation;
import org.eclipse.dirigible.repository.local.LocalObject;
import org.eclipse.dirigible.repository.local.Messages;
import org.eclipse.dirigible.repository.logging.Logger;

public abstract class LocalEntity
implements IEntity {
    private static final String THERE_IS_NO_ENTITY_AT_PATH_0 = Messages.getString("DBEntity.THERE_IS_NO_ENTITY_AT_PATH_0");
    private static final Logger logger = Logger.getLogger(LocalEntity.class);
    private final FileSystemRepository repository;
    private final RepositoryPath path;

    public LocalEntity(FileSystemRepository repository, RepositoryPath path) {
        this.repository = repository;
        this.path = path;
    }

    public FileSystemRepository getRepository() {
        return this.repository;
    }

    protected RepositoryPath getRepositoryPath() {
        return this.path;
    }

    public String getName() {
        return this.path.getLastSegment();
    }

    public String getPath() {
        return this.path.toString();
    }

    public ICollection getParent() {
        RepositoryPath parentPath = this.path.getParentPath();
        if (parentPath == null) {
            return null;
        }
        return new LocalCollection(this.repository, parentPath);
    }

    public IEntityInformation getInformation() throws IOException {
        return new LocalEntityInformation(this.path, this.getLocalObjectSafe());
    }

    protected LocalObject getLocalObject() throws IOException {
        try {
            return this.repository.getRepositoryDAO().getObjectByPath(this.getPath());
        }
        catch (LocalBaseException ex) {
            logger.error(ex.getMessage(), (Throwable)((Object)ex));
            return null;
        }
    }

    protected LocalObject getLocalObjectSafe() throws IOException {
        LocalObject result = this.getLocalObject();
        if (result == null) {
            throw new IOException(MessageFormat.format(THERE_IS_NO_ENTITY_AT_PATH_0, this.path.toString()));
        }
        return result;
    }

    protected void createAncestorsIfMissing() throws IOException {
        ICollection parent = this.getParent();
        if (parent != null && !parent.exists()) {
            parent.create();
        }
    }

    protected void createAncestorsAndSelfIfMissing() throws IOException {
        this.createAncestorsIfMissing();
        if (!this.exists()) {
            this.create();
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LocalEntity)) {
            return false;
        }
        LocalEntity other = (LocalEntity)obj;
        return this.getPath().equals(other.getPath());
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }
}

