/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.flow;

import java.io.IOException;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.flow.FlowExecutor;
import org.eclipse.dirigible.runtime.scripting.AbstractScriptingServlet;

public class FlowServlet
extends AbstractScriptingServlet {
    private static final long serialVersionUID = -9115022531455267478L;
    private static final Logger logger = Logger.getLogger((String)FlowServlet.class.getCanonicalName());

    protected void doExecution(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String module = request.getPathInfo();
        FlowExecutor executor = this.createExecutor(request);
        try {
            HashMap executionContext = new HashMap();
            Object result = executor.executeServiceModule(request, response, module, executionContext);
            if (result != null && !response.isCommitted()) {
                response.getWriter().print(result.toString());
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            response.sendError(404, e.getMessage());
        }
    }

    public FlowExecutor createExecutor(HttpServletRequest request) throws IOException {
        FlowExecutor executor = new FlowExecutor(this.getRepository(request), this.getScriptingRegistryPath(request), "/db/dirigible/registry/public/IntegrationServices");
        return executor;
    }
}

