/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.helpgenerator.documentation.linkcreators;

import java.io.IOException;
import java.util.List;
import org.eclipse.ease.helpgenerator.documentation.IClassNameResolver;
import org.eclipse.ease.helpgenerator.documentation.ReferenceTokenizer;
import org.eclipse.ease.helpgenerator.documentation.linkcreators.ILinkCreator;

public class JavaDoc8LinkCreator
implements ILinkCreator {
    private final String fOnlineReference;
    private final List<String> fSiteContent;
    private final IClassNameResolver fClassNameResolver;

    public JavaDoc8LinkCreator(String onlineReference, List<String> siteContent, IClassNameResolver classNameResolver) {
        this.fOnlineReference = onlineReference;
        this.fSiteContent = siteContent;
        this.fClassNameResolver = classNameResolver;
    }

    @Override
    public String createLink(String reference) throws IOException {
        ReferenceTokenizer tokenizer = new ReferenceTokenizer(reference, this.fClassNameResolver);
        if (tokenizer.isLink()) {
            if (this.containsPackage(ReferenceTokenizer.getPackageName(tokenizer.getQualifiedName()))) {
                if (tokenizer.isMethod()) {
                    return this.createMethodLink(tokenizer.getQualifiedName(), tokenizer.getMethod(), tokenizer.getParameters());
                }
                if (tokenizer.isField()) {
                    return this.createFieldLink(tokenizer.getQualifiedName(), tokenizer.getMethod());
                }
                if (tokenizer.isConstructor()) {
                    return this.createConstructorLink(tokenizer.getQualifiedName(), tokenizer.getParameters());
                }
                if (tokenizer.isClass()) {
                    return this.createClassLink(tokenizer.getQualifiedName());
                }
            } else {
                throw new IOException("Unknown package: '" + reference + "'");
            }
        }
        throw new IOException("Unknown reference: '" + reference + "'");
    }

    private boolean containsPackage(String packageName) {
        return this.fSiteContent.contains(packageName);
    }

    private String createMethodLink(String qualifiedClassName, String method, String parameters) {
        StringBuilder builder = this.createAnchorAndClassString(qualifiedClassName);
        builder.append('#');
        builder.append(method);
        builder.append(this.getParametersString(parameters));
        builder.append("'>");
        builder.append(ReferenceTokenizer.getSimpleClassName(qualifiedClassName));
        builder.append('.');
        builder.append(method);
        builder.append('(');
        builder.append(parameters);
        builder.append(")</a>");
        return builder.toString();
    }

    private String createConstructorLink(String qualifiedClassName, String parameters) {
        StringBuilder builder = this.createAnchorAndClassString(qualifiedClassName);
        builder.append('#');
        builder.append(this.getConstructorString(qualifiedClassName));
        builder.append(this.getParametersString(parameters));
        builder.append("'>");
        builder.append("new ");
        builder.append(ReferenceTokenizer.getSimpleClassName(qualifiedClassName));
        builder.append('(');
        builder.append(parameters);
        builder.append(')');
        builder.append("</a>");
        return builder.toString();
    }

    public String createFieldLink(String qualifiedClassName, String field) {
        StringBuilder builder = this.createAnchorAndClassString(qualifiedClassName);
        builder.append('#');
        builder.append(field);
        builder.append("'>");
        builder.append(ReferenceTokenizer.getSimpleClassName(qualifiedClassName));
        builder.append('.');
        builder.append(field);
        builder.append("</a>");
        return builder.toString();
    }

    public String createClassLink(String qualifiedClassName) {
        StringBuilder builder = this.createAnchorAndClassString(qualifiedClassName);
        builder.append("'>");
        builder.append(ReferenceTokenizer.getSimpleClassName(qualifiedClassName));
        builder.append("</a>");
        return builder.toString();
    }

    protected StringBuilder createAnchorAndClassString(String qualifiedClassName) {
        String module = this.getModule(ReferenceTokenizer.getPackageName(qualifiedClassName));
        StringBuilder builder = new StringBuilder();
        builder.append("<a href='");
        builder.append(this.fOnlineReference);
        builder.append('/');
        if (!module.isEmpty()) {
            builder.append(module).append('/');
        }
        builder.append(qualifiedClassName.replaceAll("\\.", "/"));
        builder.append(".html");
        return builder;
    }

    protected String getParametersString(String parameters) {
        StringBuilder builder = new StringBuilder();
        builder.append('-');
        builder.append(parameters.replaceAll("\\[\\]", ":A").replaceAll(",", "-").replaceAll("\\s", ""));
        builder.append('-');
        return builder.toString();
    }

    protected String getConstructorString(String qualifiedClassName) {
        return ReferenceTokenizer.getSimpleClassName(qualifiedClassName);
    }

    protected String getModule(String packageName) {
        return "";
    }

    protected List<String> getSiteContent() {
        return this.fSiteContent;
    }
}

