/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.ObservableTestFilter;
import com.sun.javatest.exec.ExecModel;
import com.sun.javatest.util.I18NResourceBundle;
import java.util.Map;
import javax.swing.JComponent;

abstract class ConfigurableTestFilter
extends ObservableTestFilter {
    protected String instanceName;
    protected ExecModel execModel;
    protected static final String INSTANCE_KEY = "instanceName";
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(ConfigurableTestFilter.class);

    private ConfigurableTestFilter() {
    }

    protected ConfigurableTestFilter(String name, ExecModel e) {
        if (name == null) {
            throw new IllegalArgumentException(i18n.getString("ctf.nullName"));
        }
        if (e == null) {
            throw new IllegalArgumentException(i18n.getString("ctf.nullExec"));
        }
        this.instanceName = name;
        this.execModel = e;
    }

    protected ConfigurableTestFilter(Map map, ExecModel e) {
        if (e == null) {
            throw new IllegalArgumentException(i18n.getString("ctf.nullExec"));
        }
        this.execModel = e;
        this.load(map);
    }

    abstract ConfigurableTestFilter cloneInstance();

    public Object clone() {
        return this.cloneInstance();
    }

    abstract String getBaseName();

    void setInstanceName(String text) {
        if (text == null) {
            throw new IllegalArgumentException(i18n.getString("ctf.nullName"));
        }
        this.instanceName = text;
    }

    boolean load(Map map) {
        this.instanceName = (String)map.get(INSTANCE_KEY);
        if (this.instanceName == null) {
            throw new IllegalStateException(i18n.getString("ctf.mapNoName"));
        }
        return true;
    }

    boolean save(Map map) {
        map.put(INSTANCE_KEY, this.instanceName);
        return true;
    }

    abstract JComponent getEditorPane();

    abstract String commitEditorSettings();

    abstract void resetEditorSettings();

    abstract boolean isEditorChanged();
}

