/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.sigfile;

import com.sun.tdk.signaturetest.ModSetup;
import com.sun.tdk.signaturetest.core.AppContext;
import com.sun.tdk.signaturetest.core.context.ModSetupOptions;
import com.sun.tdk.signaturetest.core.context.Option;
import com.sun.tdk.signaturetest.model.ModuleDescription;
import com.sun.tdk.signaturetest.sigfile.FileManager;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class StructWriter {
    private final ModSetupOptions mo = AppContext.getContext().getBean(ModSetupOptions.class);
    private final Deque<ModuleDescription> modulesToWrite = new ArrayDeque<ModuleDescription>();
    private final Set<String> moduleNames = new HashSet<String>();
    private final Set<String> reportedModuleNames = new HashSet<String>();

    public boolean createStructFile(ModSetup.WriteMode wm, Map<String, ModuleDescription> model, Set<ModuleDescription> allModules) {
        HashMap<String, ModuleDescription> allModulesMap = new HashMap<String, ModuleDescription>();
        for (ModuleDescription md : allModules) {
            allModulesMap.put(md.getName(), md);
        }
        try {
            URL signatureFile = FileManager.getURL(this.mo.getValue(Option.TEST_URL), this.mo.getValue(Option.FILE_NAME));
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element str = doc.createElement("structure");
            str.setAttribute("title", "Static coverage report");
            doc.appendChild(str);
            for (ModuleDescription md : model.values()) {
                this.reportedModuleNames.add(md.getName());
                this.processModule(md, allModulesMap, wm);
            }
            for (ModuleDescription md : this.modulesToWrite) {
                Element inc;
                Element sec = doc.createElement("section");
                sec.setAttribute("name", md.getName());
                sec.setAttribute("title", "Module " + md.getName());
                sec.setAttribute("hidden", this.reportedModuleNames.contains(md.getName()) ? "false" : "true");
                for (String pkg : md.getPackages()) {
                    inc = doc.createElement("include");
                    inc.setAttribute("packages", pkg);
                    sec.appendChild(inc);
                }
                if (wm == ModSetup.WriteMode.STRUCT_CUMULATIVE) {
                    for (ModuleDescription.Requires rq : md.getRequires()) {
                        inc = doc.createElement("include");
                        inc.setAttribute("section", rq.getName());
                        sec.appendChild(inc);
                    }
                }
                str.appendChild(sec);
            }
            DOMSource domSource = new DOMSource(doc);
            FileWriter writer = new FileWriter(signatureFile.getFile());
            StreamResult result = new StreamResult(writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.transform(domSource, result);
            writer.close();
        }
        catch (IOException | ParserConfigurationException | TransformerException e) {
            e.printStackTrace();
        }
        return true;
    }

    private void processModule(ModuleDescription md, Map<String, ModuleDescription> allModulesMap, ModSetup.WriteMode wm) {
        if (this.moduleNames.contains(md.getName())) {
            return;
        }
        if (wm == ModSetup.WriteMode.STRUCT_CUMULATIVE) {
            for (ModuleDescription.Requires rq : md.getRequires()) {
                ModuleDescription mdr = allModulesMap.get(rq.getName());
                if (mdr == null) continue;
                this.processModule(mdr, allModulesMap, wm);
            }
        }
        this.modulesToWrite.addLast(md);
        this.moduleNames.add(md.getName());
    }
}

