/*
 * Copyright (c) 2012, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2020 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ia extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "arabe";
        final String metaValue_bn = "bengalese";
        final String metaValue_bo = "tibetano";
        final String metaValue_gu = "gujarati";
        final String metaValue_ja = "japonese";
        final String metaValue_km = "khmer";
        final String metaValue_kn = "kannada";
        final String metaValue_ml = "malayalam";
        final String metaValue_mn = "mongol";
        final String metaValue_si = "cingalese";
        final String metaValue_ta = "tamil";
        final String metaValue_te = "telugu";
        final Object[][] data = new Object[][] {
            { "sbp", "sangu" },
            { "ksh", "coloniese" },
            { "nyn", "nyankole" },
            { "mwl", "mirandese" },
            { "lun", "lunda" },
            { "luo", "luo" },
            { "Zsym", "symbolos" },
            { "fil", "filipino" },
            { "hmn", "hmong" },
            { "lus", "mizo" },
            { "ban", "balinese" },
            { "Zsye", "emoji" },
            { "luy", "luyia" },
            { "bas", "basaa" },
            { "es_ES", "espaniol europee" },
            { "tem", "temne" },
            { "sco", "scotese" },
            { "scn", "siciliano" },
            { "teo", "teso" },
            { "aa", "afar" },
            { "rap", "rapanui" },
            { "ab", "abkhazo" },
            { "rar", "rarotongano" },
            { "tet", "tetum" },
            { "AD", "Andorra" },
            { "AE", "Emiratos Arabe Unite" },
            { "nl_BE", "flamingo" },
            { "AF", "Afghanistan" },
            { "af", "afrikaans" },
            { "AG", "Antigua e Barbuda" },
            { "type.ca.ethiopic", "calendario ethiope" },
            { "ak", "akan" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "am", "amharico" },
            { "Arab", metaValue_ar },
            { "an", "aragonese" },
            { "AO", "Angola" },
            { "Jpan", metaValue_ja },
            { "AQ", "Antarctica" },
            { "ar", metaValue_ar },
            { "AR", "Argentina" },
            { "Hrkt", "syllabarios japonese" },
            { "AS", "Samoa american" },
            { "as", "assamese" },
            { "AT", "Austria" },
            { "AU", "Australia" },
            { "av", "avaro" },
            { "en_US", "anglese american" },
            { "AX", "Insulas \u00c5land" },
            { "ay", "aymara" },
            { "AZ", "Azerbaidzhan" },
            { "az", "azerbaidzhano" },
            { "BA", "Bosnia e Herzegovina" },
            { "ba", "bashkir" },
            { "ceb", "cebuano" },
            { "BD", "Bangladesh" },
            { "kum", "kumyko" },
            { "BE", "Belgica" },
            { "be", "bielorusso" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaria" },
            { "bg", "bulgaro" },
            { "BI", "Burundi" },
            { "bi", "bislama" },
            { "BJ", "Benin" },
            { "BM", "Bermuda" },
            { "bm", "bambara" },
            { "myv", "erzya" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "BO", "Bolivia" },
            { "dgr", "dogrib" },
            { "BR", "Brasil" },
            { "br", "breton" },
            { "BS", "Bahamas" },
            { "bs", "bosniaco" },
            { "xog", "soga" },
            { "BT", "Bhutan" },
            { "BV", "Insula de Bouvet" },
            { "BW", "Botswana" },
            { "Mymr", "birman" },
            { "type.nu.laoo", "cifras lao" },
            { "BY", "Bielorussia" },
            { "seh", "sena" },
            { "BZ", "Belize" },
            { "type.ca.persian", "calendario persa" },
            { "type.nu.hebr", "cifras hebraic" },
            { "CA", "Canada" },
            { "ca", "catalano" },
            { "mzn", "mazanderani" },
            { "ses", "koyraboro senni" },
            { "ce", "checheno" },
            { "CF", "Republica African Central" },
            { "CG", "Congo" },
            { "CH", "Suissa" },
            { "ch", "chamorro" },
            { "CK", "Insulas Cook" },
            { "CL", "Chile" },
            { "CM", "Camerun" },
            { "CN", "China" },
            { "CO", "Colombia" },
            { "co", "corso" },
            { "Orya", "orya" },
            { "CR", "Costa Rica" },
            { "cs", "checo" },
            { "CU", "Cuba" },
            { "cu", "slavo ecclesiastic" },
            { "cv", "chuvash" },
            { "CX", "Insula de Natal" },
            { "CY", "Cypro" },
            { "cy", "gallese" },
            { "CZ", "Chechia" },
            { "type.nu.ethi", "cifras ethiope" },
            { "eka", "ekajuk" },
            { "da", "danese" },
            { "pt_PT", "portugese de Portugal" },
            { "DE", "Germania" },
            { "de", "germano" },
            { "ace", "acehnese" },
            { "cgg", "chiga" },
            { "type.cf.standard", "formato de moneta standard" },
            { "type.nu.deva", "cifras devanagari" },
            { "DK", "Danmark" },
            { "Brai", "braille" },
            { "type.nu.armnlow", "cifras armenie minuscule" },
            { "DO", "Republica Dominican" },
            { "bem", "bemba" },
            { "gor", "gorontalo" },
            { "dv", "divehi" },
            { "zun", "zuni" },
            { "es_419", "espaniol latinoamerican" },
            { "tig", "tigre" },
            { "DZ", "Algeria" },
            { "dz", "dzongkha" },
            { "bez", "bena" },
            { "pag", "pangasinan" },
            { "type.ca.chinese", "calendario chinese" },
            { "pam", "pampanga" },
            { "EC", "Ecuador" },
            { "dje", "zarma" },
            { "pap", "papiamento" },
            { "ada", "adangme" },
            { "type.nu.grek", "cifras grec" },
            { "EE", "Estonia" },
            { "ee", "ewe" },
            { "type.lb.normal", "stilo de salto de linea normal" },
            { "EG", "Egypto" },
            { "EH", "Sahara occidental" },
            { "ro_MD", "moldavo" },
            { "pau", "palauano" },
            { "el", "greco" },
            { "chk", "chuukese" },
            { "en", "anglese" },
            { "chm", "mari" },
            { "eo", "esperanto" },
            { "cho", "choctaw" },
            { "chr", "cherokee" },
            { "ER", "Eritrea" },
            { "ES", "Espania" },
            { "es", "espaniol" },
            { "ET", "Ethiopia" },
            { "et", "estoniano" },
            { "Hanb", "han con bopomofo" },
            { "EU", "Union Europee" },
            { "eu", "basco" },
            { "Hang", "hangul" },
            { "type.ca.gregorian", "calendario gregorian" },
            { "EZ", "Zona euro" },
            { "chy", "cheyenne" },
            { "shi", "tachelhit" },
            { "type.nu.gujr", "cifras gujarati" },
            { "hsb", "alte sorabo" },
            { "Hani", "han" },
            { "ady", "adygeano" },
            { "shn", "shan" },
            { "fa", "persa" },
            { "Hans", "simplificate" },
            { "type.nu.latn", "cifras occidental" },
            { "Hant", "traditional" },
            { "ff", "fula" },
            { "FI", "Finlandia" },
            { "fi", "finnese" },
            { "fj", "fijiano" },
            { "fon", "fon" },
            { "FM", "Micronesia" },
            { "yue", "cantonese" },
            { "FO", "Insulas Feroe" },
            { "fo", "feroese" },
            { "Taml", metaValue_ta },
            { "umb", "umbundu" },
            { "FR", "Francia" },
            { "fr", "francese" },
            { "fy", "frison occidental" },
            { "root", "radice" },
            { "GA", "Gabon" },
            { "ga", "irlandese" },
            { "GB", "Regno Unite" },
            { "pcm", "pidgin nigerian" },
            { "gd", "gaelico scotese" },
            { "GE", "Georgia" },
            { "GF", "Guyana francese" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Groenlandia" },
            { "gl", "galleco" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "gn", "guarani" },
            { "bho", "bhojpuri" },
            { "GQ", "Guinea equatorial" },
            { "und", "lingua incognite" },
            { "GR", "Grecia" },
            { "GT", "Guatemala" },
            { "gu", metaValue_gu },
            { "gv", "mannese" },
            { "GW", "Guinea-Bissau" },
            { "tlh", "klingon" },
            { "ha", "hausa" },
            { "ckb", "kurdo central" },
            { "zxx", "sin contento linguistic" },
            { "he", "hebreo" },
            { "hi", "hindi" },
            { "de_AT", "germano austriac" },
            { "hup", "hupa" },
            { "HN", "Honduras" },
            { "bin", "bini" },
            { "HR", "Croatia" },
            { "hr", "croato" },
            { "agq", "aghem" },
            { "gsw", "germano suisse" },
            { "HT", "Haiti" },
            { "ht", "creolo haitian" },
            { "HU", "Hungaria" },
            { "hu", "hungaro" },
            { "hy", "armeniano" },
            { "hz", "herero" },
            { "ia", "interlingua" },
            { "Jamo", "jamo" },
            { "ID", "Indonesia" },
            { "id", "indonesiano" },
            { "type.nu.tibt", "cifras tibetan" },
            { "IE", "Irlanda" },
            { "nap", "napolitano" },
            { "ig", "igbo" },
            { "naq", "nama" },
            { "ii", "yi de Sichuan" },
            { "zza", "zaza" },
            { "IL", "Israel" },
            { "IM", "Insula de Man" },
            { "IN", "India" },
            { "IO", "Territorio oceanic britanno-indian" },
            { "io", "ido" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Islanda" },
            { "is", "islandese" },
            { "IT", "Italia" },
            { "it", "italiano" },
            { "iu", "inuktitut" },
            { "Zmth", "notation mathematic" },
            { "type.nu.thai", "cifras thailandese" },
            { "type.nu.beng", "cifras bengalese" },
            { "ja", metaValue_ja },
            { "Mlym", metaValue_ml },
            { "JE", "Jersey" },
            { "type.ca.islamic", "calendario islamic" },
            { "Beng", metaValue_bn },
            { "JO", "Jordania" },
            { "JP", "Japon" },
            { "sma", "sami del sud" },
            { "ain", "ainu" },
            { "jv", "javanese" },
            { "guz", "gusii" },
            { "type.nu.knda", "cifras kannada" },
            { "mad", "madurese" },
            { "smj", "sami de Lule" },
            { "mag", "magahi" },
            { "de_CH", "alte germano suisse" },
            { "mai", "maithili" },
            { "smn", "sami de Inari" },
            { "ka", "georgiano" },
            { "bla", "siksika" },
            { "mak", "macassarese" },
            { "type.ca.buddhist", "calendario buddhista" },
            { "sms", "sami skolt" },
            { "KE", "Kenya" },
            { "419", "America latin" },
            { "KG", "Kirghizistan" },
            { "KH", "Cambodgia" },
            { "KI", "Kiribati" },
            { "ki", "kikuyu" },
            { "mas", "masai" },
            { "kj", "kuanyama" },
            { "kk", "kazakh" },
            { "kl", "groenlandese" },
            { "km", metaValue_km },
            { "KM", "Comoros" },
            { "Knda", metaValue_kn },
            { "kn", metaValue_kn },
            { "KN", "Sancte Christophoro e Nevis" },
            { "fr_CA", "francese canadian" },
            { "ko", "coreano" },
            { "KP", "Corea del Nord" },
            { "KR", "Corea del Sud" },
            { "kr", "kanuri" },
            { "ks", "kashmiri" },
            { "ku", "kurdo" },
            { "fr_CH", "francese suisse" },
            { "kv", "komi" },
            { "kw", "cornico" },
            { "tpi", "tok pisin" },
            { "KY", "Insulas de Caiman" },
            { "ky", "kirghizo" },
            { "KZ", "Kazakhstan" },
            { "Cyrl", "cyrillic" },
            { "snk", "soninke" },
            { "la", "latino" },
            { "LB", "Libano" },
            { "lb", "luxemburgese" },
            { "LC", "Sancte Lucia" },
            { "gwi", "gwich\u2019in" },
            { "type.nu.mlym", "cifras malayalam" },
            { "lg", "luganda" },
            { "LI", "Liechtenstein" },
            { "li", "limburgese" },
            { "LK", "Sri Lanka" },
            { "Tibt", metaValue_bo },
            { "ln", "lingala" },
            { "fur", "friulano" },
            { "lo", "laotiano" },
            { "type.ms.uksystem", "systema de mesura imperial" },
            { "LR", "Liberia" },
            { "LS", "Lesotho" },
            { "LT", "Lituania" },
            { "lt", "lithuano" },
            { "LU", "Luxemburg" },
            { "lu", "luba-katanga" },
            { "LV", "Lettonia" },
            { "lv", "letton" },
            { "Kana", "katakana" },
            { "LY", "Libya" },
            { "lad", "ladino" },
            { "vun", "vunjo" },
            { "lag", "langi" },
            { "Thaa", "thaana" },
            { "MA", "Marocco" },
            { "MC", "Monaco" },
            { "MD", "Moldavia" },
            { "ME", "Montenegro" },
            { "MG", "Madagascar" },
            { "mg", "malgache" },
            { "MH", "Insulas Marshall" },
            { "mh", "marshallese" },
            { "ale", "aleuto" },
            { "Thai", "thailandese" },
            { "type.co.ducet", "ordinamento Unicode predefinite" },
            { "mi", "maori" },
            { "MK", "Macedonia" },
            { "mk", "macedone" },
            { "ml", metaValue_ml },
            { "ML", "Mali" },
            { "mn", metaValue_mn },
            { "MN", "Mongolia" },
            { "new", "newari" },
            { "MP", "Insulas Marianna del Nord" },
            { "MR", "Mauritania" },
            { "mr", "marathi" },
            { "ms", "malay" },
            { "MT", "Malta" },
            { "mt", "maltese" },
            { "alt", "altai del sud" },
            { "MW", "Malawi" },
            { "MX", "Mexico" },
            { "type.ca.japanese", "calendario japonese" },
            { "MY", "Malaysia" },
            { "my", "birmano" },
            { "MZ", "Mozambique" },
            { "Armn", "armenian" },
            { "mdf", "moksha" },
            { "dsb", "basse sorabo" },
            { "NA", "Namibia" },
            { "na", "nauru" },
            { "type.co.search", "recerca generic" },
            { "202", "Africa subsaharian" },
            { "nb", "norvegiano bokm\u00e5l" },
            { "type.ca.hebrew", "calendario hebraic" },
            { "NC", "Nove Caledonia" },
            { "nd", "ndebele del nord" },
            { "NE", "Niger" },
            { "ne", "nepalese" },
            { "NF", "Insula Norfolk" },
            { "NG", "Nigeria" },
            { "ng", "ndonga" },
            { "trv", "taroko" },
            { "NI", "Nicaragua" },
            { "NL", "Nederlandia" },
            { "nl", "nederlandese" },
            { "nn", "norvegiano nynorsk" },
            { "NO", "Norvegia" },
            { "NP", "Nepal" },
            { "nr", "ndebele del sud" },
            { "nv", "navajo" },
            { "rof", "rombo" },
            { "ny", "nyanja" },
            { "NZ", "Nove Zelanda" },
            { "kac", "kachin" },
            { "kab", "kabylo" },
            { "oc", "occitano" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "men", "mende" },
            { "mer", "meri" },
            { "type.nu.armn", "cifras armenie" },
            { "OM", "Oman" },
            { "om", "oromo" },
            { "anp", "angika" },
            { "or", "oriya" },
            { "os", "osseto" },
            { "crs", "creolo seychellese" },
            { "kbd", "cabardiano" },
            { "mfe", "creolo mauritian" },
            { "srn", "sranan tongo" },
            { "PA", "Panama" },
            { "pa", "punjabi" },
            { "dua", "duala" },
            { "en_GB", "anglese britannic" },
            { "PE", "Peru" },
            { "PF", "Polynesia francese" },
            { "PG", "Papua Nove Guinea" },
            { "PH", "Philippinas" },
            { "PK", "Pakistan" },
            { "PL", "Polonia" },
            { "pl", "polonese" },
            { "ewo", "ewondo" },
            { "PM", "St. Pierre e Miquelon" },
            { "type.ca.dangi", "calendario dangi" },
            { "ps", "pashto" },
            { "PT", "Portugal" },
            { "pt", "portugese" },
            { "key.co", "ordinamento" },
            { "nia", "nias" },
            { "type.nu.greklow", "cifras grec minuscule" },
            { "PY", "Paraguay" },
            { "pt_BR", "portugese de Brasil" },
            { "tum", "tumbuka" },
            { "kcg", "tyap" },
            { "mgh", "makhuwa-meetto" },
            { "Hebr", "hebraic" },
            { "key.cf", "formato de moneta" },
            { "key.ca", "calendario" },
            { "Laoo", "lao" },
            { "mgo", "meta\u02bc" },
            { "type.hc.h23", "systema de 24 horas (0\u201323)" },
            { "type.hc.h24", "systema de 24 horas (1\u201324)" },
            { "ssy", "saho" },
            { "type.nu.mymr", "cifras birman" },
            { "niu", "nieuano" },
            { "QO", "Oceania remote" },
            { "lez", "lezghiano" },
            { "qu", "quechua" },
            { "brx", "bodo" },
            { "tvl", "tuvaluano" },
            { "kde", "makonde" },
            { "001", "Mundo" },
            { "Ethi", "ethiope" },
            { "002", "Africa" },
            { "003", "America del Nord" },
            { "type.hc.h12", "systema de 12 horas (1\u201312)" },
            { "005", "America del Sud" },
            { "jbo", "lojban" },
            { "type.hc.h11", "systema de 12 horas (0\u201311)" },
            { "009", "Oceania" },
            { "rm", "romanche" },
            { "rn", "rundi" },
            { "key.cu", "moneta" },
            { "RO", "Romania" },
            { "ro", "romaniano" },
            { "RS", "Serbia" },
            { "type.nu.orya", "cifras oriya" },
            { "type.nu.hanidec", "cifras decimal chinese" },
            { "RU", "Russia" },
            { "ru", "russo" },
            { "RW", "Ruanda" },
            { "rw", "kinyarwanda" },
            { "kea", "capoverdiano" },
            { "mic", "micmac" },
            { "suk", "sukuma" },
            { "en_AU", "anglese australian" },
            { "SA", "Arabia Saudita" },
            { "sa", "sanscrito" },
            { "SB", "Insulas Solomon" },
            { "twq", "tasawaq" },
            { "011", "Africa occidental" },
            { "SC", "Seychelles" },
            { "sc", "sardo" },
            { "SD", "Sudan" },
            { "sd", "sindhi" },
            { "013", "America central" },
            { "SE", "Svedia" },
            { "se", "sami del nord" },
            { "014", "Africa oriental" },
            { "min", "minangkabau" },
            { "015", "Africa septentrional" },
            { "sg", "sango" },
            { "type.lb.strict", "stilo de salto de linea stricte" },
            { "si", metaValue_si },
            { "017", "Africa central" },
            { "SI", "Slovenia" },
            { "018", "Africa meridional" },
            { "SJ", "Svalbard e Jan Mayen" },
            { "019", "Americas" },
            { "SK", "Slovachia" },
            { "sk", "slovaco" },
            { "SL", "Sierra Leone" },
            { "sl", "sloveno" },
            { "SM", "San Marino" },
            { "sm", "samoano" },
            { "SN", "Senegal" },
            { "sn", "shona" },
            { "SO", "Somalia" },
            { "so", "somali" },
            { "arn", "mapuche" },
            { "type.nu.arab", "cifras indo-arabe" },
            { "sq", "albanese" },
            { "arp", "arapaho" },
            { "type.nu.taml", "cifras tamil traditional" },
            { "SR", "Suriname" },
            { "sr", "serbo" },
            { "SS", "Sudan del Sud" },
            { "ss", "swati" },
            { "type.cf.account", "formato de moneta pro contabilitate" },
            { "st", "sotho del sud" },
            { "su", "sundanese" },
            { "SV", "El Salvador" },
            { "sv", "svedese" },
            { "sw", "swahili" },
            { "SY", "Syria" },
            { "type.nu.hantfin", "cifras financiari chinese traditional" },
            { "SZ", "Swazilandia" },
            { "ibb", "ibibio" },
            { "iba", "iban" },
            { "ta", metaValue_ta },
            { "asa", "asu" },
            { "type.ms.ussystem", "systema de mesura statounitese" },
            { "021", "America septentrional" },
            { "142", "Asia" },
            { "TC", "Insulas Turcos e Caicos" },
            { "yav", "yangben" },
            { "143", "Asia central" },
            { "TD", "Tchad" },
            { "te", metaValue_te },
            { "145", "Asia occidental" },
            { "TF", "Territorios meridional francese" },
            { "TG", "Togo" },
            { "tg", "tajiko" },
            { "TH", "Thailandia" },
            { "th", "thai" },
            { "ti", "tigrinya" },
            { "bug", "buginese" },
            { "kfo", "koro" },
            { "TJ", "Tadzhikistan" },
            { "en_CA", "anglese canadian" },
            { "029", "Caribes" },
            { "TK", "Tokelau" },
            { "tk", "turkmeno" },
            { "TL", "Timor del Est" },
            { "ybb", "yemba" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunisia" },
            { "tn", "tswana" },
            { "TO", "Tonga" },
            { "to", "tongano" },
            { "dyo", "jola-fonyi" },
            { "type.nu.jpan", "cifras japonese" },
            { "TR", "Turchia" },
            { "tr", "turco" },
            { "ts", "tsonga" },
            { "swb", "comoriano" },
            { "TT", "Trinidad e Tobago" },
            { "tt", "tataro" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "ast", "asturiano" },
            { "ty", "tahitiano" },
            { "TZ", "Tanzania" },
            { "nmg", "kwasio" },
            { "Zzzz", "scriptura incognite" },
            { "150", "Europa" },
            { "UA", "Ukraina" },
            { "rup", "aromaniano" },
            { "030", "Asia oriental" },
            { "151", "Europa oriental" },
            { "154", "Europa septentrional" },
            { "dzg", "dazaga" },
            { "tyv", "tuvano" },
            { "sw_CD", "swahili del Congo" },
            { "034", "Asia meridional" },
            { "155", "Europa occidental" },
            { "035", "Asia del sud-est" },
            { "UG", "Uganda" },
            { "ug", "uighur" },
            { "Kore", "corean" },
            { "Zyyy", "commun" },
            { "039", "Europa meridional" },
            { "uk", "ukrainiano" },
            { "Sinh", metaValue_si },
            { "UN", "Nationes Unite" },
            { "ur", "urdu" },
            { "US", "Statos Unite" },
            { "haw", "hawaiano" },
            { "xal", "calmuco" },
            { "UY", "Uruguay" },
            { "prg", "prussiano" },
            { "UZ", "Uzbekistan" },
            { "uz", "uzbeko" },
            { "kha", "khasi" },
            { "tzm", "tamazight del Atlas Central" },
            { "nnh", "ngiemboon" },
            { "VA", "Citate del Vaticano" },
            { "VC", "Sancte Vincente e le Grenadinas" },
            { "VE", "Venezuela" },
            { "ve", "venda" },
            { "type.ca.roc", "calendario del Republica de China" },
            { "vi", "vietnamese" },
            { "khq", "koyra chiini" },
            { "key.hc", "cyclo horari (12 o 24)" },
            { "vo", "volap\u00fck" },
            { "quc", "k\u02bciche\u02bc" },
            { "VU", "Vanuatu" },
            { "gaa", "ga" },
            { "nog", "nogai" },
            { "rwk", "rwa" },
            { "wa", "wallon" },
            { "syr", "syriaco" },
            { "053", "Australasia" },
            { "054", "Melanesia" },
            { "Grek", "grec" },
            { "057", "Region micronesian" },
            { "jgo", "ngomba" },
            { "lkt", "lakota" },
            { "wo", "wolof" },
            { "wae", "walser" },
            { "zgh", "tamazight marocchin standard" },
            { "ar_001", "arabe standard moderne" },
            { "WS", "Samoa" },
            { "Mong", metaValue_mn },
            { "wal", "wolaytta" },
            { "mni", "manipuri" },
            { "war", "waray" },
            { "awa", "awadhi" },
            { "061", "Polynesia" },
            { "Latn", "latin" },
            { "type.nu.hans", "cifras chinese simplificate" },
            { "type.nu.hant", "cifras chinese traditional" },
            { "xh", "xhosa" },
            { "XK", "Kosovo" },
            { "type.nu.romanlow", "cifras roman minuscule" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "non scripte" },
            { "byn", "blin" },
            { "moh", "mohawk" },
            { "kkj", "kako" },
            { "YE", "Yemen" },
            { "nqo", "n\u2019ko" },
            { "type.co.standard", "ordinamento standard" },
            { "yi", "yiddish" },
            { "mos", "mossi" },
            { "yo", "yoruba" },
            { "es_MX", "espaniol mexican" },
            { "vai", "vai" },
            { "ZA", "Sudafrica" },
            { "type.lb.loose", "stilo de salto de linea flexibile" },
            { "kln", "kalenjin" },
            { "Deva", "devanagari" },
            { "zh", "chinese" },
            { "type.nu.geor", "cifras georgian" },
            { "Hira", "hiragana" },
            { "ZM", "Zambia" },
            { "Bopo", "bopomofo" },
            { "key.lb", "stilo de salto de linea" },
            { "zu", "zulu" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "Region incognite" },
            { "Geor", "georgian" },
            { "kmb", "kimbundu" },
            { "type.ms.metric", "systema metric" },
            { "type.ca.iso8601", "calendario ISO-8601" },
            { "nso", "sotho del nord" },
            { "type.nu.telu", "cifras telugu" },
            { "type.nu.jpanfin", "cifras financiari japonese" },
            { "loz", "lozi" },
            { "gez", "ge\u2019ez" },
            { "ebu", "embu" },
            { "jmc", "machame" },
            { "zh_Hans", "chinese simplificate" },
            { "type.nu.hansfin", "cifras financiari chinese simplificate" },
            { "kok", "konkani" },
            { "hil", "hiligaynon" },
            { "type.nu.arabext", "cifras indo-arabe extendite" },
            { "nus", "nuer" },
            { "dak", "dakota" },
            { "type.nu.fullwide", "cifras a latitude integre" },
            { "dar", "dargwa" },
            { "dav", "taita" },
            { "lrc", "luri del nord" },
            { "zh_Hant", "chinese traditional" },
            { "kpe", "kpelle" },
            { "type.nu.khmr", "cifras khmer" },
            { "ilo", "ilocano" },
            { "mua", "mundang" },
            { "type.nu.guru", "cifras gurmukhi" },
            { "udm", "udmurto" },
            { "Khmr", metaValue_km },
            { "mul", "plure linguas" },
            { "key.ms", "systema de mesura" },
            { "mus", "creek" },
            { "gil", "gilbertese" },
            { "sad", "sandawe" },
            { "type.nu.roman", "cifras roman" },
            { "sah", "yakuto" },
            { "type.nu.tamldec", "cifras tamil" },
            { "krc", "karachay-balkaro" },
            { "inh", "ingush" },
            { "saq", "samburu" },
            { "krl", "careliano" },
            { "sat", "santali" },
            { "efi", "efik" },
            { "key.nu", "numeros" },
            { "kru", "kurukh" },
            { "sba", "ngambay" },
            { "Guru", "gurmukhi" },
            { "lua", "luba-lulua" },
            { "ksb", "shambala" },
            { "Telu", metaValue_te },
            { "ksf", "bafia" },
        };
        return data;
    }
}
