/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.jrtfs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.spi.FileSystemProvider;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import jdk.internal.jrtfs.JrtFileAttributeView;
import jdk.internal.jrtfs.JrtFileAttributes;
import jdk.internal.jrtfs.JrtFileSystem;
import jdk.internal.jrtfs.JrtPath;

public final class JrtFileSystemProvider
extends FileSystemProvider {
    private volatile FileSystem theFileSystem;
    private static final String JRT_FS_JAR = "jrt-fs.jar";

    @Override
    public String getScheme() {
        return "jrt";
    }

    private void checkPermission() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            RuntimePermission perm = new RuntimePermission("accessSystemModules");
            sm.checkPermission(perm);
        }
    }

    private void checkUri(URI uri) {
        if (!uri.getScheme().equalsIgnoreCase(this.getScheme())) {
            throw new IllegalArgumentException("URI does not match this provider");
        }
        if (uri.getAuthority() != null) {
            throw new IllegalArgumentException("Authority component present");
        }
        if (uri.getPath() == null) {
            throw new IllegalArgumentException("Path component is undefined");
        }
        if (!uri.getPath().equals("/")) {
            throw new IllegalArgumentException("Path component should be '/'");
        }
        if (uri.getQuery() != null) {
            throw new IllegalArgumentException("Query component present");
        }
        if (uri.getFragment() != null) {
            throw new IllegalArgumentException("Fragment component present");
        }
    }

    @Override
    public FileSystem newFileSystem(URI uri, Map<String, ?> env) throws IOException {
        Objects.requireNonNull(env);
        this.checkPermission();
        this.checkUri(uri);
        if (env.containsKey("java.home")) {
            return this.newFileSystem((String)env.get("java.home"), uri, env);
        }
        return new JrtFileSystem(this, env);
    }

    private FileSystem newFileSystem(String targetHome, URI uri, Map<String, ?> env) throws IOException {
        Objects.requireNonNull(targetHome);
        Path jrtfs = FileSystems.getDefault().getPath(targetHome, "lib", JRT_FS_JAR);
        if (Files.notExists(jrtfs, new LinkOption[0])) {
            throw new IOException(jrtfs.toString() + " not exist");
        }
        HashMap newEnv = new HashMap(env);
        newEnv.remove("java.home");
        URLClassLoader cl = JrtFileSystemProvider.newJrtFsLoader(jrtfs);
        try {
            Class<?> c = Class.forName(JrtFileSystemProvider.class.getName(), false, cl);
            Object tmp = c.newInstance();
            return ((FileSystemProvider)tmp).newFileSystem(uri, newEnv);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new IOException(e);
        }
    }

    private static URLClassLoader newJrtFsLoader(Path jrtfs) {
        URL url;
        try {
            url = jrtfs.toUri().toURL();
        }
        catch (MalformedURLException mue) {
            throw new IllegalArgumentException(mue);
        }
        final URL[] urls = new URL[]{url};
        return AccessController.doPrivileged(new PrivilegedAction<URLClassLoader>(){

            @Override
            public URLClassLoader run() {
                return new JrtFsLoader(urls);
            }
        });
    }

    @Override
    public Path getPath(URI uri) {
        this.checkPermission();
        if (!uri.getScheme().equalsIgnoreCase(this.getScheme())) {
            throw new IllegalArgumentException("URI does not match this provider");
        }
        if (uri.getAuthority() != null) {
            throw new IllegalArgumentException("Authority component present");
        }
        if (uri.getQuery() != null) {
            throw new IllegalArgumentException("Query component present");
        }
        if (uri.getFragment() != null) {
            throw new IllegalArgumentException("Fragment component present");
        }
        String path = uri.getPath();
        if (path == null || path.charAt(0) != '/' || path.contains("..")) {
            throw new IllegalArgumentException("Invalid path component");
        }
        return this.getTheFileSystem().getPath("/modules" + path, new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileSystem getTheFileSystem() {
        this.checkPermission();
        FileSystem fs = this.theFileSystem;
        if (fs == null) {
            JrtFileSystemProvider jrtFileSystemProvider = this;
            synchronized (jrtFileSystemProvider) {
                fs = this.theFileSystem;
                if (fs == null) {
                    try {
                        this.theFileSystem = fs = new JrtFileSystem(this, null);
                    }
                    catch (IOException ioe) {
                        throw new InternalError(ioe);
                    }
                }
            }
        }
        return fs;
    }

    @Override
    public FileSystem getFileSystem(URI uri) {
        this.checkPermission();
        this.checkUri(uri);
        return this.getTheFileSystem();
    }

    static final JrtPath toJrtPath(Path path) {
        Objects.requireNonNull(path, "path");
        if (!(path instanceof JrtPath)) {
            throw new ProviderMismatchException();
        }
        return (JrtPath)path;
    }

    @Override
    public void checkAccess(Path path, AccessMode ... modes) throws IOException {
        JrtFileSystemProvider.toJrtPath(path).checkAccess(modes);
    }

    @Override
    public Path readSymbolicLink(Path link) throws IOException {
        return JrtFileSystemProvider.toJrtPath(link).readSymbolicLink();
    }

    @Override
    public void copy(Path src, Path target, CopyOption ... options) throws IOException {
        JrtFileSystemProvider.toJrtPath(src).copy(JrtFileSystemProvider.toJrtPath(target), options);
    }

    @Override
    public void createDirectory(Path path, FileAttribute<?> ... attrs) throws IOException {
        JrtFileSystemProvider.toJrtPath(path).createDirectory(attrs);
    }

    @Override
    public final void delete(Path path) throws IOException {
        JrtFileSystemProvider.toJrtPath(path).delete();
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) {
        return JrtFileAttributeView.get(JrtFileSystemProvider.toJrtPath(path), type, options);
    }

    @Override
    public FileStore getFileStore(Path path) throws IOException {
        return JrtFileSystemProvider.toJrtPath(path).getFileStore();
    }

    @Override
    public boolean isHidden(Path path) {
        return JrtFileSystemProvider.toJrtPath(path).isHidden();
    }

    @Override
    public boolean isSameFile(Path path, Path other) throws IOException {
        return JrtFileSystemProvider.toJrtPath(path).isSameFile(other);
    }

    @Override
    public void move(Path src, Path target, CopyOption ... options) throws IOException {
        JrtFileSystemProvider.toJrtPath(src).move(JrtFileSystemProvider.toJrtPath(target), options);
    }

    @Override
    public AsynchronousFileChannel newAsynchronousFileChannel(Path path, Set<? extends OpenOption> options, ExecutorService exec, FileAttribute<?> ... attrs) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        return JrtFileSystemProvider.toJrtPath(path).newByteChannel(options, attrs);
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path path, DirectoryStream.Filter<? super Path> filter) throws IOException {
        return JrtFileSystemProvider.toJrtPath(path).newDirectoryStream(filter);
    }

    @Override
    public FileChannel newFileChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        return JrtFileSystemProvider.toJrtPath(path).newFileChannel(options, attrs);
    }

    @Override
    public InputStream newInputStream(Path path, OpenOption ... options) throws IOException {
        return JrtFileSystemProvider.toJrtPath(path).newInputStream(options);
    }

    @Override
    public OutputStream newOutputStream(Path path, OpenOption ... options) throws IOException {
        return JrtFileSystemProvider.toJrtPath(path).newOutputStream(options);
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IOException {
        if (type == BasicFileAttributes.class || type == JrtFileAttributes.class) {
            return (A)JrtFileSystemProvider.toJrtPath(path).getAttributes(options);
        }
        return null;
    }

    @Override
    public Map<String, Object> readAttributes(Path path, String attribute, LinkOption ... options) throws IOException {
        return JrtFileSystemProvider.toJrtPath(path).readAttributes(attribute, options);
    }

    @Override
    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
        JrtFileSystemProvider.toJrtPath(path).setAttribute(attribute, value, options);
    }

    private static class JrtFsLoader
    extends URLClassLoader {
        JrtFsLoader(URL[] urls) {
            super(urls);
        }

        @Override
        protected Class<?> loadClass(String cn, boolean resolve) throws ClassNotFoundException {
            Class<?> c = this.findLoadedClass(cn);
            if (c == null) {
                URL u = this.findResource(cn.replace('.', '/') + ".class");
                if (u != null) {
                    c = this.findClass(cn);
                } else {
                    return super.loadClass(cn, resolve);
                }
            }
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
    }
}

