/*
 * Copyright (c) 2012, 2023, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2020 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_es extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "hora del meridiano de Greenwich",
               "GMT",
               "",
               "",
               "",
               "",
            };
        final String[] Acre = new String[] {
               "Hora est\u00e1ndar de Acre",
               "",
               "Hora de verano de Acre",
               "",
               "Hora de Acre",
               "",
            };
        final String[] Apia = new String[] {
               "hora est\u00e1ndar de Apia",
               "",
               "horario de verano de Apia",
               "",
               "hora de Apia",
               "",
            };
        final String[] Cook = new String[] {
               "hora est\u00e1ndar de las Islas Cook",
               "",
               "hora de verano media de las Islas Cook",
               "",
               "hora de las Islas Cook",
               "",
            };
        final String[] Cuba = new String[] {
               "hora est\u00e1ndar de Cuba",
               "",
               "hora de verano de Cuba",
               "",
               "hora de Cuba",
               "",
            };
        final String[] Fiji = new String[] {
               "hora est\u00e1ndar de Fiyi",
               "",
               "hora de verano de Fiyi",
               "",
               "hora de Fiyi",
               "",
            };
        final String[] Gulf = new String[] {
               "hora est\u00e1ndar del Golfo",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "hora est\u00e1ndar de Hovd",
               "",
               "hora de verano de Hovd",
               "",
               "hora de Hovd",
               "",
            };
        final String[] Iran = new String[] {
               "hora est\u00e1ndar de Ir\u00e1n",
               "",
               "hora de verano de Ir\u00e1n",
               "",
               "hora de Ir\u00e1n",
               "",
            };
        final String[] Niue = new String[] {
               "hora de Niue",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "hora est\u00e1ndar de Omsk",
               "",
               "hora de verano de Omsk",
               "",
               "hora de Omsk",
               "",
            };
        final String[] Peru = new String[] {
               "hora est\u00e1ndar de Per\u00fa",
               "",
               "hora de verano de Per\u00fa",
               "",
               "hora de Per\u00fa",
               "",
            };
        final String[] Truk = new String[] {
               "hora de Chuuk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "hora de la isla Wake",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "hora est\u00e1ndar de Chile",
               "",
               "hora de verano de Chile",
               "",
               "hora de Chile",
               "",
            };
        final String[] China = new String[] {
               "hora est\u00e1ndar de China",
               "",
               "hora de verano de China",
               "",
               "hora de China",
               "",
            };
        final String[] Cocos = new String[] {
               "hora de las Islas Cocos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "hora de Davis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "hora est\u00e1ndar de la India",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Japan = new String[] {
               "hora est\u00e1ndar de Jap\u00f3n",
               "",
               "hora de verano de Jap\u00f3n",
               "",
               "hora de Jap\u00f3n",
               "",
            };
        final String[] Korea = new String[] {
               "hora est\u00e1ndar de Corea",
               "",
               "hora de verano de Corea",
               "",
               "hora de Corea",
               "",
            };
        final String[] Nauru = new String[] {
               "hora de Nauru",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "hora de Nepal",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "hora de Palaos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "hora est\u00e1ndar de Samoa",
               "",
               "hora de verano de Samoa",
               "",
               "hora de Samoa",
               "",
            };
        final String[] Syowa = new String[] {
               "hora de Syowa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "hora est\u00e1ndar de Tonga",
               "",
               "hora de verano de Tonga",
               "",
               "hora de Tonga",
               "",
            };
        final String[] Alaska = new String[] {
               "hora est\u00e1ndar de Alaska",
               "",
               "hora de verano de Alaska",
               "",
               "hora de Alaska",
               "",
            };
        final String[] Amazon = new String[] {
               "hora est\u00e1ndar del Amazonas",
               "",
               "hora de verano del Amazonas",
               "",
               "hora del Amazonas",
               "",
            };
        final String[] Anadyr = new String[] {
               "hora est\u00e1ndar de Anadyr",
               "",
               "hora de verano de Anadyr",
               "",
               "hora de Anadyr",
               "",
            };
        final String[] Azores = new String[] {
               "hora est\u00e1ndar de las Azores",
               "",
               "hora de verano de las Azores",
               "",
               "hora de las Azores",
               "",
            };
        final String[] Bhutan = new String[] {
               "hora de But\u00e1n",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "hora de Brun\u00e9i",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "hora est\u00e1ndar de la isla de Pascua",
               "",
               "hora de verano de la isla de Pascua",
               "",
               "hora de la isla de Pascua",
               "",
            };
        final String[] Guyana = new String[] {
               "hora de Guyana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "hora est\u00e1ndar de Israel",
               "",
               "hora de verano de Israel",
               "",
               "hora de Israel",
               "",
            };
        final String[] Kosrae = new String[] {
               "hora de Kosrae",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "hora de Mawson",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "hora est\u00e1ndar de Mosc\u00fa",
               "",
               "hora de verano de Mosc\u00fa",
               "",
               "hora de Mosc\u00fa",
               "",
            };
        final String[] Ponape = new String[] {
               "hora de Pohnpei",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "hora est\u00e1ndar de Samara",
               "",
               "hora de verano de Samara",
               "",
               "hora de Samara",
               "",
            };
        final String[] Tahiti = new String[] {
               "hora de Tahit\u00ed",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "hora est\u00e1ndar de Taip\u00e9i",
               "",
               "hora de verano de Taip\u00e9i",
               "",
               "hora de Taip\u00e9i",
               "",
            };
        final String[] Tuvalu = new String[] {
               "hora de Tuvalu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "hora de Vostok",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "hora de Wallis y Futuna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "hora est\u00e1ndar de Arabia",
               "",
               "hora de verano de Arabia",
               "",
               "hora de Arabia",
               "",
            };
        final String[] Armenia = new String[] {
               "hora est\u00e1ndar de Armenia",
               "",
               "hora de verano de Armenia",
               "",
               "hora de Armenia",
               "",
            };
        final String[] Bolivia = new String[] {
               "hora de Bolivia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "hora est\u00e1ndar de Chatham",
               "",
               "hora de verano de Chatham",
               "",
               "hora de Chatham",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "tiempo universal coordinado",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "hora de Ecuador",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "hora de Gambier",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "hora est\u00e1ndar de Georgia",
               "",
               "hora de verano de Georgia",
               "",
               "hora de Georgia",
               "",
            };
        final String[] Irkutsk = new String[] {
               "hora est\u00e1ndar de Irkutsk",
               "",
               "hora de verano de Irkutsk",
               "",
               "hora de Irkutsk",
               "",
            };
        final String[] Magadan = new String[] {
               "hora est\u00e1ndar de Magad\u00e1n",
               "",
               "hora de verano de Magad\u00e1n",
               "",
               "hora de Magad\u00e1n",
               "",
            };
        final String[] Myanmar = new String[] {
               "hora de Myanmar",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "hora est\u00e1ndar de la isla Norfolk",
               "",
               "hora de verano de la isla Norfolk",
               "",
               "hora de la isla Norfolk",
               "",
            };
        final String[] Noronha = new String[] {
               "hora est\u00e1ndar de Fernando de Noronha",
               "",
               "hora de verano de Fernando de Noronha",
               "",
               "hora de Fernando de Noronha",
               "",
            };
        final String[] Reunion = new String[] {
               "hora de Reuni\u00f3n",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "hora de Rothera",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "hora de las Islas Salom\u00f3n",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "hora de Tokelau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "hora est\u00e1ndar de Uruguay",
               "",
               "hora de verano de Uruguay",
               "",
               "hora de Uruguay",
               "",
            };
        final String[] Vanuatu = new String[] {
               "hora est\u00e1ndar de Vanuatu",
               "",
               "hora de verano de Vanuatu",
               "",
               "hora de Vanuatu",
               "",
            };
        final String[] Yakutsk = new String[] {
               "hora est\u00e1ndar de Yakutsk",
               "",
               "hora de verano de Yakutsk",
               "",
               "hora de Yakutsk",
               "",
            };
        final String[] Atlantic = new String[] {
               "hora est\u00e1ndar del Atl\u00e1ntico",
               "",
               "hora de verano del Atl\u00e1ntico",
               "",
               "hora del Atl\u00e1ntico",
               "",
            };
        final String[] Brasilia = new String[] {
               "hora est\u00e1ndar de Brasilia",
               "",
               "hora de verano de Brasilia",
               "",
               "hora de Brasilia",
               "",
            };
        final String[] Chamorro = new String[] {
               "hora est\u00e1ndar de Chamorro",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Colombia = new String[] {
               "hora est\u00e1ndar de Colombia",
               "",
               "hora de verano de Colombia",
               "",
               "hora de Colombia",
               "",
            };
        final String[] Falkland = new String[] {
               "hora est\u00e1ndar de las islas Malvinas",
               "",
               "hora de verano de las islas Malvinas",
               "",
               "hora de las islas Malvinas",
               "",
            };
        final String[] Malaysia = new String[] {
               "hora de Malasia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "hora de Maldivas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "hora est\u00e1ndar de Ul\u00e1n Bator",
               "",
               "hora de verano de Ul\u00e1n Bator",
               "",
               "hora de Ul\u00e1n Bator",
               "",
            };
        final String[] Pakistan = new String[] {
               "hora est\u00e1ndar de Pakist\u00e1n",
               "",
               "hora de verano de Pakist\u00e1n",
               "",
               "hora de Pakist\u00e1n",
               "",
            };
        final String[] Paraguay = new String[] {
               "hora est\u00e1ndar de Paraguay",
               "",
               "hora de verano de Paraguay",
               "",
               "hora de Paraguay",
               "",
            };
        final String[] Pitcairn = new String[] {
               "hora de Pitcairn",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "hora est\u00e1ndar de Sajal\u00edn",
               "",
               "hora de verano de Sajal\u00edn",
               "",
               "hora de Sajal\u00edn",
               "",
            };
        final String[] Suriname = new String[] {
               "hora de Surinam",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "hora est\u00e1ndar de Argentina",
               "",
               "hora de verano de Argentina",
               "",
               "hora de Argentina",
               "",
            };
        final String[] Christmas = new String[] {
               "hora de la Isla de Navidad",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "hora de Gal\u00e1pagos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "hora est\u00e1ndar de Hong Kong",
               "",
               "hora de verano de Hong Kong",
               "",
               "hora de Hong Kong",
               "",
            };
        final String[] Indochina = new String[] {
               "hora de Indochina",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "hora est\u00e1ndar de Kamchatka",
               "",
               "hora de verano de Kamchatka",
               "",
               "hora de Kamchatka",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "hora de Kirguist\u00e1n",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "hora est\u00e1ndar de Lord Howe",
               "",
               "hora de verano de Lord Howe",
               "",
               "hora de Lord Howe",
               "",
            };
        final String[] Marquesas = new String[] {
               "hora de Marquesas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "hora est\u00e1ndar de Mauricio",
               "",
               "hora de verano de Mauricio",
               "",
               "hora de Mauricio",
               "",
            };
        final String[] Singapore = new String[] {
               "hora de Singapur",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "hora de Venezuela",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "hora est\u00e1ndar de Volgogrado",
               "",
               "hora de verano de Volgogrado",
               "",
               "hora de Volgogrado",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "hora est\u00e1ndar de Azerbaiy\u00e1n",
               "",
               "hora de verano de Azerbaiy\u00e1n",
               "",
               "hora de Azerbaiy\u00e1n",
               "",
            };
        final String[] Bangladesh = new String[] {
               "hora est\u00e1ndar de Banglad\u00e9s",
               "",
               "hora de verano de Banglad\u00e9s",
               "",
               "hora de Banglad\u00e9s",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "hora est\u00e1ndar de Cabo Verde",
               "",
               "hora de verano de Cabo Verde",
               "",
               "hora de Cabo Verde",
               "",
            };
        final String[] East_Timor = new String[] {
               "hora de Timor Oriental",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "hora de Seychelles",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "hora de Tayikist\u00e1n",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "hora est\u00e1ndar de Uzbekist\u00e1n",
               "",
               "hora de verano de Uzbekist\u00e1n",
               "",
               "hora de Uzbekist\u00e1n",
               "",
            };
        final String[] Afghanistan = new String[] {
               "hora de Afganist\u00e1n",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "hora est\u00e1ndar de Krasnoyarsk",
               "",
               "hora de verano de Krasnoyarsk",
               "",
               "hora de Krasnoyarsk",
               "",
            };
        final String[] New_Zealand = new String[] {
               "hora est\u00e1ndar de Nueva Zelanda",
               "",
               "hora de verano de Nueva Zelanda",
               "",
               "hora de Nueva Zelanda",
               "",
            };
        final String[] Novosibirsk = new String[] {
               "hora est\u00e1ndar de Novosibirsk",
               "",
               "hora de verano de Novosibirsk",
               "",
               "hora de Novosibirsk",
               "",
            };
        final String[] Philippines = new String[] {
               "hora est\u00e1ndar de Filipinas",
               "",
               "hora de verano de Filipinas",
               "",
               "hora de Filipinas",
               "",
            };
        final String[] Vladivostok = new String[] {
               "hora est\u00e1ndar de Vladivostok",
               "",
               "hora de verano de Vladivostok",
               "",
               "hora de Vladivostok",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "hora del oc\u00e9ano \u00cdndico",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "hora de las Esp\u00f3radas Ecuatoriales",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "hora est\u00e1ndar de Terranova",
               "",
               "hora de verano de Terranova",
               "",
               "hora de Terranova",
               "",
            };
        final String[] Turkmenistan = new String[] {
               "hora est\u00e1ndar de Turkmenist\u00e1n",
               "",
               "hora de verano de Turkmenist\u00e1n",
               "",
               "hora de Turkmenist\u00e1n",
               "",
            };
        final String[] French_Guiana = new String[] {
               "hora de la Guayana Francesa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "hora est\u00e1ndar de Nueva Caledonia",
               "",
               "hora de verano de Nueva Caledonia",
               "",
               "hora de Nueva Caledonia",
               "",
            };
        final String[] South_Georgia = new String[] {
               "hora de Georgia del Sur",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "hora est\u00e1ndar de Ekaterimburgo",
               "",
               "hora de verano de Ekaterimburgo",
               "",
               "hora de Ekaterimburgo",
               "",
            };
        final String[] Africa_Central = new String[] {
               "hora de \u00c1frica central",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Africa_Eastern = new String[] {
               "hora de \u00c1frica oriental",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Africa_Western = new String[] {
               "hora est\u00e1ndar de \u00c1frica occidental",
               "",
               "hora de verano de \u00c1frica occidental",
               "",
               "hora de \u00c1frica occidental",
               "",
            };
        final String[] DumontDUrville = new String[] {
               "hora de Dumont-d\u2019Urville",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "hora est\u00e1ndar de Europa central",
               "CET",
               "hora de verano de Europa central",
               "CEST",
               "hora de Europa central",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "hora est\u00e1ndar de Europa oriental",
               "EET",
               "hora de verano de Europa oriental",
               "EEST",
               "hora de Europa oriental",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "hora est\u00e1ndar de Europa occidental",
               "WET",
               "hora de verano de Europa occidental",
               "WEST",
               "hora de Europa occidental",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "hora est\u00e1ndar del Pac\u00edfico de M\u00e9xico",
               "",
               "hora de verano del Pac\u00edfico de M\u00e9xico",
               "",
               "hora del Pac\u00edfico de M\u00e9xico",
               "",
            };
        final String[] Africa_Southern = new String[] {
               "hora de Sud\u00e1frica",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] America_Central = new String[] {
               "hora est\u00e1ndar central",
               "",
               "hora de verano central",
               "",
               "hora central",
               "",
            };
        final String[] America_Eastern = new String[] {
               "hora est\u00e1ndar oriental",
               "",
               "hora de verano oriental",
               "",
               "hora oriental",
               "",
            };
        final String[] America_Pacific = new String[] {
               "hora est\u00e1ndar del Pac\u00edfico",
               "",
               "hora de verano del Pac\u00edfico",
               "",
               "hora del Pac\u00edfico",
               "",
            };
        final String[] French_Southern = new String[] {
               "hora de Ant\u00e1rtida y Territorios Australes Franceses",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "hora de las islas Gilbert",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "hora est\u00e1ndar de Haw\u00e1i-Aleutianas",
               "",
               "hora de verano de Haw\u00e1i-Aleutianas",
               "",
               "hora de Haw\u00e1i-Aleutianas",
               "",
            };
        final String[] Phoenix_Islands = new String[] {
               "hora de las Islas F\u00e9nix",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "hora est\u00e1ndar de San Pedro y Miquel\u00f3n",
               "",
               "hora de verano de San Pedro y Miquel\u00f3n",
               "",
               "hora de San Pedro y Miquel\u00f3n",
               "",
            };
        final String[] America_Mountain = new String[] {
               "hora est\u00e1ndar de las Monta\u00f1as Rocosas",
               "",
               "hora de verano de las Monta\u00f1as Rocosas",
               "",
               "hora de las Monta\u00f1as Rocosas",
               "",
            };
        final String[] Marshall_Islands = new String[] {
               "hora de las Islas Marshall",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mexico_Northwest = new String[] {
               "hora est\u00e1ndar del noroeste de M\u00e9xico",
               "",
               "hora de verano del noroeste de M\u00e9xico",
               "",
               "hora del noroeste de M\u00e9xico",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "hora de Pap\u00faa Nueva Guinea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "hora est\u00e1ndar de Australia central",
               "",
               "hora de verano de Australia central",
               "",
               "hora de Australia central",
               "",
            };
        final String[] Australia_Eastern = new String[] {
               "hora est\u00e1ndar de Australia oriental",
               "",
               "hora de verano de Australia oriental",
               "",
               "hora de Australia oriental",
               "",
            };
        final String[] Australia_Western = new String[] {
               "hora est\u00e1ndar de Australia occidental",
               "",
               "hora de verano de Australia occidental",
               "",
               "hora de Australia occidental",
               "",
            };
        final String[] Greenland_Eastern = new String[] {
               "hora est\u00e1ndar de Groenlandia oriental",
               "",
               "hora de verano de Groenlandia oriental",
               "",
               "hora de Groenlandia oriental",
               "",
            };
        final String[] Greenland_Western = new String[] {
               "hora est\u00e1ndar de Groenlandia occidental",
               "",
               "hora de verano de Groenlandia occidental",
               "",
               "hora de Groenlandia occidental",
               "",
            };
        final String[] Indonesia_Central = new String[] {
               "hora de Indonesia central",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Indonesia_Eastern = new String[] {
               "hora de Indonesia oriental",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Indonesia_Western = new String[] {
               "hora de Indonesia occidental",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "hora de Kazajist\u00e1n oriental",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan_Western = new String[] {
               "hora de Kazajist\u00e1n occidental",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "hora est\u00e1ndar de Australia centroccidental",
               "",
               "hora de verano de Australia centroccidental",
               "",
               "hora de Australia centroccidental",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "JST", Japan },
            { "MIT", Apia },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "SST", Solomon },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UTC", ETC_UTC },
            { "MST7MDT", America_Mountain },
            { "PST8PDT", America_Pacific },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan_Western },
            { "Asia/Amman", Europe_Eastern },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Anadyr", Anadyr },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Truk },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kuching", Malaysia },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Damascus", Europe_Eastern },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan_Eastern },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Ust-Nera", Vladivostok },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "hora del meridiano de Greenwich",
                    "GMT",
                    "hora de verano de Irlanda",
                    "",
                    "",
                    "",
                }
            },
            { "Europe/Jersey", GMT },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "hora del meridiano de Greenwich",
                    "GMT",
                    "hora de verano brit\u00e1nica",
                    "",
                    "",
                    "",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", America_Mountain },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "Asia/Chongqing", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan_Western },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "hora del meridiano de Greenwich",
                    "GMT",
                    "hora de verano brit\u00e1nica",
                    "",
                    "",
                    "",
                }
            },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Pacific/Easter", Easter },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Ponape },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Pacific/Wallis", Wallis },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Godthab", Greenland_Western },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/Perth", Australia_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey", GMT },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", Maldives },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", America_Mountain },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Europe/Isle_of_Man", GMT },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "Ad\u00e9n" },
            { "timezone.excity.Asia/Baku", "Bak\u00fa" },
            { "timezone.excity.Asia/Dili", "Dili" },
            { "timezone.excity.Asia/Gaza", "Gaza" },
            { "timezone.excity.Asia/Hovd", "Hovd" },
            { "timezone.excity.Asia/Omsk", "Omsk" },
            { "timezone.excity.Asia/Oral", "Oral" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "Amm\u00e1n" },
            { "timezone.excity.Asia/Aqtau", "Aktau" },
            { "timezone.excity.Asia/Chita", "Chit\u00e1" },
            { "timezone.excity.Asia/Dhaka", "Daca" },
            { "timezone.excity.Asia/Dubai", "Dub\u00e1i" },
            { "timezone.excity.Asia/Kabul", "Kabul" },
            { "timezone.excity.Asia/Qatar", "Catar" },
            { "timezone.excity.Asia/Seoul", "Se\u00fal" },
            { "timezone.excity.Asia/Tokyo", "Tokio" },
            { "timezone.excity.Asia/Tomsk", "Tomsk" },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "Juba" },
            { "timezone.excity.Africa/Lome", "Lom\u00e9" },
            { "timezone.excity.Asia/Almaty", "Almaty" },
            { "timezone.excity.Asia/Anadyr", "An\u00e1dyr" },
            { "timezone.excity.Asia/Aqtobe", "Aktobe" },
            { "timezone.excity.Asia/Atyrau", "Atyrau" },
            { "timezone.excity.Asia/Beirut", "Beirut" },
            { "timezone.excity.Asia/Brunei", "Brun\u00e9i" },
            { "timezone.excity.Asia/Hebron", "Hebr\u00f3n" },
            { "timezone.excity.Asia/Kuwait", "Kuwait" },
            { "timezone.excity.Asia/Manila", "Manila" },
            { "timezone.excity.Asia/Muscat", "Mascate" },
            { "timezone.excity.Asia/Riyadh", "Riad" },
            { "timezone.excity.Asia/Saigon", "Ciudad Ho Chi Minh" },
            { "timezone.excity.Asia/Taipei", "Taip\u00e9i" },
            { "timezone.excity.Asia/Tehran", "Teher\u00e1n" },
            { "timezone.excity.Asia/Urumqi", "\u00dcr\u00fcmqi" },
            { "timezone.excity.Etc/Unknown", "Ciudad desconocida" },
            { "timezone.excity.Europe/Kiev", "Kiev" },
            { "timezone.excity.Europe/Oslo", "Oslo" },
            { "timezone.excity.Europe/Riga", "Riga" },
            { "timezone.excity.Europe/Rome", "Roma" },
            { "timezone.excity.Indian/Mahe", "Mah\u00e9" },
            { "timezone.excity.Africa/Accra", "Acra" },
            { "timezone.excity.Africa/Cairo", "El Cairo" },
            { "timezone.excity.Africa/Ceuta", "Ceuta" },
            { "timezone.excity.Africa/Dakar", "Dakar" },
            { "timezone.excity.Africa/Lagos", "Lagos" },
            { "timezone.excity.Africa/Tunis", "T\u00fanez" },
            { "timezone.excity.America/Adak", "Adak" },
            { "timezone.excity.America/Lima", "Lima" },
            { "timezone.excity.America/Nome", "Nome" },
            { "timezone.excity.Asia/Baghdad", "Bagdad" },
            { "timezone.excity.Asia/Bahrain", "Bar\u00e9in" },
            { "timezone.excity.Asia/Bangkok", "Bangkok" },
            { "timezone.excity.Asia/Barnaul", "Barna\u00fal" },
            { "timezone.excity.Asia/Bishkek", "Bishkek" },
            { "timezone.excity.Asia/Colombo", "Colombo" },
            { "timezone.excity.Asia/Irkutsk", "Irkutsk" },
            { "timezone.excity.Asia/Jakarta", "Yakarta" },
            { "timezone.excity.Asia/Karachi", "Karachi" },
            { "timezone.excity.Asia/Kuching", "Kuching" },
            { "timezone.excity.Asia/Magadan", "Magad\u00e1n" },
            { "timezone.excity.Asia/Nicosia", "Nicosia" },
            { "timezone.excity.Asia/Rangoon", "Yang\u00f3n (Rang\u00fan)" },
            { "timezone.excity.Asia/Tbilisi", "Tiflis" },
            { "timezone.excity.Asia/Thimphu", "Timbu" },
            { "timezone.excity.Asia/Yakutsk", "Yakutsk" },
            { "timezone.excity.Asia/Yerevan", "Erev\u00e1n" },
            { "timezone.excity.Europe/Kirov", "K\u00edrov" },
            { "timezone.excity.Europe/Malta", "Malta" },
            { "timezone.excity.Europe/Minsk", "Minsk" },
            { "timezone.excity.Europe/Paris", "Par\u00eds" },
            { "timezone.excity.Europe/Sofia", "Sof\u00eda" },
            { "timezone.excity.Europe/Vaduz", "Vaduz" },
            { "timezone.excity.Indian/Cocos", "Cocos" },
            { "timezone.excity.Pacific/Apia", "Apia" },
            { "timezone.excity.Pacific/Fiji", "Fiyi" },
            { "timezone.excity.Pacific/Guam", "Guam" },
            { "timezone.excity.Pacific/Niue", "Niue" },
            { "timezone.excity.Pacific/Wake", "Wake" },
            { "timezone.excity.Africa/Bamako", "Bamako" },
            { "timezone.excity.Africa/Bangui", "Bangui" },
            { "timezone.excity.Africa/Banjul", "Banjul" },
            { "timezone.excity.Africa/Bissau", "Bis\u00e1u" },
            { "timezone.excity.Africa/Douala", "Duala" },
            { "timezone.excity.Africa/Harare", "Harare" },
            { "timezone.excity.Africa/Kigali", "Kigali" },
            { "timezone.excity.Africa/Luanda", "Luanda" },
            { "timezone.excity.Africa/Lusaka", "Lusaka" },
            { "timezone.excity.Africa/Malabo", "Malabo" },
            { "timezone.excity.Africa/Maputo", "Maputo" },
            { "timezone.excity.Africa/Maseru", "Maseru" },
            { "timezone.excity.Africa/Niamey", "Niamey" },
            { "timezone.excity.America/Aruba", "Aruba" },
            { "timezone.excity.America/Bahia", "Bah\u00eda" },
            { "timezone.excity.America/Belem", "Bel\u00e9n" },
            { "timezone.excity.America/Boise", "Boise" },
            { "timezone.excity.America/Jujuy", "Jujuy" },
            { "timezone.excity.America/Sitka", "Sitka" },
            { "timezone.excity.America/Thule", "Thule" },
            { "timezone.excity.Asia/Ashgabat", "Asjabad" },
            { "timezone.excity.Asia/Calcutta", "Calcuta" },
            { "timezone.excity.Asia/Damascus", "Damasco" },
            { "timezone.excity.Asia/Dushanbe", "Dusamb\u00e9" },
            { "timezone.excity.Asia/Jayapura", "Jayapura" },
            { "timezone.excity.Asia/Katmandu", "Katmand\u00fa" },
            { "timezone.excity.Asia/Khandyga", "Khandyga" },
            { "timezone.excity.Asia/Makassar", "Makasar" },
            { "timezone.excity.Asia/Qostanay", "Kostan\u00e1i" },
            { "timezone.excity.Asia/Sakhalin", "Sajal\u00edn" },
            { "timezone.excity.Asia/Shanghai", "Shangh\u00e1i" },
            { "timezone.excity.Asia/Tashkent", "Taskent" },
            { "timezone.excity.Asia/Ust-Nera", "Ust-Nera" },
            { "timezone.excity.Europe/Athens", "Atenas" },
            { "timezone.excity.Europe/Berlin", "Berl\u00edn" },
            { "timezone.excity.Europe/Dublin", "Dubl\u00edn" },
            { "timezone.excity.Europe/Jersey", "Jersey" },
            { "timezone.excity.Europe/Lisbon", "Lisboa" },
            { "timezone.excity.Europe/London", "Londres" },
            { "timezone.excity.Europe/Madrid", "Madrid" },
            { "timezone.excity.Europe/Monaco", "M\u00f3naco" },
            { "timezone.excity.Europe/Moscow", "Mosc\u00fa" },
            { "timezone.excity.Europe/Prague", "Praga" },
            { "timezone.excity.Europe/Samara", "Samara" },
            { "timezone.excity.Europe/Skopje", "Skopie" },
            { "timezone.excity.Europe/Tirane", "Tirana" },
            { "timezone.excity.Europe/Vienna", "Viena" },
            { "timezone.excity.Europe/Warsaw", "Varsovia" },
            { "timezone.excity.Europe/Zagreb", "Zagreb" },
            { "timezone.excity.Europe/Zurich", "Z\u00farich" },
            { "timezone.excity.Indian/Chagos", "Chagos" },
            { "timezone.excity.Indian/Comoro", "Comoras" },
            { "timezone.excity.Pacific/Efate", "Efate" },
            { "timezone.excity.Pacific/Nauru", "Nauru" },
            { "timezone.excity.Pacific/Palau", "Palaos" },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "Abiy\u00e1n" },
            { "timezone.excity.Africa/Algiers", "Argel" },
            { "timezone.excity.Africa/Conakry", "Conakry" },
            { "timezone.excity.Africa/Kampala", "Kampala" },
            { "timezone.excity.Africa/Mbabane", "Mbabane" },
            { "timezone.excity.Africa/Nairobi", "Nairobi" },
            { "timezone.excity.Africa/Tripoli", "Tr\u00edpoli" },
            { "timezone.excity.America/Belize", "Belice" },
            { "timezone.excity.America/Bogota", "Bogot\u00e1" },
            { "timezone.excity.America/Cayman", "Caim\u00e1n" },
            { "timezone.excity.America/Cuiaba", "Cuiab\u00e1" },
            { "timezone.excity.America/Dawson", "Dawson" },
            { "timezone.excity.America/Denver", "Denver" },
            { "timezone.excity.America/Guyana", "Guyana" },
            { "timezone.excity.America/Havana", "La Habana" },
            { "timezone.excity.America/Inuvik", "Inuvik" },
            { "timezone.excity.America/Juneau", "Juneau" },
            { "timezone.excity.America/La_Paz", "La Paz" },
            { "timezone.excity.America/Maceio", "Macei\u00f3" },
            { "timezone.excity.America/Manaus", "Manaos" },
            { "timezone.excity.America/Nassau", "Nassau" },
            { "timezone.excity.America/Panama", "Panam\u00e1" },
            { "timezone.excity.America/Recife", "Recife" },
            { "timezone.excity.America/Regina", "Regina" },
            { "timezone.excity.Asia/Famagusta", "Famagusta" },
            { "timezone.excity.Asia/Hong_Kong", "Hong Kong" },
            { "timezone.excity.Asia/Jerusalem", "Jerusal\u00e9n" },
            { "timezone.excity.Asia/Kamchatka", "Kamchatka" },
            { "timezone.excity.Asia/Pontianak", "Pontianak" },
            { "timezone.excity.Asia/Pyongyang", "Pyongyang" },
            { "timezone.excity.Asia/Qyzylorda", "Kyzylorda" },
            { "timezone.excity.Asia/Samarkand", "Samarcanda" },
            { "timezone.excity.Asia/Singapore", "Singapur" },
            { "timezone.excity.Asia/Vientiane", "Vienti\u00e1n" },
            { "timezone.excity.Europe/Andorra", "Andorra" },
            { "timezone.excity.Europe/Saratov", "Sar\u00e1tov" },
            { "timezone.excity.Europe/Tallinn", "Tallin" },
            { "timezone.excity.Europe/Vatican", "El Vaticano" },
            { "timezone.excity.Europe/Vilnius", "Vilna" },
            { "timezone.excity.Indian/Mayotte", "Mayotte" },
            { "timezone.excity.Indian/Reunion", "Reuni\u00f3n" },
            { "timezone.excity.Pacific/Easter", "Isla de Pascua" },
            { "timezone.excity.Pacific/Kosrae", "Kosrae" },
            { "timezone.excity.Pacific/Majuro", "Majuro" },
            { "timezone.excity.Pacific/Midway", "Midway" },
            { "timezone.excity.Pacific/Noumea", "Numea" },
            { "timezone.excity.Pacific/Saipan", "Saip\u00e1n" },
            { "timezone.excity.Pacific/Tahiti", "Tahit\u00ed" },
            { "timezone.excity.Pacific/Tarawa", "Tarawa" },
            { "timezone.excity.Pacific/Wallis", "Wallis" },
            { "timezone.excity.Africa/Blantyre", "Blantyre" },
            { "timezone.excity.Africa/Djibouti", "Yibuti" },
            { "timezone.excity.Africa/El_Aaiun", "El Aai\u00fan" },
            { "timezone.excity.Africa/Freetown", "Freetown" },
            { "timezone.excity.Africa/Gaborone", "Gaborone" },
            { "timezone.excity.Africa/Khartoum", "Jart\u00fan" },
            { "timezone.excity.Africa/Kinshasa", "Kinshasa" },
            { "timezone.excity.Africa/Monrovia", "Monrovia" },
            { "timezone.excity.Africa/Ndjamena", "Yamena" },
            { "timezone.excity.Africa/Sao_Tome", "Santo Tom\u00e9" },
            { "timezone.excity.Africa/Windhoek", "Windhoek" },
            { "timezone.excity.America/Antigua", "Antigua" },
            { "timezone.excity.America/Caracas", "Caracas" },
            { "timezone.excity.America/Cayenne", "Cayena" },
            { "timezone.excity.America/Chicago", "Chicago" },
            { "timezone.excity.America/Cordoba", "C\u00f3rdoba" },
            { "timezone.excity.America/Creston", "Creston" },
            { "timezone.excity.America/Curacao", "Curazao" },
            { "timezone.excity.America/Detroit", "Detroit" },
            { "timezone.excity.America/Grenada", "Granada" },
            { "timezone.excity.America/Halifax", "Halifax" },
            { "timezone.excity.America/Iqaluit", "Iqaluit" },
            { "timezone.excity.America/Jamaica", "Jamaica" },
            { "timezone.excity.America/Managua", "Managua" },
            { "timezone.excity.America/Marigot", "Marigot" },
            { "timezone.excity.America/Mendoza", "Mendoza" },
            { "timezone.excity.America/Moncton", "Moncton" },
            { "timezone.excity.America/Nipigon", "Nipigon" },
            { "timezone.excity.America/Noronha", "Noronha" },
            { "timezone.excity.America/Ojinaga", "Ojinaga" },
            { "timezone.excity.America/Phoenix", "Phoenix" },
            { "timezone.excity.America/Tijuana", "Tijuana" },
            { "timezone.excity.America/Toronto", "Toronto" },
            { "timezone.excity.America/Tortola", "T\u00f3rtola" },
            { "timezone.excity.America/Yakutat", "Yakutat" },
            { "timezone.excity.Asia/Choibalsan", "Choibalsan" },
            { "timezone.excity.Asia/Phnom_Penh", "Phnom Penh" },
            { "timezone.excity.Atlantic/Azores", "Azores" },
            { "timezone.excity.Atlantic/Canary", "Canarias" },
            { "timezone.excity.Atlantic/Faeroe", "Islas Feroe" },
            { "timezone.excity.Australia/Eucla", "Eucla" },
            { "timezone.excity.Australia/Perth", "Perth" },
            { "timezone.excity.Europe/Belgrade", "Belgrado" },
            { "timezone.excity.Europe/Brussels", "Bruselas" },
            { "timezone.excity.Europe/Budapest", "Budapest" },
            { "timezone.excity.Europe/Busingen", "Busingen" },
            { "timezone.excity.Europe/Chisinau", "Chisin\u00e1u" },
            { "timezone.excity.Europe/Guernsey", "Guernesey" },
            { "timezone.excity.Europe/Helsinki", "Helsinki" },
            { "timezone.excity.Europe/Istanbul", "Estambul" },
            { "timezone.excity.Europe/Sarajevo", "Sarajevo" },
            { "timezone.excity.Europe/Uzhgorod", "\u00dazhgorod" },
            { "timezone.excity.Indian/Maldives", "Maldivas" },
            { "timezone.excity.Pacific/Chatham", "Chatham" },
            { "timezone.excity.Pacific/Fakaofo", "Fakaofo" },
            { "timezone.excity.Pacific/Gambier", "Gambier" },
            { "timezone.excity.Pacific/Norfolk", "Norfolk" },
            { "timezone.excity.Africa/Bujumbura", "Bujumbura" },
            { "timezone.excity.Africa/Mogadishu", "Mogadiscio" },
            { "timezone.excity.America/Anguilla", "Anguila" },
            { "timezone.excity.America/Asuncion", "Asunci\u00f3n" },
            { "timezone.excity.America/Barbados", "Barbados" },
            { "timezone.excity.America/Dominica", "Dominica" },
            { "timezone.excity.America/Edmonton", "Edmonton" },
            { "timezone.excity.America/Eirunepe", "Eirunep\u00e9" },
            { "timezone.excity.America/Mazatlan", "Mazatl\u00e1n" },
            { "timezone.excity.America/Miquelon", "Miquel\u00f3n" },
            { "timezone.excity.America/New_York", "Nueva York" },
            { "timezone.excity.America/Resolute", "Resolute" },
            { "timezone.excity.America/Santarem", "Santar\u00e9m" },
            { "timezone.excity.America/Santiago", "Santiago de Chile" },
            { "timezone.excity.America/St_Johns", "San Juan de Terranova" },
            { "timezone.excity.America/St_Kitts", "San Crist\u00f3bal" },
            { "timezone.excity.America/St_Lucia", "Santa Luc\u00eda" },
            { "timezone.excity.America/Winnipeg", "Winnipeg" },
            { "timezone.excity.Antarctica/Casey", "Casey" },
            { "timezone.excity.Antarctica/Davis", "Davis" },
            { "timezone.excity.Antarctica/Syowa", "Syowa" },
            { "timezone.excity.Antarctica/Troll", "Troll" },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasnoyarsk" },
            { "timezone.excity.Asia/Novosibirsk", "Novosibirsk" },
            { "timezone.excity.Asia/Ulaanbaatar", "Ul\u00e1n Bator" },
            { "timezone.excity.Asia/Vladivostok", "Vladivostok" },
            { "timezone.excity.Atlantic/Bermuda", "Bermudas" },
            { "timezone.excity.Atlantic/Madeira", "Madeira" },
            { "timezone.excity.Atlantic/Stanley", "Stanley" },
            { "timezone.excity.Australia/Currie", "Currie" },
            { "timezone.excity.Australia/Darwin", "Darwin" },
            { "timezone.excity.Australia/Hobart", "Hobart" },
            { "timezone.excity.Australia/Sydney", "S\u00eddney" },
            { "timezone.excity.Europe/Amsterdam", "\u00c1msterdam" },
            { "timezone.excity.Europe/Astrakhan", "Astrac\u00e1n" },
            { "timezone.excity.Europe/Bucharest", "Bucarest" },
            { "timezone.excity.Europe/Gibraltar", "Gibraltar" },
            { "timezone.excity.Europe/Ljubljana", "Liubliana" },
            { "timezone.excity.Europe/Mariehamn", "Mariehamn" },
            { "timezone.excity.Europe/Podgorica", "Podgorica" },
            { "timezone.excity.Europe/Stockholm", "Estocolmo" },
            { "timezone.excity.Europe/Ulyanovsk", "Uli\u00e1novsk" },
            { "timezone.excity.Europe/Volgograd", "Volgogrado" },
            { "timezone.excity.Indian/Christmas", "Navidad" },
            { "timezone.excity.Indian/Kerguelen", "Kerguelen" },
            { "timezone.excity.Indian/Mauritius", "Mauricio" },
            { "timezone.excity.Pacific/Auckland", "Auckland" },
            { "timezone.excity.Pacific/Funafuti", "Funafuti" },
            { "timezone.excity.Pacific/Honolulu", "Honolul\u00fa" },
            { "timezone.excity.Pacific/Johnston", "Johnston" },
            { "timezone.excity.Pacific/Pitcairn", "Pitcairn" },
            { "timezone.excity.Africa/Casablanca", "Casablanca" },
            { "timezone.excity.Africa/Libreville", "Libreville" },
            { "timezone.excity.Africa/Lubumbashi", "Lubumbashi" },
            { "timezone.excity.Africa/Nouakchott", "Nuakchot" },
            { "timezone.excity.Africa/Porto-Novo", "Portonovo" },
            { "timezone.excity.America/Anchorage", "Anchorage" },
            { "timezone.excity.America/Araguaina", "Aragua\u00edna" },
            { "timezone.excity.America/Boa_Vista", "Boa Vista" },
            { "timezone.excity.America/Catamarca", "Catamarca" },
            { "timezone.excity.America/Chihuahua", "Chihuahua" },
            { "timezone.excity.America/Fortaleza", "Fortaleza" },
            { "timezone.excity.America/Glace_Bay", "Glace Bay" },
            { "timezone.excity.America/Goose_Bay", "Goose Bay" },
            { "timezone.excity.America/Guatemala", "Guatemala" },
            { "timezone.excity.America/Guayaquil", "Guayaquil" },
            { "timezone.excity.America/Matamoros", "Matamoros" },
            { "timezone.excity.America/Menominee", "Menominee" },
            { "timezone.excity.America/Monterrey", "Monterrey" },
            { "timezone.excity.America/Sao_Paulo", "S\u00e3o Paulo" },
            { "timezone.excity.America/Vancouver", "Vancouver" },
            { "timezone.excity.Antarctica/Mawson", "Mawson" },
            { "timezone.excity.Antarctica/Palmer", "Palmer" },
            { "timezone.excity.Antarctica/Vostok", "Vostok" },
            { "timezone.excity.Asia/Kuala_Lumpur", "Kuala Lumpur" },
            { "timezone.excity.Asia/Novokuznetsk", "Novokuznetsk" },
            { "timezone.excity.Europe/Bratislava", "Bratislava" },
            { "timezone.excity.Europe/Copenhagen", "Copenhague" },
            { "timezone.excity.Europe/Luxembourg", "Luxemburgo" },
            { "timezone.excity.Europe/San_Marino", "San Marino" },
            { "timezone.excity.Europe/Simferopol", "Simfer\u00f3pol" },
            { "timezone.excity.Europe/Zaporozhye", "Zaporiyia" },
            { "timezone.excity.Pacific/Enderbury", "Enderbury" },
            { "timezone.excity.Pacific/Galapagos", "Gal\u00e1pagos" },
            { "timezone.excity.Pacific/Kwajalein", "Kwajalein" },
            { "timezone.excity.Pacific/Marquesas", "Marquesas" },
            { "timezone.excity.Pacific/Pago_Pago", "Pago Pago" },
            { "timezone.excity.Pacific/Rarotonga", "Rarotonga" },
            { "timezone.excity.Pacific/Tongatapu", "Tongatapu" },
            { "timezone.excity.Africa/Addis_Ababa", "Addis Abeba" },
            { "timezone.excity.Africa/Brazzaville", "Brazzaville" },
            { "timezone.excity.Africa/Ouagadougou", "Uagadug\u00fa" },
            { "timezone.excity.America/Costa_Rica", "Costa Rica" },
            { "timezone.excity.America/Grand_Turk", "Gran Turca" },
            { "timezone.excity.America/Guadeloupe", "Guadalupe" },
            { "timezone.excity.America/Hermosillo", "Hermosillo" },
            { "timezone.excity.America/Kralendijk", "Kralendijk" },
            { "timezone.excity.America/Louisville", "Louisville" },
            { "timezone.excity.America/Martinique", "Martinica" },
            { "timezone.excity.America/Metlakatla", "Metlakatla" },
            { "timezone.excity.America/Montevideo", "Montevideo" },
            { "timezone.excity.America/Montserrat", "Montserrat" },
            { "timezone.excity.America/Paramaribo", "Paramaribo" },
            { "timezone.excity.America/Rio_Branco", "R\u00edo Branco" },
            { "timezone.excity.America/St_Vincent", "San Vicente" },
            { "timezone.excity.America/Whitehorse", "Whitehorse" },
            { "timezone.excity.Antarctica/McMurdo", "McMurdo" },
            { "timezone.excity.Antarctica/Rothera", "Rothera" },
            { "timezone.excity.Asia/Srednekolymsk", "Srednekolimsk" },
            { "timezone.excity.Asia/Yekaterinburg", "Ekaterimburgo" },
            { "timezone.excity.Atlantic/Reykjavik", "Reikiavik" },
            { "timezone.excity.Atlantic/St_Helena", "Santa Elena" },
            { "timezone.excity.Australia/Adelaide", "Adelaida" },
            { "timezone.excity.Australia/Brisbane", "Brisbane" },
            { "timezone.excity.Australia/Lindeman", "Lindeman" },
            { "timezone.excity.Europe/Isle_of_Man", "Isla de Man" },
            { "timezone.excity.Europe/Kaliningrad", "Kaliningrado" },
            { "timezone.excity.Pacific/Kiritimati", "Kiritimati" },
            { "timezone.excity.Africa/Johannesburg", "Johannesburgo" },
            { "timezone.excity.America/El_Salvador", "El Salvador" },
            { "timezone.excity.America/Fort_Nelson", "Fort Nelson" },
            { "timezone.excity.America/Los_Angeles", "Los \u00c1ngeles" },
            { "timezone.excity.America/Mexico_City", "Ciudad de M\u00e9xico" },
            { "timezone.excity.America/Pangnirtung", "Pangnirtung" },
            { "timezone.excity.America/Porto_Velho", "Porto Velho" },
            { "timezone.excity.America/Puerto_Rico", "Puerto Rico" },
            { "timezone.excity.America/Rainy_River", "Rainy River" },
            { "timezone.excity.America/Tegucigalpa", "Tegucigalpa" },
            { "timezone.excity.America/Thunder_Bay", "Thunder Bay" },
            { "timezone.excity.America/Yellowknife", "Yellowknife" },
            { "timezone.excity.Arctic/Longyearbyen", "Longyearbyen" },
            { "timezone.excity.Atlantic/Cape_Verde", "Cabo Verde" },
            { "timezone.excity.Australia/Lord_Howe", "Lord Howe" },
            { "timezone.excity.Australia/Melbourne", "Melbourne" },
            { "timezone.excity.Indian/Antananarivo", "Antananarivo" },
            { "timezone.excity.Pacific/Guadalcanal", "Guadalcanal" },
            { "timezone.excity.Africa/Dar_es_Salaam", "Dar es Salaam" },
            { "timezone.excity.America/Blanc-Sablon", "Blanc-Sablon" },
            { "timezone.excity.America/Buenos_Aires", "Buenos Aires" },
            { "timezone.excity.America/Campo_Grande", "Campo Grande" },
            { "timezone.excity.America/Danmarkshavn", "Danmarkshavn" },
            { "timezone.excity.America/Dawson_Creek", "Dawson Creek" },
            { "timezone.excity.America/Indianapolis", "Indian\u00e1polis" },
            { "timezone.excity.America/Punta_Arenas", "Punta Arenas" },
            { "timezone.excity.America/Rankin_Inlet", "Rankin Inlet" },
            { "timezone.excity.America/Santa_Isabel", "Santa Isabel" },
            { "timezone.excity.Antarctica/Macquarie", "Macquarie" },
            { "timezone.excity.Pacific/Bougainville", "Bougainville" },
            { "timezone.excity.Pacific/Port_Moresby", "Port Moresby" },
            { "timezone.excity.America/Cambridge_Bay", "Cambridge Bay" },
            { "timezone.excity.America/Port_of_Spain", "Puerto Espa\u00f1a" },
            { "timezone.excity.America/Santo_Domingo", "Santo Domingo" },
            { "timezone.excity.America/St_Barthelemy", "San Bartolom\u00e9" },
            { "timezone.excity.America/Swift_Current", "Swift Current" },
            { "timezone.excity.Australia/Broken_Hill", "Broken Hill" },
            { "timezone.excity.America/Port-au-Prince", "Puerto Pr\u00edncipe" },
            { "timezone.excity.Atlantic/South_Georgia", "Georgia del Sur" },
            { "timezone.excity.America/Argentina/Salta", "Salta" },
            { "timezone.excity.America/Argentina/Tucuman", "Tucum\u00e1n" },
            { "timezone.excity.America/Argentina/Ushuaia", "Ushuaia" },
            { "timezone.excity.America/Argentina/La_Rioja", "La Rioja" },
            { "timezone.excity.America/Argentina/San_Juan", "San Juan" },
            { "timezone.excity.America/Argentina/San_Luis", "San Luis" },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah, Dakota del Norte" },
            { "timezone.excity.America/North_Dakota/Center", "Center, Dakota del Norte" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "R\u00edo Gallegos" },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salem, Dakota del Norte" },
        };
        return data;
    }
}
