/*
 * Copyright (c) 2012, 2022, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ia extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "arabe";
        final String metaValue_bn = "bengalese";
        final String metaValue_gu = "gujarati";
        final String metaValue_ja = "japonese";
        final String metaValue_km = "khmer";
        final String metaValue_kn = "kannada";
        final String metaValue_ml = "malayalam";
        final String metaValue_mn = "mongol";
        final String metaValue_si = "cingalese";
        final String metaValue_ta = "tamil";
        final String metaValue_te = "telugu";
        final Object[][] data = new Object[][] {
            { "ksh", "coloniese" },
            { "mwl", "mirandese" },
            { "Zsym", "symbolos" },
            { "Zsye", "emoji" },
            { "ccp", "chakma" },
            { "tem", "temne" },
            { "teo", "teso" },
            { "rap", "rapanui" },
            { "AC", "Insula del Ascension" },
            { "rar", "rarotongano" },
            { "tet", "tetum" },
            { "AD", "Andorra" },
            { "AE", "Emiratos Arabe Unite" },
            { "nl_BE", "flamingo" },
            { "AF", "Afghanistan" },
            { "AG", "Antigua e Barbuda" },
            { "type.ca.ethiopic", "calendario ethiope" },
            { "AI", "Anguilla" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "AO", "Angola" },
            { "AQ", "Antarctica" },
            { "AR", "Argentina" },
            { "AS", "Samoa american" },
            { "AT", "Austria" },
            { "AU", "Australia" },
            { "AW", "Aruba" },
            { "en_US", "anglese american" },
            { "AX", "Insulas \u00c5land" },
            { "AZ", "Azerbaidzhan" },
            { "BA", "Bosnia e Herzegovina" },
            { "BB", "Barbados" },
            { "ceb", "cebuano" },
            { "BD", "Bangladesh" },
            { "kum", "kumyko" },
            { "BE", "Belgica" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaria" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Sancte Bartholomeo" },
            { "BM", "Bermuda" },
            { "myv", "erzya" },
            { "BN", "Brunei" },
            { "BO", "Bolivia" },
            { "BQ", "Paises Basse caribe" },
            { "BR", "Brasil" },
            { "BS", "Bahamas" },
            { "xog", "soga" },
            { "BT", "Bhutan" },
            { "BV", "Insula de Bouvet" },
            { "BW", "Botswana" },
            { "BY", "Bielorussia" },
            { "BZ", "Belize" },
            { "type.ca.persian", "calendario persa" },
            { "type.nu.hebr", "cifras hebraic" },
            { "CA", "Canada" },
            { "CC", "Insulas Cocos (Keeling)" },
            { "mzn", "mazanderani" },
            { "CD", "Congo - Kinshasa" },
            { "CF", "Republica African Central" },
            { "CG", "Congo - Brazzaville" },
            { "CH", "Suissa" },
            { "CI", "Costa de Ebore" },
            { "CK", "Insulas Cook" },
            { "CL", "Chile" },
            { "CM", "Camerun" },
            { "CN", "China" },
            { "CO", "Colombia" },
            { "CP", "Insula Clipperton" },
            { "CR", "Costa Rica" },
            { "CU", "Cuba" },
            { "CV", "Capo Verde" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Insula de Natal" },
            { "CY", "Cypro" },
            { "CZ", "Chechia" },
            { "eka", "ekajuk" },
            { "DE", "Germania" },
            { "ace", "acehnese" },
            { "cgg", "chiga" },
            { "DG", "Diego Garcia" },
            { "type.nu.deva", "cifras devanagari" },
            { "DJ", "Djibuti" },
            { "DK", "Danmark" },
            { "Brai", "braille" },
            { "DM", "Dominica" },
            { "type.nu.armnlow", "cifras armenie minuscule" },
            { "DO", "Republica Dominican" },
            { "gor", "gorontalo" },
            { "zun", "zuni" },
            { "tig", "tigre" },
            { "DZ", "Algeria" },
            { "pag", "pangasinan" },
            { "EA", "Ceuta e Melilla" },
            { "pam", "pampanga" },
            { "EC", "Ecuador" },
            { "pap", "papiamento" },
            { "ada", "adangme" },
            { "EE", "Estonia" },
            { "EG", "Egypto" },
            { "EH", "Sahara occidental" },
            { "pau", "palauano" },
            { "chk", "chuukese" },
            { "chm", "mari" },
            { "cho", "choctaw" },
            { "chr", "cherokee" },
            { "ER", "Eritrea" },
            { "ES", "Espania" },
            { "ET", "Ethiopia" },
            { "EU", "Union Europee" },
            { "type.ca.gregorian", "calendario gregorian" },
            { "EZ", "Zona euro" },
            { "chy", "cheyenne" },
            { "type.nu.gujr", "cifras gujarati" },
            { "ady", "adygeano" },
            { "FI", "Finlandia" },
            { "FJ", "Fiji" },
            { "FK", "Insulas Falkland" },
            { "FM", "Micronesia" },
            { "FO", "Insulas Feroe" },
            { "Taml", metaValue_ta },
            { "FR", "Francia" },
            { "GA", "Gabon" },
            { "GB", "Regno Unite" },
            { "pcm", "pidgin nigerian" },
            { "GD", "Grenada" },
            { "GE", "Georgia" },
            { "GF", "Guyana francese" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Groenlandia" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadeloupe" },
            { "GQ", "Guinea equatorial" },
            { "GR", "Grecia" },
            { "GS", "Georgia del Sud e Insulas Sandwich Austral" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guinea-Bissau" },
            { "rhg", "rohingya" },
            { "tlh", "klingon" },
            { "GY", "Guyana" },
            { "ckb", "kurdo central" },
            { "zxx", "sin contento linguistic" },
            { "de_AT", "germano austriac" },
            { "HK", "Hongkong, R.A.S. de China" },
            { "HM", "Insulas Heard e McDonald" },
            { "HN", "Honduras" },
            { "HR", "Croatia" },
            { "agq", "aghem" },
            { "gsw", "germano suisse" },
            { "HT", "Haiti" },
            { "HU", "Hungaria" },
            { "IC", "Insulas Canari" },
            { "ID", "Indonesia" },
            { "IE", "Irlanda" },
            { "nap", "napolitano" },
            { "naq", "nama" },
            { "zza", "zaza" },
            { "IL", "Israel" },
            { "IM", "Insula de Man" },
            { "IN", "India" },
            { "IO", "Territorio oceanic britanno-indian" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Islanda" },
            { "IT", "Italia" },
            { "Zmth", "notation mathematic" },
            { "type.nu.thai", "cifras thailandese" },
            { "type.nu.beng", "cifras bengalese" },
            { "JE", "Jersey" },
            { "type.ca.islamic", "calendario islamic" },
            { "Beng", metaValue_bn },
            { "JM", "Jamaica" },
            { "JO", "Jordania" },
            { "JP", "Japon" },
            { "ain", "ainu" },
            { "guz", "gusii" },
            { "type.nu.knda", "cifras kannada" },
            { "de_CH", "alte germano suisse" },
            { "type.ca.buddhist", "calendario buddhista" },
            { "KE", "Kenya" },
            { "419", "America latin" },
            { "KG", "Kirghizistan" },
            { "KH", "Cambodgia" },
            { "KI", "Kiribati" },
            { "KM", "Comoros" },
            { "Knda", metaValue_kn },
            { "KN", "Sancte Christophoro e Nevis" },
            { "fr_CA", "francese canadian" },
            { "KP", "Corea del Nord" },
            { "KR", "Corea del Sud" },
            { "fr_CH", "francese suisse" },
            { "KW", "Kuwait" },
            { "tpi", "tok pisin" },
            { "KY", "Insulas de Caiman" },
            { "KZ", "Kazakhstan" },
            { "Cyrl", "cyrillic" },
            { "LA", "Laos" },
            { "LB", "Libano" },
            { "LC", "Sancte Lucia" },
            { "gwi", "gwich\u2019in" },
            { "nds", "basse germano" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberia" },
            { "LS", "Lesotho" },
            { "LT", "Lituania" },
            { "LU", "Luxemburg" },
            { "LV", "Lettonia" },
            { "Kana", "katakana" },
            { "LY", "Libya" },
            { "lad", "ladino" },
            { "vun", "vunjo" },
            { "lag", "langi" },
            { "Thaa", "thaana" },
            { "MA", "Marocco" },
            { "MC", "Monaco" },
            { "MD", "Moldavia" },
            { "ME", "Montenegro" },
            { "MF", "Sancte Martino francese" },
            { "MG", "Madagascar" },
            { "MH", "Insulas Marshall" },
            { "ale", "aleuto" },
            { "Thai", "thailandese" },
            { "MK", "Macedonia del Nord" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Birmania)" },
            { "MN", "Mongolia" },
            { "new", "newari" },
            { "MO", "Macao, R.A.S. de China" },
            { "MP", "Insulas Marianna del Nord" },
            { "MQ", "Martinica" },
            { "MR", "Mauritania" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Mauritio" },
            { "alt", "altai del sud" },
            { "MV", "Maldivas" },
            { "MW", "Malawi" },
            { "MX", "Mexico" },
            { "type.ca.japanese", "calendario japonese" },
            { "MY", "Malaysia" },
            { "MZ", "Mozambique" },
            { "NA", "Namibia" },
            { "202", "Africa subsaharian" },
            { "type.ca.hebrew", "calendario hebraic" },
            { "NC", "Nove Caledonia" },
            { "NE", "Niger" },
            { "NF", "Insula Norfolk" },
            { "NG", "Nigeria" },
            { "trv", "taroko" },
            { "NI", "Nicaragua" },
            { "NL", "Nederlandia" },
            { "NO", "Norvegia" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "rof", "rombo" },
            { "NZ", "Nove Zelanda" },
            { "OM", "Oman" },
            { "anp", "angika" },
            { "crs", "creolo seychellese" },
            { "PA", "Panama" },
            { "en_GB", "anglese britannic" },
            { "PE", "Peru" },
            { "PF", "Polynesia francese" },
            { "PG", "Papua Nove Guinea" },
            { "PH", "Philippinas" },
            { "PK", "Pakistan" },
            { "PL", "Polonia" },
            { "ewo", "ewondo" },
            { "PM", "St. Pierre e Miquelon" },
            { "PN", "Insulas Pitcairn" },
            { "PR", "Porto Rico" },
            { "PS", "Territorios palestin" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "nia", "nias" },
            { "type.nu.greklow", "cifras grec minuscule" },
            { "PY", "Paraguay" },
            { "tum", "tumbuka" },
            { "Hebr", "hebraic" },
            { "QA", "Qatar" },
            { "niu", "nieuano" },
            { "QO", "Oceania remote" },
            { "lez", "lezghiano" },
            { "tvl", "tuvaluano" },
            { "001", "Mundo" },
            { "002", "Africa" },
            { "003", "America del Nord" },
            { "RE", "Reunion" },
            { "005", "America del Sud" },
            { "jbo", "lojban" },
            { "009", "Oceania" },
            { "RO", "Romania" },
            { "RS", "Serbia" },
            { "RU", "Russia" },
            { "RW", "Ruanda" },
            { "SA", "Arabia Saudita" },
            { "SB", "Insulas Solomon" },
            { "twq", "tasawaq" },
            { "011", "Africa occidental" },
            { "SC", "Seychelles" },
            { "SD", "Sudan" },
            { "013", "America central" },
            { "SE", "Svedia" },
            { "014", "Africa oriental" },
            { "015", "Africa septentrional" },
            { "SG", "Singapur" },
            { "SH", "Sancte Helena" },
            { "type.lb.strict", "stilo de salto de linea stricte" },
            { "017", "Africa central" },
            { "SI", "Slovenia" },
            { "018", "Africa meridional" },
            { "SJ", "Svalbard e Jan Mayen" },
            { "019", "Americas" },
            { "SK", "Slovachia" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "arn", "mapuche" },
            { "arp", "arapaho" },
            { "type.nu.taml", "cifras tamil traditional" },
            { "SR", "Suriname" },
            { "SS", "Sudan del Sud" },
            { "ST", "S\u00e3o Tom\u00e9 e Pr\u00edncipe" },
            { "SV", "El Salvador" },
            { "SX", "Sancte Martino nederlandese" },
            { "SY", "Syria" },
            { "SZ", "Eswatini" },
            { "TA", "Tristan da Cunha" },
            { "asa", "asu" },
            { "type.ms.ussystem", "systema de mesura statounitese" },
            { "021", "America septentrional" },
            { "TC", "Insulas Turcos e Caicos" },
            { "yav", "yangben" },
            { "TD", "Tchad" },
            { "TF", "Territorios meridional francese" },
            { "TG", "Togo" },
            { "TH", "Thailandia" },
            { "TJ", "Tadzhikistan" },
            { "029", "Caribes" },
            { "TK", "Tokelau" },
            { "TL", "Timor del Est" },
            { "ybb", "yemba" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunisia" },
            { "TO", "Tonga" },
            { "TR", "Turchia" },
            { "TT", "Trinidad e Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "ast", "asturiano" },
            { "TZ", "Tanzania" },
            { "nmg", "kwasio" },
            { "Zzzz", "scriptura incognite" },
            { "UA", "Ukraina" },
            { "rup", "aromaniano" },
            { "030", "Asia oriental" },
            { "tyv", "tuvano" },
            { "sw_CD", "swahili del Congo" },
            { "034", "Asia meridional" },
            { "035", "Asia del sud-est" },
            { "UG", "Uganda" },
            { "039", "Europa meridional" },
            { "Sinh", metaValue_si },
            { "UM", "Insulas peripheric del SUA" },
            { "UN", "Nationes Unite" },
            { "US", "Statos Unite" },
            { "haw", "hawaiano" },
            { "UY", "Uruguay" },
            { "prg", "prussiano" },
            { "UZ", "Uzbekistan" },
            { "tzm", "tamazight del Atlas Central" },
            { "nnh", "ngiemboon" },
            { "VA", "Citate del Vaticano" },
            { "VC", "Sancte Vincente e le Grenadinas" },
            { "VE", "Venezuela" },
            { "VG", "Insulas Virgine britannic" },
            { "VI", "Insulas Virgine statounitese" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "nog", "nogai" },
            { "rwk", "rwa" },
            { "053", "Australasia" },
            { "054", "Melanesia" },
            { "WF", "Wallis e Futuna" },
            { "057", "Region micronesian" },
            { "jgo", "ngomba" },
            { "lkt", "lakota" },
            { "wae", "walser" },
            { "WS", "Samoa" },
            { "wal", "wolaytta" },
            { "XA", "Pseudo-accentos" },
            { "war", "waray" },
            { "XB", "Pseudo-bidi" },
            { "awa", "awadhi" },
            { "061", "Polynesia" },
            { "XK", "Kosovo" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "non scripte" },
            { "YE", "Yemen" },
            { "nqo", "n\u2019ko" },
            { "type.co.standard", "ordinamento standard" },
            { "YT", "Mayotte" },
            { "ZA", "Africa del Sud" },
            { "type.lb.loose", "stilo de salto de linea flexibile" },
            { "Deva", "devanagari" },
            { "type.nu.geor", "cifras georgian" },
            { "Hira", "hiragana" },
            { "ZM", "Zambia" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "Region incognite" },
            { "type.ms.metric", "systema metric" },
            { "type.ca.iso8601", "calendario ISO-8601" },
            { "nso", "sotho del nord" },
            { "type.nu.telu", "cifras telugu" },
            { "loz", "lozi" },
            { "jmc", "machame" },
            { "type.nu.hansfin", "cifras financiari chinese simplificate" },
            { "hil", "hiligaynon" },
            { "type.nu.arabext", "cifras indo-arabe extendite" },
            { "nus", "nuer" },
            { "dak", "dakota" },
            { "type.nu.fullwide", "cifras a latitude integre" },
            { "dar", "dargwa" },
            { "dav", "taita" },
            { "lrc", "luri del nord" },
            { "udm", "udmurto" },
            { "Khmr", metaValue_km },
            { "sad", "sandawe" },
            { "type.nu.roman", "cifras roman" },
            { "sah", "yakuto" },
            { "saq", "samburu" },
            { "sat", "santali" },
            { "sba", "ngambay" },
            { "Guru", "gurmukhi" },
            { "lua", "luba-lulua" },
            { "sbp", "sangu" },
            { "nyn", "nyankole" },
            { "lun", "lunda" },
            { "luo", "luo" },
            { "fil", "filipino" },
            { "hmn", "hmong" },
            { "lus", "mizo" },
            { "ban", "balinese" },
            { "luy", "luyia" },
            { "bas", "basaa" },
            { "es_ES", "espaniol europee" },
            { "sco", "scotese" },
            { "scn", "siciliano" },
            { "aa", "afar" },
            { "ab", "abkhazo" },
            { "af", "afrikaans" },
            { "ak", "akan" },
            { "am", "amharico" },
            { "Arab", metaValue_ar },
            { "an", "aragonese" },
            { "Jpan", metaValue_ja },
            { "ar", metaValue_ar },
            { "Hrkt", "syllabarios japonese" },
            { "as", "assamese" },
            { "av", "avaro" },
            { "ay", "aymara" },
            { "az", "azerbaidzhano" },
            { "ba", "bashkir" },
            { "be", "bielorusso" },
            { "bg", "bulgaro" },
            { "bi", "bislama" },
            { "bm", "bambara" },
            { "bn", metaValue_bn },
            { "bo", "tibetano" },
            { "dgr", "dogrib" },
            { "br", "breton" },
            { "bs", "bosniaco" },
            { "Mymr", "birman" },
            { "type.nu.laoo", "cifras lao" },
            { "seh", "sena" },
            { "ca", "catalano" },
            { "ses", "koyraboro senni" },
            { "ce", "checheno" },
            { "ch", "chamorro" },
            { "co", "corso" },
            { "Orya", "orya" },
            { "cs", "checo" },
            { "cu", "slavo ecclesiastic" },
            { "cv", "chuvash" },
            { "cy", "gallese" },
            { "type.nu.ethi", "cifras ethiope" },
            { "da", "danese" },
            { "pt_PT", "portugese de Portugal" },
            { "de", "germano" },
            { "type.cf.standard", "formato de moneta standard" },
            { "bem", "bemba" },
            { "dv", "divehi" },
            { "es_419", "espaniol latinoamerican" },
            { "dz", "dzongkha" },
            { "bez", "bena" },
            { "type.ca.chinese", "calendario chinese" },
            { "dje", "zarma" },
            { "type.nu.grek", "cifras grec" },
            { "ee", "ewe" },
            { "type.lb.normal", "stilo de salto de linea normal" },
            { "ro_MD", "moldavo" },
            { "el", "greco" },
            { "en", "anglese" },
            { "eo", "esperanto" },
            { "es", "espaniol" },
            { "et", "estoniano" },
            { "Hanb", "han con bopomofo" },
            { "eu", "basco" },
            { "Hang", "hangul" },
            { "shi", "tachelhit" },
            { "hsb", "alte sorabo" },
            { "Hani", "han" },
            { "shn", "shan" },
            { "fa", "persa" },
            { "Hans", "simplificate" },
            { "type.nu.latn", "cifras occidental" },
            { "Hant", "traditional" },
            { "ff", "fula" },
            { "fi", "finnese" },
            { "fj", "fijiano" },
            { "fon", "fon" },
            { "yue", "cantonese" },
            { "fo", "feroese" },
            { "umb", "umbundu" },
            { "fr", "francese" },
            { "fy", "frison occidental" },
            { "ga", "irlandese" },
            { "gd", "gaelico scotese" },
            { "gl", "galleco" },
            { "gn", "guarani" },
            { "bho", "bhojpuri" },
            { "und", "lingua incognite" },
            { "gu", metaValue_gu },
            { "gv", "mannese" },
            { "ha", "hausa" },
            { "he", "hebreo" },
            { "hi", "hindi" },
            { "hup", "hupa" },
            { "bin", "bini" },
            { "hr", "croato" },
            { "ht", "creolo haitian" },
            { "hu", "hungaro" },
            { "hy", "armenio" },
            { "hz", "herero" },
            { "ia", "interlingua" },
            { "Jamo", "jamo" },
            { "id", "indonesiano" },
            { "type.nu.tibt", "cifras tibetan" },
            { "ig", "igbo" },
            { "ii", "yi de Sichuan" },
            { "io", "ido" },
            { "is", "islandese" },
            { "it", "italiano" },
            { "iu", "inuktitut" },
            { "ja", metaValue_ja },
            { "Mlym", metaValue_ml },
            { "doi", "dogri" },
            { "sma", "sami del sud" },
            { "jv", "javanese" },
            { "mad", "madurese" },
            { "smj", "sami de Lule" },
            { "mag", "magahi" },
            { "mai", "maithili" },
            { "smn", "sami de Inari" },
            { "ka", "georgiano" },
            { "bla", "siksika" },
            { "mak", "macassarese" },
            { "sms", "sami skolt" },
            { "ki", "kikuyu" },
            { "mas", "masai" },
            { "kj", "kuanyama" },
            { "kk", "kazakh" },
            { "kl", "groenlandese" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", "coreano" },
            { "kr", "kanuri" },
            { "ks", "kashmiri" },
            { "ku", "kurdo" },
            { "kv", "komi" },
            { "kw", "cornico" },
            { "ky", "kirghizo" },
            { "snk", "soninke" },
            { "la", "latino" },
            { "lb", "luxemburgese" },
            { "type.nu.mlym", "cifras malayalam" },
            { "lg", "luganda" },
            { "li", "limburgese" },
            { "Tibt", "tibetan" },
            { "ln", "lingala" },
            { "fur", "friulano" },
            { "lo", "laotiano" },
            { "type.ms.uksystem", "systema de mesura imperial" },
            { "lt", "lithuano" },
            { "lu", "luba-katanga" },
            { "lv", "letton" },
            { "mg", "malgache" },
            { "mh", "marshallese" },
            { "type.co.ducet", "ordinamento Unicode predefinite" },
            { "mi", "maori" },
            { "mk", "macedone" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "marathi" },
            { "ms", "malay" },
            { "mt", "maltese" },
            { "my", "birmano" },
            { "Armn", "armenie" },
            { "mdf", "moksha" },
            { "dsb", "basse sorabo" },
            { "na", "nauru" },
            { "type.co.search", "recerca generic" },
            { "nb", "norvegiano bokm\u00e5l" },
            { "nd", "ndebele del nord" },
            { "ne", "nepalese" },
            { "ng", "ndonga" },
            { "nl", "nederlandese" },
            { "nn", "norvegiano nynorsk" },
            { "no", "norvegiano" },
            { "nr", "ndebele del sud" },
            { "nv", "navajo" },
            { "ny", "nyanja" },
            { "kac", "kachin" },
            { "kab", "kabylo" },
            { "oc", "occitano" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "men", "mende" },
            { "mer", "meri" },
            { "type.nu.armn", "cifras armenie" },
            { "om", "oromo" },
            { "or", "oriya" },
            { "os", "osseto" },
            { "kbd", "cabardiano" },
            { "mfe", "creolo mauritian" },
            { "srn", "sranan tongo" },
            { "pa", "punjabi" },
            { "dua", "duala" },
            { "pl", "polonese" },
            { "type.ca.dangi", "calendario dangi" },
            { "ps", "pashto" },
            { "pt", "portugese" },
            { "key.co", "ordinamento" },
            { "pt_BR", "portugese de Brasil" },
            { "kcg", "tyap" },
            { "mgh", "makhuwa-meetto" },
            { "key.cf", "formato de moneta" },
            { "key.ca", "calendario" },
            { "Laoo", "lao" },
            { "mgo", "meta\u02bc" },
            { "type.hc.h23", "systema de 24 horas (0\u201323)" },
            { "type.hc.h24", "systema de 24 horas (1\u201324)" },
            { "ssy", "saho" },
            { "type.nu.mymr", "cifras birman" },
            { "qu", "quechua" },
            { "brx", "bodo" },
            { "kde", "makonde" },
            { "Ethi", "ethiope" },
            { "type.hc.h12", "systema de 12 horas (1\u201312)" },
            { "type.hc.h11", "systema de 12 horas (0\u201311)" },
            { "rm", "romanche" },
            { "rn", "rundi" },
            { "key.cu", "moneta" },
            { "ro", "romaniano" },
            { "type.nu.orya", "cifras oriya" },
            { "type.nu.hanidec", "cifras decimal chinese" },
            { "ru", "russo" },
            { "rw", "kinyarwanda" },
            { "kea", "capoverdiano" },
            { "mic", "micmac" },
            { "suk", "sukuma" },
            { "en_AU", "anglese australian" },
            { "sa", "sanscrito" },
            { "sc", "sardo" },
            { "sd", "sindhi" },
            { "se", "sami del nord" },
            { "min", "minangkabau" },
            { "sg", "sango" },
            { "si", metaValue_si },
            { "sk", "slovaco" },
            { "sl", "sloveno" },
            { "sm", "samoano" },
            { "sn", "shona" },
            { "so", "somali" },
            { "type.nu.arab", "cifras indo-arabe" },
            { "sq", "albanese" },
            { "sr", "serbo" },
            { "ss", "swati" },
            { "type.cf.account", "formato de moneta pro contabilitate" },
            { "st", "sotho del sud" },
            { "su", "sundanese" },
            { "sv", "svedese" },
            { "sw", "swahili" },
            { "type.nu.hantfin", "cifras financiari chinese traditional" },
            { "ibb", "ibibio" },
            { "iba", "iban" },
            { "ta", metaValue_ta },
            { "142", "Asia" },
            { "143", "Asia central" },
            { "te", metaValue_te },
            { "145", "Asia occidental" },
            { "tg", "tajiko" },
            { "th", "thai" },
            { "ti", "tigrinya" },
            { "bug", "buginese" },
            { "kfo", "koro" },
            { "en_CA", "anglese canadian" },
            { "tk", "turkmeno" },
            { "tn", "tswana" },
            { "to", "tongano" },
            { "dyo", "jola-fonyi" },
            { "type.nu.jpan", "cifras japonese" },
            { "tr", "turco" },
            { "ts", "tsonga" },
            { "swb", "comoriano" },
            { "tt", "tataro" },
            { "ty", "tahitiano" },
            { "150", "Europa" },
            { "151", "Europa oriental" },
            { "154", "Europa septentrional" },
            { "dzg", "dazaga" },
            { "155", "Europa occidental" },
            { "ug", "uighur" },
            { "Kore", "corean" },
            { "Zyyy", "commun" },
            { "uk", "ukrainiano" },
            { "ur", "urdu" },
            { "xal", "calmuco" },
            { "uz", "uzbeko" },
            { "kha", "khasi" },
            { "ve", "venda" },
            { "type.ca.roc", "calendario del Republica de China" },
            { "vi", "vietnamese" },
            { "khq", "koyra chiini" },
            { "key.hc", "cyclo horari (12 o 24)" },
            { "vo", "volap\u00fck" },
            { "quc", "k\u02bciche\u02bc" },
            { "gaa", "ga" },
            { "wa", "wallon" },
            { "syr", "syriaco" },
            { "Grek", "grec" },
            { "wo", "wolof" },
            { "zgh", "tamazight marocchin standard" },
            { "ar_001", "arabe standard moderne" },
            { "Mong", metaValue_mn },
            { "mni", "manipuri" },
            { "Latn", "latin" },
            { "type.nu.hans", "cifras chinese simplificate" },
            { "type.nu.hant", "cifras chinese traditional" },
            { "xh", "xhosa" },
            { "type.nu.romanlow", "cifras roman minuscule" },
            { "byn", "blin" },
            { "moh", "mohawk" },
            { "kkj", "kako" },
            { "yi", "yiddish" },
            { "mos", "mossi" },
            { "yo", "yoruba" },
            { "es_MX", "espaniol mexican" },
            { "vai", "vai" },
            { "kln", "kalenjin" },
            { "zh", "chinese" },
            { "Bopo", "bopomofo" },
            { "key.lb", "stilo de salto de linea" },
            { "zu", "zulu" },
            { "Geor", "georgian" },
            { "kmb", "kimbundu" },
            { "type.nu.jpanfin", "cifras financiari japonese" },
            { "gez", "ge\u2019ez" },
            { "ebu", "embu" },
            { "zh_Hans", "chinese simplificate" },
            { "kok", "konkani" },
            { "zh_Hant", "chinese traditional" },
            { "kpe", "kpelle" },
            { "type.nu.khmr", "cifras khmer" },
            { "ilo", "ilocano" },
            { "mua", "mundang" },
            { "type.nu.guru", "cifras gurmukhi" },
            { "mul", "plure linguas" },
            { "key.ms", "systema de mesura" },
            { "mus", "creek" },
            { "gil", "gilbertese" },
            { "type.nu.tamldec", "cifras tamil" },
            { "krc", "karachay-balkaro" },
            { "inh", "ingush" },
            { "fa_AF", "dari" },
            { "krl", "careliano" },
            { "efi", "efik" },
            { "key.nu", "numeros" },
            { "kru", "kurukh" },
            { "ksb", "shambala" },
            { "Telu", metaValue_te },
            { "ksf", "bafia" },
        };
        return data;
    }
}
