/*
 * Copyright (c) 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * This file is generated by FieldGen.java. Do not modify it directly.
 */

package sun.security.util.math.intpoly;

import java.math.BigInteger;
public final class Curve448OrderField extends IntegerPolynomial {
    private static final int BITS_PER_LIMB = 28;
    private static final int NUM_LIMBS = 16;
    private static final int MAX_ADDS = 1;
    public static final BigInteger MODULUS = evaluateModulus();
    private static final long CARRY_ADD = 1 << 27;
    private static final int LIMB_MASK = -1 >>> (64 - BITS_PER_LIMB);

    public static final Curve448OrderField ONE = new Curve448OrderField();

    private Curve448OrderField() {

        super(BITS_PER_LIMB, NUM_LIMBS, MAX_ADDS, MODULUS);

    }
    //(0%nat,-78101261)::(28%nat,126626091)::(56%nat,93279523)::(84%nat,-64542500)::(112%nat,110109037)::(140%nat,77262179)::(168%nat,-104575269)::(196%nat,130851391)::(224%nat,-1)::nil.
    private static BigInteger evaluateModulus() {
        BigInteger result = BigInteger.valueOf(2).pow(446);
        result = result.subtract(BigInteger.valueOf(78101261));
        result = result.add(BigInteger.valueOf(2).pow(28).multiply(BigInteger.valueOf(126626091)));
        result = result.add(BigInteger.valueOf(2).pow(56).multiply(BigInteger.valueOf(93279523)));
        result = result.subtract(BigInteger.valueOf(2).pow(84).multiply(BigInteger.valueOf(64542500)));
        result = result.add(BigInteger.valueOf(2).pow(112).multiply(BigInteger.valueOf(110109037)));
        result = result.add(BigInteger.valueOf(2).pow(140).multiply(BigInteger.valueOf(77262179)));
        result = result.subtract(BigInteger.valueOf(2).pow(168).multiply(BigInteger.valueOf(104575269)));
        result = result.add(BigInteger.valueOf(2).pow(196).multiply(BigInteger.valueOf(130851391)));
        result = result.subtract(BigInteger.valueOf(2).pow(224));
        return result;
    }
    @Override
    protected void reduceIn(long[] limbs, long v, int i) {
        long t0 = 78101261 * v;
        limbs[i - 16] += (t0 << 2) & LIMB_MASK;
        limbs[i - 15] += t0 >> 26;
        long t1 = -126626091 * v;
        limbs[i - 15] += (t1 << 2) & LIMB_MASK;
        limbs[i - 14] += t1 >> 26;
        long t2 = -93279523 * v;
        limbs[i - 14] += (t2 << 2) & LIMB_MASK;
        limbs[i - 13] += t2 >> 26;
        long t3 = 64542500 * v;
        limbs[i - 13] += (t3 << 2) & LIMB_MASK;
        limbs[i - 12] += t3 >> 26;
        long t4 = -110109037 * v;
        limbs[i - 12] += (t4 << 2) & LIMB_MASK;
        limbs[i - 11] += t4 >> 26;
        long t5 = -77262179 * v;
        limbs[i - 11] += (t5 << 2) & LIMB_MASK;
        limbs[i - 10] += t5 >> 26;
        long t6 = 104575269 * v;
        limbs[i - 10] += (t6 << 2) & LIMB_MASK;
        limbs[i - 9] += t6 >> 26;
        long t7 = -130851391 * v;
        limbs[i - 9] += (t7 << 2) & LIMB_MASK;
        limbs[i - 8] += t7 >> 26;
        limbs[i - 8] += (v << 2) & LIMB_MASK;
        limbs[i - 7] += v >> 26;
    }
    @Override
    protected void finalCarryReduceLast(long[] limbs) {
        long c = limbs[15] >> 26;
        limbs[15] -= c << 26;
        long t8 = 78101261 * c;
        limbs[0] += t8;
        t8 = -126626091 * c;
        limbs[1] += t8;
        t8 = -93279523 * c;
        limbs[2] += t8;
        t8 = 64542500 * c;
        limbs[3] += t8;
        t8 = -110109037 * c;
        limbs[4] += t8;
        t8 = -77262179 * c;
        limbs[5] += t8;
        t8 = 104575269 * c;
        limbs[6] += t8;
        t8 = -130851391 * c;
        limbs[7] += t8;
        limbs[8] += c;
    }
    private void carryReduce(long[] r, long c0, long c1, long c2, long c3, long c4, long c5, long c6, long c7, long c8, long c9, long c10, long c11, long c12, long c13, long c14, long c15, long c16, long c17, long c18, long c19, long c20, long c21, long c22, long c23, long c24, long c25, long c26, long c27, long c28, long c29, long c30) {
        long c31 = 0;
        //carry from position 0
        long t0 = (c0 + CARRY_ADD) >> 28;
        c0 -= (t0 << 28);
        c1 += t0;
        //carry from position 1
        t0 = (c1 + CARRY_ADD) >> 28;
        c1 -= (t0 << 28);
        c2 += t0;
        //carry from position 2
        t0 = (c2 + CARRY_ADD) >> 28;
        c2 -= (t0 << 28);
        c3 += t0;
        //carry from position 3
        t0 = (c3 + CARRY_ADD) >> 28;
        c3 -= (t0 << 28);
        c4 += t0;
        //carry from position 4
        t0 = (c4 + CARRY_ADD) >> 28;
        c4 -= (t0 << 28);
        c5 += t0;
        //carry from position 5
        t0 = (c5 + CARRY_ADD) >> 28;
        c5 -= (t0 << 28);
        c6 += t0;
        //carry from position 6
        t0 = (c6 + CARRY_ADD) >> 28;
        c6 -= (t0 << 28);
        c7 += t0;
        //carry from position 7
        t0 = (c7 + CARRY_ADD) >> 28;
        c7 -= (t0 << 28);
        c8 += t0;
        //carry from position 8
        t0 = (c8 + CARRY_ADD) >> 28;
        c8 -= (t0 << 28);
        c9 += t0;
        //carry from position 9
        t0 = (c9 + CARRY_ADD) >> 28;
        c9 -= (t0 << 28);
        c10 += t0;
        //carry from position 10
        t0 = (c10 + CARRY_ADD) >> 28;
        c10 -= (t0 << 28);
        c11 += t0;
        //carry from position 11
        t0 = (c11 + CARRY_ADD) >> 28;
        c11 -= (t0 << 28);
        c12 += t0;
        //carry from position 12
        t0 = (c12 + CARRY_ADD) >> 28;
        c12 -= (t0 << 28);
        c13 += t0;
        //carry from position 13
        t0 = (c13 + CARRY_ADD) >> 28;
        c13 -= (t0 << 28);
        c14 += t0;
        //carry from position 14
        t0 = (c14 + CARRY_ADD) >> 28;
        c14 -= (t0 << 28);
        c15 += t0;
        //carry from position 15
        t0 = (c15 + CARRY_ADD) >> 28;
        c15 -= (t0 << 28);
        c16 += t0;
        //carry from position 16
        t0 = (c16 + CARRY_ADD) >> 28;
        c16 -= (t0 << 28);
        c17 += t0;
        //carry from position 17
        t0 = (c17 + CARRY_ADD) >> 28;
        c17 -= (t0 << 28);
        c18 += t0;
        //carry from position 18
        t0 = (c18 + CARRY_ADD) >> 28;
        c18 -= (t0 << 28);
        c19 += t0;
        //carry from position 19
        t0 = (c19 + CARRY_ADD) >> 28;
        c19 -= (t0 << 28);
        c20 += t0;
        //carry from position 20
        t0 = (c20 + CARRY_ADD) >> 28;
        c20 -= (t0 << 28);
        c21 += t0;
        //carry from position 21
        t0 = (c21 + CARRY_ADD) >> 28;
        c21 -= (t0 << 28);
        c22 += t0;
        //carry from position 22
        t0 = (c22 + CARRY_ADD) >> 28;
        c22 -= (t0 << 28);
        c23 += t0;
        //carry from position 23
        t0 = (c23 + CARRY_ADD) >> 28;
        c23 -= (t0 << 28);
        c24 += t0;
        //carry from position 24
        t0 = (c24 + CARRY_ADD) >> 28;
        c24 -= (t0 << 28);
        c25 += t0;
        //carry from position 25
        t0 = (c25 + CARRY_ADD) >> 28;
        c25 -= (t0 << 28);
        c26 += t0;
        //carry from position 26
        t0 = (c26 + CARRY_ADD) >> 28;
        c26 -= (t0 << 28);
        c27 += t0;
        //carry from position 27
        t0 = (c27 + CARRY_ADD) >> 28;
        c27 -= (t0 << 28);
        c28 += t0;
        //carry from position 28
        t0 = (c28 + CARRY_ADD) >> 28;
        c28 -= (t0 << 28);
        c29 += t0;
        //carry from position 29
        t0 = (c29 + CARRY_ADD) >> 28;
        c29 -= (t0 << 28);
        c30 += t0;
        //carry from position 30
        t0 = (c30 + CARRY_ADD) >> 28;
        c30 -= (t0 << 28);
        c31 += t0;

        carryReduce0(r, c0, c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, c11, c12, c13, c14, c15, c16, c17, c18, c19, c20, c21, c22, c23, c24, c25, c26, c27, c28, c29, c30, c31);
    }
    void carryReduce0(long[] r, long c0, long c1, long c2, long c3, long c4, long c5, long c6, long c7, long c8, long c9, long c10, long c11, long c12, long c13, long c14, long c15, long c16, long c17, long c18, long c19, long c20, long c21, long c22, long c23, long c24, long c25, long c26, long c27, long c28, long c29, long c30, long c31) {
        long t0;

        //reduce from position 31
        t0 = 78101261 * c31;
        c15 += (t0 << 2) & LIMB_MASK;
        c16 += t0 >> 26;
        t0 = -126626091 * c31;
        c16 += (t0 << 2) & LIMB_MASK;
        c17 += t0 >> 26;
        t0 = -93279523 * c31;
        c17 += (t0 << 2) & LIMB_MASK;
        c18 += t0 >> 26;
        t0 = 64542500 * c31;
        c18 += (t0 << 2) & LIMB_MASK;
        c19 += t0 >> 26;
        t0 = -110109037 * c31;
        c19 += (t0 << 2) & LIMB_MASK;
        c20 += t0 >> 26;
        t0 = -77262179 * c31;
        c20 += (t0 << 2) & LIMB_MASK;
        c21 += t0 >> 26;
        t0 = 104575269 * c31;
        c21 += (t0 << 2) & LIMB_MASK;
        c22 += t0 >> 26;
        t0 = -130851391 * c31;
        c22 += (t0 << 2) & LIMB_MASK;
        c23 += t0 >> 26;
        c23 += (c31 << 2) & LIMB_MASK;
        c24 += c31 >> 26;
        //reduce from position 30
        t0 = 78101261 * c30;
        c14 += (t0 << 2) & LIMB_MASK;
        c15 += t0 >> 26;
        t0 = -126626091 * c30;
        c15 += (t0 << 2) & LIMB_MASK;
        c16 += t0 >> 26;
        t0 = -93279523 * c30;
        c16 += (t0 << 2) & LIMB_MASK;
        c17 += t0 >> 26;
        t0 = 64542500 * c30;
        c17 += (t0 << 2) & LIMB_MASK;
        c18 += t0 >> 26;
        t0 = -110109037 * c30;
        c18 += (t0 << 2) & LIMB_MASK;
        c19 += t0 >> 26;
        t0 = -77262179 * c30;
        c19 += (t0 << 2) & LIMB_MASK;
        c20 += t0 >> 26;
        t0 = 104575269 * c30;
        c20 += (t0 << 2) & LIMB_MASK;
        c21 += t0 >> 26;
        t0 = -130851391 * c30;
        c21 += (t0 << 2) & LIMB_MASK;
        c22 += t0 >> 26;
        c22 += (c30 << 2) & LIMB_MASK;
        c23 += c30 >> 26;
        //reduce from position 29
        t0 = 78101261 * c29;
        c13 += (t0 << 2) & LIMB_MASK;
        c14 += t0 >> 26;
        t0 = -126626091 * c29;
        c14 += (t0 << 2) & LIMB_MASK;
        c15 += t0 >> 26;
        t0 = -93279523 * c29;
        c15 += (t0 << 2) & LIMB_MASK;
        c16 += t0 >> 26;
        t0 = 64542500 * c29;
        c16 += (t0 << 2) & LIMB_MASK;
        c17 += t0 >> 26;
        t0 = -110109037 * c29;
        c17 += (t0 << 2) & LIMB_MASK;
        c18 += t0 >> 26;
        t0 = -77262179 * c29;
        c18 += (t0 << 2) & LIMB_MASK;
        c19 += t0 >> 26;
        t0 = 104575269 * c29;
        c19 += (t0 << 2) & LIMB_MASK;
        c20 += t0 >> 26;
        t0 = -130851391 * c29;
        c20 += (t0 << 2) & LIMB_MASK;
        c21 += t0 >> 26;
        c21 += (c29 << 2) & LIMB_MASK;
        c22 += c29 >> 26;
        //reduce from position 28
        t0 = 78101261 * c28;
        c12 += (t0 << 2) & LIMB_MASK;
        c13 += t0 >> 26;
        t0 = -126626091 * c28;
        c13 += (t0 << 2) & LIMB_MASK;
        c14 += t0 >> 26;
        t0 = -93279523 * c28;
        c14 += (t0 << 2) & LIMB_MASK;
        c15 += t0 >> 26;
        t0 = 64542500 * c28;
        c15 += (t0 << 2) & LIMB_MASK;
        c16 += t0 >> 26;
        t0 = -110109037 * c28;
        c16 += (t0 << 2) & LIMB_MASK;
        c17 += t0 >> 26;
        t0 = -77262179 * c28;
        c17 += (t0 << 2) & LIMB_MASK;
        c18 += t0 >> 26;
        t0 = 104575269 * c28;
        c18 += (t0 << 2) & LIMB_MASK;
        c19 += t0 >> 26;
        t0 = -130851391 * c28;
        c19 += (t0 << 2) & LIMB_MASK;
        c20 += t0 >> 26;
        c20 += (c28 << 2) & LIMB_MASK;
        c21 += c28 >> 26;
        //reduce from position 27
        t0 = 78101261 * c27;
        c11 += (t0 << 2) & LIMB_MASK;
        c12 += t0 >> 26;
        t0 = -126626091 * c27;
        c12 += (t0 << 2) & LIMB_MASK;
        c13 += t0 >> 26;
        t0 = -93279523 * c27;
        c13 += (t0 << 2) & LIMB_MASK;
        c14 += t0 >> 26;
        t0 = 64542500 * c27;
        c14 += (t0 << 2) & LIMB_MASK;
        c15 += t0 >> 26;
        t0 = -110109037 * c27;
        c15 += (t0 << 2) & LIMB_MASK;
        c16 += t0 >> 26;
        t0 = -77262179 * c27;
        c16 += (t0 << 2) & LIMB_MASK;
        c17 += t0 >> 26;
        t0 = 104575269 * c27;
        c17 += (t0 << 2) & LIMB_MASK;
        c18 += t0 >> 26;
        t0 = -130851391 * c27;
        c18 += (t0 << 2) & LIMB_MASK;
        c19 += t0 >> 26;
        c19 += (c27 << 2) & LIMB_MASK;
        c20 += c27 >> 26;
        //reduce from position 26
        t0 = 78101261 * c26;
        c10 += (t0 << 2) & LIMB_MASK;
        c11 += t0 >> 26;
        t0 = -126626091 * c26;
        c11 += (t0 << 2) & LIMB_MASK;
        c12 += t0 >> 26;
        t0 = -93279523 * c26;
        c12 += (t0 << 2) & LIMB_MASK;
        c13 += t0 >> 26;
        t0 = 64542500 * c26;
        c13 += (t0 << 2) & LIMB_MASK;
        c14 += t0 >> 26;
        t0 = -110109037 * c26;
        c14 += (t0 << 2) & LIMB_MASK;
        c15 += t0 >> 26;
        t0 = -77262179 * c26;
        c15 += (t0 << 2) & LIMB_MASK;
        c16 += t0 >> 26;
        t0 = 104575269 * c26;
        c16 += (t0 << 2) & LIMB_MASK;
        c17 += t0 >> 26;
        t0 = -130851391 * c26;
        c17 += (t0 << 2) & LIMB_MASK;
        c18 += t0 >> 26;
        c18 += (c26 << 2) & LIMB_MASK;
        c19 += c26 >> 26;
        //reduce from position 25
        t0 = 78101261 * c25;
        c9 += (t0 << 2) & LIMB_MASK;
        c10 += t0 >> 26;
        t0 = -126626091 * c25;
        c10 += (t0 << 2) & LIMB_MASK;
        c11 += t0 >> 26;
        t0 = -93279523 * c25;
        c11 += (t0 << 2) & LIMB_MASK;
        c12 += t0 >> 26;
        t0 = 64542500 * c25;
        c12 += (t0 << 2) & LIMB_MASK;
        c13 += t0 >> 26;
        t0 = -110109037 * c25;
        c13 += (t0 << 2) & LIMB_MASK;
        c14 += t0 >> 26;
        t0 = -77262179 * c25;
        c14 += (t0 << 2) & LIMB_MASK;
        c15 += t0 >> 26;
        t0 = 104575269 * c25;
        c15 += (t0 << 2) & LIMB_MASK;
        c16 += t0 >> 26;
        t0 = -130851391 * c25;
        c16 += (t0 << 2) & LIMB_MASK;
        c17 += t0 >> 26;
        c17 += (c25 << 2) & LIMB_MASK;
        c18 += c25 >> 26;
        //reduce from position 24
        t0 = 78101261 * c24;
        c8 += (t0 << 2) & LIMB_MASK;
        c9 += t0 >> 26;
        t0 = -126626091 * c24;
        c9 += (t0 << 2) & LIMB_MASK;
        c10 += t0 >> 26;
        t0 = -93279523 * c24;
        c10 += (t0 << 2) & LIMB_MASK;
        c11 += t0 >> 26;
        t0 = 64542500 * c24;
        c11 += (t0 << 2) & LIMB_MASK;
        c12 += t0 >> 26;
        t0 = -110109037 * c24;
        c12 += (t0 << 2) & LIMB_MASK;
        c13 += t0 >> 26;
        t0 = -77262179 * c24;
        c13 += (t0 << 2) & LIMB_MASK;
        c14 += t0 >> 26;
        t0 = 104575269 * c24;
        c14 += (t0 << 2) & LIMB_MASK;
        c15 += t0 >> 26;
        t0 = -130851391 * c24;
        c15 += (t0 << 2) & LIMB_MASK;
        c16 += t0 >> 26;
        c16 += (c24 << 2) & LIMB_MASK;
        c17 += c24 >> 26;
        //reduce from position 23
        t0 = 78101261 * c23;
        c7 += (t0 << 2) & LIMB_MASK;
        c8 += t0 >> 26;
        t0 = -126626091 * c23;
        c8 += (t0 << 2) & LIMB_MASK;
        c9 += t0 >> 26;
        t0 = -93279523 * c23;
        c9 += (t0 << 2) & LIMB_MASK;
        c10 += t0 >> 26;
        t0 = 64542500 * c23;
        c10 += (t0 << 2) & LIMB_MASK;
        c11 += t0 >> 26;
        t0 = -110109037 * c23;
        c11 += (t0 << 2) & LIMB_MASK;
        c12 += t0 >> 26;
        t0 = -77262179 * c23;
        c12 += (t0 << 2) & LIMB_MASK;
        c13 += t0 >> 26;
        t0 = 104575269 * c23;
        c13 += (t0 << 2) & LIMB_MASK;
        c14 += t0 >> 26;
        t0 = -130851391 * c23;
        c14 += (t0 << 2) & LIMB_MASK;
        c15 += t0 >> 26;
        c15 += (c23 << 2) & LIMB_MASK;
        c16 += c23 >> 26;
        //reduce from position 22
        t0 = 78101261 * c22;
        c6 += (t0 << 2) & LIMB_MASK;
        c7 += t0 >> 26;
        t0 = -126626091 * c22;
        c7 += (t0 << 2) & LIMB_MASK;
        c8 += t0 >> 26;
        t0 = -93279523 * c22;
        c8 += (t0 << 2) & LIMB_MASK;
        c9 += t0 >> 26;
        t0 = 64542500 * c22;
        c9 += (t0 << 2) & LIMB_MASK;
        c10 += t0 >> 26;
        t0 = -110109037 * c22;
        c10 += (t0 << 2) & LIMB_MASK;
        c11 += t0 >> 26;
        t0 = -77262179 * c22;
        c11 += (t0 << 2) & LIMB_MASK;
        c12 += t0 >> 26;
        t0 = 104575269 * c22;
        c12 += (t0 << 2) & LIMB_MASK;
        c13 += t0 >> 26;
        t0 = -130851391 * c22;
        c13 += (t0 << 2) & LIMB_MASK;
        c14 += t0 >> 26;
        c14 += (c22 << 2) & LIMB_MASK;
        c15 += c22 >> 26;
        //reduce from position 21
        t0 = 78101261 * c21;
        c5 += (t0 << 2) & LIMB_MASK;
        c6 += t0 >> 26;
        t0 = -126626091 * c21;
        c6 += (t0 << 2) & LIMB_MASK;
        c7 += t0 >> 26;
        t0 = -93279523 * c21;
        c7 += (t0 << 2) & LIMB_MASK;
        c8 += t0 >> 26;
        t0 = 64542500 * c21;
        c8 += (t0 << 2) & LIMB_MASK;
        c9 += t0 >> 26;
        t0 = -110109037 * c21;
        c9 += (t0 << 2) & LIMB_MASK;
        c10 += t0 >> 26;
        t0 = -77262179 * c21;
        c10 += (t0 << 2) & LIMB_MASK;
        c11 += t0 >> 26;
        t0 = 104575269 * c21;
        c11 += (t0 << 2) & LIMB_MASK;
        c12 += t0 >> 26;
        t0 = -130851391 * c21;
        c12 += (t0 << 2) & LIMB_MASK;
        c13 += t0 >> 26;
        c13 += (c21 << 2) & LIMB_MASK;
        c14 += c21 >> 26;
        //reduce from position 20
        t0 = 78101261 * c20;
        c4 += (t0 << 2) & LIMB_MASK;
        c5 += t0 >> 26;
        t0 = -126626091 * c20;
        c5 += (t0 << 2) & LIMB_MASK;
        c6 += t0 >> 26;
        t0 = -93279523 * c20;
        c6 += (t0 << 2) & LIMB_MASK;
        c7 += t0 >> 26;
        t0 = 64542500 * c20;
        c7 += (t0 << 2) & LIMB_MASK;
        c8 += t0 >> 26;
        t0 = -110109037 * c20;
        c8 += (t0 << 2) & LIMB_MASK;
        c9 += t0 >> 26;
        t0 = -77262179 * c20;
        c9 += (t0 << 2) & LIMB_MASK;
        c10 += t0 >> 26;
        t0 = 104575269 * c20;
        c10 += (t0 << 2) & LIMB_MASK;
        c11 += t0 >> 26;
        t0 = -130851391 * c20;
        c11 += (t0 << 2) & LIMB_MASK;
        c12 += t0 >> 26;
        c12 += (c20 << 2) & LIMB_MASK;
        c13 += c20 >> 26;
        //reduce from position 19
        t0 = 78101261 * c19;
        c3 += (t0 << 2) & LIMB_MASK;
        c4 += t0 >> 26;
        t0 = -126626091 * c19;
        c4 += (t0 << 2) & LIMB_MASK;
        c5 += t0 >> 26;
        t0 = -93279523 * c19;
        c5 += (t0 << 2) & LIMB_MASK;
        c6 += t0 >> 26;
        t0 = 64542500 * c19;
        c6 += (t0 << 2) & LIMB_MASK;
        c7 += t0 >> 26;
        t0 = -110109037 * c19;
        c7 += (t0 << 2) & LIMB_MASK;
        c8 += t0 >> 26;
        t0 = -77262179 * c19;
        c8 += (t0 << 2) & LIMB_MASK;
        c9 += t0 >> 26;
        t0 = 104575269 * c19;
        c9 += (t0 << 2) & LIMB_MASK;
        c10 += t0 >> 26;
        t0 = -130851391 * c19;
        c10 += (t0 << 2) & LIMB_MASK;
        c11 += t0 >> 26;
        c11 += (c19 << 2) & LIMB_MASK;
        c12 += c19 >> 26;
        //reduce from position 18
        t0 = 78101261 * c18;
        c2 += (t0 << 2) & LIMB_MASK;
        c3 += t0 >> 26;
        t0 = -126626091 * c18;
        c3 += (t0 << 2) & LIMB_MASK;
        c4 += t0 >> 26;
        t0 = -93279523 * c18;
        c4 += (t0 << 2) & LIMB_MASK;
        c5 += t0 >> 26;
        t0 = 64542500 * c18;
        c5 += (t0 << 2) & LIMB_MASK;
        c6 += t0 >> 26;
        t0 = -110109037 * c18;
        c6 += (t0 << 2) & LIMB_MASK;
        c7 += t0 >> 26;
        t0 = -77262179 * c18;
        c7 += (t0 << 2) & LIMB_MASK;
        c8 += t0 >> 26;
        t0 = 104575269 * c18;
        c8 += (t0 << 2) & LIMB_MASK;
        c9 += t0 >> 26;
        t0 = -130851391 * c18;
        c9 += (t0 << 2) & LIMB_MASK;
        c10 += t0 >> 26;
        c10 += (c18 << 2) & LIMB_MASK;
        c11 += c18 >> 26;
        //reduce from position 17
        t0 = 78101261 * c17;
        c1 += (t0 << 2) & LIMB_MASK;
        c2 += t0 >> 26;
        t0 = -126626091 * c17;
        c2 += (t0 << 2) & LIMB_MASK;
        c3 += t0 >> 26;
        t0 = -93279523 * c17;
        c3 += (t0 << 2) & LIMB_MASK;
        c4 += t0 >> 26;
        t0 = 64542500 * c17;
        c4 += (t0 << 2) & LIMB_MASK;
        c5 += t0 >> 26;
        t0 = -110109037 * c17;
        c5 += (t0 << 2) & LIMB_MASK;
        c6 += t0 >> 26;
        t0 = -77262179 * c17;
        c6 += (t0 << 2) & LIMB_MASK;
        c7 += t0 >> 26;
        t0 = 104575269 * c17;
        c7 += (t0 << 2) & LIMB_MASK;
        c8 += t0 >> 26;
        t0 = -130851391 * c17;
        c8 += (t0 << 2) & LIMB_MASK;
        c9 += t0 >> 26;
        c9 += (c17 << 2) & LIMB_MASK;
        c10 += c17 >> 26;
        //reduce from position 16
        t0 = 78101261 * c16;
        c0 += (t0 << 2) & LIMB_MASK;
        c1 += t0 >> 26;
        t0 = -126626091 * c16;
        c1 += (t0 << 2) & LIMB_MASK;
        c2 += t0 >> 26;
        t0 = -93279523 * c16;
        c2 += (t0 << 2) & LIMB_MASK;
        c3 += t0 >> 26;
        t0 = 64542500 * c16;
        c3 += (t0 << 2) & LIMB_MASK;
        c4 += t0 >> 26;
        t0 = -110109037 * c16;
        c4 += (t0 << 2) & LIMB_MASK;
        c5 += t0 >> 26;
        t0 = -77262179 * c16;
        c5 += (t0 << 2) & LIMB_MASK;
        c6 += t0 >> 26;
        t0 = 104575269 * c16;
        c6 += (t0 << 2) & LIMB_MASK;
        c7 += t0 >> 26;
        t0 = -130851391 * c16;
        c7 += (t0 << 2) & LIMB_MASK;
        c8 += t0 >> 26;
        c8 += (c16 << 2) & LIMB_MASK;
        c9 += c16 >> 26;
        c16 = 0;

        carryReduce1(r, c0, c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, c11, c12, c13, c14, c15, c16, c17, c18, c19, c20, c21, c22, c23, c24, c25, c26, c27, c28, c29, c30, c31);
    }
    void carryReduce1(long[] r, long c0, long c1, long c2, long c3, long c4, long c5, long c6, long c7, long c8, long c9, long c10, long c11, long c12, long c13, long c14, long c15, long c16, long c17, long c18, long c19, long c20, long c21, long c22, long c23, long c24, long c25, long c26, long c27, long c28, long c29, long c30, long c31) {
        long t0;

        //carry from position 0
        t0 = (c0 + CARRY_ADD) >> 28;
        c0 -= (t0 << 28);
        c1 += t0;
        //carry from position 1
        t0 = (c1 + CARRY_ADD) >> 28;
        c1 -= (t0 << 28);
        c2 += t0;
        //carry from position 2
        t0 = (c2 + CARRY_ADD) >> 28;
        c2 -= (t0 << 28);
        c3 += t0;
        //carry from position 3
        t0 = (c3 + CARRY_ADD) >> 28;
        c3 -= (t0 << 28);
        c4 += t0;
        //carry from position 4
        t0 = (c4 + CARRY_ADD) >> 28;
        c4 -= (t0 << 28);
        c5 += t0;
        //carry from position 5
        t0 = (c5 + CARRY_ADD) >> 28;
        c5 -= (t0 << 28);
        c6 += t0;
        //carry from position 6
        t0 = (c6 + CARRY_ADD) >> 28;
        c6 -= (t0 << 28);
        c7 += t0;
        //carry from position 7
        t0 = (c7 + CARRY_ADD) >> 28;
        c7 -= (t0 << 28);
        c8 += t0;
        //carry from position 8
        t0 = (c8 + CARRY_ADD) >> 28;
        c8 -= (t0 << 28);
        c9 += t0;
        //carry from position 9
        t0 = (c9 + CARRY_ADD) >> 28;
        c9 -= (t0 << 28);
        c10 += t0;
        //carry from position 10
        t0 = (c10 + CARRY_ADD) >> 28;
        c10 -= (t0 << 28);
        c11 += t0;
        //carry from position 11
        t0 = (c11 + CARRY_ADD) >> 28;
        c11 -= (t0 << 28);
        c12 += t0;
        //carry from position 12
        t0 = (c12 + CARRY_ADD) >> 28;
        c12 -= (t0 << 28);
        c13 += t0;
        //carry from position 13
        t0 = (c13 + CARRY_ADD) >> 28;
        c13 -= (t0 << 28);
        c14 += t0;
        //carry from position 14
        t0 = (c14 + CARRY_ADD) >> 28;
        c14 -= (t0 << 28);
        c15 += t0;
        //carry from position 15
        t0 = (c15 + CARRY_ADD) >> 28;
        c15 -= (t0 << 28);
        c16 += t0;

        carryReduce2(r, c0, c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, c11, c12, c13, c14, c15, c16, c17, c18, c19, c20, c21, c22, c23, c24, c25, c26, c27, c28, c29, c30, c31);
    }
    void carryReduce2(long[] r, long c0, long c1, long c2, long c3, long c4, long c5, long c6, long c7, long c8, long c9, long c10, long c11, long c12, long c13, long c14, long c15, long c16, long c17, long c18, long c19, long c20, long c21, long c22, long c23, long c24, long c25, long c26, long c27, long c28, long c29, long c30, long c31) {
        long t0;

        //reduce from position 16
        t0 = 78101261 * c16;
        c0 += (t0 << 2) & LIMB_MASK;
        c1 += t0 >> 26;
        t0 = -126626091 * c16;
        c1 += (t0 << 2) & LIMB_MASK;
        c2 += t0 >> 26;
        t0 = -93279523 * c16;
        c2 += (t0 << 2) & LIMB_MASK;
        c3 += t0 >> 26;
        t0 = 64542500 * c16;
        c3 += (t0 << 2) & LIMB_MASK;
        c4 += t0 >> 26;
        t0 = -110109037 * c16;
        c4 += (t0 << 2) & LIMB_MASK;
        c5 += t0 >> 26;
        t0 = -77262179 * c16;
        c5 += (t0 << 2) & LIMB_MASK;
        c6 += t0 >> 26;
        t0 = 104575269 * c16;
        c6 += (t0 << 2) & LIMB_MASK;
        c7 += t0 >> 26;
        t0 = -130851391 * c16;
        c7 += (t0 << 2) & LIMB_MASK;
        c8 += t0 >> 26;
        c8 += (c16 << 2) & LIMB_MASK;
        c9 += c16 >> 26;
        //carry from position 0
        t0 = (c0 + CARRY_ADD) >> 28;
        c0 -= (t0 << 28);
        c1 += t0;
        //carry from position 1
        t0 = (c1 + CARRY_ADD) >> 28;
        c1 -= (t0 << 28);
        c2 += t0;
        //carry from position 2
        t0 = (c2 + CARRY_ADD) >> 28;
        c2 -= (t0 << 28);
        c3 += t0;
        //carry from position 3
        t0 = (c3 + CARRY_ADD) >> 28;
        c3 -= (t0 << 28);
        c4 += t0;
        //carry from position 4
        t0 = (c4 + CARRY_ADD) >> 28;
        c4 -= (t0 << 28);
        c5 += t0;
        //carry from position 5
        t0 = (c5 + CARRY_ADD) >> 28;
        c5 -= (t0 << 28);
        c6 += t0;
        //carry from position 6
        t0 = (c6 + CARRY_ADD) >> 28;
        c6 -= (t0 << 28);
        c7 += t0;
        //carry from position 7
        t0 = (c7 + CARRY_ADD) >> 28;
        c7 -= (t0 << 28);
        c8 += t0;
        //carry from position 8
        t0 = (c8 + CARRY_ADD) >> 28;
        c8 -= (t0 << 28);
        c9 += t0;
        //carry from position 9
        t0 = (c9 + CARRY_ADD) >> 28;
        c9 -= (t0 << 28);
        c10 += t0;
        //carry from position 10
        t0 = (c10 + CARRY_ADD) >> 28;
        c10 -= (t0 << 28);
        c11 += t0;
        //carry from position 11
        t0 = (c11 + CARRY_ADD) >> 28;
        c11 -= (t0 << 28);
        c12 += t0;
        //carry from position 12
        t0 = (c12 + CARRY_ADD) >> 28;
        c12 -= (t0 << 28);
        c13 += t0;
        //carry from position 13
        t0 = (c13 + CARRY_ADD) >> 28;
        c13 -= (t0 << 28);
        c14 += t0;
        //carry from position 14
        t0 = (c14 + CARRY_ADD) >> 28;
        c14 -= (t0 << 28);
        c15 += t0;

        r[0] = c0;
        r[1] = c1;
        r[2] = c2;
        r[3] = c3;
        r[4] = c4;
        r[5] = c5;
        r[6] = c6;
        r[7] = c7;
        r[8] = c8;
        r[9] = c9;
        r[10] = c10;
        r[11] = c11;
        r[12] = c12;
        r[13] = c13;
        r[14] = c14;
        r[15] = c15;
    }
    private void carryReduce(long[] r, long c0, long c1, long c2, long c3, long c4, long c5, long c6, long c7, long c8, long c9, long c10, long c11, long c12, long c13, long c14, long c15) {
        long c16 = 0;
        //carry from position 0
        long t0 = (c0 + CARRY_ADD) >> 28;
        c0 -= (t0 << 28);
        c1 += t0;
        //carry from position 1
        t0 = (c1 + CARRY_ADD) >> 28;
        c1 -= (t0 << 28);
        c2 += t0;
        //carry from position 2
        t0 = (c2 + CARRY_ADD) >> 28;
        c2 -= (t0 << 28);
        c3 += t0;
        //carry from position 3
        t0 = (c3 + CARRY_ADD) >> 28;
        c3 -= (t0 << 28);
        c4 += t0;
        //carry from position 4
        t0 = (c4 + CARRY_ADD) >> 28;
        c4 -= (t0 << 28);
        c5 += t0;
        //carry from position 5
        t0 = (c5 + CARRY_ADD) >> 28;
        c5 -= (t0 << 28);
        c6 += t0;
        //carry from position 6
        t0 = (c6 + CARRY_ADD) >> 28;
        c6 -= (t0 << 28);
        c7 += t0;
        //carry from position 7
        t0 = (c7 + CARRY_ADD) >> 28;
        c7 -= (t0 << 28);
        c8 += t0;
        //carry from position 8
        t0 = (c8 + CARRY_ADD) >> 28;
        c8 -= (t0 << 28);
        c9 += t0;
        //carry from position 9
        t0 = (c9 + CARRY_ADD) >> 28;
        c9 -= (t0 << 28);
        c10 += t0;
        //carry from position 10
        t0 = (c10 + CARRY_ADD) >> 28;
        c10 -= (t0 << 28);
        c11 += t0;
        //carry from position 11
        t0 = (c11 + CARRY_ADD) >> 28;
        c11 -= (t0 << 28);
        c12 += t0;
        //carry from position 12
        t0 = (c12 + CARRY_ADD) >> 28;
        c12 -= (t0 << 28);
        c13 += t0;
        //carry from position 13
        t0 = (c13 + CARRY_ADD) >> 28;
        c13 -= (t0 << 28);
        c14 += t0;
        //carry from position 14
        t0 = (c14 + CARRY_ADD) >> 28;
        c14 -= (t0 << 28);
        c15 += t0;
        //carry from position 15
        t0 = (c15 + CARRY_ADD) >> 28;
        c15 -= (t0 << 28);
        c16 += t0;

        carryReduce0(r, c0, c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, c11, c12, c13, c14, c15, c16);
    }
    void carryReduce0(long[] r, long c0, long c1, long c2, long c3, long c4, long c5, long c6, long c7, long c8, long c9, long c10, long c11, long c12, long c13, long c14, long c15, long c16) {
        long t0;

        //reduce from position 16
        t0 = 78101261 * c16;
        c0 += (t0 << 2) & LIMB_MASK;
        c1 += t0 >> 26;
        t0 = -126626091 * c16;
        c1 += (t0 << 2) & LIMB_MASK;
        c2 += t0 >> 26;
        t0 = -93279523 * c16;
        c2 += (t0 << 2) & LIMB_MASK;
        c3 += t0 >> 26;
        t0 = 64542500 * c16;
        c3 += (t0 << 2) & LIMB_MASK;
        c4 += t0 >> 26;
        t0 = -110109037 * c16;
        c4 += (t0 << 2) & LIMB_MASK;
        c5 += t0 >> 26;
        t0 = -77262179 * c16;
        c5 += (t0 << 2) & LIMB_MASK;
        c6 += t0 >> 26;
        t0 = 104575269 * c16;
        c6 += (t0 << 2) & LIMB_MASK;
        c7 += t0 >> 26;
        t0 = -130851391 * c16;
        c7 += (t0 << 2) & LIMB_MASK;
        c8 += t0 >> 26;
        c8 += (c16 << 2) & LIMB_MASK;
        c9 += c16 >> 26;
        //carry from position 0
        t0 = (c0 + CARRY_ADD) >> 28;
        c0 -= (t0 << 28);
        c1 += t0;
        //carry from position 1
        t0 = (c1 + CARRY_ADD) >> 28;
        c1 -= (t0 << 28);
        c2 += t0;
        //carry from position 2
        t0 = (c2 + CARRY_ADD) >> 28;
        c2 -= (t0 << 28);
        c3 += t0;
        //carry from position 3
        t0 = (c3 + CARRY_ADD) >> 28;
        c3 -= (t0 << 28);
        c4 += t0;
        //carry from position 4
        t0 = (c4 + CARRY_ADD) >> 28;
        c4 -= (t0 << 28);
        c5 += t0;
        //carry from position 5
        t0 = (c5 + CARRY_ADD) >> 28;
        c5 -= (t0 << 28);
        c6 += t0;
        //carry from position 6
        t0 = (c6 + CARRY_ADD) >> 28;
        c6 -= (t0 << 28);
        c7 += t0;
        //carry from position 7
        t0 = (c7 + CARRY_ADD) >> 28;
        c7 -= (t0 << 28);
        c8 += t0;
        //carry from position 8
        t0 = (c8 + CARRY_ADD) >> 28;
        c8 -= (t0 << 28);
        c9 += t0;
        //carry from position 9
        t0 = (c9 + CARRY_ADD) >> 28;
        c9 -= (t0 << 28);
        c10 += t0;
        //carry from position 10
        t0 = (c10 + CARRY_ADD) >> 28;
        c10 -= (t0 << 28);
        c11 += t0;
        //carry from position 11
        t0 = (c11 + CARRY_ADD) >> 28;
        c11 -= (t0 << 28);
        c12 += t0;
        //carry from position 12
        t0 = (c12 + CARRY_ADD) >> 28;
        c12 -= (t0 << 28);
        c13 += t0;
        //carry from position 13
        t0 = (c13 + CARRY_ADD) >> 28;
        c13 -= (t0 << 28);
        c14 += t0;
        //carry from position 14
        t0 = (c14 + CARRY_ADD) >> 28;
        c14 -= (t0 << 28);
        c15 += t0;

        r[0] = c0;
        r[1] = c1;
        r[2] = c2;
        r[3] = c3;
        r[4] = c4;
        r[5] = c5;
        r[6] = c6;
        r[7] = c7;
        r[8] = c8;
        r[9] = c9;
        r[10] = c10;
        r[11] = c11;
        r[12] = c12;
        r[13] = c13;
        r[14] = c14;
        r[15] = c15;
    }
    @Override
    protected void mult(long[] a, long[] b, long[] r) {
        long c0 = (a[0] * b[0]);
        long c1 = (a[0] * b[1]) + (a[1] * b[0]);
        long c2 = (a[0] * b[2]) + (a[1] * b[1]) + (a[2] * b[0]);
        long c3 = (a[0] * b[3]) + (a[1] * b[2]) + (a[2] * b[1]) + (a[3] * b[0]);
        long c4 = (a[0] * b[4]) + (a[1] * b[3]) + (a[2] * b[2]) + (a[3] * b[1]) + (a[4] * b[0]);
        long c5 = (a[0] * b[5]) + (a[1] * b[4]) + (a[2] * b[3]) + (a[3] * b[2]) + (a[4] * b[1]) + (a[5] * b[0]);
        long c6 = (a[0] * b[6]) + (a[1] * b[5]) + (a[2] * b[4]) + (a[3] * b[3]) + (a[4] * b[2]) + (a[5] * b[1]) + (a[6] * b[0]);
        long c7 = (a[0] * b[7]) + (a[1] * b[6]) + (a[2] * b[5]) + (a[3] * b[4]) + (a[4] * b[3]) + (a[5] * b[2]) + (a[6] * b[1]) + (a[7] * b[0]);
        long c8 = (a[0] * b[8]) + (a[1] * b[7]) + (a[2] * b[6]) + (a[3] * b[5]) + (a[4] * b[4]) + (a[5] * b[3]) + (a[6] * b[2]) + (a[7] * b[1]) + (a[8] * b[0]);
        long c9 = (a[0] * b[9]) + (a[1] * b[8]) + (a[2] * b[7]) + (a[3] * b[6]) + (a[4] * b[5]) + (a[5] * b[4]) + (a[6] * b[3]) + (a[7] * b[2]) + (a[8] * b[1]) + (a[9] * b[0]);
        long c10 = (a[0] * b[10]) + (a[1] * b[9]) + (a[2] * b[8]) + (a[3] * b[7]) + (a[4] * b[6]) + (a[5] * b[5]) + (a[6] * b[4]) + (a[7] * b[3]) + (a[8] * b[2]) + (a[9] * b[1]) + (a[10] * b[0]);
        long c11 = (a[0] * b[11]) + (a[1] * b[10]) + (a[2] * b[9]) + (a[3] * b[8]) + (a[4] * b[7]) + (a[5] * b[6]) + (a[6] * b[5]) + (a[7] * b[4]) + (a[8] * b[3]) + (a[9] * b[2]) + (a[10] * b[1]) + (a[11] * b[0]);
        long c12 = (a[0] * b[12]) + (a[1] * b[11]) + (a[2] * b[10]) + (a[3] * b[9]) + (a[4] * b[8]) + (a[5] * b[7]) + (a[6] * b[6]) + (a[7] * b[5]) + (a[8] * b[4]) + (a[9] * b[3]) + (a[10] * b[2]) + (a[11] * b[1]) + (a[12] * b[0]);
        long c13 = (a[0] * b[13]) + (a[1] * b[12]) + (a[2] * b[11]) + (a[3] * b[10]) + (a[4] * b[9]) + (a[5] * b[8]) + (a[6] * b[7]) + (a[7] * b[6]) + (a[8] * b[5]) + (a[9] * b[4]) + (a[10] * b[3]) + (a[11] * b[2]) + (a[12] * b[1]) + (a[13] * b[0]);
        long c14 = (a[0] * b[14]) + (a[1] * b[13]) + (a[2] * b[12]) + (a[3] * b[11]) + (a[4] * b[10]) + (a[5] * b[9]) + (a[6] * b[8]) + (a[7] * b[7]) + (a[8] * b[6]) + (a[9] * b[5]) + (a[10] * b[4]) + (a[11] * b[3]) + (a[12] * b[2]) + (a[13] * b[1]) + (a[14] * b[0]);
        long c15 = (a[0] * b[15]) + (a[1] * b[14]) + (a[2] * b[13]) + (a[3] * b[12]) + (a[4] * b[11]) + (a[5] * b[10]) + (a[6] * b[9]) + (a[7] * b[8]) + (a[8] * b[7]) + (a[9] * b[6]) + (a[10] * b[5]) + (a[11] * b[4]) + (a[12] * b[3]) + (a[13] * b[2]) + (a[14] * b[1]) + (a[15] * b[0]);
        long c16 = (a[1] * b[15]) + (a[2] * b[14]) + (a[3] * b[13]) + (a[4] * b[12]) + (a[5] * b[11]) + (a[6] * b[10]) + (a[7] * b[9]) + (a[8] * b[8]) + (a[9] * b[7]) + (a[10] * b[6]) + (a[11] * b[5]) + (a[12] * b[4]) + (a[13] * b[3]) + (a[14] * b[2]) + (a[15] * b[1]);
        long c17 = (a[2] * b[15]) + (a[3] * b[14]) + (a[4] * b[13]) + (a[5] * b[12]) + (a[6] * b[11]) + (a[7] * b[10]) + (a[8] * b[9]) + (a[9] * b[8]) + (a[10] * b[7]) + (a[11] * b[6]) + (a[12] * b[5]) + (a[13] * b[4]) + (a[14] * b[3]) + (a[15] * b[2]);
        long c18 = (a[3] * b[15]) + (a[4] * b[14]) + (a[5] * b[13]) + (a[6] * b[12]) + (a[7] * b[11]) + (a[8] * b[10]) + (a[9] * b[9]) + (a[10] * b[8]) + (a[11] * b[7]) + (a[12] * b[6]) + (a[13] * b[5]) + (a[14] * b[4]) + (a[15] * b[3]);
        long c19 = (a[4] * b[15]) + (a[5] * b[14]) + (a[6] * b[13]) + (a[7] * b[12]) + (a[8] * b[11]) + (a[9] * b[10]) + (a[10] * b[9]) + (a[11] * b[8]) + (a[12] * b[7]) + (a[13] * b[6]) + (a[14] * b[5]) + (a[15] * b[4]);
        long c20 = (a[5] * b[15]) + (a[6] * b[14]) + (a[7] * b[13]) + (a[8] * b[12]) + (a[9] * b[11]) + (a[10] * b[10]) + (a[11] * b[9]) + (a[12] * b[8]) + (a[13] * b[7]) + (a[14] * b[6]) + (a[15] * b[5]);
        long c21 = (a[6] * b[15]) + (a[7] * b[14]) + (a[8] * b[13]) + (a[9] * b[12]) + (a[10] * b[11]) + (a[11] * b[10]) + (a[12] * b[9]) + (a[13] * b[8]) + (a[14] * b[7]) + (a[15] * b[6]);
        long c22 = (a[7] * b[15]) + (a[8] * b[14]) + (a[9] * b[13]) + (a[10] * b[12]) + (a[11] * b[11]) + (a[12] * b[10]) + (a[13] * b[9]) + (a[14] * b[8]) + (a[15] * b[7]);
        long c23 = (a[8] * b[15]) + (a[9] * b[14]) + (a[10] * b[13]) + (a[11] * b[12]) + (a[12] * b[11]) + (a[13] * b[10]) + (a[14] * b[9]) + (a[15] * b[8]);
        long c24 = (a[9] * b[15]) + (a[10] * b[14]) + (a[11] * b[13]) + (a[12] * b[12]) + (a[13] * b[11]) + (a[14] * b[10]) + (a[15] * b[9]);
        long c25 = (a[10] * b[15]) + (a[11] * b[14]) + (a[12] * b[13]) + (a[13] * b[12]) + (a[14] * b[11]) + (a[15] * b[10]);
        long c26 = (a[11] * b[15]) + (a[12] * b[14]) + (a[13] * b[13]) + (a[14] * b[12]) + (a[15] * b[11]);
        long c27 = (a[12] * b[15]) + (a[13] * b[14]) + (a[14] * b[13]) + (a[15] * b[12]);
        long c28 = (a[13] * b[15]) + (a[14] * b[14]) + (a[15] * b[13]);
        long c29 = (a[14] * b[15]) + (a[15] * b[14]);
        long c30 = (a[15] * b[15]);

        carryReduce(r, c0, c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, c11, c12, c13, c14, c15, c16, c17, c18, c19, c20, c21, c22, c23, c24, c25, c26, c27, c28, c29, c30);
    }
    @Override
    protected void reduce(long[] a) {
        carryReduce(a, a[0], a[1], a[2], a[3], a[4], a[5], a[6], a[7], a[8], a[9], a[10], a[11], a[12], a[13], a[14], a[15]);
    }
    @Override
    protected void square(long[] a, long[] r) {
        long c0 = (a[0] * a[0]);
        long c1 = 2 * ((a[0] * a[1]));
        long c2 = 2 * ((a[0] * a[2])) + (a[1] * a[1]);
        long c3 = 2 * ((a[0] * a[3]) + (a[1] * a[2]));
        long c4 = 2 * ((a[0] * a[4]) + (a[1] * a[3])) + (a[2] * a[2]);
        long c5 = 2 * ((a[0] * a[5]) + (a[1] * a[4]) + (a[2] * a[3]));
        long c6 = 2 * ((a[0] * a[6]) + (a[1] * a[5]) + (a[2] * a[4])) + (a[3] * a[3]);
        long c7 = 2 * ((a[0] * a[7]) + (a[1] * a[6]) + (a[2] * a[5]) + (a[3] * a[4]));
        long c8 = 2 * ((a[0] * a[8]) + (a[1] * a[7]) + (a[2] * a[6]) + (a[3] * a[5])) + (a[4] * a[4]);
        long c9 = 2 * ((a[0] * a[9]) + (a[1] * a[8]) + (a[2] * a[7]) + (a[3] * a[6]) + (a[4] * a[5]));
        long c10 = 2 * ((a[0] * a[10]) + (a[1] * a[9]) + (a[2] * a[8]) + (a[3] * a[7]) + (a[4] * a[6])) + (a[5] * a[5]);
        long c11 = 2 * ((a[0] * a[11]) + (a[1] * a[10]) + (a[2] * a[9]) + (a[3] * a[8]) + (a[4] * a[7]) + (a[5] * a[6]));
        long c12 = 2 * ((a[0] * a[12]) + (a[1] * a[11]) + (a[2] * a[10]) + (a[3] * a[9]) + (a[4] * a[8]) + (a[5] * a[7])) + (a[6] * a[6]);
        long c13 = 2 * ((a[0] * a[13]) + (a[1] * a[12]) + (a[2] * a[11]) + (a[3] * a[10]) + (a[4] * a[9]) + (a[5] * a[8]) + (a[6] * a[7]));
        long c14 = 2 * ((a[0] * a[14]) + (a[1] * a[13]) + (a[2] * a[12]) + (a[3] * a[11]) + (a[4] * a[10]) + (a[5] * a[9]) + (a[6] * a[8])) + (a[7] * a[7]);
        long c15 = 2 * ((a[0] * a[15]) + (a[1] * a[14]) + (a[2] * a[13]) + (a[3] * a[12]) + (a[4] * a[11]) + (a[5] * a[10]) + (a[6] * a[9]) + (a[7] * a[8]));
        long c16 = 2 * ((a[1] * a[15]) + (a[2] * a[14]) + (a[3] * a[13]) + (a[4] * a[12]) + (a[5] * a[11]) + (a[6] * a[10]) + (a[7] * a[9])) + (a[8] * a[8]);
        long c17 = 2 * ((a[2] * a[15]) + (a[3] * a[14]) + (a[4] * a[13]) + (a[5] * a[12]) + (a[6] * a[11]) + (a[7] * a[10]) + (a[8] * a[9]));
        long c18 = 2 * ((a[3] * a[15]) + (a[4] * a[14]) + (a[5] * a[13]) + (a[6] * a[12]) + (a[7] * a[11]) + (a[8] * a[10])) + (a[9] * a[9]);
        long c19 = 2 * ((a[4] * a[15]) + (a[5] * a[14]) + (a[6] * a[13]) + (a[7] * a[12]) + (a[8] * a[11]) + (a[9] * a[10]));
        long c20 = 2 * ((a[5] * a[15]) + (a[6] * a[14]) + (a[7] * a[13]) + (a[8] * a[12]) + (a[9] * a[11])) + (a[10] * a[10]);
        long c21 = 2 * ((a[6] * a[15]) + (a[7] * a[14]) + (a[8] * a[13]) + (a[9] * a[12]) + (a[10] * a[11]));
        long c22 = 2 * ((a[7] * a[15]) + (a[8] * a[14]) + (a[9] * a[13]) + (a[10] * a[12])) + (a[11] * a[11]);
        long c23 = 2 * ((a[8] * a[15]) + (a[9] * a[14]) + (a[10] * a[13]) + (a[11] * a[12]));
        long c24 = 2 * ((a[9] * a[15]) + (a[10] * a[14]) + (a[11] * a[13])) + (a[12] * a[12]);
        long c25 = 2 * ((a[10] * a[15]) + (a[11] * a[14]) + (a[12] * a[13]));
        long c26 = 2 * ((a[11] * a[15]) + (a[12] * a[14])) + (a[13] * a[13]);
        long c27 = 2 * ((a[12] * a[15]) + (a[13] * a[14]));
        long c28 = 2 * ((a[13] * a[15])) + (a[14] * a[14]);
        long c29 = 2 * ((a[14] * a[15]));
        long c30 = (a[15] * a[15]);

        carryReduce(r, c0, c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, c11, c12, c13, c14, c15, c16, c17, c18, c19, c20, c21, c22, c23, c24, c25, c26, c27, c28, c29, c30);
    }
}

