/*
 * Copyright (c) 2012, 2022, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class CurrencyNames_bn extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final Object[][] data = new Object[][] {
            { "AED", "AED" },
            { "AFN", "AFN" },
            { "ALL", "ALL" },
            { "AMD", "AMD" },
            { "ANG", "ANG" },
            { "AOA", "AOA" },
            { "ARS", "ARS" },
            { "AWG", "AWG" },
            { "AZN", "AZN" },
            { "BAM", "BAM" },
            { "BBD", "BBD" },
            { "BDT", "\u09f3" },
            { "BGN", "BGN" },
            { "BHD", "BHD" },
            { "BIF", "BIF" },
            { "BMD", "BMD" },
            { "BND", "BND" },
            { "BOB", "BOB" },
            { "BSD", "BSD" },
            { "BTN", "BTN" },
            { "BWP", "BWP" },
            { "BYN", "BYN" },
            { "BYR", "BYR" },
            { "BZD", "BZD" },
            { "CDF", "CDF" },
            { "CHF", "CHF" },
            { "CLP", "CLP" },
            { "CNH", "CNH" },
            { "COP", "COP" },
            { "CRC", "CRC" },
            { "CUC", "CUC" },
            { "CUP", "CUP" },
            { "CVE", "CVE" },
            { "CZK", "CZK" },
            { "DJF", "DJF" },
            { "DKK", "DKK" },
            { "DOP", "DOP" },
            { "DZD", "DZD" },
            { "EGP", "EGP" },
            { "ERN", "ERN" },
            { "ETB", "ETB" },
            { "FJD", "FJD" },
            { "FKP", "FKP" },
            { "GEL", "GEL" },
            { "GHS", "GHS" },
            { "GIP", "GIP" },
            { "GMD", "GMD" },
            { "GNF", "GNF" },
            { "GTQ", "GTQ" },
            { "GYD", "GYD" },
            { "HNL", "HNL" },
            { "HRK", "HRK" },
            { "HTG", "HTG" },
            { "HUF", "HUF" },
            { "IDR", "IDR" },
            { "IQD", "IQD" },
            { "IRR", "IRR" },
            { "ISK", "ISK" },
            { "JMD", "JMD" },
            { "JOD", "JOD" },
            { "KES", "KES" },
            { "KGS", "KGS" },
            { "KHR", "KHR" },
            { "KMF", "KMF" },
            { "KPW", "KPW" },
            { "KWD", "KWD" },
            { "KYD", "KYD" },
            { "KZT", "KZT" },
            { "LAK", "LAK" },
            { "LBP", "LBP" },
            { "LKR", "LKR" },
            { "LRD", "LRD" },
            { "LTL", "LTL" },
            { "LVL", "LVL" },
            { "LYD", "LYD" },
            { "MAD", "MAD" },
            { "MDL", "MDL" },
            { "MGA", "MGA" },
            { "MKD", "MKD" },
            { "MMK", "MMK" },
            { "MNT", "MNT" },
            { "MOP", "MOP" },
            { "MRO", "MRO" },
            { "MRU", "MRU" },
            { "MUR", "MUR" },
            { "MVR", "MVR" },
            { "MWK", "MWK" },
            { "MYR", "MYR" },
            { "MZN", "MZN" },
            { "NAD", "NAD" },
            { "NGN", "NGN" },
            { "NIO", "NIO" },
            { "NOK", "NOK" },
            { "NPR", "NPR" },
            { "OMR", "OMR" },
            { "PAB", "PAB" },
            { "PEN", "PEN" },
            { "PGK", "PGK" },
            { "PHP", "PHP" },
            { "PKR", "PKR" },
            { "PLN", "PLN" },
            { "PYG", "PYG" },
            { "QAR", "QAR" },
            { "RON", "RON" },
            { "RSD", "RSD" },
            { "RUB", "RUB" },
            { "RWF", "RWF" },
            { "SAR", "SAR" },
            { "SBD", "SBD" },
            { "SCR", "SCR" },
            { "SDG", "SDG" },
            { "SEK", "SEK" },
            { "SGD", "SGD" },
            { "SHP", "SHP" },
            { "SLL", "SLL" },
            { "SOS", "SOS" },
            { "SRD", "SRD" },
            { "SSP", "SSP" },
            { "STD", "STD" },
            { "STN", "STN" },
            { "SYP", "SYP" },
            { "SZL", "SZL" },
            { "THB", "\u0e3f" },
            { "TJS", "TJS" },
            { "TMT", "TMT" },
            { "TND", "TND" },
            { "TOP", "TOP" },
            { "TRY", "TRY" },
            { "TTD", "TTD" },
            { "TZS", "TZS" },
            { "UAH", "UAH" },
            { "UGX", "UGX" },
            { "UYU", "UYU" },
            { "UZS", "UZS" },
            { "VEF", "VEF" },
            { "VES", "VES" },
            { "VUV", "VUV" },
            { "WST", "WST" },
            { "YER", "YER" },
            { "ZAR", "ZAR" },
            { "ZMW", "ZMW" },
            { "adp", "\u098f\u09cd\u09af\u09be\u09a8\u09cd\u09a1\u09cb\u09b0\u09be\u09a8 \u09aa\u09c7\u09b8\u09c7\u09a4\u09be" },
            { "aed", "\u09b8\u0982\u09af\u09c1\u0995\u09cd\u09a4 \u0986\u09b0\u09ac \u0986\u09ae\u09bf\u09b0\u09be\u09a4 \u09a6\u09bf\u09b0\u09b9\u09be\u09ae" },
            { "afa", "\u0986\u09ab\u0997\u09be\u09a8\u09bf (\u09e7\u09ef\u09e8\u09ed\u2013\u09e8\u09e6\u09e6\u09e8)" },
            { "afn", "\u0986\u09ab\u0997\u09be\u09a8 \u0986\u09ab\u0997\u09be\u09a8\u09bf" },
            { "all", "\u0986\u09b2\u09ac\u09c7\u09a8\u09bf\u09af\u09bc\u09be\u09a8 \u09b2\u09c7\u0995" },
            { "amd", "\u0986\u09b0\u09ae\u09c7\u09a8\u09bf\u09af\u09bc\u09be\u09a8 \u09a6\u09cd\u09b0\u09be\u09ae" },
            { "ang", "\u09a8\u09c7\u09a6\u09be\u09b0\u09b2\u09cd\u09af\u09be\u09a8\u09cd\u09a1 \u098f\u09cd\u09af\u09be\u09a8\u09cd\u099f\u09bf\u09b2\u09bf\u09af\u09bc\u09be\u09a8 \u0997\u09c1\u09b2\u09cd\u09a1\u09c7\u09b0" },
            { "aoa", "\u098f\u09cd\u09af\u09be\u0999\u09cd\u0997\u09cb\u09b2\u09be\u09a8 \u0995\u0993\u09af\u09bc\u09be\u09a8\u099c\u09be" },
            { "aok", "\u098f\u09cd\u09af\u09be\u0999\u09cd\u0997\u09cb\u09b2\u09be\u09a8 \u0995\u0993\u09af\u09bc\u09be\u09a8\u099c\u09be (\u09e7\u09ef\u09ed\u09ed\u2013\u09e7\u09ef\u09ef\u09e6)" },
            { "aon", "\u098f\u09cd\u09af\u09be\u0999\u09cd\u0997\u09cb\u09b2\u09be\u09a8 \u09a8\u09a4\u09c1\u09a8 \u0995\u0993\u09af\u09bc\u09be\u09a8\u099c\u09be (\u09e7\u09ef\u09ef\u09eb\u2013\u09e8\u09e6\u09e6\u09e6)" },
            { "aor", "\u098f\u09cd\u09af\u09be\u0999\u09cd\u0997\u09cb\u09b2\u09be\u09a8 \u0995\u0993\u09af\u09bc\u09be\u09a8\u099c\u09be (\u09e7\u09ef\u09ef\u09eb\u2013\u09e7\u09ef\u09ef\u09ef)" },
            { "ara", "\u0986\u09b0\u09cd\u099c\u09c7\u09a8\u09cd\u099f\u09bf\u09a8\u09be \u0985\u09b8\u09cd\u099f\u09cd\u09b0\u09be\u09b2" },
            { "arp", "\u0986\u09b0\u09cd\u099c\u09c7\u09a8\u09cd\u099f\u09bf\u09a8\u09be \u09aa\u09c7\u09b8\u09cb (\u09e7\u09ef\u09ee\u09e9\u2013\u09e7\u09ef\u09ee\u09eb)" },
            { "ars", "\u0986\u09b0\u09cd\u099c\u09c7\u09a8\u09cd\u099f\u09bf\u09a8\u09be \u09aa\u09c7\u09b8\u09cb" },
            { "ats", "\u0985\u09b8\u09cd\u099f\u09cd\u09b0\u09bf\u09af\u09bc\u09be\u09a8 \u09b6\u09bf\u09b2\u09bf\u0982" },
            { "aud", "\u0985\u09b8\u09cd\u099f\u09cd\u09b0\u09c7\u09b2\u09bf\u09af\u09bc\u09be\u09a8 \u09a1\u09b2\u09be\u09b0" },
            { "awg", "\u0986\u09b0\u09c1\u09ac\u09be \u09ab\u09cd\u09b2\u09cb\u09b0\u09bf\u09a8" },
            { "azm", "\u0986\u099c\u09be\u09b0\u09ac\u09be\u0987\u099c\u09be\u09a8 \u09ae\u09be\u09a8\u09be\u09a4 (\u09e7\u09ef\u09ef\u09e9\u2013\u09e8\u09e6\u09e6\u09ec)" },
            { "azn", "\u0986\u099c\u09be\u09b0\u09ac\u09be\u0987\u099c\u09be\u09a8 \u09ae\u09be\u09a8\u09be\u09a4" },
            { "bad", "\u09ac\u09b8\u09a8\u09bf\u09af\u09bc\u09be \u098f\u09ac\u0982 \u09b9\u09be\u09b0\u09cd\u099c\u09c7\u0997\u09cb\u09ad\u09bf\u09a8\u09be \u09a6\u09bf\u09a8\u09be\u09b0" },
            { "bam", "\u09ac\u09b8\u09a8\u09bf\u09af\u09bc\u09be \u098f\u09ac\u0982 \u09b9\u09be\u09b0\u09cd\u099c\u09c7\u0997\u09cb\u09ad\u09bf\u09a8\u09be \u09ac\u09bf\u09a8\u09bf\u09ae\u09c7\u09af\u09bc \u09ae\u09be\u09b0\u09cd\u0995" },
            { "bbd", "\u09ac\u09be\u09b0\u09cd\u09ac\u09c7\u09a1\u09cb\u099c \u09a1\u09b2\u09be\u09b0" },
            { "bdt", "\u09ac\u09be\u0982\u09b2\u09be\u09a6\u09c7\u09b6\u09c0 \u099f\u09be\u0995\u09be" },
            { "bec", "\u09ac\u09c7\u09b2\u099c\u09bf\u09af\u09bc\u09be\u09a8 \u09ab\u09cd\u09b0\u09be\u0999\u09cd\u0995 (\u09b0\u09c2\u09aa\u09be\u09a8\u09cd\u09a4\u09b0\u09af\u09cb\u0997\u09cd\u09af)" },
            { "bef", "\u09ac\u09c7\u09b2\u099c\u09bf\u09af\u09bc\u09be\u09a8 \u09ab\u09cd\u09b0\u09be\u0999\u09cd\u0995" },
            { "bel", "\u09ac\u09c7\u09b2\u099c\u09bf\u09af\u09bc\u09be\u09a8 \u09ab\u09cd\u09b0\u09be\u0999\u09cd\u0995 (\u0986\u09b0\u09cd\u09a5\u09bf\u0995)" },
            { "bgl", "\u09ac\u09c1\u09b2\u0997\u09c7\u09b0\u09c0\u09af\u09bc \u09b9\u09be\u09b0\u09cd\u09a1 \u09b2\u09c7\u09ad" },
            { "bgn", "\u09ac\u09c1\u09b2\u0997\u09c7\u09b0\u09c0\u09af\u09bc \u09b2\u09c7\u09ad" },
            { "bhd", "\u09ac\u09be\u09b9\u09b0\u09be\u0987\u09a8\u09bf \u09a6\u09bf\u09a8\u09be\u09b0" },
            { "bif", "\u09ac\u09c1\u09b0\u09c1\u09a8\u09cd\u09a1\u09bf \u09ab\u09cd\u09b0\u09be\u0999\u09cd\u0995" },
            { "bmd", "\u09ac\u09be\u09b0\u09ae\u09bf\u0989\u09a1\u09be\u09a8 \u09a1\u09b2\u09be\u09b0" },
            { "bnd", "\u09ac\u09cd\u09b0\u09c1\u09a8\u09c7\u0987 \u09a1\u09b2\u09be\u09b0" },
            { "bob", "\u09ac\u09b2\u09bf\u09ad\u09bf\u09af\u09bc\u09be\u09a8 \u09ac\u09b2\u09bf\u09ad\u09bf\u09af\u09bc\u09be\u09a8\u09cb" },
            { "bop", "\u09ac\u09b2\u09bf\u09ad\u09bf\u09af\u09bc\u09be\u09a8 \u09aa\u09c7\u09b8\u09cb" },
            { "bov", "\u09ac\u09b2\u09bf\u09ad\u09bf\u09af\u09bc\u09be\u09a8 \u09ae\u09ad\u09a1\u09cb\u09b2" },
            { "brb", "\u09ac\u09cd\u09b0\u09be\u099c\u09bf\u09b2\u09bf\u09af\u09bc\u09be\u09a8 \u0995\u09cd\u09b0\u09c1\u099c\u09c7\u09af\u09bc\u09b0\u09cb\u09a8\u09cb\u09ad\u09cb (\u09e7\u09ef\u09ec\u09ed\u2013\u09e7\u09ef\u09ee\u09ec)" },
            { "brc", "\u09ac\u09cd\u09b0\u09be\u099c\u09bf\u09b2\u09bf\u09af\u09bc\u09be\u09a8 \u0995\u09cd\u09b0\u09c1\u099c\u09c7\u0987\u09a1\u09be\u0989" },
            { "bre", "\u09ac\u09cd\u09b0\u09be\u099c\u09bf\u09b2\u09bf\u09af\u09bc\u09be\u09a8 \u0995\u09cd\u09b0\u09c1\u099c\u09c7\u09af\u09bc\u09b0\u09cb (\u09e7\u09ef\u09ef\u09e6\u2013\u09e7\u09ef\u09ef\u09e9)" },
            { "brl", "\u09ac\u09cd\u09b0\u09be\u099c\u09bf\u09b2\u09bf\u09af\u09bc\u09be\u09a8 \u09b0\u09bf\u09af\u09bc\u09c7\u09b2" },
            { "brn", "\u09ac\u09cd\u09b0\u09be\u099c\u09bf\u09b2\u09bf\u09af\u09bc\u09be\u09a8 \u0995\u09cd\u09b0\u09c1\u099c\u09c7\u0987\u09a1\u09cb \u09a8\u09cb\u09ad\u09cb" },
            { "brr", "\u09ac\u09cd\u09b0\u09be\u099c\u09bf\u09b2\u09bf\u09af\u09bc\u09be\u09a8 \u0995\u09cd\u09b0\u09c1\u099c\u09c7\u09af\u09bc\u09b0\u09cb" },
            { "bsd", "\u09ac\u09be\u09b9\u09be\u09ae\u09bf\u09af\u09bc\u09be\u09a8 \u09a1\u09b2\u09be\u09b0" },
            { "btn", "\u09ad\u09c1\u099f\u09be\u09a8\u09bf \u098f\u09a8\u0997\u09c1\u09b2\u09cd\u099f\u09cd\u09b0\u09c1\u09ae" },
            { "buk", "\u09ac\u09b0\u09cd\u09ae\u09bf \u0995\u09bf\u09af\u09bc\u09be\u09ce" },
            { "bwp", "\u09ac\u09a4\u09b8\u09cb\u09af\u09bc\u09be\u09a8\u09be \u09aa\u09c1\u09b2\u09be" },
            { "byb", "\u09ac\u09c7\u09b2\u09be\u09b0\u09c1\u09b6\u09bf\u09af\u09bc\u09be\u09a8 \u09a8\u09bf\u0989 \u09b0\u09c1\u09ac\u09c7\u09b2 (\u09e7\u09ef\u09ef\u09ea\u2013\u09e7\u09ef\u09ef\u09ef)" },
            { "byn", "\u09ac\u09c7\u09b2\u09be\u09b0\u09c1\u09b6\u09bf\u09af\u09bc\u09be\u09a8 \u09b0\u09c1\u09ac\u09c7\u09b2" },
            { "byr", "\u09ac\u09c7\u09b2\u09be\u09b0\u09c1\u09b6\u09bf\u09af\u09bc\u09be\u09a8 \u09b0\u09c1\u09ac\u09c7\u09b2 (2000\u20132016)" },
            { "bzd", "\u09ac\u09c7\u09b2\u09bf\u099c \u09a1\u09b2\u09be\u09b0" },
            { "cad", "\u0995\u09be\u09a8\u09be\u09a1\u09bf\u09af\u09bc\u09be\u09a8 \u09a1\u09b2\u09be\u09b0" },
            { "cdf", "\u0995\u0999\u09cd\u0997\u09cb\u09b2\u09bf\u09b8 \u09ab\u09cd\u09b0\u09cd\u09af\u09be\u0999\u09cd\u0995" },
            { "che", "\u09b8\u09c1\u0987\u099c\u09be\u09b0\u09b2\u09cd\u09af\u09be\u09a8\u09cd\u09a1 \u0987\u0989\u09b0\u09cb" },
            { "chf", "\u09b8\u09c1\u0987\u09b8 \u09ab\u09cd\u09b0\u09be\u0981" },
            { "chw", "\u09b8\u09c1\u0987\u099c\u09be\u09b0\u09b2\u09cd\u09af\u09be\u09a8\u09cd\u09a1 \u09ab\u09cd\u09b0\u09be\u0999\u09cd\u0995" },
            { "clf", "\u099a\u09bf\u09b2\u09bf\u09af\u09bc\u09be\u09a8 \u0989\u09a8\u09bf\u09a6\u09be\u09a6\u09c7\u09b8 \u09a6\u09bf \u09ab\u09cb\u09ae\u09c7\u09a8\u09cd\u09a4\u09cb" },
            { "clp", "\u099a\u09bf\u09b2\u09bf \u09aa\u09c7\u09b8\u09cb" },
            { "cnh", "\u099a\u09be\u0987\u09a8\u09bf\u099c \u0987\u0989\u09af\u09bc\u09be\u09a8 (\u0985\u09ab\u09b6\u09cb\u09b0)" },
            { "cny", "\u099a\u09c0\u09a8\u09be \u09af\u09bc\u09c1\u09af\u09bc\u09be\u09a8" },
            { "cop", "\u0995\u09b2\u09cb\u09ae\u09cd\u09ac\u09bf\u09af\u09bc\u09be\u09a8 \u09aa\u09c7\u09b8\u09cb" },
            { "cou", "\u0989\u09a8\u09bf\u09a6\u09be\u09a6 \u09a6\u09bf \u09ad\u09cd\u09af\u09be\u09b2\u09cb\u09b0 \u09b0\u09bf\u09af\u09bc\u09c7\u09b2" },
            { "crc", "\u0995\u09cb\u09b8\u09cd\u099f\u09be \u09b0\u09bf\u0995\u09be \u0995\u09cb\u09b2\u09cb\u09a8" },
            { "csd", "\u09aa\u09cd\u09b0\u09be\u099a\u09c0\u09a8 \u09b8\u09be\u09b0\u09ac\u09bf\u09af\u09bc\u09be\u09a8 \u09a6\u09bf\u09a8\u09be\u09b0" },
            { "csk", "\u099a\u09c7\u0995\u09cb\u09b8\u09cd\u09b2\u09cb\u09ad\u09be\u0995 \u09b9\u09be\u09b0\u09cd\u09a1 \u0995\u09cb\u09b0\u09c1\u09a8\u09be" },
            { "cuc", "\u0995\u09bf\u0989\u09ac\u09be\u09a8 \u09b0\u09c2\u09aa\u09be\u09a8\u09cd\u09a4\u09b0\u09af\u09cb\u0997\u09cd\u09af \u09aa\u09c7\u09b8\u09cb" },
            { "cup", "\u0995\u09bf\u0989\u09ac\u09be\u09a8 \u09aa\u09c7\u09b8\u09cb" },
            { "cve", "\u0995\u09c7\u09aa \u09ad\u09be\u09b0\u09cd\u09a6\u09c7 \u098f\u09b8\u0995\u09c1\u09a1\u09cb" },
            { "cyp", "\u09b8\u09be\u0987\u09aa\u09cd\u09b0\u09be\u09b8 \u09aa\u09be\u0989\u09a8\u09cd\u09a1" },
            { "czk", "\u099a\u09c7\u0995 \u09aa\u09cd\u09b0\u099c\u09be\u09a4\u09a8\u09cd\u09a4\u09cd\u09b0 \u0995\u09cb\u09b0\u09c1\u09a8\u09be" },
            { "ddm", "\u09aa\u09c2\u09b0\u09cd\u09ac \u099c\u09be\u09b0\u09cd\u09ae\u09be\u09a8 \u09ae\u09be\u09b0\u09cd\u0995" },
            { "dem", "\u09a1\u09af\u09bc\u099a\u09cd \u09ae\u09be\u09b0\u09cd\u0995" },
            { "djf", "\u099c\u09bf\u09ac\u09c1\u09a4\u09bf \u09ab\u09cd\u09b0\u09be\u0999\u09cd\u0995" },
            { "dkk", "\u09a1\u09cd\u09af\u09be\u09a8\u09bf\u09b6 \u0995\u09cd\u09b0\u09cb\u09a8" },
            { "dop", "\u09a1\u09cb\u09ae\u09bf\u09a8\u09bf\u0995\u09be\u09a8 \u09aa\u09c7\u09b8\u09cb" },
            { "dzd", "\u0986\u09b2\u099c\u09c7\u09b0\u09c0\u09af\u09bc \u09a6\u09bf\u09a8\u09be\u09b0" },
            { "ecs", "\u0987\u0995\u09c1\u09af\u09bc\u09be\u09a1\u09cb\u09b0 \u09b8\u09c1\u0995\u09cd\u09b0\u09c7" },
            { "ecv", "\u0987\u0995\u09c1\u09af\u09bc\u09be\u09a1\u09cb\u09b0 \u0989\u09a8\u09bf\u09a6\u09be\u09a6\u09c7\u09b8 \u09a6\u09bf \u09ad\u09c7\u09b2\u09b0 \u0995\u09a8\u09b8\u09a4\u09be\u09a8\u09cd\u09a4\u09c7 (\u0987\u0989\u09ad\u09bf\u09b8\u09bf)" },
            { "eek", "\u098f\u09b8\u09cd\u09a4\u09cb\u09a8\u09bf\u09af\u09bc\u09be \u0995\u09cd\u09b0\u09c1\u09a8\u09bf" },
            { "egp", "\u09ae\u09bf\u09b6\u09b0\u09c0\u09af\u09bc \u09aa\u09be\u0989\u09a8\u09cd\u09a1" },
            { "ern", "\u098f\u09b0\u09bf\u099f\u09cd\u09b0\u09bf\u09af\u09bc\u09c7\u09a8 \u09a8\u09be\u0995\u09ab\u09be" },
            { "esa", "\u09b8\u09cd\u09aa\u09cd\u09af\u09be\u09a8\u09bf\u09b6 \u09aa\u09c7\u09b8\u09c7\u09a4\u09be (\u098f\u0995\u0987 \u09b9\u09bf\u09b8\u09be\u09ac)" },
            { "esb", "\u09b8\u09cd\u09aa\u09cd\u09af\u09be\u09a8\u09bf\u09b6 \u09aa\u09c7\u09b8\u09c7\u09a4\u09be (\u09b0\u09c2\u09aa\u09be\u09a8\u09cd\u09a4\u09b0\u09af\u09cb\u0997\u09cd\u09af \u09b9\u09bf\u09b8\u09be\u09ac)" },
            { "esp", "\u09b8\u09cd\u09aa\u09cd\u09af\u09be\u09a8\u09bf\u09b6 \u09aa\u09c7\u09b8\u09c7\u09a4\u09be" },
            { "etb", "\u0987\u09a5\u09bf\u0993\u09aa\u09bf\u09af\u09bc\u09be\u09a8 \u09ac\u09bf\u09b0" },
            { "eur", "\u0987\u0989\u09b0\u09cb" },
            { "fim", "\u09ab\u09bf\u09a8\u09bf\u09b8 \u09ae\u09be\u09b0\u09cd\u0995\u09be" },
            { "fjd", "\u09ab\u09bf\u099c\u09bf \u09a1\u09b2\u09be\u09b0" },
            { "fkp", "\u09ab\u0995\u09b2\u09cd\u09af\u09be\u09a8\u09cd\u09a1 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c \u09aa\u09be\u0989\u09a8\u09cd\u09a1" },
            { "frf", "\u09ab\u09b0\u09be\u09b8\u09bf \u09ab\u09cd\u09b0\u09be\u0999\u09cd\u0995" },
            { "gbp", "\u09ac\u09cd\u09b0\u09bf\u099f\u09bf\u09b6 \u09aa\u09be\u0989\u09a8\u09cd\u09a1" },
            { "gek", "\u099c\u09b0\u09cd\u099c\u09bf\u09af\u09bc\u09be\u09a8 \u0995\u09c1\u09aa\u09a8 \u09b2\u09be\u09b0\u09bf\u099f" },
            { "gel", "\u099c\u09b0\u09cd\u099c\u09bf\u09af\u09bc\u09be\u09a8 \u09b2\u09be\u09b0\u09bf" },
            { "ghc", "\u0998\u09be\u09a8\u09be \u09b8\u09c7\u09a1\u09bf (\u09e7\u09ef\u09ed\u09ef\u2013\u09e8\u09e6\u09e6\u09ed)" },
            { "ghs", "\u0998\u09be\u09a8\u09be \u09b8\u09c7\u09a1\u09bf" },
            { "gip", "\u099c\u09bf\u09ac\u09cd\u09b0\u09be\u09b2\u09cd\u099f\u09be\u09b0 \u09aa\u09be\u0989\u09a8\u09cd\u09a1" },
            { "gmd", "\u0997\u09be\u09ae\u09cd\u09ac\u09bf\u09af\u09bc\u09be \u09a1\u09be\u09b2\u09be\u09b8\u09bf" },
            { "gnf", "\u0997\u09bf\u09a8\u09bf \u09ab\u09cd\u09b0\u09be\u0999\u09cd\u0995" },
            { "gns", "\u0997\u09bf\u09a8\u09bf \u09b8\u09be\u0987\u09b2\u09bf" },
            { "gqe", "\u0987\u0995\u09c1\u09af\u09bc\u09c7\u099f\u09cb\u09b0\u09bf\u09af\u09bc\u09be\u09b2 \u0997\u09bf\u09a8\u09bf \u0987\u0995\u09c1\u09af\u09bc\u09bf\u09b2\u09bf" },
            { "grd", "\u0997\u09cd\u09b0\u09c0\u0995 \u09a6\u09cd\u09b0\u09be\u099a\u09ae\u09be" },
            { "gtq", "\u0997\u09c1\u09af\u09bc\u09be\u09a4\u09c7\u09ae\u09be\u09b2\u09be \u0995\u09c1\u09af\u09bc\u09c7\u09ce\u099c\u09be\u09b2" },
            { "gwe", "\u09aa\u09b0\u09cd\u09a4\u09c1\u0997\u09bf\u099c \u0997\u09bf\u09a8\u09bf \u098f\u09b8\u0995\u09c1\u09a1\u09cb" },
            { "gwp", "\u0997\u09bf\u09a8\u09bf \u09ac\u09bf\u09b8\u09be\u0989 \u09aa\u09c7\u09b8\u09cb" },
            { "gyd", "\u0997\u09be\u09af\u09bc\u09be\u09a8\u09bf\u099c \u09a1\u09b2\u09be\u09b0" },
            { "hkd", "\u09b9\u0982\u0995\u0982 \u09a1\u09b2\u09be\u09b0" },
            { "hnl", "\u09b9\u09a8\u09cd\u09a1\u09c1\u09b0\u09be\u09b8 \u09b2\u09c7\u09ae\u09cd\u09aa\u09bf\u09b0\u09be" },
            { "hrd", "\u0995\u09cd\u09b0\u09cb\u09af\u09bc\u09c7\u09b6\u09bf\u09af\u09bc\u09be\u09a8 \u09a6\u09bf\u09a8\u09be\u09b0" },
            { "hrk", "\u0995\u09cd\u09b0\u09cb\u09af\u09bc\u09c7\u09b6\u09bf\u09af\u09bc\u09be\u09a8 \u0995\u09c1\u09a8\u09be" },
            { "htg", "\u09b9\u09be\u0987\u09a4\u09bf \u0997\u09cc\u09b0\u09cd\u09a6\u09c7" },
            { "huf", "\u09b9\u09be\u0999\u09cd\u0997\u09c7\u09b0\u09bf\u09af\u09bc\u09be\u09a8 \u09ab\u09cb\u09b0\u09bf\u09a8\u09cd\u099f" },
            { "idr", "\u0987\u09a8\u09cd\u09a6\u09cb\u09a8\u09c7\u09b6\u09bf\u09af\u09bc\u09be\u09a8 \u09b0\u09c1\u09aa\u09bf\u09af\u09bc\u09be\u09b9" },
            { "iep", "\u0987\u09b0\u09bf\u09b6 \u09aa\u09be\u0989\u09a8\u09cd\u09a1" },
            { "ilp", "\u0987\u09b8\u09cd\u09b0\u09be\u0987\u09b2\u09bf \u09aa\u09be\u0989\u09a8\u09cd\u09a1" },
            { "ils", "\u0987\u09b8\u09b0\u09be\u09af\u09bc\u09c7\u09b2\u09bf \u09a8\u09a4\u09c1\u09a8 \u09b6\u09c7\u0995\u09c7\u09b2" },
            { "inr", "\u09ad\u09be\u09b0\u09a4\u09c0\u09af\u09bc \u09b0\u09c1\u09aa\u09bf" },
            { "iqd", "\u0987\u09b0\u09be\u0995\u09bf \u09a6\u09bf\u09a8\u09be\u09b0" },
            { "irr", "\u0987\u09b0\u09be\u09a8\u09bf\u09af\u09bc\u09be\u09a8 \u09b0\u09bf\u09af\u09bc\u09be\u09b2" },
            { "isk", "\u0986\u0987\u09b8\u09b2\u09cd\u09af\u09be\u09a8\u09cd\u09a1\u09c0\u09af\u09bc \u0995\u09cd\u09b0\u09cb\u09a8\u09be" },
            { "itl", "\u0987\u09a4\u09be\u09b2\u09c0\u09af\u09bc \u09b2\u09bf\u09b0\u09be" },
            { "jmd", "\u099c\u09be\u09ae\u09be\u0987\u0995\u09be\u09a8 \u09a1\u09b2\u09be\u09b0" },
            { "jod", "\u099c\u09b0\u09cd\u09a1\u09be\u09a8\u09bf\u09af\u09bc\u09be\u09a8 \u09a6\u09bf\u09a8\u09be\u09b0" },
            { "jpy", "\u099c\u09be\u09aa\u09be\u09a8\u09bf \u0987\u09af\u09bc\u09c7\u09a8" },
            { "kes", "\u0995\u09c7\u09a8\u09bf\u09af\u09bc\u09be\u09a8 \u09b6\u09bf\u09b2\u09bf\u0982" },
            { "kgs", "\u0995\u09bf\u09b0\u0997\u09bf\u099c\u09b8\u09cd\u09a4\u09be\u09a8 \u09b8\u09cb\u09ae" },
            { "khr", "\u0995\u09ae\u09cd\u09ac\u09cb\u09a1\u09bf\u09af\u09bc\u09be\u09a8 \u09b0\u09bf\u09af\u09bc\u09c7\u09b2" },
            { "kmf", "\u0995\u09ae\u09cb\u09b0\u09bf\u09af\u09bc\u09be\u09a8 \u09ab\u09cd\u09b0\u09be\u0999\u09cd\u0995" },
            { "kpw", "\u0989\u09a4\u09cd\u09a4\u09b0 \u0995\u09cb\u09b0\u09bf\u09af\u09bc\u09be\u09b0 \u0993\u09a8" },
            { "krw", "\u09a6\u0995\u09cd\u09b7\u09bf\u09a3 \u0995\u09cb\u09b0\u09bf\u09af\u09bc\u09be\u09a8 \u0993\u09a8" },
            { "kwd", "\u0995\u09c1\u09af\u09bc\u09c7\u09a4\u09bf \u09a6\u09bf\u09a8\u09be\u09b0" },
            { "kyd", "\u0995\u09c7\u09ae\u09cd\u09af\u09be\u09a8 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c\u09c7\u09b0 \u09a1\u09b2\u09be\u09b0" },
            { "kzt", "\u0995\u09be\u099c\u09be\u0996\u09be\u09b8\u09cd\u09a4\u09be\u09a8\u09bf \u099f\u09c7\u0999\u09cd\u0997\u09c7" },
            { "lak", "\u09b2\u09c7\u0989\u09b6\u09be\u09a8 \u0995\u09bf\u09aa" },
            { "lbp", "\u09b2\u09c7\u09ac\u09be\u09a8\u09bf\u099c \u09aa\u09be\u0989\u09a8\u09cd\u09a1" },
            { "lkr", "\u09b6\u09cd\u09b0\u09c0\u09b2\u0999\u09cd\u0995\u09be\u09a8 \u09b0\u09c1\u09aa\u09bf" },
            { "lrd", "\u09b2\u09bf\u09ac\u09c7\u09b0\u09bf\u09af\u09bc\u09be\u09a8 \u09a1\u09b2\u09be\u09b0" },
            { "lsl", "\u09b2\u09c7\u09b8\u09c1\u099f\u09c1 \u09b2\u09cb\u099f\u09bf" },
            { "ltl", "\u09b2\u09bf\u09a5\u09c1\u0987\u09a8\u09bf\u09af\u09bc\u09be\u09a8 \u09b2\u09bf\u099f\u09be" },
            { "ltt", "\u09b2\u09bf\u09a5\u09c1\u0987\u09a8\u09bf\u09af\u09bc\u09be\u09a8 \u099f\u09be\u09b2\u09cb\u09a8\u09cd\u09af\u09be\u09b8" },
            { "luc", "\u09b2\u09c1\u0995\u09cd\u09b8\u09c7\u09ae\u09ac\u09be\u09b0\u09cd\u0997 \u09b0\u09c1\u09aa\u09be\u09a8\u09cd\u09a4\u09af\u09cb\u0997\u09cd\u09af \u09ab\u09cd\u09b0\u09be\u0999\u09cd\u0995" },
            { "luf", "\u09b2\u09c1\u0995\u09cd\u09b8\u09c7\u09ae\u09ac\u09be\u09b0\u09cd\u0997 \u09ab\u09cd\u09b0\u09be\u0999\u09cd\u0995" },
            { "lul", "\u09b2\u09c1\u0995\u09cd\u09b8\u09c7\u09ae\u09ac\u09be\u09b0\u09cd\u0997 \u09ab\u09be\u0987\u09a8\u09c7\u09a8\u09b6\u09bf\u09af\u09bc\u09be\u09b2 \u09ab\u09cd\u09b0\u09be\u0999\u09cd\u0995" },
            { "lvl", "\u09b2\u09cd\u09af\u09be\u099f\u09ad\u09bf\u09af\u09bc\u09be\u09a8 \u09b2\u09cd\u09af\u09be\u099f\u09cd\u200c\u09b8" },
            { "lvr", "\u09b2\u09cd\u09af\u09be\u099f\u09ad\u09bf\u09af\u09bc\u09be\u09a8 \u09b0\u09c1\u09ac\u09b2" },
            { "lyd", "\u09b2\u09bf\u09ac\u09bf\u09af\u09bc\u09be\u09a8 \u09a6\u09bf\u09a8\u09be\u09b0" },
            { "mad", "\u09ae\u09cb\u09b0\u09cb\u0995\u09cd\u0995\u09be\u09a8 \u09a6\u09bf\u09b0\u09b9\u09be\u09ae" },
            { "maf", "\u09ae\u09cb\u09b0\u09cb\u0995\u09cd\u0995\u09be\u09a8 \u09ab\u09cd\u09b0\u09be\u0999\u09cd\u0995" },
            { "mdl", "\u09ae\u09cb\u09b2\u09cd\u09a1\u09cb\u09ad\u09be\u09a8 \u09b2\u09c7\u09af\u09bc\u09c1" },
            { "mga", "\u09ae\u09be\u09a6\u09be\u0997\u09be\u09b8\u09cd\u0995\u09be\u09b0 \u0986\u09b0\u09bf\u09af\u09bc\u09be\u09b0\u09bf" },
            { "mgf", "\u09ae\u09be\u09a6\u09be\u0997\u09be\u09b8\u09cd\u0995\u09be\u09b0 \u09ab\u09cd\u09b0\u09be\u0999\u09cd\u0995" },
            { "mkd", "\u09ae\u09cd\u09af\u09be\u09b8\u09c7\u09a1\u09cb\u09a8\u09bf\u09af\u09bc\u09be\u09a8 \u09a6\u09bf\u09a8\u09be\u09b0" },
            { "mlf", "\u09ae\u09be\u09b2\u09bf \u09ab\u09cd\u09b0\u09be\u0999\u09cd\u0995" },
            { "mmk", "\u09ae\u09be\u09af\u09bc\u09be\u09a8\u09ae\u09be\u09b0 \u0995\u09bf\u09af\u09bc\u09be\u09a4" },
            { "mnt", "\u09ae\u0999\u09cd\u0997\u09cb\u09b2\u09bf\u09af\u09bc\u09be\u09a8 \u09a4\u09c1\u0997\u09b0\u09bf\u0995" },
            { "mop", "\u09ae\u09cd\u09af\u09be\u0995\u09cd\u09af\u09be\u0993 \u09aa\u09be\u099f\u09be\u0995\u09be" },
            { "mro", "\u09ae\u09cc\u09b0\u09bf\u09a4\u09be\u09a8\u09bf\u09af\u09bc\u09be\u09a8 \u0993\u0989\u0997\u09c1\u0987\u09af\u09bc\u09be (\u09e7\u09ef\u09ed\u09e9\u2013\u09e8\u09e6\u09e7\u09ed)" },
            { "mru", "\u09ae\u09cc\u09b0\u09bf\u09a4\u09be\u09a8\u09bf\u09af\u09bc\u09be\u09a8 \u0993\u0989\u0997\u09c1\u0987\u09af\u09bc\u09be" },
            { "mtl", "\u09ae\u09be\u09b2\u09cd\u099f\u09be \u09b2\u09bf\u09b0\u09be" },
            { "mtp", "\u09ae\u09be\u09b2\u09cd\u099f\u09be \u09aa\u09be\u0989\u09a8\u09cd\u09a1" },
            { "mur", "\u09ae\u09cc\u09b0\u09bf\u09a4\u09be\u09a8\u09bf\u09af\u09bc\u09be\u09a8 \u09b0\u09c1\u09aa\u09bf" },
            { "mvr", "\u09ae\u09be\u09b2\u09a6\u09bf\u09ad\u09bf\u09af\u09bc\u09be\u09a8 \u09b0\u09c1\u09ab\u09bf\u09af\u09bc\u09be" },
            { "mwk", "\u09ae\u09be\u09b2\u09be\u0989\u0987\u09af\u09bc\u09be\u09a8 \u0995\u09cb\u09af\u09bc\u09be\u099a\u09be" },
            { "mxn", "\u09ae\u09cd\u09af\u09be\u0995\u09cd\u09b8\u09bf\u0995\u09be\u09a8 \u09aa\u09c7\u09b8\u09cb" },
            { "mxp", "\u09ae\u09cd\u09af\u09be\u0995\u09cd\u09b8\u09bf\u0995\u09be\u09a8 \u09b8\u09bf\u09b2\u09ad\u09be\u09b0 \u09aa\u09c7\u09b8\u09cb (\u09e7\u09ee\u09ec\u09e7\u2013\u09e7\u09ef\u09ef\u09e8)" },
            { "mxv", "\u09ae\u09c7\u0995\u09cd\u09b8\u09bf\u0995\u09be\u09a8 \u0989\u09a8\u09bf\u09a6\u09be\u09a6 \u09a6\u09bf \u0987\u09a8\u09ad\u09be\u09b0\u09cd\u09b8\u09be\u09a8 (UDI)" },
            { "myr", "\u09ae\u09be\u09b2\u09af\u09bc\u09c7\u09b6\u09bf\u09af\u09bc\u09be\u09a8 \u09b0\u09bf\u0999\u09cd\u0997\u09bf\u09ce" },
            { "mze", "\u09ae\u09cb\u099c\u09be\u09ae\u09cd\u09ac\u09bf\u0995 \u098f\u09b8\u0995\u09c1\u09a1\u09cb" },
            { "mzm", "\u09aa\u09cd\u09b0\u09be\u099a\u09c0\u09a8 \u09ae\u09cb\u099c\u09be\u09ae\u09cd\u09ac\u09bf\u0995 \u09ae\u09c7\u099f\u09bf\u0995\u09c7\u09b2" },
            { "mzn", "\u09ae\u09cb\u099c\u09be\u09ae\u09cd\u09ac\u09bf\u0995 \u09ae\u09c7\u099f\u09bf\u0995\u09c7\u09b2" },
            { "nad", "\u09a8\u09be\u09ae\u09bf\u09ac\u09bf\u09af\u09bc\u09be \u09a1\u09b2\u09be\u09b0" },
            { "ngn", "\u09a8\u09be\u0987\u099c\u09c7\u09b0\u09bf\u09af\u09bc\u09be\u09a8 \u09a8\u09be\u09af\u09bc\u09b0\u09be" },
            { "nic", "\u09a8\u09bf\u0995\u09be\u09b0\u09be\u0997\u09c1\u09af\u09bc\u09be\u09a8 \u0995\u09b0\u09cd\u09a1\u09cb\u09ac\u09be (\u09e7\u09ef\u09ee\u09ee\u2013\u09e7\u09ef\u09ef\u09e7)" },
            { "nio", "\u09a8\u09bf\u0995\u09be\u09b0\u09be\u0997\u09c1\u09af\u09bc\u09be\u09a8 \u0995\u09b0\u09cd\u09a1\u09cb\u09ac\u09be" },
            { "nlg", "\u09a8\u09c7\u09a6\u09be\u09b0\u09b2\u09cd\u09af\u09be\u09a8\u09cd\u09a1 \u0997\u09c1\u09b2\u09cd\u09a1\u09c7\u09b0" },
            { "nok", "\u09a8\u09b0\u0993\u09af\u09bc\u09c7\u099c\u09bf\u09af\u09bc\u09be\u09a8 \u0995\u09cd\u09b0\u09cb\u09a8" },
            { "npr", "\u09a8\u09c7\u09aa\u09be\u09b2\u09bf \u09b0\u09c1\u09aa\u09bf" },
            { "nzd", "\u09a8\u09bf\u0989\u099c\u09bf\u09b2\u09cd\u09af\u09be\u09a8\u09cd\u09a1 \u09a1\u09b2\u09be\u09b0" },
            { "omr", "\u0993\u09ae\u09be\u09a8\u09bf \u09b0\u09bf\u09af\u09bc\u09be\u09b2" },
            { "pab", "\u09aa\u09be\u09a8\u09be\u09ae\u09be\u09a8\u09bf\u09af\u09bc\u09be\u09a8 \u09ac\u09be\u09b2\u09ac\u09cb\u09af\u09bc\u09be" },
            { "pei", "\u09aa\u09c7\u09b0\u09c1\u09ad\u09bf\u09af\u09bc\u09be\u09a8 \u0987\u09a8\u09cd\u09a4\u09bf" },
            { "pen", "\u09aa\u09c7\u09b0\u09c1\u09ad\u09bf\u09af\u09bc\u09be\u09a8 \u09b8\u09cb\u09b2" },
            { "pes", "\u09aa\u09c7\u09b0\u09c1\u09ad\u09bf\u09af\u09bc\u09be\u09a8 \u09b8\u09cb\u09b2 (1863\u20131965)" },
            { "pgk", "\u09aa\u09be\u09aa\u09c1\u09af\u09bc\u09be \u09a8\u09bf\u0989 \u0997\u09bf\u09a8\u09bf\u09af\u09bc\u09be\u09a8 \u0995\u09bf\u09a8\u09be" },
            { "php", "\u09ab\u09bf\u09b2\u09bf\u09aa\u09be\u0987\u09a8 \u09aa\u09c7\u09b8\u09cb" },
            { "pkr", "\u09aa\u09be\u0995\u09bf\u09b8\u09cd\u09a4\u09be\u09a8\u09bf \u09b0\u09c1\u09aa\u09bf" },
            { "pln", "\u09aa\u09cb\u09b2\u09bf\u09b6 \u099c\u09cd\u09b2\u09cb\u099f\u09bf" },
            { "plz", "\u09aa\u09cb\u09b2\u09bf\u09b6 \u099c\u09cd\u09b2\u09cb\u099f\u09bf (\u09e7\u09ef\u09eb\u09e6\u2013\u09e7\u09ef\u09ef\u09eb)" },
            { "pte", "\u09aa\u09b0\u09cd\u09a4\u09c1\u0997\u09bf\u099c \u098f\u09b8\u0995\u09c1\u09a1\u09cb" },
            { "pyg", "\u09aa\u09cd\u09af\u09be\u09b0\u09be\u0997\u09c1\u09af\u09bc\u09be\u09a8 \u0997\u09c1\u09af\u09bc\u09be\u09b0\u09be\u09a8\u09bf" },
            { "qar", "\u0995\u09be\u09a4\u09be\u09b0 \u09b0\u09bf\u09af\u09bc\u09be\u09b2" },
            { "rhd", "\u09b0\u09cb\u09a1\u09c7\u09b6\u09bf\u09af\u09bc\u09be\u09a8 \u09a1\u09b2\u09be\u09b0" },
            { "rol", "\u09aa\u09cd\u09b0\u09be\u099a\u09c0\u09a8 \u09b0\u09c1\u09ae\u09be\u09a8\u09bf\u09af\u09bc\u09be \u09b2\u09c7\u09af\u09bc\u09c1" },
            { "ron", "\u09b0\u09c1\u09ae\u09be\u09a8\u09bf\u09af\u09bc\u09be \u09b2\u09c7\u09af\u09bc\u09c1" },
            { "rsd", "\u09b8\u09be\u09b0\u09ac\u09bf\u09af\u09bc\u09be\u09a8 \u09a6\u09bf\u09a8\u09be\u09b0" },
            { "rub", "\u09b0\u09be\u09b6\u09bf\u09af\u09bc\u09be\u09a8 \u09b0\u09c1\u09ac\u09c7\u09b2" },
            { "rur", "\u09b0\u09be\u09b6\u09bf\u09af\u09bc\u09be\u09a8 \u09b0\u09c1\u09ac\u09b2 (\u09e7\u09ef\u09ef\u09e7\u2013\u09e7\u09ef\u09ef\u09ee)" },
            { "rwf", "\u09b0\u09c1\u09af\u09bc\u09be\u09a8\u09cd\u09a1\u09be\u09a8 \u09ab\u09cd\u09b0\u09be\u0999\u09cd\u0995" },
            { "sar", "\u09b8\u09cc\u09a6\u09bf \u09b0\u09bf\u09af\u09bc\u09be\u09b2" },
            { "sbd", "\u09b8\u09b2\u09cb\u09ae\u09a8 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c \u09a1\u09b2\u09be\u09b0" },
            { "scr", "\u09b8\u09c7\u09af\u09bc\u099a\u09c7\u09b2\u09cd\u09b2\u09cb\u0987\u09b8 \u09b0\u09c1\u09aa\u09bf" },
            { "sdd", "\u09aa\u09cd\u09b0\u09be\u099a\u09c0\u09a8 \u09b8\u09c1\u09a6\u09be\u09a8\u09bf \u09a6\u09bf\u09a8\u09be\u09b0" },
            { "sdg", "\u09b8\u09c1\u09a6\u09be\u09a8\u09bf \u09aa\u09be\u0989\u09a8\u09cd\u09a1" },
            { "sdp", "\u09aa\u09cd\u09b0\u09be\u099a\u09c0\u09a8 \u09b8\u09c1\u09a6\u09be\u09a8\u09bf \u09aa\u09be\u0989\u09a8\u09cd\u09a1" },
            { "sek", "\u09b8\u09c1\u0987\u09a1\u09bf\u09b6 \u0995\u09cd\u09b0\u09cb\u09a8\u09be" },
            { "sgd", "\u09b8\u09bf\u0999\u09cd\u0997\u09be\u09aa\u09c1\u09b0 \u09a1\u09b2\u09be\u09b0" },
            { "shp", "\u09b8\u09c7\u09a8\u09cd\u099f \u09b9\u09c7\u09b2\u09c7\u09a8\u09be \u09aa\u09be\u0989\u09a8\u09cd\u09a1" },
            { "sit", "\u09b8\u09cd\u09b2\u09cb\u09ad\u09be\u09a8\u09bf\u09af\u09bc\u09be \u099f\u09cb\u09b2\u09be\u09b0" },
            { "skk", "\u09b8\u09cd\u09b2\u09cb\u09ad\u09be\u0995 \u0995\u09cb\u09b0\u09c1\u09a8\u09be" },
            { "sll", "\u09b8\u09bf\u09af\u09bc\u09c7\u09b0\u09be\u09b2\u09bf\u09af\u09bc\u09a8 \u09b2\u09bf\u09af\u09bc\u09a8" },
            { "sos", "\u09b8\u09cb\u09ae\u09be\u09b2\u09bf \u09b6\u09bf\u09b2\u09bf\u0982" },
            { "srd", "\u09b8\u09c1\u09b0\u09bf\u09a8\u09be\u09ae\u09bf\u099c \u09a1\u09b2\u09be\u09b0" },
            { "srg", "\u09b8\u09c1\u09b0\u09bf\u09a8\u09be\u09ae \u0997\u09bf\u09b2\u09cd\u09a1\u09be\u09b0" },
            { "ssp", "\u09a6\u0995\u09cd\u09b7\u09bf\u09a3 \u09b8\u09c1\u09a6\u09be\u09a8\u09bf \u09aa\u09be\u0989\u09a8\u09cd\u09a1" },
            { "std", "\u09b8\u09be\u0993 \u099f\u09cb\u09ae\u09c7 \u098f\u09ac\u0982 \u09aa\u09cd\u09b0\u09bf\u09a8\u09cd\u09b8\u09bf\u09aa\u09c7 \u09a1\u09cb\u09ac\u09b0\u09be (\u09e7\u09ef\u09ed\u09ed\u2013\u09e8\u09e6\u09e7\u09ed)" },
            { "stn", "\u09b8\u09be\u0993 \u099f\u09cb\u09ae\u09c7 \u098f\u09ac\u0982 \u09aa\u09cd\u09b0\u09bf\u09a8\u09cd\u09b8\u09bf\u09aa\u09c7 \u09a1\u09cb\u09ac\u09b0\u09be" },
            { "sur", "\u09b8\u09cb\u09ad\u09bf\u09af\u09bc\u09c7\u09a4 \u09b0\u09c1\u09ac\u09b2" },
            { "svc", "\u098f\u09b2 \u09b8\u09cd\u09af\u09be\u09b2\u09ad\u09cb\u09a1\u09cb\u09b0 \u0995\u09cb\u09b2\u09cb\u09a8" },
            { "syp", "\u09b8\u09bf\u09b0\u09bf\u09af\u09bc\u09be\u09a8 \u09aa\u09be\u0989\u09a8\u09cd\u09a1" },
            { "szl", "\u09b8\u09cb\u09af\u09bc\u09be\u099c\u09bf\u09b2\u09cd\u09af\u09be\u09a8\u09cd\u09a1 \u09b2\u09bf\u09b2\u09be\u0999\u09cd\u0997\u09c7\u09a8\u09bf" },
            { "thb", "\u09a5\u09be\u0987 \u09ac\u09be\u09a4" },
            { "tjr", "\u09a4\u09be\u099c\u09bf\u0995\u09bf\u09b8\u09cd\u09a4\u09be\u09a8 \u09b0\u09c1\u09ac\u09b2" },
            { "tjs", "\u09a4\u09be\u099c\u09bf\u0995\u09bf\u09b8\u09cd\u09a4\u09be\u09a8 \u09b8\u09cb\u09ae\u09cb\u09a8\u09bf" },
            { "tmm", "\u09a4\u09c1\u09b0\u09cd\u0995\u09ae\u09c7\u09a8\u09bf\u09b8\u09cd\u099f\u09be\u09a8\u09bf \u09ae\u09be\u09a8\u09be\u09a4" },
            { "tmt", "\u09a4\u09c1\u09b0\u09cd\u0995\u09ae\u09c7\u09a8\u09bf\u09b8\u09cd\u09a4\u09be\u09a8 \u09ae\u09be\u09a8\u09a4" },
            { "tnd", "\u09a4\u09bf\u0989\u09a8\u09c7\u09b6\u09bf\u09af\u09bc\u09be\u09a8 \u09a6\u09bf\u09a8\u09be\u09b0" },
            { "top", "\u099f\u09cb\u0999\u09cd\u0997\u09be \u09aa\u09be\u2019\u0986\u0999\u09cd\u0997\u09be" },
            { "tpe", "\u09a4\u09bf\u09ae\u09c1\u09b0 \u098f\u09b8\u0995\u09c1\u09a1\u09cb" },
            { "trl", "\u09aa\u09cd\u09b0\u09be\u099a\u09c0\u09a8 \u09a4\u09c1\u09b0\u09cd\u0995\u09bf \u09b2\u09bf\u09b0\u09be" },
            { "try", "\u09a4\u09c1\u09b0\u09cd\u0995\u09bf \u09b2\u09bf\u09b0\u09be" },
            { "ttd", "\u09a4\u09cd\u09b0\u09bf\u09a8\u09bf\u09a6\u09be\u09a6 \u098f\u09ac\u0982 \u099f\u09cb\u09ac\u09be\u0997\u09cb \u09a1\u09b2\u09be\u09b0" },
            { "twd", "\u09a8\u09a4\u09c1\u09a8 \u09a4\u09be\u0987\u0993\u09af\u09bc\u09be\u09a8 \u09a1\u09b2\u09be\u09b0" },
            { "tzs", "\u09a4\u09be\u099e\u09cd\u099c\u09a8\u09bf\u09af\u09bc\u09be \u09b6\u09bf\u09b2\u09bf\u0982" },
            { "uah", "\u0987\u0989\u0995\u09cd\u09b0\u09c7\u0987\u09a8 \u09b9\u09c3\u09ad\u09a8\u09bf\u09af\u09bc\u09be" },
            { "uak", "\u0987\u0989\u0995\u09cd\u09b0\u09c7\u0987\u09a8 \u0995\u09be\u09b0\u09cd\u09ac\u09cb\u09ad\u09cd\u09af\u09be\u09a8\u09cd\u099f\u09b8" },
            { "ugs", "\u0989\u0997\u09be\u09a8\u09cd\u09a1\u09be\u09a8 \u09b6\u09bf\u09b2\u09bf\u0982 (\u09e7\u09ef\u09ec\u09ec\u2013\u09e7\u09ef\u09ee\u09ed)" },
            { "ugx", "\u0989\u0997\u09be\u09a8\u09cd\u09a1\u09be\u09a8 \u09b6\u09bf\u09b2\u09bf\u0982" },
            { "usd", "\u09ae\u09be\u09b0\u09cd\u0995\u09bf\u09a8 \u09a1\u09b2\u09be\u09b0" },
            { "usn", "\u09ae\u09be\u09b0\u09cd\u0995\u09bf\u09a8 \u09a1\u09b2\u09be\u09b0 (\u09aa\u09b0\u09ac\u09b0\u09cd\u09a4\u09c0 \u09a6\u09bf\u09a8)" },
            { "uss", "\u09ae\u09be\u09b0\u09cd\u0995\u09bf\u09a8 \u09a1\u09b2\u09be\u09b0 (\u098f\u0995\u0987 \u09a6\u09bf\u09a8)" },
            { "uyi", "\u0989\u09b0\u09c1\u0997\u09c1\u09af\u09bc\u09be\u09af\u09bc\u09be\u09a8 \u09aa\u09c7\u09b8\u09cb \u098f\u09a8 \u0989\u09a8\u09bf\u09a6\u09be\u09a6\u09c7\u09b8 \u0987\u09a8\u09a1\u09c7\u0995\u09cd\u09b8\u09c7\u09a1\u09be\u09b8" },
            { "uyp", "\u0989\u09b0\u09c1\u0997\u09c1\u09af\u09bc\u09c7 \u09aa\u09c7\u09b8\u09cb (\u09e7\u09ef\u09ed\u09eb\u2013\u09e7\u09ef\u09ef\u09e9)" },
            { "uyu", "\u0989\u09b0\u09c1\u0997\u09c1\u09af\u09bc\u09c7 \u09aa\u09c7\u09b8\u09cb" },
            { "uzs", "\u0989\u099c\u09ac\u09c7\u0995\u09bf\u09b8\u09cd\u09a4\u09be\u09a8\u09bf \u09b8\u09cb\u09ae" },
            { "veb", "\u09ad\u09c7\u09a8\u09bf\u099c\u09c1\u09af\u09bc\u09c7\u09b2\u09be\u09a8 \u09ac\u09b2\u09bf\u09ad\u09be\u09b0 (\u09e7\u09ee\u09ed\u09e7\u2013\u09e8\u09e6\u09e6\u09ee)" },
            { "vef", "\u09ad\u09c7\u09a8\u09bf\u099c\u09c1\u09af\u09bc\u09c7\u09b2\u09c0\u09af\u09bc \u09ac\u09b2\u09bf\u09ad\u09be\u09b0 (\u09e8\u09e6\u09e6\u09ee\u2013\u09e8\u09e6\u09e7\u09ee)" },
            { "ves", "\u09ad\u09c7\u09a8\u09bf\u099c\u09c1\u09af\u09bc\u09c7\u09b2\u09c0\u09af\u09bc \u09ac\u09b2\u09bf\u09ad\u09be\u09b0" },
            { "vnd", "\u09ad\u09bf\u09af\u09bc\u09c7\u09a4\u09a8\u09be\u09ae\u09bf \u09a1\u0999\u09cd\u0997" },
            { "vuv", "\u09ad\u09be\u09a8\u09c1\u09af\u09bc\u09be\u09a4\u09c1 \u09ad\u09be\u09a4\u09c1" },
            { "wst", "\u09b8\u09be\u09ae\u09cb\u09af\u09bc\u09be\u09a8 \u099f\u09be\u09b2\u09be" },
            { "xaf", "\u09ae\u09a7\u09cd\u09af \u0986\u09ab\u09cd\u09b0\u09bf\u0995\u09be\u09a8 [CFA] \u09ab\u09cd\u09b0\u09cd\u09af\u09be\u0999\u09cd\u0995" },
            { "xag", "\u09b8\u09bf\u09b2\u09ad\u09be\u09b0" },
            { "xau", "\u0997\u09cb\u09b2\u09cd\u09a1" },
            { "xbb", "\u0987\u0989\u09b0\u09cb\u09aa\u09c0\u09af\u09bc \u0986\u09b0\u09cd\u09a5\u09bf\u0995 \u098f\u0995\u0995" },
            { "xcd", "\u09aa\u09c2\u09b0\u09cd\u09ac \u0995\u09cd\u09af\u09be\u09b0\u09be\u09ac\u09bf\u09af\u09bc\u09be\u09a8 \u09a1\u09b2\u09be\u09b0" },
            { "xeu", "\u0987\u0989\u09b0\u09cb\u09aa\u09c0\u09af\u09bc \u09ae\u09c1\u09a6\u09cd\u09b0\u09be \u098f\u0995\u0995" },
            { "xfo", "\u09ab\u09b0\u09be\u09b8\u09bf \u0997\u09cb\u09b2\u09cd\u09a1 \u09ab\u09cd\u09b0\u09be\u0999\u09cd\u0995" },
            { "xfu", "\u09ab\u09b0\u09be\u09b8\u09bf \u0987\u0989\u0986\u0987\u09b8\u09bf - \u09ab\u09cd\u09b0\u09be\u0999\u09cd\u0995" },
            { "xof", "\u09aa\u09b6\u09cd\u099a\u09bf\u09ae \u0986\u09ab\u09cd\u09b0\u09bf\u0995\u09be\u09a8 [CFA] \u09ab\u09cd\u09b0\u09cd\u09af\u09be\u0999\u09cd\u0995" },
            { "xpd", "\u09aa\u09cd\u09af\u09be\u09b2\u09c7\u09a1\u09bf\u09af\u09bc\u09be\u09ae" },
            { "xpf", "\u09b8\u09bf\u098f\u09ab\u09aa\u09bf \u09ab\u09cd\u09b0\u09cd\u09af\u09be\u0999\u09cd\u0995" },
            { "xpt", "\u09aa\u09cd\u09b2\u09be\u099f\u09bf\u09a8\u09be\u09ae" },
            { "xxx", "\u0985\u099c\u09be\u09a8\u09be \u09ae\u09c1\u09a6\u09cd\u09b0\u09be" },
            { "ydd", "\u0987\u09af\u09bc\u09c7\u09ae\u09c7\u09a8\u09bf \u09a6\u09bf\u09a8\u09be\u09b0" },
            { "yer", "\u0987\u09af\u09bc\u09c7\u09ae\u09c7\u09a8\u09bf \u09b0\u09bf\u09af\u09bc\u09be\u09b2" },
            { "yud", "\u09af\u09c1\u0997\u09cb\u09b6\u09cd\u09b2\u09be\u09ad\u09bf\u09af\u09bc \u09b9\u09be\u09b0\u09cd\u09a1 \u09a6\u09bf\u09a8\u09be\u09b0" },
            { "yum", "\u09af\u09c1\u0997\u09cb\u09b6\u09cd\u09b2\u09be\u09ad\u09bf\u09af\u09bc \u09a8\u09cb\u09ad\u09bf \u09a6\u09bf\u09a8\u09be\u09b0" },
            { "yun", "\u09af\u09c1\u0997\u09cb\u09b6\u09cd\u09b2\u09be\u09ad\u09bf\u09af\u09bc \u09b0\u09c1\u09aa\u09be\u09a8\u09cd\u09a4\u09b0\u09af\u09cb\u0997\u09cd\u09af \u09a6\u09bf\u09a8\u09be\u09b0" },
            { "zal", "\u09a6\u0995\u09cd\u09b7\u09bf\u09a3 \u0986\u09ab\u09cd\u09b0\u09bf\u0995\u09be\u09a8 \u09b0\u200c\u09cd\u09af\u09be\u09a8\u09cd\u09a1" },
            { "zar", "\u09a6\u0995\u09cd\u09b7\u09bf\u09a3 \u0986\u09ab\u09cd\u09b0\u09bf\u0995\u09be\u09a8 \u09b0\u09c7\u09a8\u09cd\u09a1" },
            { "zmk", "\u099c\u09be\u09ae\u09cd\u09ac\u09bf\u09af\u09bc\u09be\u09a8 \u0995\u0993\u09af\u09bc\u09be\u099a\u09be (\u09e7\u09ef\u09ec\u09ee\u2013\u09e8\u09e6\u09e7\u09e8)" },
            { "zmw", "\u099c\u09be\u09ae\u09cd\u09ac\u09bf\u09af\u09bc\u09be\u09a8 \u0995\u0993\u09af\u09bc\u09be\u099a\u09be" },
            { "zrn", "\u099c\u09be\u0987\u09b0\u09bf\u09af\u09bc\u09be\u09a8 \u09a8\u09bf\u0989 \u099c\u09be\u0987\u09b0\u09c7" },
            { "zrz", "\u099c\u09be\u0987\u09b0\u09bf\u09af\u09bc\u09be\u09a8 \u099c\u09be\u0987\u09b0\u09c7" },
            { "zwd", "\u099c\u09bf\u09ae\u09cd\u09ac\u09be\u09ac\u09c1\u09af\u09bc\u09c7 \u09a1\u09b2\u09be\u09b0 (\u09e7\u09ef\u09ee\u09e6\u2013\u09e8\u09e6\u09e6\u09ee)" },
            { "zwl", "\u099c\u09bf\u09ae\u09cd\u09ac\u09be\u09ac\u09c1\u09af\u09bc\u09c7 \u09a1\u09b2\u09be\u09b0 (\u09e8\u09e6\u09e6\u09ef)" },
            { "zwr", "\u099c\u09bf\u09ae\u09cd\u09ac\u09be\u09ac\u09c1\u09af\u09bc\u09c7 \u09a1\u09b2\u09be\u09b0 (\u09e8\u09e6\u09e6\u09ee)" },
        };
        return data;
    }
}
