/*
 * Copyright (c) 2012, 2022, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_sc extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "\u00e0rabu";
        final String metaValue_hy = "armenu";
        final String metaValue_ban = "balinesu";
        final String metaValue_bn = "bengalesu";
        final String metaValue_bug = "buginesu";
        final String metaValue_ccp = "chakma";
        final String metaValue_chr = "cherokee";
        final String metaValue_ka = "georgianu";
        final String metaValue_el = "grecu";
        final String metaValue_gu = "gujarati";
        final String metaValue_jv = "giavanesu";
        final String metaValue_ja = "giaponesu";
        final String metaValue_km = "khmer";
        final String metaValue_kn = "kannada";
        final String metaValue_ko = "coreanu";
        final String metaValue_lo = "laotianu";
        final String metaValue_la = "latinu";
        final String metaValue_men = "mende";
        final String metaValue_ml = "malayalam";
        final String metaValue_mn = "m\u00f2ngolu";
        final String metaValue_nqo = "n\u2019ko";
        final String metaValue_or = "odia";
        final String metaValue_si = "singalesu";
        final String metaValue_su = "sundanesu";
        final String metaValue_syr = "sir\u00ecacu";
        final String metaValue_ta = "tamil";
        final String metaValue_te = "telugu";
        final String metaValue_th = "tailandesu";
        final String metaValue_bo = "tibetanu";
        final String metaValue_vai = "vai";
        final String metaValue_kw = "c\u00f2rnicu";
        final String metaValue_Hans = "semplificadu";
        final Object[][] data = new Object[][] {
            { "001", "Mundu" },
            { "002", "\u00c0frica" },
            { "003", "Am\u00e8rica de su Nord" },
            { "005", "Am\u00e8rica de su Sud" },
            { "009", "Otze\u00e0nia" },
            { "011", "\u00c0frica otzidentale" },
            { "013", "Am\u00e8rica tzentrale" },
            { "014", "\u00c0frica orientale" },
            { "015", "\u00c0frica setentrionale" },
            { "017", "\u00c0frica tzentrale" },
            { "018", "\u00c0frica meridionale" },
            { "019", "Am\u00e8ricas" },
            { "021", "Am\u00e8rica setentrionale" },
            { "029", "Car\u00e0ibes" },
            { "030", "\u00c0sia orientale" },
            { "034", "\u00c0sia meridionale" },
            { "035", "Sud-est asi\u00e0ticu" },
            { "039", "Europa meridionale" },
            { "053", "Austral\u00e0sia" },
            { "054", "Melan\u00e8sia" },
            { "057", "Regione micronesiana" },
            { "061", "Polin\u00e8sia" },
            { "142", "\u00c0sia" },
            { "143", "\u00c0sia tzentrale" },
            { "145", "\u00c0sia otzidentale" },
            { "150", "Europa" },
            { "151", "Europa orientale" },
            { "154", "Europa setentrionale" },
            { "155", "Europa otzidentale" },
            { "202", "\u00c0frica sub-sahariana" },
            { "419", "Am\u00e8rica latina" },
            { "AC", "\u00ccsula de s\u2019Ascensione" },
            { "AD", "Andorra" },
            { "AE", "Emirados \u00c0rabos Unidos" },
            { "AF", "Afgh\u00e0nistan" },
            { "AG", "Antigua e Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albania" },
            { "AM", "Arm\u00e8nia" },
            { "AO", "Angola" },
            { "AQ", "Ant\u00e0rticu" },
            { "AR", "Argentina" },
            { "AS", "Samoa americanas" },
            { "AT", "\u00c0ustria" },
            { "AU", "Austr\u00e0lia" },
            { "AW", "Aruba" },
            { "AX", "\u00ccsulas \u00c5land" },
            { "AZ", "Azerbaigi\u00e0n" },
            { "BA", "B\u00f2snia e Erzeg\u00f2vina" },
            { "BB", "Barbados" },
            { "BD", "Banglad\u00e8sh" },
            { "BE", "B\u00e8lgiu" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaria" },
            { "BH", "Bahrein" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Santu Bartolomeu" },
            { "BM", "Bermudas" },
            { "BN", "Brunei" },
            { "BO", "Bol\u00ecvia" },
            { "BQ", "Car\u00e0ibes olandesas" },
            { "BR", "Brasile" },
            { "BS", "Bahamas" },
            { "BT", "Bhut\u00e0n" },
            { "BV", "\u00ccsula Bouvet" },
            { "BW", "Botswana" },
            { "BY", "Bielor\u00f9ssia" },
            { "BZ", "Belize" },
            { "CA", "C\u00e0nada" },
            { "CC", "\u00ccsulas Cocos (Keeling)" },
            { "CD", "Congo - Kinshasa" },
            { "CF", "Rep\u00f9blica Tzentrafricana" },
            { "CG", "Congo - Bratzaville" },
            { "CH", "Isv\u00ectzera" },
            { "CI", "Costa de Av\u00f2riu" },
            { "CK", "\u00ccsulas Cook" },
            { "CL", "Tzile" },
            { "CM", "Camer\u00f9n" },
            { "CN", "Tzina" },
            { "CO", "Col\u00f2mbia" },
            { "CP", "\u00ccsula de Clipperton" },
            { "CR", "Costa Rica" },
            { "CU", "Cuba" },
            { "CV", "Cabu birde" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "\u00ccsula de sa Natividade" },
            { "CY", "Tzipru" },
            { "CZ", "Tz\u00e8chia" },
            { "DE", "Germ\u00e0nia" },
            { "DG", "Diego Garcia" },
            { "DJ", "Gibuti" },
            { "DK", "Danimarca" },
            { "DM", "Dominica" },
            { "DO", "Rep\u00f9blica Dominicana" },
            { "DZ", "Algeria" },
            { "EA", "Ceuta e Melilla" },
            { "EC", "\u00c8cuador" },
            { "EE", "Est\u00f2nia" },
            { "EG", "Egitu" },
            { "EH", "Sahara otzidentale" },
            { "ER", "Eritrea" },
            { "ES", "Ispagna" },
            { "ET", "Eti\u00f2pia" },
            { "EU", "Unione Europea" },
            { "EZ", "Eurozona" },
            { "FI", "Finl\u00e0ndia" },
            { "FJ", "Fiji" },
            { "FK", "\u00ccsulas Falkland" },
            { "FM", "Micron\u00e8sia" },
            { "FO", "\u00ccsulas F\u00f8royar" },
            { "FR", "Frantza" },
            { "GA", "Gab\u00f2n" },
            { "GB", "Regnu Unidu" },
            { "GD", "Grenada" },
            { "GE", "Ge\u00f2rgia" },
            { "GF", "Guiana frantzesa" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Gibilterra" },
            { "GL", "Groenl\u00e0ndia" },
            { "GM", "G\u00e0mbia" },
            { "GN", "Guinea" },
            { "GP", "Guadalupa" },
            { "GQ", "Guinea Ecuadoriale" },
            { "GR", "Gr\u00e8tzia" },
            { "GS", "Ge\u00f2rgia de su Sud e \u00ccsulas Sandwich Australes" },
            { "GT", "Guatemala" },
            { "GU", "Gu\u00e0m" },
            { "GW", "Guinea-Bissau" },
            { "GY", "Guyana" },
            { "HK", "RAS tzinesa de Hong Kong" },
            { "HM", "\u00ccsulas Heard e McDonald" },
            { "HN", "Honduras" },
            { "HR", "Cro\u00e0tzia" },
            { "HT", "Haiti" },
            { "HU", "Ungheria" },
            { "IC", "\u00ccsulas Can\u00e0rias" },
            { "ID", "Indon\u00e8sia" },
            { "IE", "Irlanda" },
            { "IL", "Israele" },
            { "IM", "\u00ccsula de Man" },
            { "IN", "\u00ccndia" },
            { "IO", "Territ\u00f2riu Brit\u00e0nnicu de s\u2019Otz\u00e8anu Indianu" },
            { "IQ", "Iraq" },
            { "IR", "Ir\u00e0n" },
            { "IS", "Islanda" },
            { "IT", "It\u00e0lia" },
            { "JE", "Jersey" },
            { "JM", "Giam\u00e0ica" },
            { "JO", "Giord\u00e0nia" },
            { "JP", "Giapone" },
            { "KE", "K\u00e8nya" },
            { "KG", "Kirgh\u00eczistan" },
            { "KH", "Camb\u00f2dia" },
            { "KI", "Kiribati" },
            { "KM", "Comoras" },
            { "KN", "Santu Cristolu e Nevis" },
            { "KP", "Corea de su Nord" },
            { "KR", "Corea de su Sud" },
            { "KW", "Kuwait" },
            { "KY", "\u00ccsulas Cayman" },
            { "KZ", "Kaz\u00e0kistan" },
            { "LA", "Laos" },
            { "LB", "L\u00e8banu" },
            { "LC", "Santa Lughia" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Lib\u00e8ria" },
            { "LS", "Lesotho" },
            { "LT", "Litu\u00e0nia" },
            { "LU", "Lussemburgu" },
            { "LV", "Let\u00f2nia" },
            { "LY", "L\u00ecbia" },
            { "MA", "Marocu" },
            { "MC", "M\u00f2nacu" },
            { "MD", "Mold\u00e0via" },
            { "ME", "Montenegro" },
            { "MF", "Santu Martine" },
            { "MG", "Madagasc\u00e0r" },
            { "MH", "\u00ccsulas Marshall" },
            { "MK", "Matzed\u00f2nia de su Nord" },
            { "ML", "Mali" },
            { "MM", "Myanm\u00e0r (Birm\u00e0nia)" },
            { "MN", "Mong\u00f2lia" },
            { "MO", "RAS tzinesa de Macao" },
            { "MP", "\u00ccsulas Mariannas setentrionales" },
            { "MQ", "Martinica" },
            { "MR", "Maurit\u00e0nia" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Maur\u00ectzius" },
            { "MV", "Maldivas" },
            { "MW", "Malawi" },
            { "MX", "M\u00e8ssicu" },
            { "MY", "Mal\u00e8sia" },
            { "MZ", "Mozambicu" },
            { "NA", "Nam\u00ecbia" },
            { "NC", "Caled\u00f2nia Noa" },
            { "NE", "Niger" },
            { "NF", "\u00ccsula Norfolk" },
            { "NG", "Nig\u00e8ria" },
            { "NI", "Nicar\u00e0gua" },
            { "NL", "Paisos Bassos" },
            { "NO", "Norv\u00e8gia" },
            { "NP", "N\u00e8pal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Zelanda Noa" },
            { "OM", "Om\u00e0n" },
            { "PA", "P\u00e0nama" },
            { "PE", "Per\u00f9" },
            { "PF", "Polin\u00e8sia frantzesa" },
            { "PG", "P\u00e0pua Guinea Noa" },
            { "PH", "Filipinas" },
            { "PK", "P\u00e0kistan" },
            { "PL", "Pol\u00f2nia" },
            { "PM", "Santu Predu e Miquelon" },
            { "PN", "\u00ccsulas P\u00ectcairn" },
            { "PR", "Puerto Rico" },
            { "PS", "Territ\u00f2rios palestinesos" },
            { "PT", "Portogallu" },
            { "PW", "Palau" },
            { "PY", "Paragu\u00e0y" },
            { "QA", "Catar" },
            { "QO", "Otze\u00e0nia perif\u00e8rica" },
            { "RE", "Riunione" },
            { "RO", "Romania" },
            { "RS", "S\u00e8rbia" },
            { "RU", "R\u00f9ssia" },
            { "RW", "Ruanda" },
            { "SA", "Ar\u00e0bia Saudita" },
            { "SB", "\u00ccsulas Salomone" },
            { "SC", "Seychelles" },
            { "SD", "Sud\u00e0n" },
            { "SE", "Isv\u00e8tzia" },
            { "SG", "Singapore" },
            { "SH", "Santa Elene" },
            { "SI", "Islov\u00e8nia" },
            { "SJ", "Svalbard e Jan Mayen" },
            { "SK", "Islov\u00e0chia" },
            { "SL", "Sierra Leone" },
            { "SM", "Santu Marinu" },
            { "SN", "Senegal" },
            { "SO", "Som\u00e0lia" },
            { "SR", "Suriname" },
            { "SS", "Sudan de su Sud" },
            { "ST", "S\u00e3o Tom\u00e9 e Pr\u00edncipe" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "S\u00ecria" },
            { "SZ", "Eswatini" },
            { "TA", "Tristan da Cunha" },
            { "TC", "\u00ccsulas Turks e Caicos" },
            { "TD", "Chad" },
            { "TF", "Terras australes frantzesas" },
            { "TG", "Togo" },
            { "TH", "Tail\u00e0ndia" },
            { "TJ", "Tag\u00eckistan" },
            { "TK", "Tokelau" },
            { "TL", "Timor-Est" },
            { "TM", "Turkm\u00e8nistan" },
            { "TN", "Tunisia" },
            { "TO", "Tonga" },
            { "TR", "Turchia" },
            { "TT", "Trinidad e Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiw\u00e0n" },
            { "TZ", "Tanz\u00e0nia" },
            { "UA", "Ucraina" },
            { "UG", "Uganda" },
            { "UM", "\u00ccsulas perif\u00e8ricas de sos Istados Unidos" },
            { "UN", "Natziones Unidas" },
            { "US", "Istados Unidos" },
            { "UY", "Urugu\u00e0y" },
            { "UZ", "Uzb\u00e8kistan" },
            { "VA", "Tzitade de su Vaticanu" },
            { "VC", "Santu Vissente e sas Grenadinas" },
            { "VE", "Venetzuela" },
            { "VG", "\u00ccsulas V\u00e8rgines Brit\u00e0nnicas" },
            { "VI", "\u00ccsulas V\u00e8rgines de sos Istados Unidos" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis e Futuna" },
            { "WS", "Samoa" },
            { "XA", "ps\u00e8udo-atzentos" },
            { "XB", "ps\u00e8udo-bidi" },
            { "XK", "K\u00f2ssovo" },
            { "YE", "Yemen" },
            { "YT", "Mayotte" },
            { "ZA", "Sud\u00e0frica" },
            { "ZM", "Z\u00e0mbia" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "regione disconnota" },
            { "ab", "abcasu" },
            { "af", "afrikaans" },
            { "ak", "akan" },
            { "am", "am\u00e0ricu" },
            { "an", "aragonesu" },
            { "ar", metaValue_ar },
            { "as", "assamesu" },
            { "av", "avaru" },
            { "ay", "aimara" },
            { "az", "azerbaigianu" },
            { "ba", "baschiru" },
            { "be", "bielorussu" },
            { "bg", "b\u00f9lgaru" },
            { "bi", "bislama" },
            { "bm", "bambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "br\u00e8tone" },
            { "bs", "bosn\u00ecacu" },
            { "ca", "catalanu" },
            { "ce", "cecenu" },
            { "ch", "chamorru" },
            { "co", "corsicanu" },
            { "cs", "tzecu" },
            { "cu", "islavu eclesi\u00e0sticu" },
            { "cv", "ciuv\u00e0sciu" },
            { "cy", "gallesu" },
            { "da", "danesu" },
            { "de", "tedescu" },
            { "dv", "malvidianu" },
            { "dz", "dzongkha" },
            { "ee", "ewe" },
            { "el", metaValue_el },
            { "en", "inglesu" },
            { "eo", "esperanto" },
            { "es", "ispagnolu" },
            { "et", "\u00e8stone" },
            { "eu", "bascu" },
            { "fa", "persianu" },
            { "ff", "fulah" },
            { "fi", "finlandesu" },
            { "fj", "fijianu" },
            { "fo", "faroesu" },
            { "fr", "frantzesu" },
            { "fy", "frisone otzidentale" },
            { "ga", "irlandesu" },
            { "gd", "ga\u00e8licu iscotzesu" },
            { "gl", "galitzianu" },
            { "gn", "guaran\u00ec" },
            { "gu", metaValue_gu },
            { "gv", "mannesu" },
            { "ha", "hausa" },
            { "he", "ebreu" },
            { "hi", "hindi" },
            { "hr", "croatu" },
            { "ht", "cr\u00e8olu haitianu" },
            { "hu", "ungheresu" },
            { "hy", metaValue_hy },
            { "hz", "herero" },
            { "ia", "interl\u00ecngua" },
            { "id", "indonesianu" },
            { "ig", "igbo" },
            { "ii", "sichuan yi" },
            { "io", "ido" },
            { "is", "islandesu" },
            { "it", "italianu" },
            { "iu", "inuktitut" },
            { "ja", metaValue_ja },
            { "jv", metaValue_jv },
            { "ka", metaValue_ka },
            { "ki", "kikuyu" },
            { "kj", "kuanyama" },
            { "kk", "kazacu" },
            { "kl", "groenlandesu" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "kanuri" },
            { "ks", "kashmiri" },
            { "ku", "curdu" },
            { "kv", "komi" },
            { "kw", metaValue_kw },
            { "ky", "chirghisu" },
            { "la", metaValue_la },
            { "lb", "lussemburghesu" },
            { "lg", "ganda" },
            { "li", "limburghesu" },
            { "ln", "lingala" },
            { "lo", metaValue_lo },
            { "lt", "lituanu" },
            { "lu", "luba-katanga" },
            { "lv", "l\u00e8tone" },
            { "mg", "malg\u00e0sciu" },
            { "mh", "marshallesu" },
            { "mi", "maori" },
            { "mk", "matz\u00e8done" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "marathi" },
            { "ms", "malesu" },
            { "mt", "maltesu" },
            { "my", "burmesu" },
            { "na", "nauru" },
            { "nb", "norvegesu bokm\u00e5l" },
            { "nd", "ndebele de su nord" },
            { "ne", "nepalesu" },
            { "ng", "ndonga" },
            { "nl", "olandesu" },
            { "nn", "norvegesu nynorsk" },
            { "no", "norvegesu" },
            { "nr", "ndebele de su sud" },
            { "nv", "navajo" },
            { "ny", "nyanja" },
            { "oc", "otzitanu" },
            { "om", "oromo" },
            { "or", metaValue_or },
            { "os", "oss\u00e8ticu" },
            { "pa", "punjabi" },
            { "pl", "polacu" },
            { "ps", "pashto" },
            { "pt", "portoghesu" },
            { "qu", "quechua" },
            { "rm", "rom\u00e0nciu" },
            { "rn", "rundi" },
            { "ro", "rumenu" },
            { "ru", "russu" },
            { "rw", "kinyarwanda" },
            { "sa", "s\u00e0nscritu" },
            { "sc", "sardu" },
            { "sd", "sindhi" },
            { "se", "sami setentrionale" },
            { "sg", "sango" },
            { "si", metaValue_si },
            { "sk", "islovacu" },
            { "sl", "islovenu" },
            { "sm", "samoanu" },
            { "sn", "shona" },
            { "so", "s\u00f2malu" },
            { "sq", "albanesu" },
            { "sr", "serbu" },
            { "ss", "swati" },
            { "st", "sotho meridionale" },
            { "su", metaValue_su },
            { "sv", "isvedesu" },
            { "sw", "swahili" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "tagicu" },
            { "th", metaValue_th },
            { "ti", "tigrignu" },
            { "tk", "turcmenu" },
            { "tn", "tswana" },
            { "to", "tonganu" },
            { "tr", "turcu" },
            { "ts", "tsonga" },
            { "tt", "t\u00e0taru" },
            { "ty", "taitianu" },
            { "ug", "uiguru" },
            { "uk", "ucrainu" },
            { "ur", "urdu" },
            { "uz", "uzbecu" },
            { "ve", "venda" },
            { "vi", "vietnamita" },
            { "vo", "volap\u00fck" },
            { "wa", "vallonu" },
            { "wo", "wolof" },
            { "xh", "xhosa" },
            { "yi", "yiddish" },
            { "yo", "yoruba" },
            { "zh", "tzinesu" },
            { "zu", "zulu" },
            { "ace", "acehnesu" },
            { "ada", "adangme" },
            { "ady", "adigh\u00e8" },
            { "agq", "aghem" },
            { "ain", "\u00e0inu" },
            { "ale", "aleutinu" },
            { "alt", "altai meridionale" },
            { "ann", "obolo" },
            { "anp", "angika" },
            { "arn", "mapudungun" },
            { "arp", "arapaho" },
            { "ars", "\u00e0rabu najdi" },
            { "asa", "asu" },
            { "ast", "asturianu" },
            { "atj", "atikamekw" },
            { "awa", "awadhi" },
            { "ban", metaValue_ban },
            { "bas", "basaa" },
            { "bem", "bemba" },
            { "bez", "bena" },
            { "bho", "bhojpuri" },
            { "bin", "bini" },
            { "bla", "pees nieddos" },
            { "brx", "bodo" },
            { "bug", metaValue_bug },
            { "byn", "blin" },
            { "cay", "cayuga" },
            { "ccp", metaValue_ccp },
            { "ceb", "cebuanu" },
            { "cgg", "chiga" },
            { "chk", "chuukesu" },
            { "chm", "mari" },
            { "cho", "choctaw" },
            { "chp", "chipewyan" },
            { "chr", metaValue_chr },
            { "chy", "cheyenne" },
            { "ckb", "curdu tzentrale" },
            { "clc", "chilcotin" },
            { "crg", "michif" },
            { "crj", "cree sud-orientale" },
            { "crk", "cree de sas campuras" },
            { "crl", "cree nord-orientale" },
            { "crm", "cree moose" },
            { "crr", "algonchinu de sa Carolina" },
            { "csw", "cree de sas paludes" },
            { "dak", "dakota" },
            { "dar", "dargua" },
            { "dav", "taita" },
            { "dgr", "dogrib" },
            { "dje", "zarma" },
            { "doi", "dogri" },
            { "dsb", "s\u00f2rabu bassu" },
            { "dua", "duala" },
            { "dyo", "jola-fonyi" },
            { "dzg", "dazaga" },
            { "ebu", "embu" },
            { "efi", "efik" },
            { "eka", "ekajuk" },
            { "ewo", "ewondo" },
            { "fil", "filipinu" },
            { "fon", "fon" },
            { "frc", "frantzesu cajun" },
            { "frr", "frisone setentrionale" },
            { "fur", "friulanu" },
            { "gaa", "ga" },
            { "gez", "ge\u2019ez" },
            { "gil", "gilbertesu" },
            { "gor", "gorontalo" },
            { "gsw", "tedescu isv\u00ectzeru" },
            { "guz", "gusii" },
            { "gwi", "gwich\u02bcin" },
            { "hai", "haida" },
            { "haw", "hawaianu" },
            { "hax", "haida meridionale" },
            { "hil", "ilongu" },
            { "hmn", "hmong" },
            { "hsb", "s\u00f2rabu artu" },
            { "hup", "hupa" },
            { "hur", "halkomelem" },
            { "iba", "iban" },
            { "ibb", "ibibio" },
            { "ikt", "inuktitut canadesu otzidentale" },
            { "ilo", "ilocanu" },
            { "inh", "ing\u00f9sciu" },
            { "jbo", "lojban" },
            { "jgo", "ngomba" },
            { "jmc", "machame" },
            { "kab", "cabilu" },
            { "kac", "kachin" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "kbd", "cabardianu" },
            { "kcg", "tyap" },
            { "kde", "makonde" },
            { "kea", "cabubirdianu" },
            { "kfo", "koro" },
            { "kgp", "kaingang" },
            { "kha", "khasi" },
            { "khq", "koyra chiini" },
            { "kkj", "kako" },
            { "kln", "kalenjin" },
            { "kmb", "kimbundu" },
            { "kok", "konkani" },
            { "kpe", "kpelle" },
            { "krc", "caraciai-balcaru" },
            { "krl", "carelianu" },
            { "kru", "kurukh" },
            { "ksb", "shambala" },
            { "ksf", "bafia" },
            { "ksh", "coloniesu" },
            { "kum", "cumucu" },
            { "kwk", "kwak\u02bcwala" },
            { "lad", "giudeu-ispagnolu" },
            { "lag", "langi" },
            { "lez", "lezghianu" },
            { "lij", "l\u00ecgure" },
            { "lil", "lillooet" },
            { "lkt", "lakota" },
            { "lou", "cr\u00e8olu de sa Louisiana" },
            { "loz", "lozi" },
            { "lrc", "luri setentrionale" },
            { "lsm", "s\u00e0mia" },
            { "lua", "tshiluba" },
            { "lun", "lunda" },
            { "luo", "luo" },
            { "lus", "mizo" },
            { "luy", "luyia" },
            { "mad", "maduresu" },
            { "mag", "magahi" },
            { "mai", "maithili" },
            { "mak", "makassaresu" },
            { "mas", "masai" },
            { "mdf", "moksha" },
            { "men", metaValue_men },
            { "mer", "meru" },
            { "mfe", "cr\u00e8olu mauritzianu" },
            { "mgh", "makhuwa-meetto" },
            { "mgo", "meta\u2019" },
            { "mic", "micmac" },
            { "min", "minangkabau" },
            { "mni", "manipuri" },
            { "moe", "innu-aimun" },
            { "moh", "mohawk" },
            { "mos", "moore" },
            { "mua", "mundang" },
            { "mul", "limbas m\u00f9ltiplas" },
            { "mus", "muscogee" },
            { "mwl", "mirandesu" },
            { "myv", "erzya" },
            { "mzn", "mazandarani" },
            { "nap", "napoletanu" },
            { "naq", "nama" },
            { "nds", "tedescu bassu" },
            { "new", "nepal bhasa" },
            { "nia", "nias" },
            { "niu", "niueanu" },
            { "nmg", "kwasio" },
            { "nnh", "ngiemboon" },
            { "nog", "nogai" },
            { "nqo", metaValue_nqo },
            { "nso", "sotho setentrionale" },
            { "nus", "nuer" },
            { "nyn", "nyankole" },
            { "ojb", "ojibwa nord-otzidentale" },
            { "ojc", "ojibwa tzentrale" },
            { "ojs", "oji-Cree" },
            { "ojw", "ojibwa otzidentale" },
            { "oka", "okanagan" },
            { "pag", "pangasinan" },
            { "pam", "pampanga" },
            { "pap", "papiamentu" },
            { "pau", "palauanu" },
            { "pcm", "pidgin nigerianu" },
            { "pis", "pijin" },
            { "pqm", "malecite-passamaquoddy" },
            { "prg", "prussianu" },
            { "rap", "rapanui" },
            { "rar", "rarotonganu" },
            { "rhg", "rohingya" },
            { "rof", "rombo" },
            { "rup", "arumenu" },
            { "rwk", "rwa" },
            { "sad", "sandawe" },
            { "sah", "yakut" },
            { "saq", "samburu" },
            { "sat", "santali" },
            { "sba", "ngambay" },
            { "sbp", "sangu" },
            { "scn", "sitzilianu" },
            { "sco", "scots" },
            { "seh", "sena" },
            { "ses", "koyraboro senni" },
            { "shi", "tashelhit" },
            { "shn", "shan" },
            { "slh", "lushootseed meridionale" },
            { "smn", "sami de sos inari" },
            { "sms", "sami skolt" },
            { "snk", "soninke" },
            { "srn", "sranan tongo" },
            { "str", "salish de sas astrinturas" },
            { "suk", "sukuma" },
            { "swb", "comorianu" },
            { "syr", metaValue_syr },
            { "tce", "tutchone meridionale" },
            { "tem", "temne" },
            { "teo", "teso" },
            { "tet", "tetum" },
            { "tgx", "tagish" },
            { "tht", "tahltan" },
            { "tig", "tigr\u00e8" },
            { "tlh", "klingon" },
            { "tli", "tlingit" },
            { "tok", "toki pona" },
            { "tpi", "tok pisin" },
            { "trv", "taroko" },
            { "ttm", "tutchone setentrionale" },
            { "tum", "tumbuka" },
            { "tvl", "tuvalu" },
            { "twq", "tasawaq" },
            { "tyv", "tuvanu" },
            { "tzm", "tamazight de s\u2019Atl\u00e0nte tzentrale" },
            { "udm", "udmurtu" },
            { "umb", "umbundu" },
            { "und", "limba disconnota" },
            { "vai", metaValue_vai },
            { "vec", "v\u00e8netu" },
            { "vun", "vunjo" },
            { "wae", "walser" },
            { "wal", "wolaita" },
            { "war", "waray" },
            { "wuu", "wu" },
            { "xal", "calmucu" },
            { "xog", "soga" },
            { "yav", "yangben" },
            { "ybb", "yemba" },
            { "yrl", "nheengatu" },
            { "yue", "cantonesu" },
            { "zgh", "tamazight istandard marochinu" },
            { "zun", "zuni" },
            { "zxx", "perunu cuntenutu lingu\u00ecsticu" },
            { "zza", "zazaki" },
            { "Adlm", "adlam" },
            { "Aghb", "albanesu cauc\u00e0sicu" },
            { "Ahom", "ahom" },
            { "Arab", metaValue_ar },
            { "Aran", "nasta\u02bfl\u012bq" },
            { "Armi", "aram\u00e0icu imperiale" },
            { "Armn", metaValue_hy },
            { "Avst", "av\u00e8sticu" },
            { "Bali", metaValue_ban },
            { "Bamu", "bamum" },
            { "Bass", "bassa vah" },
            { "Batk", "batak" },
            { "Beng", metaValue_bn },
            { "Bhks", "bhaiksuki" },
            { "Bopo", "bopomofo" },
            { "Brah", "brahmi" },
            { "Brai", "braille" },
            { "Bugi", metaValue_bug },
            { "Buhd", "buhid" },
            { "Cakm", metaValue_ccp },
            { "Cans", "sillab\u00e0riu abor\u00ecgenu canadesu unificadu" },
            { "Cari", "carian" },
            { "Cham", "cham" },
            { "Cher", metaValue_chr },
            { "Chrs", "cor\u00e0smiu" },
            { "Copt", "coptu" },
            { "Cpmn", "tzipro-min\u00f2icu" },
            { "Cprt", "tzipriotu" },
            { "Cyrl", "tzir\u00ecllicu" },
            { "Deva", "devanagari" },
            { "Diak", "dives akuru" },
            { "Dogr", "dogra" },
            { "Dsrt", "deseret" },
            { "Dupl", "istenografia duployan" },
            { "Egyp", "gerogl\u00ecficos egitzianos" },
            { "Elba", "elbasan" },
            { "Elym", "elim\u00e0icu" },
            { "Ethi", "et\u00ecope" },
            { "Geor", metaValue_ka },
            { "Glag", "glagol\u00ecticu" },
            { "Gong", "gunjala gondi" },
            { "Gonm", "gondi de Masaram" },
            { "Goth", "g\u00f2ticu" },
            { "Gran", "grantha" },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "gurmukhi" },
            { "Hanb", "han cun bopomofo" },
            { "Hang", "hangul" },
            { "Hani", "han" },
            { "Hano", "hanunoo" },
            { "Hans", metaValue_Hans },
            { "Hant", "traditzionale" },
            { "Hatr", "hatran" },
            { "Hebr", "ebr\u00e0icu" },
            { "Hira", "hiragana" },
            { "Hluw", "gerogl\u00ecficos anat\u00f2licos" },
            { "Hmng", "pahawn hmong" },
            { "Hmnp", "nyiakeng puachue hmong" },
            { "Hrkt", "sillab\u00e0rios giaponesos" },
            { "Hung", "ungheresu antigu" },
            { "Ital", "it\u00e0licu antigu" },
            { "Jamo", "jamo" },
            { "Java", metaValue_jv },
            { "Jpan", metaValue_ja },
            { "Kali", "kayah li" },
            { "Kana", "katakana" },
            { "Kawi", "kawi" },
            { "Khar", "kharoshthi" },
            { "Khmr", metaValue_km },
            { "Khoj", "khojki" },
            { "Kits", "iscritura khitan minore" },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Kthi", "kaithi" },
            { "Lana", "lanna" },
            { "Laoo", metaValue_lo },
            { "Latn", metaValue_la },
            { "Lepc", "lepcha" },
            { "Limb", "limbu" },
            { "Lina", "lineare A" },
            { "Linb", "lineare B" },
            { "Lisu", "lisu" },
            { "Lyci", "l\u00ectziu" },
            { "Lydi", "l\u00ecdiu" },
            { "Mahj", "mahajani" },
            { "Maka", "makasar" },
            { "Mand", "mand\u00e0icu" },
            { "Mani", "manicheu" },
            { "Marc", "marchen" },
            { "Medf", "medefaidrin" },
            { "Mend", metaValue_men },
            { "Merc", "corsivu mero\u00ecticu" },
            { "Mero", "mero\u00ecticu" },
            { "Mlym", metaValue_ml },
            { "Modi", "modi" },
            { "Mong", metaValue_mn },
            { "Mroo", "mro" },
            { "Mtei", "meitei mayek" },
            { "Mult", "multani" },
            { "Mymr", "birmanu" },
            { "Nagm", "nag mundari" },
            { "Nand", "nandinagari" },
            { "Narb", "\u00e0rabu setentrionale antigu" },
            { "Nbat", "nabateu" },
            { "Newa", "newa" },
            { "Nkoo", metaValue_nqo },
            { "Nshu", "n\u00fcshu" },
            { "Ogam", "ogham" },
            { "Olck", "ol chiki" },
            { "Orkh", "orkhon" },
            { "Orya", metaValue_or },
            { "Osge", "osage" },
            { "Osma", "osmanya" },
            { "Ougr", "uiguru antigu" },
            { "Palm", "palmirenu" },
            { "Pauc", "pau cin hau" },
            { "Perm", "p\u00e8rmicu antigu" },
            { "Phag", "phags-pa" },
            { "Phli", "pahlavi de sas iscritziones" },
            { "Phlp", "psalter pahlavi" },
            { "Phnx", "fen\u00ectziu" },
            { "Plrd", "pollard miao" },
            { "Prti", "p\u00e0rticu de sas iscritziones" },
            { "Qaag", "zawgyi" },
            { "Rjng", "rejang" },
            { "Rohg", "hanifi rohingya" },
            { "Runr", "r\u00f9nicu" },
            { "Samr", "samaritanu" },
            { "Sarb", "\u00e0rabu meridionale antigu" },
            { "Saur", "saurashtra" },
            { "Sgnw", "limba de sos sinnos" },
            { "Shaw", "shavianu" },
            { "Shrd", "sharada" },
            { "Sidd", "siddham" },
            { "Sind", "khudawadi" },
            { "Sinh", metaValue_si },
            { "Sogd", "sogdianu" },
            { "Sogo", "sogdianu antigu" },
            { "Sora", "sora sompeng" },
            { "Soyo", "soyombo" },
            { "Sund", metaValue_su },
            { "Sylo", "syloti nagri" },
            { "Syrc", metaValue_syr },
            { "Tagb", "tagbanwa" },
            { "Takr", "takri" },
            { "Tale", "tai le" },
            { "Talu", "tai lue nou" },
            { "Taml", metaValue_ta },
            { "Tang", "tangut" },
            { "Tavt", "tai viet" },
            { "Telu", metaValue_te },
            { "Tfng", "tifinagh" },
            { "Tglg", "tagalog" },
            { "Thaa", "thaana" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Tirh", "tirhuta" },
            { "Tnsa", "tangsa" },
            { "Toto", "toto" },
            { "Ugar", "ugar\u00ecticu" },
            { "Vaii", metaValue_vai },
            { "Vith", "vithkuqi" },
            { "Wara", "varang kshiti" },
            { "Wcho", "wancho" },
            { "Xpeo", "persianu antigu" },
            { "Xsux", "cuneiforme sumero-ac\u00e0dicu" },
            { "Yezi", "yezidi" },
            { "Yiii", "yi" },
            { "Zanb", "zanabar cuadradu" },
            { "Zinh", "eredadu" },
            { "Zmth", "notatzione matem\u00e0tica" },
            { "Zsye", "emoji" },
            { "Zsym", "s\u00ecmbulos" },
            { "Zxxx", "no iscritu" },
            { "Zyyy", "comune" },
            { "Zzzz", "iscritura disconnota" },
            { "de_AT", "tedescu austr\u00ecacu" },
            { "de_CH", "tedescu artu isv\u00ectzeru" },
            { "en_AU", "inglesu australianu" },
            { "en_CA", "inglesu canadesu" },
            { "en_GB", "inglesu brit\u00e0nnicu" },
            { "en_US", "inglesu americanu" },
            { "es_ES", "ispagnolu europeu" },
            { "es_MX", "ispagnolu messicanu" },
            { "fa_AF", "dari" },
            { "fr_CA", "frantzesu canadesu" },
            { "fr_CH", "frantzesu isv\u00ectzeru" },
            { "nl_BE", "fiammingu" },
            { "pt_BR", "portoghesu brasilianu" },
            { "pt_PT", "portoghesu europeu" },
            { "ro_MD", "moldavu" },
            { "sw_CD", "swahili de su Congo" },
            { "%%1901", "ortografia traditzionale tedesca" },
            { "%%1994", "ortografia resiana istandardizada" },
            { "%%1996", "ortografia tedesca de su 1996" },
            { "ar_001", "\u00e0rabu modernu istandard" },
            { "es_419", "ispagnolu latinoamericanu" },
            { "key.ca", "calend\u00e0riu" },
            { "key.cf", "formadu de valuta" },
            { "key.co", "ordinamentu" },
            { "key.cu", "valuta" },
            { "key.hc", "sistema or\u00e0riu (12 o 24 oras)" },
            { "key.lb", "casta de truncadura de l\u00ecnia" },
            { "key.ms", "sistema de medida" },
            { "key.nu", "n\u00f9meros" },
            { "nds_NL", "s\u00e0ssone bassu" },
            { "%%ALUKU", "dialetu aluku" },
            { "%%BARLA", "grupu dialetale barlavento de su cabubirdianu" },
            { "%%BISKE", "dialetu de Santu Giorghi/Bila" },
            { "%%BOONT", "boontling" },
            { "%%CORNU", metaValue_kw },
            { "%%GALLO", "gallu" },
            { "%%JAUER", "dialetu jauer" },
            { "%%KKCOR", "ortografia comuna" },
            { "%%KSCOR", "ortografia istandard" },
            { "%%LIPAW", "su dialetu lipovaz de su resianu" },
            { "%%NEDIS", "dialetu de Natisone" },
            { "%%NJIVA", "dialetu de Gniva/Njiva" },
            { "%%NULIK", "volap\u00fck modernu" },
            { "%%OSOJS", "dialetu de Oseacco/Osojane" },
            { "%%PEANO", "interlingua de peano" },
            { "%%POSIX", "inform\u00e0ticu" },
            { "%%PUTER", "puter" },
            { "%%RIGIK", "volap\u00fck cl\u00e0ssicu" },
            { "%%ROZAJ", "resianu" },
            { "%%RUMGR", "istandard de sos Grisones" },
            { "%%SAAHO", "saho" },
            { "%%SOLBA", "dialetu de Stolvizza/Solbica" },
            { "%%SOTAV", "grupu dialetale sotavento de su cabubirdianu" },
            { "%%UCCOR", "ortografia unificada" },
            { "hi_Latn", "hindi (car\u00e0teres latinos)" },
            { "zh_Hans", "tzinesu semplificadu" },
            { "zh_Hant", "tzinesu traditzionale" },
            { "%%AO1990", "acordu ortogr\u00e0ficu de sa limba portoghesa de su 1990" },
            { "%%ARANES", "aranesu" },
            { "%%ASANTE", "asante" },
            { "%%AUVERN", "auvernesu" },
            { "%%CISAUP", "cisalpinu" },
            { "%%CREISS", "creschente" },
            { "%%DAJNKO", "alfabetu Dajnko" },
            { "%%EKAVSK", "serbu cun pron\u00f9ntzia ekaviana" },
            { "%%FONIPA", "alfabetu fon\u00e8ticu internatzionale IPA" },
            { "%%FONUPA", "alfabetu fon\u00e8ticu ur\u00e0licu UPA" },
            { "%%GASCON", "gasconu" },
            { "%%GRITAL", "ortografia otzitana italianizada" },
            { "%%NDYUKA", "dialetu ndyuka" },
            { "%%NICARD", "nitzardu" },
            { "%%PAMAKA", "dialetu pamaka" },
            { "%%PINYIN", "romanizatzione pinyin" },
            { "%%SCOUSE", "scouse" },
            { "%%SIMPLE", metaValue_Hans },
            { "%%TARASK", "ortografia tara\u0161kievica" },
            { "%%UCRCOR", "ortografia revisionada unificada" },
            { "%%ULSTER", "ortografia de s\u2019Ulster" },
            { "%%UNIFON", "alfabetu fon\u00e8ticu Unifon" },
            { "%%ABL1943", "formulatzione ortogr\u00e0fica de su 1943" },
            { "%%AKUAPEM", "akuapem" },
            { "%%ALALC97", "romanizatzione de ALA-LC, versione de su 1997" },
            { "%%ARKAIKA", "esperanto arc\u00e0icu" },
            { "%%BALANKA", "dialetu balanka de s\u2019anii" },
            { "%%BAUDDHA", "variante \u00ecbrida buddhista" },
            { "%%BOHORIC", "alfabetu Bohori\u010d" },
            { "%%EMODENG", "primu inglesu modernu" },
            { "%%FONNAPA", "alfabetu fon\u00e8ticu de s\u2019Am\u00e8rica setentrionale" },
            { "%%GRCLASS", "ortografia otzitana cl\u00e0ssica" },
            { "%%GRMISTR", "ortografia otzitana mistraliana" },
            { "%%HEPBURN", "romanizatzione Hepburn" },
            { "%%ITIHASA", "variante \u00e8pica induista" },
            { "%%LAUKIKA", "variante cl\u00e0ssica" },
            { "%%LEMOSIN", "limosinu" },
            { "%%METELKO", "alfabetu Metelko" },
            { "%%MONOTON", "monot\u00f2nicu" },
            { "%%PAHAWH2", "ortografia reduida pahawh hmong fase 2" },
            { "%%PAHAWH3", "ortografia reduida pahawh hmong fase 3" },
            { "%%PAHAWH4", "ortografia reduida pahawh hmong fase 4" },
            { "%%POLYTON", "polit\u00f2nicu" },
            { "%%PROVENC", "proventzale" },
            { "%%REVISED", "ortografia revisionada" },
            { "%%SURSILV", "sursilvanu" },
            { "%%SUTSILV", "sutsilvanu" },
            { "%%VAIDIKA", "variante v\u00e8dica" },
            { "%%1606NICT", "frantzesu m\u00e8diu-tardu finas a su 1606" },
            { "%%1694ACAD", "primu frantzesu modernu" },
            { "%%1959ACAD", "acad\u00e8micu" },
            { "%%BAKU1926", "alfabetu latinu turcu unificadu" },
            { "%%BASICENG", "inglesu b\u00e0sicu" },
            { "%%BISCAYAN", "bizcaianu" },
            { "%%BORNHOLM", "bornholmesu" },
            { "%%COLB1945", "cunventzione ortogr\u00e0fica portoghesa-brasiliana de su 1945" },
            { "%%FONKIRSH", "alfabetu fon\u00e8ticu de Kirshenbaum" },
            { "%%FONXSAMP", "alfabetu fon\u00e8ticu X-SAMPA" },
            { "%%HOGNORSK", "variante de norvegesu artu (h\u00f8gnorsk)" },
            { "%%HSISTEMO", "sistema ortogr\u00e0ficu H de s\u2019esperanto" },
            { "%%IJEKAVSK", "serbu cun pron\u00f9ntzia ijekaviana" },
            { "%%IVANCHOV", "ortografia b\u00f9lgara de Ivanchov de su 1899" },
            { "%%JYUTPING", "romanizatzione jyutping" },
            { "%%KOCIEWIE", "variante kochieviana" },
            { "%%LENGADOC", "languedocianu" },
            { "%%LUNA1918", "ortografia russa riformada de su 1918" },
            { "%%NEWFOUND", "inglesu de Terranova" },
            { "%%OXENDICT", "ortografia inglesa de su ditzion\u00e0riu de Oxford" },
            { "%%PETR1708", "ortografia de Perdu I de su 1708" },
            { "%%SCOTLAND", "inglesu istandard iscotzesu" },
            { "%%SPANGLIS", "spanglish" },
            { "%%SURMIRAN", "surmiranu" },
            { "%%SYNNEJYL", "jutlandesu meridionale" },
            { "%%TONGYONG", "romanizatzione pinyin tongyong" },
            { "%%TUNUMIIT", "groenlandesu orientale" },
            { "%%VALENCIA", "valentzianu" },
            { "%%VALLADER", "vallader" },
            { "%%VECDRUKA", "ortografia l\u00e8tone vec\u0101 druka" },
            { "%%VIVARAUP", "vivaro-alpinu" },
            { "%%WADEGILE", "romanizatzione Wale-Giles" },
            { "%%XSISTEMO", "sistema ortogr\u00e0ficu X de s\u2019esperanto" },
            { "type.ca.roc", "calend\u00e0riu minguo" },
            { "type.co.eor", "r\u00e8gulas de ordinamentu europeas" },
            { "type.hc.h11", "sistema or\u00e0riu a 12 oras (0\u201311)" },
            { "type.hc.h12", "sistema or\u00e0riu a 12 oras (1\u201312)" },
            { "type.hc.h23", "sistema or\u00e0riu a 24 oras (0\u201323)" },
            { "type.hc.h24", "sistema or\u00e0riu a 24 oras (1\u201324)" },
            { "type.nu.ahom", "tzifras ahom" },
            { "type.nu.arab", "tzifras indo-\u00e0rabas" },
            { "type.nu.armn", "n\u00f9meros armenos" },
            { "type.nu.bali", "tzifras balinesas" },
            { "type.nu.beng", "tzifras bengalesas" },
            { "type.nu.brah", "tzifras brahmi" },
            { "type.nu.cakm", "tzifras chakma" },
            { "type.nu.cham", "tzifras cham" },
            { "type.nu.cyrl", "tzifras tzir\u00ecllicas" },
            { "type.nu.deva", "tzifras devanagari" },
            { "type.nu.diak", "tzifras dhives akuru" },
            { "type.nu.ethi", "n\u00f9meros et\u00ecopes" },
            { "type.nu.geor", "n\u00f9meros georgianos" },
            { "type.nu.gong", "tzifras gondi gunjala" },
            { "type.nu.gonm", "tzifras gondi masaram" },
            { "type.nu.grek", "n\u00f9meros grecos" },
            { "type.nu.gujr", "tzifras gujarati" },
            { "type.nu.guru", "tzifras gurmukhi" },
            { "type.nu.hans", "n\u00f9meros in tzinesu semplificadu" },
            { "type.nu.hant", "n\u00f9meros in tzinesu traditzionale" },
            { "type.nu.hebr", "n\u00f9meros ebr\u00e0icos" },
            { "type.nu.hmng", "tzifras pahawh hmong" },
            { "type.nu.hmnp", "tzifras nyiakeng puachue hmong" },
            { "type.nu.java", "tzifras giavanesas" },
            { "type.nu.jpan", "n\u00f9meros giaponesos" },
            { "type.nu.kali", "tzifras kayah li" },
            { "type.nu.kawi", "tzifras kawi" },
            { "type.nu.khmr", "tzifras khmer" },
            { "type.nu.knda", "tzifras kannada" },
            { "type.nu.lana", "tzifras tai tham hora" },
            { "type.nu.laoo", "tzifras laotianas" },
            { "type.nu.latn", "tzifras otzidentales" },
            { "type.nu.lepc", "tzifras lepcha" },
            { "type.nu.limb", "tzifras limbu" },
            { "type.nu.mlym", "tzifras malayam" },
            { "type.nu.modi", "tzifras modi" },
            { "type.nu.mong", "tzifras m\u00f2ngolas" },
            { "type.nu.mroo", "tzifras mro" },
            { "type.nu.mtei", "tzifras meitei mayek" },
            { "type.nu.mymr", "tzifras birmanas" },
            { "type.nu.nagm", "tzifras nag mundari" },
            { "type.nu.nkoo", "tzifras n\u2019ko" },
            { "type.nu.olck", "tzifras ol chiki" },
            { "type.nu.orya", "tzifras odia" },
            { "type.nu.osma", "tzifras osmanya" },
            { "type.nu.rohg", "tzifras rohingya hanifi" },
            { "type.nu.saur", "tzifras saurashtra" },
            { "type.nu.shrd", "tzifras sharada" },
            { "type.nu.sind", "tzifras khudawadi" },
            { "type.nu.sinh", "tzifras lith singalesas" },
            { "type.nu.sora", "tzifras sora sompeng" },
            { "type.nu.sund", "tzifras sundanesas" },
            { "type.nu.takr", "tzifras takri" },
            { "type.nu.talu", "tzifras tai lue noas" },
            { "type.nu.taml", "n\u00f9meros tamil traditzionales" },
            { "type.nu.telu", "tzifras telugu" },
            { "type.nu.thai", "tzifras tailandesas" },
            { "type.nu.tibt", "tzifras tibetanas" },
            { "type.nu.tirh", "tzifras tirhuta" },
            { "type.nu.tnsa", "tzifras tangsa" },
            { "type.nu.vaii", "tzifras vai" },
            { "type.nu.wara", "tzifras warang citi" },
            { "type.nu.wcho", "tzifras wancho" },
            { "type.ca.dangi", "calend\u00e0riu dangi" },
            { "type.co.ducet", "ordinamentu Unicode predefinidu" },
            { "type.co.emoji", "ordinamentu de sas emoji" },
            { "type.lb.loose", "truncadura de l\u00ecnia facoltativa" },
            { "type.nu.roman", "n\u00f9meros romanos" },
            { "type.ca.coptic", "calend\u00e0riu coptu" },
            { "type.ca.hebrew", "calend\u00e0riu ebr\u00e0icu" },
            { "type.ca.indian", "calend\u00e0riu natzionale indianu" },
            { "type.co.compat", "ordinamentu antepostu, pro cumpatibilitade" },
            { "type.co.pinyin", "ordinamentu pinyin" },
            { "type.co.search", "chirca gen\u00e8rica" },
            { "type.co.stroke", "\u00f2rdine de sos tratos" },
            { "type.co.unihan", "ordinamentu in base a sos radicales" },
            { "type.co.zhuyin", "ordinamentu zhuyin" },
            { "type.lb.normal", "truncadura de l\u00ecnia normale" },
            { "type.lb.strict", "truncadura de l\u00ecnia fortzada" },
            { "type.ms.metric", "sistema m\u00e8tricu" },
            { "type.ca.chinese", "calend\u00e0riu tzinesu" },
            { "type.ca.islamic", "calend\u00e0riu isl\u00e0micu" },
            { "type.ca.iso8601", "calend\u00e0riu ISO-8601" },
            { "type.ca.persian", "calend\u00e0riu persianu" },
            { "type.cf.account", "formadu de valuta cont\u00e0bile" },
            { "type.co.big5han", "ordinamentu de su tzinesu traditzionale - Big5" },
            { "type.nu.arabext", "tzifras indo-\u00e0rabas est\u00e8ndidas" },
            { "type.nu.armnlow", "n\u00f9meros armenos min\u00f9scolos" },
            { "type.nu.greklow", "n\u00f9meros grecos min\u00f9scolos" },
            { "type.nu.hanidec", "n\u00f9meros detzimales tzinesos" },
            { "type.nu.hansfin", "n\u00f9meros finantzi\u00e0rios in tzinesu semplificadu" },
            { "type.nu.hantfin", "n\u00f9meros finantzi\u00e0rios in tzinesu traditzionale" },
            { "type.nu.jpanfin", "n\u00f9meros finantzi\u00e0rios giaponesos" },
            { "type.nu.mathdbl", "tzifras matem\u00e0ticas a tr\u00e0tu d\u00f2piu" },
            { "type.nu.tamldec", "tzifras tamil" },
            { "type.ca.buddhist", "calend\u00e0riu buddhista" },
            { "type.ca.ethiopic", "calend\u00e0riu et\u00ecope" },
            { "type.ca.japanese", "calend\u00e0riu giaponesu" },
            { "type.cf.standard", "formadu de valuta istandard" },
            { "type.co.reformed", "ordinamentu riformadu" },
            { "type.co.searchjl", "chirca pro consonante hangul initziale" },
            { "type.co.standard", "ordinamentu istandard" },
            { "type.ms.uksystem", "sistema imperiale brit\u00e0nnicu" },
            { "type.ms.ussystem", "sistema consuetudin\u00e0riu americanu" },
            { "type.nu.fullwide", "tzifras a larg\u00e0ria intrea" },
            { "type.nu.lanatham", "tzifras tai tham tham" },
            { "type.nu.mathbold", "tzifras matem\u00e0ticas in grussitu" },
            { "type.nu.mathmono", "tzifras matem\u00e0ticas a isp\u00e0tziu s\u00ecngulu" },
            { "type.nu.mathsanb", "tzifras matem\u00e0ticas in grussitu chene gr\u00e0tzias" },
            { "type.nu.mathsans", "tzifras matem\u00e0ticas chene gr\u00e0tzias" },
            { "type.nu.mymrshan", "tzifras shan birmanas" },
            { "type.nu.mymrtlng", "tzifras tai lang birmanas" },
            { "type.nu.romanlow", "n\u00f9meros romanos min\u00f9scolos" },
            { "type.ca.gregorian", "calend\u00e0riu gregorianu" },
            { "type.co.gb2312han", "ordinamentu de su tzinesu semplificadu - GB2312" },
            { "type.co.phonebook", "ordinamentu de s\u2019elencu telef\u00f2nicu" },
            { "type.co.dictionary", "ordinamentu de su ditzion\u00e0riu" },
            { "type.co.traditional", "ordinamentu traditzionale" },
            { "type.ca.islamic-rgsa", "calend\u00e0riu isl\u00e0micu (Ar\u00e0bia Saudita, osservatzione)" },
            { "type.ca.islamic-tbla", "calend\u00e0riu isl\u00e0micu (tabulare, \u00e8poca astron\u00f2mica)" },
            { "type.ca.islamic-civil", "calend\u00e0riu isl\u00e0micu (tabulare, \u00e8poca tzivile)" },
            { "type.ca.islamic-umalqura", "calend\u00e0riu isl\u00e0micu (Umm al-Qura)" },
            { "type.ca.ethiopic-amete-alem", "calend\u00e0riu et\u00ecope Amete Alem" },
        };
        return data;
    }
}
