/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_lb extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "M\u00ebttler Greenwich-Z\u00e4it",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Acre = new String[] {
               "Acre-Normalz\u00e4it",
               "",
               "Acre-Summerz\u00e4it",
               "",
               "Acre-Z\u00e4it",
               "",
            };
        final String[] Cook = new String[] {
               "Cookinselen-Normalz\u00e4it",
               "",
               "Cookinselen-Summerz\u00e4it",
               "",
               "Cookinselen-Z\u00e4it",
               "",
            };
        final String[] Cuba = new String[] {
               "Kubanesch Normalz\u00e4it",
               "CST",
               "Kubanesch Summerz\u00e4it",
               "CDT",
               "Kubanesch Z\u00e4it",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Fidschi-Normalz\u00e4it",
               "",
               "Fidschi-Summerz\u00e4it",
               "",
               "Fidschi-Z\u00e4it",
               "",
            };
        final String[] Gulf = new String[] {
               "Golf-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Hovd-Normalz\u00e4it",
               "",
               "Hovd-Summerz\u00e4it",
               "",
               "Hovd-Z\u00e4it",
               "",
            };
        final String[] Iran = new String[] {
               "Iranesch Normalz\u00e4it",
               "",
               "Iranesch Summerz\u00e4it",
               "",
               "Iranesch Z\u00e4it",
               "",
            };
        final String[] Niue = new String[] {
               "Niue-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Omsk-Normalz\u00e4it",
               "",
               "Omsk-Summerz\u00e4it",
               "",
               "Omsk-Z\u00e4it",
               "",
            };
        final String[] Peru = new String[] {
               "Peruanesch Normalz\u00e4it",
               "",
               "Peruanesch Summerz\u00e4it",
               "",
               "Peruanesch Z\u00e4it",
               "",
            };
        final String[] Truk = new String[] {
               "Chuuk-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Wake-Insel-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Chilenesch Normalz\u00e4it",
               "",
               "Chilenesch Summerz\u00e4it",
               "",
               "Chilenesch Z\u00e4it",
               "",
            };
        final String[] China = new String[] {
               "Chinesesch Normalz\u00e4it",
               "CST",
               "Chinesesch Summerz\u00e4it",
               "CDT",
               "Chinesesch Z\u00e4it",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Kokosinselen-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Davis-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Indesch Z\u00e4it",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Japanesch Normalz\u00e4it",
               "JST",
               "Japanesch Summerz\u00e4it",
               "JDT",
               "Japanesch Z\u00e4it",
               "JT",
            };
        final String[] Korea = new String[] {
               "Koreanesch Normalz\u00e4it",
               "KST",
               "Koreanesch Summerz\u00e4it",
               "KST",
               "Koreanesch Z\u00e4it",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Nauru-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Nepalesesch Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Palau-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Samoa-Normalz\u00e4it",
               "SST",
               "Samoa-Summerz\u00e4it",
               "SST",
               "Samoa-Z\u00e4it",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Syowa-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Tonganesch Normalz\u00e4it",
               "",
               "Tonganesch Summerz\u00e4it",
               "",
               "Tonganesch Z\u00e4it",
               "",
            };
        final String[] Alaska = new String[] {
               "Alaska-Normalz\u00e4it",
               "AKST",
               "Alaska-Summerz\u00e4it",
               "AKDT",
               "Alaska-Z\u00e4it",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Amazonas-Normalz\u00e4it",
               "",
               "Amazonas-Summerz\u00e4it",
               "",
               "Amazonas-Z\u00e4it",
               "",
            };
        final String[] Anadyr = new String[] {
               "Anadyr-Normalz\u00e4it",
               "",
               "Anadyr-Summerz\u00e4it",
               "",
               "Anadyr-Z\u00e4it",
               "",
            };
        final String[] Azores = new String[] {
               "Azoren-Normalz\u00e4it",
               "",
               "Azoren-Summerz\u00e4it",
               "",
               "Azoren-Z\u00e4it",
               "",
            };
        final String[] Bhutan = new String[] {
               "Bhutan-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Brunei-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Ouschterinsel-Normalz\u00e4it",
               "",
               "Ouschterinsel-Summerz\u00e4it",
               "",
               "Ouschterinsel-Z\u00e4it",
               "",
            };
        final String[] Guyana = new String[] {
               "Guyana-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Israelesch Normalz\u00e4it",
               "IST",
               "Israelesch Summerz\u00e4it",
               "IDT",
               "Israelesch Z\u00e4it",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Kosrae-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Mawson-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Moskauer Normalz\u00e4it",
               "MSK",
               "Moskauer Summerz\u00e4it",
               "MSK",
               "Moskauer Z\u00e4it",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Ponape-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "Samara-Normalz\u00e4it",
               "",
               "Samara-Summerz\u00e4it",
               "",
               "Samara-Z\u00e4it",
               "",
            };
        final String[] Tahiti = new String[] {
               "Tahiti-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Taipei-Normalz\u00e4it",
               "CST",
               "Taipei-Summerz\u00e4it",
               "CDT",
               "Taipei-Z\u00e4it",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Tuvalu-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Wostok-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Wallis-a-Futuna-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Arabesch Normalz\u00e4it",
               "",
               "Arabesch Summerz\u00e4it",
               "",
               "Arabesch Z\u00e4it",
               "",
            };
        final String[] Armenia = new String[] {
               "Armenesch Normalz\u00e4it",
               "",
               "Armenesch Summerz\u00e4it",
               "",
               "Armenesch Z\u00e4it",
               "",
            };
        final String[] Bolivia = new String[] {
               "Bolivianesch Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Chatham-Normalz\u00e4it",
               "",
               "Chatham-Summerz\u00e4it",
               "",
               "Chatham-Z\u00e4it",
               "",
            };
        final String[] Ecuador = new String[] {
               "Ecuadorianesch Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Gambier-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Georgesch Normalz\u00e4it",
               "",
               "Georgesch Summerz\u00e4it",
               "",
               "Georgesch Z\u00e4it",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Irkutsk-Normalz\u00e4it",
               "",
               "Irkutsk-Summerz\u00e4it",
               "",
               "Irkutsk-Z\u00e4it",
               "",
            };
        final String[] Magadan = new String[] {
               "Magadan-Normalz\u00e4it",
               "",
               "Magadan-Summerz\u00e4it",
               "",
               "Magadan-Z\u00e4it",
               "",
            };
        final String[] Myanmar = new String[] {
               "Myanmar-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Norfolkinselen-Normalz\u00e4it",
               "",
               "Norfolkinselen-Summerz\u00e4it",
               "",
               "Norfolkinselen-Z\u00e4it",
               "",
            };
        final String[] Noronha = new String[] {
               "Fernando-de-Noronha-Normalz\u00e4it",
               "",
               "Fernando-de-Noronha-Summerz\u00e4it",
               "",
               "Fernando-de-Noronha-Z\u00e4it",
               "",
            };
        final String[] Reunion = new String[] {
               "R\u00e9union-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Rothera-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Salomoninselen-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Tokelau-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Uruguyanesch Normalz\u00e4it",
               "",
               "Uruguayanesch Summerz\u00e4it",
               "",
               "Uruguayanesch Z\u00e4it",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Vanuatu-Normalz\u00e4it",
               "",
               "Vanuatu-Summerz\u00e4it",
               "",
               "Vanuatu-Z\u00e4it",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Jakutsk-Normalz\u00e4it",
               "",
               "Jakutsk-Summerz\u00e4it",
               "",
               "Jakutsk-Z\u00e4it",
               "",
            };
        final String[] Atlantic = new String[] {
               "Atlantik-Normalz\u00e4it",
               "AST",
               "Atlantik-Summerz\u00e4it",
               "AST",
               "Atlantik-Z\u00e4it",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "Bras\u00edlia-Normalz\u00e4it",
               "",
               "Bras\u00edlia-Summerz\u00e4it",
               "",
               "Bras\u00edlia-Z\u00e4it",
               "",
            };
        final String[] Chamorro = new String[] {
               "Chamorro-Z\u00e4it",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Kolumbianesch Normalz\u00e4it",
               "",
               "Kolumbianesch Summerz\u00e4it",
               "",
               "Kolumbianesch Z\u00e4it",
               "",
            };
        final String[] Falkland = new String[] {
               "Falklandinselen-Normalz\u00e4it",
               "",
               "Falklandinselen-Summerz\u00e4it",
               "",
               "Falklandinselen-Z\u00e4it",
               "",
            };
        final String[] Malaysia = new String[] {
               "Malaysesch Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Maldiven-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Ulaanbaatar-Normalz\u00e4it",
               "",
               "Ulaanbaatar-Summerz\u00e4it",
               "",
               "Ulaanbaatar-Z\u00e4it",
               "",
            };
        final String[] Pakistan = new String[] {
               "Pakistanesch Normalz\u00e4it",
               "PKT",
               "Pakistanesch Summerz\u00e4it",
               "PKST",
               "Pakistanesch Z\u00e4it",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Paraguayanesch Normalz\u00e4it",
               "",
               "Paraguayanesch Summerz\u00e4it",
               "",
               "Paraguayanesch Z\u00e4it",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Pitcairninselen-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Sakhalin-Normalz\u00e4it",
               "",
               "Sakhalin-Summerz\u00e4it",
               "",
               "Sakhalin-Z\u00e4it",
               "",
            };
        final String[] Suriname = new String[] {
               "Suriname-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Argentinesch Normalz\u00e4it",
               "",
               "Argentinesch Summerz\u00e4it",
               "",
               "Argentinesch Z\u00e4it",
               "",
            };
        final String[] Christmas = new String[] {
               "Chr\u00ebschtdagsinsel-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Galapagos-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Hong-Kong-Normalz\u00e4it",
               "HKT",
               "Hong-Kong-Summerz\u00e4it",
               "HKST",
               "Hong-Kong-Z\u00e4it",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Indochina-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Kamtschatka-Normalz\u00e4it",
               "",
               "Kamtschatka-Summerz\u00e4it",
               "",
               "Kamtschatka-Z\u00e4it",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Kirgisistan-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Lord-Howe-Normalz\u00e4it",
               "",
               "Lord-Howe-Summerz\u00e4it",
               "",
               "Lord-Howe-Z\u00e4it",
               "",
            };
        final String[] Marquesas = new String[] {
               "Marquesas-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Mauritius-Normalz\u00e4it",
               "",
               "Mauritius-Summerz\u00e4it",
               "",
               "Mauritius-Z\u00e4it",
               "",
            };
        final String[] Singapore = new String[] {
               "Singapur-Standardz\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Venezuela-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Wolgograd-Normalz\u00e4it",
               "MSK",
               "Wolgograd-Summerz\u00e4it",
               "MSK",
               "Wolgograd-Z\u00e4it",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "Aserbeidschanesch Normalz\u00e4it",
               "",
               "Aserbaidschanesch Summerz\u00e4it",
               "",
               "Aserbaidschanesch Z\u00e4it",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Bangladesch-Normalz\u00e4it",
               "",
               "Bangladesch-Summerz\u00e4it",
               "",
               "Bangladesch-Z\u00e4it",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Kap-Verde-Normalz\u00e4it",
               "",
               "Kap-Verde-Summerz\u00e4it",
               "",
               "Kap-Verde-Z\u00e4it",
               "",
            };
        final String[] EMPTY_ZONE = new String[] {
               "",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] East_Timor = new String[] {
               "Osttimor-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Seychellen-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Tadschikistan-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Usbekistan-Normalz\u00e4it",
               "",
               "Usbekistan-Summerz\u00e4it",
               "",
               "Usbekistan-Z\u00e4it",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Afghanistan-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnojarsk-Normalz\u00e4it",
               "",
               "Krasnojarsk-Summerz\u00e4it",
               "",
               "Krasnojarsk-Z\u00e4it",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Neis\u00e9iland-Normalz\u00e4it",
               "NZST",
               "Neis\u00e9iland-Summerz\u00e4it",
               "NZDT",
               "Neis\u00e9iland-Z\u00e4it",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "Nowosibirsk-Normalz\u00e4it",
               "",
               "Nowosibirsk-Summerz\u00e4it",
               "",
               "Nowosibirsk-Z\u00e4it",
               "",
            };
        final String[] Philippines = new String[] {
               "Philippinnesch Normalz\u00e4it",
               "PST",
               "Philippinnesch Summerz\u00e4it",
               "PDT",
               "Philippinnesch Z\u00e4it",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Wladiwostok-Normalz\u00e4it",
               "",
               "Wladiwostok-Summerz\u00e4it",
               "",
               "Wladiwostok-Z\u00e4it",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Indeschen Ozean-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Linneninselen-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Neifundland-Normalz\u00e4it",
               "NST",
               "Neifundland-Summerz\u00e4it",
               "NDT",
               "Neifundland-Z\u00e4it",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Turkmenistan-Normalz\u00e4it",
               "",
               "Turkmenistan-Summerz\u00e4it",
               "",
               "Turkmenistan-Z\u00e4it",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Frans\u00e9isch-Guayane-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Neikaledonesch Normalz\u00e4it",
               "",
               "Neikaledonesch Summerz\u00e4it",
               "",
               "Neikaledonesch Z\u00e4it",
               "",
            };
        final String[] South_Georgia = new String[] {
               "S\u00fcdgeorgesch Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Jekaterinbuerg-Normalz\u00e4it",
               "",
               "Jekaterinbuerg-Summerz\u00e4it",
               "",
               "Jekaterinbuerg-Z\u00e4it",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Zentralafrikanesch Z\u00e4it",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Ostafrikanesch Z\u00e4it",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Westafrikanesch Normalz\u00e4it",
               "WAT",
               "Westafrikanesch Summerz\u00e4it",
               "WAT",
               "Westafrikanesch Z\u00e4it",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Dumont-d\u2019Urville-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "M\u00ebtteleurop\u00e4esch Normalz\u00e4it",
               "CET",
               "M\u00ebtteleurop\u00e4esch Summerz\u00e4it",
               "CEST",
               "M\u00ebtteleurop\u00e4esch Z\u00e4it",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Osteurop\u00e4esch Normalz\u00e4it",
               "EET",
               "Osteurop\u00e4esch Summerz\u00e4it",
               "EEST",
               "Osteurop\u00e4esch Z\u00e4it",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Westeurop\u00e4esch Normalz\u00e4it",
               "WET",
               "Westeurop\u00e4esch Summerz\u00e4it",
               "WEST",
               "Westeurop\u00e4esch Z\u00e4it",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Mexikanesch Pazifik-Normalz\u00e4it",
               "MST",
               "Mexikanesch Pazifik-Summerz\u00e4it",
               "MDT",
               "Mexikanesch Pazifikz\u00e4it",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "S\u00fcdafrikanesch Z\u00e4it",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Nordamerikanesch Inland-Normalz\u00e4it",
               "CST",
               "Nordamerikanesch Inland-Summerz\u00e4it",
               "CDT",
               "Nordamerikanesch Inlandz\u00e4it",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Nordamerikanesch Ostk\u00fcsten-Normalz\u00e4it",
               "EST",
               "Nordamerikanesch Ostk\u00fcsten-Summerz\u00e4it",
               "EST",
               "Nordamerikanesch Ostk\u00fcstenz\u00e4it",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "Nordamerikanesch Westk\u00fcsten-Normalz\u00e4it",
               "PST",
               "Nordamerikanesch Westk\u00fcsten-Summerz\u00e4it",
               "PDT",
               "Nordamerikanesch Westk\u00fcstenz\u00e4it",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Frans\u00e9isch S\u00fcd- an Antarktisgebidder-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Gilbert-Inselen-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Hawaii-Aleuten-Normalz\u00e4it",
               "HST",
               "Hawaii-Aleuten-Summerz\u00e4it",
               "HST",
               "Hawaii-Aleuten-Z\u00e4it",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "Phoenixinselen-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Saint-Pierre-a-Miquelon-Normalz\u00e4it",
               "",
               "Saint-Pierre-a-Miquelon-Summerz\u00e4it",
               "",
               "Saint-Pierre-a-Miquelon-Z\u00e4it",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Rocky-Mountain-Normalz\u00e4it",
               "MST",
               "Rocky-Mountain-Summerz\u00e4it",
               "MST",
               "Rocky-Mountain-Z\u00e4it",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "Marshallinselen-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Papua-Neiguinea-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Zentralaustralesch Normalz\u00e4it",
               "ACST",
               "Zentralaustralesch Summerz\u00e4it",
               "ACDT",
               "Zentralaustralesch Z\u00e4it",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Ostaustralesch Normalz\u00e4it",
               "AEST",
               "Ostaustralesch Summerz\u00e4it",
               "AEDT",
               "Ostaustralesch Z\u00e4it",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Westaustralesch Normalz\u00e4it",
               "AWST",
               "Westaustralesch Summerz\u00e4it",
               "AWDT",
               "Westaustralesch Z\u00e4it",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Zentralindonesesch Z\u00e4it",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Ostindonesesch Z\u00e4it",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Westindonesesch Z\u00e4it",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Westkasachesch Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Zentral-/Westaustralesch Normalz\u00e4it",
               "",
               "Zentral-/Westaustralesch Summerz\u00e4it",
               "",
               "Zentral-/Westaustralesch Z\u00e4it",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", EMPTY_ZONE },
            { "GB",
                new String[] {
                    "M\u00ebttler Greenwich-Z\u00e4it",
                    "GMT",
                    "Britesch Summerz\u00e4it",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EST", America_Eastern },
            { "HST", Hawaii_Aleutian },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "VST", Indochina },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "M\u00ebttler Greenwich-Z\u00e4it",
                    "GMT",
                    "Iresch Summerz\u00e4it",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "GB-Eire",
                new String[] {
                    "M\u00ebttler Greenwich-Z\u00e4it",
                    "GMT",
                    "Britesch Summerz\u00e4it",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan_Western },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan_Western },
            { "Asia/Anadyr", Anadyr },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/Acre", Acre },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan_Western },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "M\u00ebttler Greenwich-Z\u00e4it",
                    "GMT",
                    "Iresch Summerz\u00e4it",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "M\u00ebttler Greenwich-Z\u00e4it",
                    "GMT",
                    "Britesch Summerz\u00e4it",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "M\u00ebttler Greenwich-Z\u00e4it",
                    "GMT",
                    "Britesch Summerz\u00e4it",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan_Western },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "M\u00ebttler Greenwich-Z\u00e4it",
                    "GMT",
                    "Britesch Summerz\u00e4it",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "M\u00ebttler Greenwich-Z\u00e4it",
                    "GMT",
                    "Britesch Summerz\u00e4it",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Porto_Acre", Acre },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "M\u00ebttler Greenwich-Z\u00e4it",
                    "GMT",
                    "Britesch Summerz\u00e4it",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Macau", "Macau" },
            { "timezone.excity.Asia/Qatar", "Katar" },
            { "timezone.excity.Asia/Tokyo", "Tokio" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Asia/Aqtobe", "Aqt\u00f6be" },
            { "timezone.excity.Asia/Muscat", "Muskat" },
            { "timezone.excity.Asia/Riyadh", "Riad" },
            { "timezone.excity.Asia/Saigon", "Ho-Chi-Minh-Stad" },
            { "timezone.excity.Asia/Taipei", "Taipeh" },
            { "timezone.excity.Asia/Tehran", "Teheran" },
            { "timezone.excity.Etc/Unknown", "Onbekannt" },
            { "timezone.excity.Europe/Kiev", "Kiew" },
            { "timezone.excity.Europe/Rome", "Roum" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Cairo", "Kairo" },
            { "timezone.excity.Asia/Baghdad", "Bagdad" },
            { "timezone.excity.Asia/Bishkek", "Bischkek" },
            { "timezone.excity.Asia/Nicosia", "Nikosia" },
            { "timezone.excity.Asia/Tbilisi", "Tiflis" },
            { "timezone.excity.Asia/Yakutsk", "Jakutsk" },
            { "timezone.excity.Asia/Yerevan", "Erivan" },
            { "timezone.excity.Pacific/Fiji", "Fidschi" },
            { "timezone.excity.Asia/Calcutta", "Kalkutta" },
            { "timezone.excity.Asia/Damascus", "Damaskus" },
            { "timezone.excity.Asia/Dushanbe", "Duschanbe" },
            { "timezone.excity.Asia/Jayapura", "Port Numbay" },
            { "timezone.excity.Asia/Sakhalin", "Sachalin" },
            { "timezone.excity.Asia/Tashkent", "Taschkent" },
            { "timezone.excity.Europe/Athens", "Athen" },
            { "timezone.excity.Europe/Lisbon", "Lissabon" },
            { "timezone.excity.Europe/Moscow", "Moskau" },
            { "timezone.excity.Europe/Prague", "Prag" },
            { "timezone.excity.Europe/Tirane", "Tirana" },
            { "timezone.excity.Europe/Vienna", "Wien" },
            { "timezone.excity.Europe/Warsaw", "Warschau" },
            { "timezone.excity.Europe/Zurich", "Z\u00fcrech" },
            { "timezone.excity.Indian/Comoro", "Komoren" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Algiers", "Alger" },
            { "timezone.excity.America/Cayman", "Kaimaninselen" },
            { "timezone.excity.America/Havana", "Havanna" },
            { "timezone.excity.Asia/Kamchatka", "Kamtschatka" },
            { "timezone.excity.Asia/Pyongyang", "Pj\u00f6ngjang" },
            { "timezone.excity.Asia/Singapore", "Singapur" },
            { "timezone.excity.Europe/Vatican", "Vatikan" },
            { "timezone.excity.Europe/Vilnius", "Wilna" },
            { "timezone.excity.Pacific/Easter", "Ouschterinsel" },
            { "timezone.excity.Africa/Djibouti", "Dschibuti" },
            { "timezone.excity.Africa/El_Aaiun", "El Aai\u00fan" },
            { "timezone.excity.Africa/Khartoum", "Khartum" },
            { "timezone.excity.America/Jamaica", "Jamaika" },
            { "timezone.excity.Atlantic/Azores", "Azoren" },
            { "timezone.excity.Atlantic/Canary", "Kanaresch Inselen" },
            { "timezone.excity.Atlantic/Faeroe", "F\u00e4r\u00f6er" },
            { "timezone.excity.Europe/Belgrade", "Belgrad" },
            { "timezone.excity.Europe/Brussels", "Br\u00e9issel" },
            { "timezone.excity.Europe/Chisinau", "Kischinau" },
            { "timezone.excity.Indian/Maldives", "Maldiven" },
            { "timezone.excity.Africa/Mogadishu", "Mogadischu" },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasnojarsk" },
            { "timezone.excity.Asia/Novosibirsk", "Nowosibirsk" },
            { "timezone.excity.Asia/Vladivostok", "Wladiwostok" },
            { "timezone.excity.Atlantic/Bermuda", "Bermudas" },
            { "timezone.excity.Europe/Bucharest", "Bukarest" },
            { "timezone.excity.Europe/Volgograd", "Wolgograd" },
            { "timezone.excity.Indian/Christmas", "Chr\u00ebschtdagsinsel" },
            { "timezone.excity.Antarctica/Vostok", "Wostok" },
            { "timezone.excity.Europe/Copenhagen", "Kopenhagen" },
            { "timezone.excity.Europe/Luxembourg", "L\u00ebtzebuerg" },
            { "timezone.excity.Africa/Addis_Ababa", "Addis Abeba" },
            { "timezone.excity.Africa/Ouagadougou", "Wagadugu" },
            { "timezone.excity.Asia/Yekaterinburg", "Jekaterinbuerg" },
            { "timezone.excity.America/El_Salvador", "Salvador" },
            { "timezone.excity.America/Mexico_City", "Mexiko-Stad" },
            { "timezone.excity.Atlantic/Cape_Verde", "Kap Verde" },
            { "timezone.excity.America/Port_of_Spain", "Port-of-Spain" },
            { "timezone.excity.America/St_Barthelemy", "Saint-Barth\u00e9lemy" },
            { "timezone.excity.Atlantic/South_Georgia", "S\u00fcdgeorgien" },
        };
        return data;
    }
}
