/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_pt_PT extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Hora de Greenwich",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Acre = new String[] {
               "Hora padr\u00e3o do Acre",
               "\u2205\u2205\u2205",
               "Hora de ver\u00e3o do Acre",
               "\u2205\u2205\u2205",
               "Hora do Acre",
               "\u2205\u2205\u2205",
            };
        final String[] Apia = new String[] {
               "Hora padr\u00e3o de Apia",
               "",
               "Hora de ver\u00e3o de Apia",
               "",
               "Hora de Apia",
               "",
            };
        final String[] Cook = new String[] {
               "Hora padr\u00e3o das Ilhas Cook",
               "",
               "Hora de ver\u00e3o das Ilhas Cook",
               "",
               "Hora das Ilhas Cook",
               "",
            };
        final String[] Cuba = new String[] {
               "Hora padr\u00e3o de Cuba",
               "CST",
               "Hora de ver\u00e3o de Cuba",
               "CDT",
               "Hora de Cuba",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Hora padr\u00e3o de Fiji",
               "",
               "Hora de ver\u00e3o de Fiji",
               "",
               "Hora de Fiji",
               "",
            };
        final String[] Gulf = new String[] {
               "Hora padr\u00e3o do Golfo",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Hora padr\u00e3o de Hovd",
               "",
               "Hora de ver\u00e3o de Hovd",
               "",
               "Hora de Hovd",
               "",
            };
        final String[] Iran = new String[] {
               "Hora padr\u00e3o do Ir\u00e3o",
               "",
               "Hora de ver\u00e3o do Ir\u00e3o",
               "",
               "Hora do Ir\u00e3o",
               "",
            };
        final String[] Niue = new String[] {
               "Hora de Niu\u00ea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Hora padr\u00e3o de Omsk",
               "",
               "Hora de ver\u00e3o de Omsk",
               "",
               "Hora de Omsk",
               "",
            };
        final String[] Peru = new String[] {
               "Hora padr\u00e3o do Peru",
               "",
               "Hora de ver\u00e3o do Peru",
               "",
               "Hora do Peru",
               "",
            };
        final String[] Truk = new String[] {
               "Hora de Chuuk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Hora da Ilha Wake",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Hora padr\u00e3o do Chile",
               "",
               "Hora de ver\u00e3o do Chile",
               "",
               "Hora do Chile",
               "",
            };
        final String[] China = new String[] {
               "Hora padr\u00e3o da China",
               "CST",
               "Hora de ver\u00e3o da China",
               "CDT",
               "Hora da China",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Hora das Ilhas Cocos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Hora de Davis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Hora padr\u00e3o da \u00cdndia",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Hora padr\u00e3o do Jap\u00e3o",
               "JST",
               "Hora de ver\u00e3o do Jap\u00e3o",
               "JDT",
               "Hora do Jap\u00e3o",
               "JT",
            };
        final String[] Korea = new String[] {
               "Hora padr\u00e3o da Coreia",
               "KST",
               "Hora de ver\u00e3o da Coreia",
               "KST",
               "Hora da Coreia",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Hora de Nauru",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Hora do Nepal",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Hora de Palau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Hora padr\u00e3o de Samoa",
               "SST",
               "Hora de ver\u00e3o de Samoa",
               "SST",
               "Hora de Samoa",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Hora de Syowa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Hora padr\u00e3o de Tonga",
               "",
               "Hora de ver\u00e3o de Tonga",
               "",
               "Hora de Tonga",
               "",
            };
        final String[] Yukon = new String[] {
               "Hora do Yukon",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "Hora padr\u00e3o do Alasca",
               "AKST",
               "Hora de ver\u00e3o do Alasca",
               "AKDT",
               "Hora do Alasca",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Hora padr\u00e3o do Amazonas",
               "\u2205\u2205\u2205",
               "Hora de ver\u00e3o do Amazonas",
               "\u2205\u2205\u2205",
               "Hora do Amazonas",
               "\u2205\u2205\u2205",
            };
        final String[] Anadyr = new String[] {
               "Hora padr\u00e3o de Anadyr",
               "",
               "Hora de ver\u00e3o de Anadyr",
               "",
               "Hora de Anadyr",
               "",
            };
        final String[] Azores = new String[] {
               "Hora padr\u00e3o dos A\u00e7ores",
               "AZOT",
               "Hora de ver\u00e3o dos A\u00e7ores",
               "AZOST",
               "Hora dos A\u00e7ores",
               "AZOT",
            };
        final String[] Bhutan = new String[] {
               "Hora do But\u00e3o",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Hora do Brunei Darussalam",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Hora padr\u00e3o da Ilha da P\u00e1scoa",
               "",
               "Hora de ver\u00e3o da Ilha da P\u00e1scoa",
               "",
               "Hora da Ilha da P\u00e1scoa",
               "",
            };
        final String[] Guyana = new String[] {
               "Hora da Guiana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Hora padr\u00e3o de Israel",
               "IST",
               "Hora de ver\u00e3o de Israel",
               "IDT",
               "Hora de Israel",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Hora de Kosrae",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Hora de Mawson",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Hora padr\u00e3o de Moscovo",
               "MSK",
               "Hora de ver\u00e3o de Moscovo",
               "MSK",
               "Hora de Moscovo",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Hora de Ponape",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "Hora padr\u00e3o de Samara",
               "",
               "Hora de ver\u00e3o de Samara",
               "",
               "Hora de Samara",
               "",
            };
        final String[] Tahiti = new String[] {
               "Hora do Taiti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Hora padr\u00e3o de Taip\u00e9",
               "CST",
               "Hora de ver\u00e3o de Taip\u00e9",
               "CDT",
               "Hora de Taip\u00e9",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Hora de Tuvalu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Hora de Vostok",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Hora de Wallis e Futuna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Hora padr\u00e3o da Ar\u00e1bia",
               "",
               "Hora de ver\u00e3o da Ar\u00e1bia",
               "",
               "Hora da Ar\u00e1bia",
               "",
            };
        final String[] Armenia = new String[] {
               "Hora padr\u00e3o da Arm\u00e9nia",
               "",
               "Hora de ver\u00e3o da Arm\u00e9nia",
               "",
               "Hora da Arm\u00e9nia",
               "",
            };
        final String[] Bolivia = new String[] {
               "Hora da Bol\u00edvia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Hora padr\u00e3o de Chatham",
               "",
               "Hora de ver\u00e3o de Chatham",
               "",
               "Hora de Chatham",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Hora Coordenada Universal",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Hora do Equador",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Hora de Gambier",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Hora padr\u00e3o da Ge\u00f3rgia",
               "",
               "Hora de ver\u00e3o da Ge\u00f3rgia",
               "",
               "Hora da Ge\u00f3rgia",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Hora padr\u00e3o de Irkutsk",
               "",
               "Hora de ver\u00e3o de Irkutsk",
               "",
               "Hora de Irkutsk",
               "",
            };
        final String[] Magadan = new String[] {
               "Hora padr\u00e3o de Magadan",
               "",
               "Hora de ver\u00e3o de Magadan",
               "",
               "Hora de Magadan",
               "",
            };
        final String[] Myanmar = new String[] {
               "Hora de Mianmar",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Hora padr\u00e3o da Ilha Norfolk",
               "",
               "Hora de ver\u00e3o da Ilha Norfolk",
               "",
               "Hora da Ilha Norfolk",
               "",
            };
        final String[] Noronha = new String[] {
               "Hora padr\u00e3o de Fernando de Noronha",
               "",
               "Hora de ver\u00e3o de Fernando de Noronha",
               "",
               "Hora de Fernando de Noronha",
               "",
            };
        final String[] Reunion = new String[] {
               "Hora de Reuni\u00e3o",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Hora de Rothera",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Hora das Ilhas Salom\u00e3o",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Hora de Tokelau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Hora padr\u00e3o do Uruguai",
               "",
               "Hora de ver\u00e3o do Uruguai",
               "",
               "Hora do Uruguai",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Hora padr\u00e3o do Vanuatu",
               "",
               "Hora de ver\u00e3o do Vanuatu",
               "",
               "Hora do Vanuatu",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Hora padr\u00e3o de Yakutsk",
               "",
               "Hora de ver\u00e3o de Yakutsk",
               "",
               "Hora de Yakutsk",
               "",
            };
        final String[] Atlantic = new String[] {
               "Hora padr\u00e3o do Atl\u00e2ntico",
               "AST",
               "Hora de ver\u00e3o do Atl\u00e2ntico",
               "AST",
               "Hora do Atl\u00e2ntico",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "Hora padr\u00e3o de Bras\u00edlia",
               "\u2205\u2205\u2205",
               "Hora de ver\u00e3o de Bras\u00edlia",
               "\u2205\u2205\u2205",
               "Hora de Bras\u00edlia",
               "\u2205\u2205\u2205",
            };
        final String[] Chamorro = new String[] {
               "Hora padr\u00e3o de Chamorro",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Hora padr\u00e3o da Col\u00f4mbia",
               "",
               "Hora de ver\u00e3o da Col\u00f4mbia",
               "",
               "Hora da Col\u00f4mbia",
               "",
            };
        final String[] Falkland = new String[] {
               "Hora padr\u00e3o das Ilhas Falkland",
               "",
               "Hora de ver\u00e3o das Ilhas Falkland",
               "",
               "Hora das Ilhas Falkland",
               "",
            };
        final String[] Malaysia = new String[] {
               "Hora da Mal\u00e1sia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Hora das Maldivas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Hora padr\u00e3o de Ulan Bator",
               "",
               "Hora de ver\u00e3o de Ulan Bator",
               "",
               "Hora de Ulan Bator",
               "",
            };
        final String[] Pakistan = new String[] {
               "Hora padr\u00e3o do Paquist\u00e3o",
               "PKT",
               "Hora de ver\u00e3o do Paquist\u00e3o",
               "PKST",
               "Hora do Paquist\u00e3o",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Hora padr\u00e3o do Paraguai",
               "",
               "Hora de ver\u00e3o do Paraguai",
               "",
               "Hora do Paraguai",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Hora de Pitcairn",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Hora padr\u00e3o de Sacalina",
               "",
               "Hora de ver\u00e3o de Sacalina",
               "",
               "Hora de Sacalina",
               "",
            };
        final String[] Suriname = new String[] {
               "Hora do Suriname",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Hora padr\u00e3o da Argentina",
               "",
               "Hora de ver\u00e3o da Argentina",
               "",
               "Hora da Argentina",
               "",
            };
        final String[] Christmas = new String[] {
               "Hora da Ilha do Natal",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Hora das Gal\u00e1pagos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Hora padr\u00e3o de Hong Kong",
               "HKT",
               "Hora de ver\u00e3o de Hong Kong",
               "HKST",
               "Hora de Hong Kong",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Hora da Indochina",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Hora padr\u00e3o de Petropavlovsk-Kamchatski",
               "",
               "Hora de ver\u00e3o de Petropavlovsk-Kamchatski",
               "",
               "Hora de Petropavlovsk-Kamchatski",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Hora do Quirguist\u00e3o",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Hora padr\u00e3o de Lord Howe",
               "",
               "Hora de ver\u00e3o de Lord Howe",
               "",
               "Hora de Lord Howe",
               "",
            };
        final String[] Marquesas = new String[] {
               "Hora das Ilhas Marquesas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Hora padr\u00e3o da Maur\u00edcia",
               "",
               "Hora de ver\u00e3o da Maur\u00edcia",
               "",
               "Hora da Maur\u00edcia",
               "",
            };
        final String[] Singapore = new String[] {
               "Hora padr\u00e3o de Singapura",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Hora da Venezuela",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Hora padr\u00e3o de Volgogrado",
               "MSK",
               "Hora de ver\u00e3o de Volgogrado",
               "MSK",
               "Hora de Volgogrado",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "Hora padr\u00e3o do Azerbaij\u00e3o",
               "",
               "Hora de ver\u00e3o do Azerbaij\u00e3o",
               "",
               "Hora do Azerbaij\u00e3o",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Hora padr\u00e3o do Bangladeche",
               "",
               "Hora de ver\u00e3o do Bangladeche",
               "",
               "Hora do Bangladeche",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Hora padr\u00e3o de Cabo Verde",
               "",
               "Hora de ver\u00e3o de Cabo Verde",
               "",
               "Hora de Cabo Verde",
               "",
            };
        final String[] East_Timor = new String[] {
               "Hora de Timor Leste",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "Hora do Cazaquist\u00e3o",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Hora das Seicheles",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Hora do Tajiquist\u00e3o",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Hora padr\u00e3o do Uzbequist\u00e3o",
               "",
               "Hora de ver\u00e3o do Uzbequist\u00e3o",
               "",
               "Hora do Uzbequist\u00e3o",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Hora do Afeganist\u00e3o",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Hora padr\u00e3o de Krasnoyarsk",
               "",
               "Hora de ver\u00e3o de Krasnoyarsk",
               "",
               "Hora de Krasnoyarsk",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Hora padr\u00e3o da Nova Zel\u00e2ndia",
               "NZST",
               "Hora de ver\u00e3o da Nova Zel\u00e2ndia",
               "NZDT",
               "Hora da Nova Zel\u00e2ndia",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "Hora padr\u00e3o de Novosibirsk",
               "",
               "Hora de ver\u00e3o de Novosibirsk",
               "",
               "Hora de Novosibirsk",
               "",
            };
        final String[] Philippines = new String[] {
               "Hora padr\u00e3o das Filipinas",
               "PST",
               "Hora de ver\u00e3o das Filipinas",
               "PDT",
               "Hora das Filipinas",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Hora padr\u00e3o de Vladivostok",
               "",
               "Hora de ver\u00e3o de Vladivostok",
               "",
               "Hora de Vladivostok",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Hora do Oceano \u00cdndico",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Hora das Ilhas Line",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Hora padr\u00e3o da Terra Nova",
               "NST",
               "Hora de ver\u00e3o da Terra Nova",
               "NDT",
               "Hora da Terra Nova",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Hora padr\u00e3o do Turquemenist\u00e3o",
               "",
               "Hora de ver\u00e3o do Turquemenist\u00e3o",
               "",
               "Hora do Turquemenist\u00e3o",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Hora da Guiana Francesa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Hora padr\u00e3o da Nova Caled\u00f3nia",
               "",
               "Hora de ver\u00e3o da Nova Caled\u00f3nia",
               "",
               "Hora da Nova Caled\u00f3nia",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Hora da Ge\u00f3rgia do Sul",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Hora padr\u00e3o de Ecaterimburgo",
               "",
               "Hora de ver\u00e3o de Ecaterimburgo",
               "",
               "Hora de Ecaterimburgo",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Hora da \u00c1frica Central",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Hora da \u00c1frica Oriental",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Hora padr\u00e3o da \u00c1frica Ocidental",
               "WAT",
               "Hora de ver\u00e3o da \u00c1frica Ocidental",
               "WAT",
               "Hora da \u00c1frica Ocidental",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Hora de Dumont-d\u2019Urville",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Hora padr\u00e3o da Europa Central",
               "CET",
               "Hora de ver\u00e3o da Europa Central",
               "CEST",
               "Hora da Europa Central",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Hora padr\u00e3o da Europa Oriental",
               "EET",
               "Hora de ver\u00e3o da Europa Oriental",
               "EEST",
               "Hora da Europa Oriental",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Hora padr\u00e3o da Europa Ocidental",
               "WET",
               "Hora de ver\u00e3o da Europa Ocidental",
               "WEST",
               "Hora da Europa Ocidental",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Hora padr\u00e3o do Pac\u00edfico Mexicano",
               "MST",
               "Hora de ver\u00e3o do Pac\u00edfico Mexicano",
               "MDT",
               "Hora do Pac\u00edfico Mexicano",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Hora da \u00c1frica do Sul",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Hora padr\u00e3o central norte-americana",
               "CST",
               "Hora de ver\u00e3o central norte-americana",
               "CDT",
               "Hora central norte-americana",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Hora padr\u00e3o oriental norte-americana",
               "EST",
               "Hora de ver\u00e3o oriental norte-americana",
               "EST",
               "Hora oriental norte-americana",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "Hora padr\u00e3o do Pac\u00edfico norte-americana",
               "PST",
               "Hora de ver\u00e3o do Pac\u00edfico norte-americana",
               "PDT",
               "Hora do Pac\u00edfico norte-americana",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Hora das Terras Austrais e Ant\u00e1rcticas Francesas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Hora das Ilhas Gilbert",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Hora padr\u00e3o do Havai e Aleutas",
               "HST",
               "Hora de ver\u00e3o do Havai e Aleutas",
               "HST",
               "Hora do Havai e Aleutas",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "Hora das Ilhas F\u00e9nix",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Hora padr\u00e3o de S\u00e3o Pedro e Miquel\u00e3o",
               "",
               "Hora de ver\u00e3o de S\u00e3o Pedro e Miquel\u00e3o",
               "",
               "Hora de S\u00e3o Pedro e Miquel\u00e3o",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Hora padr\u00e3o de montanha norte-americana",
               "MST",
               "Hora de ver\u00e3o de montanha norte-americana",
               "MST",
               "Hora de montanha norte-americana",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "Hora das Ilhas Marshall",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Hora de Papua Nova Guin\u00e9",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Hora padr\u00e3o da Austr\u00e1lia Central",
               "ACST",
               "Hora de ver\u00e3o da Austr\u00e1lia Central",
               "ACDT",
               "Hora da Austr\u00e1lia Central",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Hora padr\u00e3o da Austr\u00e1lia Oriental",
               "AEST",
               "Hora de ver\u00e3o da Austr\u00e1lia Oriental",
               "AEDT",
               "Hora da Austr\u00e1lia Oriental",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Hora padr\u00e3o da Austr\u00e1lia Ocidental",
               "AWST",
               "Hora de ver\u00e3o da Austr\u00e1lia Ocidental",
               "AWDT",
               "Hora da Austr\u00e1lia Ocidental",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Hora da Indon\u00e9sia Central",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Hora da Indon\u00e9sia Oriental",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Hora da Indon\u00e9sia Ocidental",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Hora padr\u00e3o da Austr\u00e1lia Central Ocidental",
               "",
               "Hora de ver\u00e3o da Austr\u00e1lia Central Ocidental",
               "",
               "Hora da Austr\u00e1lia Central Ocidental",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "Hora de Greenwich",
                    "GMT",
                    "Hora de ver\u00e3o Brit\u00e2nica",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii_Aleutian },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "Hora Coordenada Universal",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Hora de Greenwich",
                    "GMT",
                    "Hora de ver\u00e3o da Irlanda",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "Hora Coordenada Universal",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "Hora Coordenada Universal",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "Hora de Greenwich",
                    "GMT",
                    "Hora de ver\u00e3o Brit\u00e2nica",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "Hora Coordenada Universal",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Universal",
                new String[] {
                    "Hora Coordenada Universal",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Anadyr", Anadyr },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/Acre", Acre },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "Hora Coordenada Universal",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Hora de Greenwich",
                    "GMT",
                    "Hora de ver\u00e3o da Irlanda",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Hora de Greenwich",
                    "GMT",
                    "Hora de ver\u00e3o Brit\u00e2nica",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Hora de Greenwich",
                    "GMT",
                    "Hora de ver\u00e3o Brit\u00e2nica",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Hora de Greenwich",
                    "GMT",
                    "Hora de ver\u00e3o Brit\u00e2nica",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Hora de Greenwich",
                    "GMT",
                    "Hora de ver\u00e3o Brit\u00e2nica",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Porto_Acre", Acre },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Hora de Greenwich",
                    "GMT",
                    "Hora de ver\u00e3o Brit\u00e2nica",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "Adem" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Aqtau", "Aqtau" },
            { "timezone.excity.Asia/Dhaka", "Daca" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Asia/Aqtobe", "Aqtobe" },
            { "timezone.excity.Asia/Kuwait", "Koweit" },
            { "timezone.excity.Asia/Taipei", "Taip\u00e9" },
            { "timezone.excity.Asia/Tehran", "Teer\u00e3o" },
            { "timezone.excity.Indian/Mahe", "Mahe" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Dakar", "Dacar" },
            { "timezone.excity.Africa/Tunis", "Tunes" },
            { "timezone.excity.Asia/Baghdad", "Bagdade" },
            { "timezone.excity.Asia/Bahrain", "Bar\u00e9m" },
            { "timezone.excity.Asia/Bangkok", "Banguecoque" },
            { "timezone.excity.Asia/Karachi", "Carachi" },
            { "timezone.excity.Asia/Rangoon", "Yangon" },
            { "timezone.excity.Asia/Thimphu", "Timphu" },
            { "timezone.excity.Asia/Yerevan", "Erevan" },
            { "timezone.excity.Indian/Cocos", "Ilhas Cocos" },
            { "timezone.excity.Africa/Bamako", "Bamaco" },
            { "timezone.excity.Africa/Lusaka", "Lusaca" },
            { "timezone.excity.Africa/Niamey", "Niamei" },
            { "timezone.excity.America/Bahia", "Ba\u00eda" },
            { "timezone.excity.Asia/Katmandu", "Catmandu" },
            { "timezone.excity.Asia/Makassar", "Macassar" },
            { "timezone.excity.Asia/Qostanay", "Kostanay" },
            { "timezone.excity.Europe/Madrid", "Madrid" },
            { "timezone.excity.Europe/Monaco", "M\u00f3naco" },
            { "timezone.excity.Europe/Moscow", "Moscovo" },
            { "timezone.excity.Pacific/Efate", "Efate" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Kampala", "Campala" },
            { "timezone.excity.Africa/Nairobi", "Nairobi" },
            { "timezone.excity.Africa/Tripoli", "Tripoli" },
            { "timezone.excity.America/Cancun", "Cancun" },
            { "timezone.excity.America/Cayman", "Caim\u00e3o" },
            { "timezone.excity.Europe/Tallinn", "Talim" },
            { "timezone.excity.Pacific/Easter", "Ilha da P\u00e1scoa" },
            { "timezone.excity.Pacific/Tarawa", "Tarawa" },
            { "timezone.excity.Africa/Djibouti", "Jibuti" },
            { "timezone.excity.Africa/Ndjamena", "Ndjamena" },
            { "timezone.excity.America/Curacao", "Cura\u00e7au" },
            { "timezone.excity.Atlantic/Faeroe", "Faro\u00e9" },
            { "timezone.excity.Europe/Busingen", "Busingen" },
            { "timezone.excity.Europe/Helsinki", "Hels\u00ednquia" },
            { "timezone.excity.Pacific/Chatham", "Chatham" },
            { "timezone.excity.America/Dominica", "Dom\u00ednica" },
            { "timezone.excity.America/New_York", "Nova Iorque" },
            { "timezone.excity.America/St_Johns", "St. John\u2019s" },
            { "timezone.excity.Europe/Amsterdam", "Amesterd\u00e3o" },
            { "timezone.excity.Indian/Christmas", "Ilha do Natal" },
            { "timezone.excity.Indian/Mauritius", "Maur\u00edcia" },
            { "timezone.excity.Pacific/Pitcairn", "Ilhas Pitcairn" },
            { "timezone.excity.Africa/Porto-Novo", "Porto-Novo" },
            { "timezone.excity.America/Araguaina", "Araguaina" },
            { "timezone.excity.America/St_Thomas", "St. Thomas" },
            { "timezone.excity.Europe/Copenhagen", "Copenhaga" },
            { "timezone.excity.Europe/San_Marino", "S\u00e3o Marinho" },
            { "timezone.excity.Africa/Addis_Ababa", "Adis-Abeba" },
            { "timezone.excity.America/Montevideo", "Montevideu" },
            { "timezone.excity.America/Montserrat", "Monserrate" },
            { "timezone.excity.Atlantic/Reykjavik", "Reiquiavique" },
            { "timezone.excity.Europe/Kaliningrad", "Caliningrado" },
            { "timezone.excity.America/El_Salvador", "Salvador" },
            { "timezone.excity.Australia/Lord_Howe", "Ilha de Lord Howe" },
            { "timezone.excity.America/Port_of_Spain", "Porto de Espanha" },
            { "timezone.excity.America/Bahia_Banderas", "Bahia Banderas" },
            { "timezone.excity.America/Port-au-Prince", "Port-au-Prince" },
            { "timezone.excity.America/Argentina/Tucuman", "Tucum\u00e1n" },
        };
        return data;
    }
}
