/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ps extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_NR = "\u0646\u0627\u06cc\u0631\u0648";
        final String metaValue_TR = "\u062a\u0631\u06a9\u064a";
        final String metaValue_ar = "\u0639\u0631\u0628\u064a";
        final String metaValue_ccp = "\u0686\u06a9\u0645\u0627";
        final String metaValue_el = "\u06cc\u0648\u0646\u0627\u0646\u064a";
        final String metaValue_gu = "\u06ab\u062c\u0631\u0627\u062a\u064a";
        final String metaValue_he = "\u0639\u0628\u0631\u0627\u0646\u064a";
        final String metaValue_ja = "\u062c\u0627\u067e\u0627\u0646\u064a";
        final String metaValue_km = "\u062e\u0645\u0631";
        final String metaValue_kn = "\u06a9\u0646\u0627\u0689\u0627";
        final String metaValue_ko = "\u06a9\u0648\u0631\u06cc\u0627\u06cc\u06cc";
        final String metaValue_ta = "\u062a\u0627\u0645\u0644";
        final String metaValue_bo = "\u062a\u0628\u062a\u064a";
        final String metaValue_vai = "\u0648\u0627\u06cc";
        final Object[][] data = new Object[][] {
            { "001", "\u0646\u0693\u06cd" },
            { "002", "\u0627\u0641\u0631\u064a\u0642\u0627" },
            { "003", "\u0634\u0645\u0627\u0644\u06cc \u0627\u0645\u0631\u06cc\u06a9\u0627" },
            { "005", "\u0633\u0648\u064a\u0644\u064a \u0627\u0645\u0631\u064a\u06a9\u0627" },
            { "009", "\u0627\u0648\u0642\u064a\u0627\u0646\u0648\u0633\u064a\u0647" },
            { "011", "\u0644\u0648\u06cc\u062f\u06cc\u0681 \u0627\u0641\u0631\u06cc\u0642\u0627" },
            { "013", "\u0645\u0646\u062e\u0646\u06cd \u0627\u0645\u0631\u064a\u06a9\u0627" },
            { "014", "\u062e\u062a\u06cc\u0681 \u0627\u0641\u0631\u06cc\u0642\u0627" },
            { "015", "\u0634\u0645\u0627\u0644\u064a \u0627\u0641\u0631\u06cc\u0642\u0627" },
            { "017", "\u0645\u0646\u0681\u0646\u06cd \u0627\u0641\u0631\u06cc\u0642\u0627" },
            { "018", "\u0633\u0648\u064a\u0644\u064a \u0627\u0641\u0631\u064a\u0642\u0627" },
            { "019", "\u0627\u0645\u0631\u064a\u06a9\u06d0" },
            { "021", "\u0634\u0645\u0627\u0644\u064a \u0627\u0645\u0631\u06cc\u06a9\u0627" },
            { "029", "\u06a9\u06cc\u0631\u06cc\u0628\u06cc\u0646" },
            { "030", "\u062e\u062a\u06cc\u0681 \u0622\u0633\u06cc\u0627" },
            { "034", "\u0633\u0648\u064a\u0644\u064a \u0622\u0633\u064a\u0627" },
            { "035", "\u0633\u0648\u064a\u0644\u064a \u062e\u062a\u064a\u0681 \u0622\u0633\u064a\u0627" },
            { "039", "\u0633\u0648\u064a\u0644\u064a \u0627\u0631\u0648\u067e\u0627" },
            { "053", "\u0622\u0633\u062a\u0631\u0627\u0644\u06cc\u0627" },
            { "054", "\u0645\u0644\u0627\u0646\u0634\u06cc\u0627" },
            { "057", "\u062f \u0645\u0627\u06cc\u06a9\u0631\u0648\u0646\u06cc\u0633\u06cc\u0646\u06cc\u0646 \u0633\u06cc\u0645\u0647" },
            { "061", "\u067e\u0648\u0644\u0646\u064a\u0633\u064a\u0627" },
            { "142", "\u0622\u0633\u064a\u0627" },
            { "143", "\u0645\u0646\u0681\u0646\u06cd \u0622\u0633\u064a\u0627" },
            { "145", "\u0644\u0648\u06cc\u062f\u06cc\u0681 \u0622\u0633\u06cc\u0627" },
            { "150", "\u0627\u0631\u0648\u067e\u0627" },
            { "151", "\u062e\u062a\u064a\u0681 \u0627\u0631\u0648\u067e\u0627" },
            { "154", "\u0634\u0645\u0627\u0644\u064a \u0627\u0631\u0648\u067e\u0627" },
            { "155", "\u0644\u0648\u06d0\u062f\u064a\u0681 \u0627\u0631\u0648\u067e\u0627" },
            { "202", "\u0633\u0628 \u0633\u0647\u0627\u0631\u0646 \u0627\u0641\u0631\u064a\u0642\u0627" },
            { "419", "\u0644\u0627\u062a\u06cc\u0646\u064a \u0627\u0645\u0631\u06cc\u06a9\u0627" },
            { "AC", "\u0627\u0633\u064a\u0646\u0634\u0627\u0646 \u067c\u0627\u067e\u0648" },
            { "AD", "\u0627\u0646\u062f\u0648\u0631\u0627" },
            { "AE", "\u0645\u062a\u062d\u062f\u0647 \u0639\u0631\u0628 \u0627\u0645\u0627\u0631\u0627\u062a" },
            { "AF", "\u0627\u0641\u063a\u0627\u0646\u0633\u062a\u0627\u0646" },
            { "AG", "\u0627\u0646\u067c\u064a\u06ab\u0648\u0627 \u0627\u0648 \u0628\u0627\u0631\u0628\u0648\u062f\u0627" },
            { "AI", "\u0627\u0646\u06ab\u06cc\u0644\u0627" },
            { "AL", "\u0627\u0644\u0628\u0627\u0646\u06cc\u0647" },
            { "AM", "\u0627\u0631\u0645\u0646\u0633\u062a\u0627\u0646" },
            { "AO", "\u0627\u0646\u06ab\u0648\u0644\u0627" },
            { "AQ", "\u0627\u0646\u062a\u0627\u0631\u06a9\u062a\u06cc\u06a9\u0627" },
            { "AR", "\u0627\u0631\u062c\u0646\u067c\u0627\u064a\u0646" },
            { "AS", "\u0627\u0645\u0631\u06cc\u06a9\u0627\u06cc\u06cc \u0633\u0627\u0645\u0627\u0648\u0627" },
            { "AT", "\u0627\u062a\u0631\u06cc\u0634" },
            { "AU", "\u0622\u0633\u067c\u0631\u0627\u0644\u06cc\u0627" },
            { "AW", "\u0622\u0631\u0648\u0628\u0627" },
            { "AX", "\u0627\u0644\u0627\u0646\u062f \u067c\u0627\u067e\u0648\u0627\u0646" },
            { "AZ", "\u0627\u0630\u0631\u0628\u0627\u064a\u062c\u0627\u0646" },
            { "BA", "\u0628\u0648\u0633\u0646\u064a\u0627 \u0627\u0648 \u0647\u06d0\u0631\u0632\u06ab\u0648\u064a\u0646\u0627" },
            { "BB", "\u0628\u0627\u0631\u0628\u0627\u062f\u0648\u0633" },
            { "BD", "\u0628\u0646\u06af\u0644\u0647 \u062f\u06d0\u0634" },
            { "BE", "\u0628\u06cc\u0644\u062c\u06cc\u0645" },
            { "BF", "\u0628\u0648\u0631\u06a9\u06cc\u0646\u0627 \u0641\u0627\u0633\u0648" },
            { "BG", "\u0628\u0644\u063a\u0627\u0631\u06cc\u0647" },
            { "BH", "\u0628\u062d\u0631\u064a\u0646" },
            { "BI", "\u0628\u0631\u0648\u0646\u062f\u064a" },
            { "BJ", "\u0628\u06cc\u0646\u0646" },
            { "BL", "\u0633\u064a\u0646\u067c \u0628\u0627\u0631\u062a\u064a\u0644\u0645\u064a" },
            { "BM", "\u0628\u0631\u0645\u0648\u062f\u0627" },
            { "BN", "\u0628\u0631\u0648\u0646\u0627\u0626\u064a" },
            { "BO", "\u0628\u0648\u0644\u06cc\u0648\u06cc\u0627" },
            { "BQ", "\u06a9\u06cc\u0631\u06cc\u0628\u06cc\u0646 \u0647\u0627\u0644\u06cc\u0646\u0689" },
            { "BR", "\u0628\u0631\u0627\u0632\u06cc\u0644" },
            { "BS", "\u0628\u0627\u0647\u0645\u0627\u0633" },
            { "BT", "\u0628\u0647\u0648\u067c\u0627\u0646" },
            { "BV", "\u0628\u0648\u0648\u06cc\u067c \u067c\u0627\u067e\u0648" },
            { "BW", "\u0628\u0648\u062a\u0633\u0648\u0627\u0646\u0647" },
            { "BY", "\u0628\u06cc\u0644\u0627\u0631\u0648\u0633" },
            { "BZ", "\u0628\u0644\u06cc\u0632" },
            { "CA", "\u06a9\u0627\u0646\u0627\u0689\u0627" },
            { "CC", "\u06a9\u0648\u06a9\u0648\u0632 (\u06a9\u064a\u0644\u0646\u06ab) \u067c\u0627\u067e\u0648\u06ab\u0627\u0646" },
            { "CD", "\u06a9\u0627\u0646\u06ab\u0648 - \u06a9\u06cc\u0646\u0634\u0627\u0633\u0627" },
            { "CF", "\u0648\u0633\u0637\u064a \u0627\u0641\u0631\u064a\u0642\u0627 \u062c\u0645\u0647\u0648\u0631" },
            { "CG", "\u06a9\u0627\u0646\u06ab\u0648 - \u0628\u0631\u0648\u0632\u0648\u06cc\u06cc\u0644" },
            { "CH", "\u0633\u0648\u06cc\u0633" },
            { "CI", "\u062f \u0639\u0627\u062c \u0633\u0627\u062d\u0644" },
            { "CK", "\u06a9\u0648\u06a9 \u067c\u0627\u067e\u0648\u06ab\u0627\u0646" },
            { "CL", "\u0686\u06cc\u0644\u064a" },
            { "CM", "\u06a9\u0627\u0645\u0631\u0648\u0646" },
            { "CN", "\u0686\u06cc\u0646" },
            { "CO", "\u06a9\u0648\u0644\u0645\u0628\u06cc\u0627" },
            { "CP", "\u062f \u06a9\u0644\u067e\u0631\u067c\u0648\u0646 \u067c\u0627\u067e\u0648" },
            { "CR", "\u06a9\u0648\u0633\u062a\u0627\u0631\u06cc\u06a9\u0627" },
            { "CU", "\u06a9\u06cc\u0648\u0628\u0627" },
            { "CV", "\u06a9\u06cc\u067e \u0648\u0631\u062f" },
            { "CW", "\u06a9\u0648\u0631\u0627\u06a9\u0627\u0648" },
            { "CX", "\u062f \u06a9\u0631\u064a\u0633\u0645\u0633 \u067c\u0627\u067e\u0648" },
            { "CY", "\u0642\u0628\u0631\u0633" },
            { "CZ", "\u0686\u06a9\u06cc\u0627" },
            { "DE", "\u0627\u0644\u0645\u0627\u0646" },
            { "DG", "\u0689\u0627\u06cc\u06ab\u0648 \u06ab\u0627\u0631\u0633\u06cc\u0627" },
            { "DJ", "\u062c\u0628\u0648\u062a\u064a" },
            { "DK", "\u0689\u0646\u0645\u0627\u0631\u06a9" },
            { "DM", "\u062f\u0648\u0645\u06cc\u0646\u06cc\u06a9\u0627" },
            { "DO", "\u062c\u0645\u0647\u0648\u0631\u064a\u0647 \u0689\u0648\u0645\u064a\u0646\u064a\u06a9\u0646" },
            { "DZ", "\u0627\u0644\u062c\u0632\u0627\u06cc\u0631" },
            { "EA", "\u0633\u064a\u0648\u062a\u0627 \u0627\u0648 \u0645\u0627\u0644\u064a\u0644\u0627" },
            { "EC", "\u0627\u06a9\u0648\u0627\u062f\u0648\u0631" },
            { "EE", "\u0627\u0633\u062a\u0648\u0646\u06cc\u0627" },
            { "EG", "\u0645\u0635\u0631" },
            { "EH", "\u0644\u0648\u064a\u062f\u064a\u0681 \u0635\u062d\u0627\u0631\u0627" },
            { "ER", "\u0627\u0631\u06cc\u062a\u0631\u0647" },
            { "ES", "\u0647\u0633\u067e\u0627\u0646\u06cc\u0647" },
            { "ET", "\u062d\u0628\u0634\u0647" },
            { "EU", "\u0627\u0631\u0648\u067e\u0627\u064a\u064a \u0627\u062a\u062d\u0627\u062f\u064a\u0647" },
            { "EZ", "\u0627\u0631\u0648\u067e\u0627\u064a\u064a \u0633\u064a\u0645\u0647" },
            { "FI", "\u0641\u0646\u0644\u06cc\u0646\u0689" },
            { "FJ", "\u0641\u062c\u064a" },
            { "FK", "\u0641\u0627\u06a9\u0644\u064a\u0646\u0689 \u067c\u0627\u067e\u0648\u06ab\u0627\u0646" },
            { "FM", "\u0645\u06cc\u06a9\u0631\u0648\u0646\u06cc\u0632\u06cc\u0627" },
            { "FO", "\u0641\u0627\u0631\u0648 \u067c\u0627\u067e\u0648" },
            { "FR", "\u0641\u0631\u0627\u0646\u0633\u0647" },
            { "GA", "\u06ab\u0627\u0628\u0646" },
            { "GB", "\u0628\u0631\u062a\u0627\u0646\u06cc\u0647" },
            { "GD", "\u06ab\u0631\u0646\u0627\u062f\u0627" },
            { "GE", "\u06af\u0648\u0631\u062c\u0633\u062a\u0627\u0646" },
            { "GF", "\u0641\u0631\u0627\u0646\u0633\u0648\u064a \u06ab\u0627\u0646\u0627" },
            { "GG", "\u06ab\u0631\u0646\u0633\u064a" },
            { "GH", "\u06ab\u0627\u0646\u0627" },
            { "GI", "\u062c\u0628\u0644 \u0627\u0644\u0637\u0627\u0631\u0642" },
            { "GL", "\u06ab\u0631\u06cc\u0646\u0644\u06cc\u0646\u0689" },
            { "GM", "\u06ab\u0627\u0645\u0628\u06cc\u0627" },
            { "GN", "\u06ab\u06cc\u0646\u0647" },
            { "GP", "\u06ab\u0648\u0627\u062f\u0644\u0648\u067e" },
            { "GQ", "\u0627\u0633\u062a\u0648\u0627\u06cc\u06cc \u06ab\u06cc\u0646\u064a" },
            { "GR", "\u06cc\u0648\u0646\u0627\u0646" },
            { "GS", "\u0633\u0648\u064a\u0644\u064a \u062c\u0627\u0631\u062c\u064a\u0627 \u0627\u0648 \u0633\u0648\u064a\u0644\u064a \u0633\u06d0\u0646\u0689\u0648\u0686 \u067c\u0627\u067e\u0648\u06ab\u0627\u0646" },
            { "GT", "\u06ab\u0648\u0627\u062a\u06cc\u0645\u0627\u0644\u0627" },
            { "GU", "\u06ab\u0648\u0627\u0645" },
            { "GW", "\u06ab\u06cc\u0646\u0647 \u0628\u06cc\u0633\u0648" },
            { "GY", "\u06ab\u06cc\u0627\u0646\u0627" },
            { "HK", "\u0647\u0627\u0646\u06ab \u06a9\u0627\u0646\u06ab SAR \u0686\u06cc\u0646" },
            { "HM", "\u0647\u0627\u0631\u0689 \u0627\u0648 \u0645\u064a\u06a9\u0689\u0627\u0646\u0644\u0689 \u067c\u0627\u067e\u0648\u06ab\u0627\u0646" },
            { "HN", "\u0647\u0627\u0646\u0689\u0648\u0631\u0627\u0633" },
            { "HR", "\u06a9\u0631\u0648\u0627\u0634\u064a\u0627" },
            { "HT", "\u0647\u0627\u06cc\u067c\u064a" },
            { "HU", "\u0645\u062c\u0627\u0631\u0633\u062a\u0627\u0646" },
            { "IC", "\u062f \u06a9\u0646\u0627\u0631\u064a \u067c\u0627\u067e\u0648\u06ab\u0627\u0646" },
            { "ID", "\u0627\u0646\u062f\u0648\u0646\u06cc\u0632\u06cc\u0627" },
            { "IE", "\u0622\u064a\u0631\u0644\u06d0\u0646\u0689" },
            { "IL", "\u0627\u0633\u0631\u0627\u064a\u064a\u0644" },
            { "IM", "\u062f \u0622\u0626\u0644 \u0622\u0641 \u0645\u06cc\u0646" },
            { "IN", "\u0647\u0646\u062f" },
            { "IO", "\u062f \u0628\u0631\u062a\u0627\u0646\u0648\u064a \u0647\u0646\u062f \u0633\u0645\u0646\u062f\u0631\u064a \u0633\u064a\u0645\u0647" },
            { "IQ", "\u0639\u0631\u0627\u0642" },
            { "IR", "\u0627\u064a\u0631\u0627\u0646" },
            { "IS", "\u0622\u06cc\u0633\u0644\u06cc\u0646\u0689" },
            { "IT", "\u0627\u06cc\u067c\u0627\u0644\u06cc\u0647" },
            { "JE", "\u062c\u0631\u0633\u06cc" },
            { "JM", "\u062c\u0645\u06cc\u06a9\u0627" },
            { "JO", "\u0627\u0631\u062f\u0646" },
            { "JP", "\u062c\u0627\u067e\u0627\u0646" },
            { "KE", "\u06a9\u06cc\u0646\u06cc\u0627" },
            { "KG", "\u0642\u0631\u063a\u0632\u0633\u062a\u0627\u0646" },
            { "KH", "\u06a9\u0645\u0628\u0648\u062f\u06cc\u0627" },
            { "KI", "\u06a9\u06cc\u0631\u064a \u0628\u0627\u062a\u064a" },
            { "KM", "\u06a9\u0648\u0645\u0648\u0631\u0648\u0633" },
            { "KN", "\u0633\u06cc\u0646\u067c \u06a9\u067c\u0633 \u0627\u0648 \u0646\u06cc\u0648\u06cc\u0633" },
            { "KP", "\u0634\u0645\u0627\u0644\u06cc \u06a9\u0648\u0631\u06cc\u0627" },
            { "KR", "\u0633\u0648\u06cc\u0644\u064a \u06a9\u0648\u0631\u06cc\u0627" },
            { "KW", "\u06a9\u0648\u064a\u062a" },
            { "KY", "\u06a9\u06cc\u0645\u0627\u0646 \u067c\u0627\u067e\u0648\u06ab\u0627\u0646" },
            { "KZ", "\u0642\u0632\u0627\u0642\u0633\u062a\u0627\u0646" },
            { "LA", "\u0644\u0627\u0648\u0633" },
            { "LB", "\u0644\u0628\u0646\u0627\u0646" },
            { "LC", "\u0633\u06cc\u0646\u067c \u0644\u0648\u0633\u06cc\u0627" },
            { "LI", "\u0644\u06cc\u062e\u062a\u0646 \u0627\u0634\u062a\u0627\u06cc\u0646" },
            { "LK", "\u0633\u0631\u064a\u0644\u0646\u06a9\u0627" },
            { "LR", "\u0644\u0627\u064a\u0628\u064a\u0631\u064a\u0627" },
            { "LS", "\u0644\u0633\u0648\u062a\u0648" },
            { "LT", "\u0644\u06cc\u062a\u0648\u0627\u0646\u06cc\u0627" },
            { "LU", "\u0644\u0648\u06ab\u0632\u0627\u0645\u0628\u0648\u0631\u06ab" },
            { "LV", "\u0644\u064a\u062a\u0647\u0648\u064a\u0627" },
            { "LY", "\u0644\u06cc\u0628\u06cc\u0627" },
            { "MA", "\u0645\u0631\u0627\u06a9\u0634" },
            { "MC", "\u0645\u0648\u0646\u0627\u06a9\u0648" },
            { "MD", "\u0645\u0648\u0644\u062f\u0648\u0627" },
            { "ME", "\u0645\u0648\u0646\u067c\u06cc\u0646\u06cc\u06ab\u0631\u0648" },
            { "MF", "\u0633\u06cc\u0646\u067c \u0645\u0627\u0631\u067c\u0646" },
            { "MG", "\u0645\u062f\u063a\u0627\u0633\u06a9\u0631" },
            { "MH", "\u0645\u0627\u0631\u0634\u0644 \u067c\u0627\u067e\u0648\u06ab\u0627\u0646" },
            { "MK", "\u0634\u0645\u0627\u0644\u064a \u0645\u0642\u062f\u0648\u0646\u064a\u0647" },
            { "ML", "\u0645\u0627\u0644\u064a" },
            { "MM", "\u0645\u064a\u0627\u0646\u0645\u0627\u0631 (\u0628\u0631\u0645\u0627)" },
            { "MN", "\u0645\u0646\u06ab\u0648\u0644\u064a\u0627" },
            { "MO", "\u0645\u06a9\u0627\u0648 SAR \u0686\u06cc\u0646" },
            { "MP", "\u0634\u0645\u0627\u0644\u064a \u0645\u0627\u0631\u064a\u0627\u0646\u0627 \u067c\u0627\u067e\u0648\u06ab\u0627\u0646" },
            { "MQ", "\u0645\u0627\u0631\u067c\u06cc\u0646\u06cc\u06a9" },
            { "MR", "\u0645\u0648\u0631\u06cc\u062a\u0627\u0646\u06cc\u0627" },
            { "MS", "\u0645\u0627\u0646\u067c\u06cc\u0633\u06cc\u0631\u062a" },
            { "MT", "\u0645\u0627\u0644\u067c\u0627" },
            { "MU", "\u0645\u0648\u0631\u06cc\u0634\u06cc\u0633" },
            { "MV", "\u0645\u0627\u0644\u062f\u064a\u067e" },
            { "MW", "\u0645\u0627\u0644\u0627\u0648\u064a" },
            { "MX", "\u0645\u06cc\u06a9\u0633\u06cc\u06a9\u0648" },
            { "MY", "\u0645\u0627\u0644\u06cc\u0632\u06cc\u0627" },
            { "MZ", "\u0645\u0648\u0632\u0645\u0628\u064a\u0642" },
            { "NA", "\u0646\u06cc\u0645\u0628\u06cc\u0627" },
            { "NC", "\u0646\u0648\u06cc \u06a9\u0627\u0644\u06cc\u0689\u0648\u0646\u06cc\u0627" },
            { "NE", "\u0646\u0627\u064a\u062c\u064a\u0631" },
            { "NF", "\u0646\u0627\u0631\u0641\u0648\u0644\u06a9 \u067c\u0627\u067e\u0648\u06ab\u0627\u0646" },
            { "NG", "\u0646\u0627\u06cc\u062c\u06cc\u0631\u06cc\u0627" },
            { "NI", "\u0646\u06a9\u0627\u0631\u0627\u06ab\u0648\u0627" },
            { "NL", "\u0647\u0627\u0644\u06d0\u0646\u0689" },
            { "NO", "\u0646\u0627\u0631\u0648\u06cd" },
            { "NP", "\u0646\u06cc\u067e\u0627\u0644" },
            { "NR", metaValue_NR },
            { "NU", "\u0646\u06cc\u0648\u0648" },
            { "NZ", "\u0646\u06cc\u0648\u0632\u06cc\u0644\u0646\u0689" },
            { "OM", "\u0639\u0645\u0627\u0646" },
            { "PA", "\u067e\u0627\u0646\u0627\u0645\u0627" },
            { "PE", "\u067e\u06cc\u0631\u0648" },
            { "PF", "\u0641\u0631\u0627\u0646\u0633\u0648\u064a \u067e\u0648\u0644\u064a\u0646\u064a\u0633\u064a\u0627" },
            { "PG", "\u067e\u0627\u067e\u0648\u0627 \u0646\u064a\u0648 \u06ab\u064a\u0646\u064a" },
            { "PH", "\u0641\u0644\u067e\u064a\u0646" },
            { "PK", "\u067e\u0627\u06a9\u0633\u062a\u0627\u0646" },
            { "PL", "\u067e\u0648\u0644\u0646\u0689" },
            { "PM", "\u0633\u06cc\u0646\u067c \u067e\u06cc\u06cc\u0631 \u0627\u0648 \u0645\u06cc\u06a9\u0648\u0644\u0648\u0646" },
            { "PN", "\u067e\u064a\u067c\u06a9\u064a\u0631\u0646 \u067c\u0627\u067e\u0648\u06ab\u0627\u0646" },
            { "PR", "\u067e\u0648\u0631\u062a\u0648 \u0631\u06cc\u06a9\u0648" },
            { "PS", "\u0641\u0644\u0633\u0637\u06cc\u0646\u064a \u0633\u064a\u0645\u06d0" },
            { "PT", "\u067e\u0648\u0631\u062a\u06ab\u0627\u0644" },
            { "PW", "\u067e\u0644\u0627\u0624" },
            { "PY", "\u067e\u0627\u0631\u0627\u06ab\u0648\u06cc" },
            { "QA", "\u0642\u0637\u0631" },
            { "QO", "\u0628\u0647\u0631\u0646\u06cd \u0627\u0648\u0633\u064a\u0627\u0646\u0647" },
            { "RE", "\u0631\u06cc\u0648\u0646\u06cc\u0646" },
            { "RO", "\u0631\u0648\u0645\u0627\u0646\u06cc\u0627" },
            { "RS", "\u0633\u0631\u0628\u064a\u0627" },
            { "RU", "\u0631\u0648\u0633\u06cc\u0647" },
            { "RW", "\u0631\u0648\u0646\u062f\u0627" },
            { "SA", "\u0633\u0639\u0648\u062f\u064a \u0639\u0631\u0628\u0633\u062a\u0627\u0646" },
            { "SB", "\u0633\u0644\u064a\u0645\u0627\u0646 \u067c\u0627\u067e\u0648\u06ab\u0627\u0646" },
            { "SC", "\u0633\u06cc\u0686\u06cc\u0644\u06cc\u0633" },
            { "SD", "\u0633\u0648\u0689\u0627\u0646" },
            { "SE", "\u0633\u0648\u06cc\u0689\u0646" },
            { "SG", "\u0633\u064a\u0646\u06af\u0627\u067e\u0648\u0631" },
            { "SH", "\u0633\u06cc\u0646\u067c \u0647\u06cc\u0644\u06cc\u0646\u0627" },
            { "SI", "\u0633\u0644\u0648\u0627\u0646\u06cc\u0627" },
            { "SJ", "\u0633\u0648\u0627\u0644\u0628\u0627\u0631\u062f \u0627\u0648 \u062c\u0627\u0646 \u0645\u064a\u064a\u0646" },
            { "SK", "\u0633\u0644\u0648\u0627\u06a9\u06cc\u0627" },
            { "SL", "\u0633\u06cc\u06cc\u0631\u0627 \u0644\u06cc\u0648\u0646" },
            { "SM", "\u0633\u0627\u0646 \u0645\u0627\u0631\u06cc\u0646\u0648" },
            { "SN", "\u0633\u064a\u0646\u064a\u06ab\u0627\u0644" },
            { "SO", "\u0633\u0648\u0645\u0627\u0644\u06cc\u0627" },
            { "SR", "\u0633\u0648\u0631\u06cc\u0646\u0627\u0645" },
            { "SS", "\u0633\u0648\u064a\u0644\u064a \u0633\u0648\u0689\u0627\u0646" },
            { "ST", "\u0633\u0627\u0648 \u067c\u06cc\u0645 \u0627\u0648 \u067e\u0631\u0646\u0633\u06cc\u067e" },
            { "SV", "\u0633\u0627\u0644\u0648\u06d0\u0689\u0648\u0631" },
            { "SX", "\u0633\u06cc\u0646\u067c \u0645\u0627\u0631\u067c\u06cc\u0646" },
            { "SY", "\u0633\u0648\u0631\u06cc\u0647" },
            { "SZ", "\u0627\u0633\u0648\u0627\u067c\u064a\u0646\u064a" },
            { "TA", "\u062a\u0631\u06cc\u0633\u062a\u0627\u0646 \u062f\u0627 \u06a9\u0646\u0647\u0627" },
            { "TC", "\u062f \u062a\u0631\u06a9\u06cc\u06d0 \u0627\u0648 \u06a9\u06cc\u06a9\u0627\u0633\u0648 \u067c\u0627\u067e\u0648" },
            { "TD", "\u0686\u0627\u0689" },
            { "TF", "\u062f \u0641\u0631\u0627\u0646\u0633\u06d0 \u062c\u0646\u0648\u0628\u064a \u0633\u06cc\u0645\u06d0" },
            { "TG", "\u067c\u0648\u06ab\u0648" },
            { "TH", "\u062a\u0647\u0627\u064a\u0644\u0646\u0689" },
            { "TJ", "\u062a\u0627\u062c\u06a9\u0633\u062a\u0627\u0646" },
            { "TK", "\u062a\u0648\u06a9\u06cc\u0644\u0648" },
            { "TL", "\u062a\u064a\u0645\u0648\u0631-\u0644\u064a\u0633\u067c" },
            { "TM", "\u062a\u0648\u0631\u06a9\u0645\u0646\u0633\u062a\u0627\u0646" },
            { "TN", "\u062a\u0648\u0646\u0633" },
            { "TO", "\u062a\u0648\u0646\u06ab\u0627" },
            { "TR", metaValue_TR },
            { "TT", "\u067c\u0631\u064a\u0646\u064a\u0689\u0627\u0689 \u0627\u0648 \u067c\u0648\u0628\u0627\u06ab\u0648" },
            { "TV", "\u062a\u0648\u0627\u0644\u06cc\u0648" },
            { "TW", "\u062a\u0627\u0626\u064a\u0648\u0627\u0646" },
            { "TZ", "\u062a\u0646\u0632\u0627\u0646\u06cc\u0627" },
            { "UA", "\u0627\u0648\u06a9\u0631\u0627\u06cc\u0646" },
            { "UG", "\u06cc\u0648\u06ab\u0627\u0646\u0689\u0627" },
            { "UM", "\u062f \u0645\u062a\u062d\u062f\u0647 \u0627\u06cc\u0627\u0644\u0627\u062a\u0648 \u067c\u0627\u067e\u0648\u06ab\u0627\u0646" },
            { "UN", "\u0645\u0644\u06af\u0631\u064a \u0645\u0644\u062a\u0648\u0646\u0647" },
            { "US", "\u0645\u062a\u062d\u062f\u0647 \u0622\u064a\u0627\u0644\u0627\u062a" },
            { "UY", "\u06cc\u0648\u0631\u0648\u06ab\u0648\u06cc" },
            { "UZ", "\u0627\u0648\u0632\u0628\u06a9\u0633\u062a\u0627\u0646" },
            { "VA", "\u0648\u0627\u062a\u06cc\u06a9\u0627\u0646 \u069a\u0627\u0631" },
            { "VC", "\u0633\u06cc\u0646\u067c \u0648\u06cc\u0633\u0646\u067c\u06cc\u0646\u067c \u0627\u0648 \u06ab\u0631\u06cc\u0646\u0689\u06cc\u0646\u0632" },
            { "VE", "\u0648\u06cc\u0646\u0632\u0648\u06cc\u0644\u0627" },
            { "VG", "\u0628\u0631\u06cc\u062a\u0627\u0646\u0648\u06cc \u0648\u06cc\u06ab\u0648\u0631 \u067c\u0627\u067e\u0648\u06ab\u0627\u0646" },
            { "VI", "\u062f \u0645\u062a\u062d\u062f\u0647 \u0622\u064a\u0627\u0644\u0627\u062a\u0648 \u0648\u0631\u062c\u0646 \u067c\u0627\u067e\u0648\u06ab\u0627\u0646" },
            { "VN", "\u0648\u06d0\u062a\u0646\u0627\u0645" },
            { "VU", "\u0648\u0627\u0646\u0627\u062a\u0648" },
            { "WF", "\u0648\u0627\u0644\u06cc\u0633 \u0627\u0648 \u0641\u0648\u062a\u0648\u0646\u0627" },
            { "WS", "\u0633\u0627\u0645\u0627\u0648\u0627" },
            { "XA", "\u062c\u0639\u0644\u064a \u062e\u062c" },
            { "XB", "\u0633\u06cc\u0689\u0648 \u0628\u06cc\u0689\u06cc" },
            { "XK", "\u06a9\u0648\u0633\u0648\u0648" },
            { "YE", "\u06cc\u0645\u0646" },
            { "YT", "\u0645\u0627\u064a\u0648\u067c" },
            { "ZA", "\u0633\u0648\u06cc\u0644\u064a \u0627\u0641\u0631\u06cc\u0642\u0627" },
            { "ZM", "\u0632\u06cc\u0645\u0628\u06cc\u0627" },
            { "ZW", "\u0632\u06cc\u0645\u0628\u0627\u0628\u0648\u06cc" },
            { "ZZ", "\u0646\u0627\u0645\u0639\u0644\u0648\u0645\u0647 \u0633\u064a\u0645\u0647" },
            { "aa", "\u0627\u0641\u0631\u064a" },
            { "ab", "\u0627\u0628\u062e\u0627\u0632\u064a" },
            { "af", "\u0627\u0641\u0631\u06cc\u06a9\u0627\u0646\u0633\u064a" },
            { "ak", "\u0627\u06a9\u0627\u0646\u064a" },
            { "am", "\u0627\u0645\u0647\u0627\u0631\u064a" },
            { "an", "\u0627\u0631\u0627\u06af\u0648\u0646\u06d0\u0633\u064a" },
            { "ar", metaValue_ar },
            { "as", "\u0627\u0633\u0627\u0645\u064a" },
            { "av", "\u0627\u0648\u0627\u0631\u064a" },
            { "ay", "\u0627\u06cc\u0645\u0627\u0631\u064a" },
            { "az", "\u0627\u0630\u0631\u0628\u0627\u06cc\u062c\u0627\u0646\u064a" },
            { "ba", "\u0628\u0627\u0634\u06a9\u064a\u0631" },
            { "be", "\u0628\u06d0\u0644\u0627\u0631\u0648\u0633\u064a" },
            { "bg", "\u0628\u0644\u063a\u0627\u0631\u064a" },
            { "bi", "\u0628\u0633\u0644\u0627\u0645\u0627" },
            { "bm", "\u0628\u0645\u0628\u0627\u0631\u0627" },
            { "bn", "\u0628\u0646\u06af\u0627\u0644\u064a" },
            { "bo", metaValue_bo },
            { "br", "\u0628\u0631\u06d0\u062a\u0648\u0646" },
            { "bs", "\u0628\u0648\u0633\u0646\u064a" },
            { "ca", "\u06a9\u067c\u0644\u0627\u0646\u064a" },
            { "ce", "\u0686\u064a\u0686\u0646\u064a" },
            { "ch", "\u0686\u0645\u0648\u0631\u0648" },
            { "co", "\u06a9\u0648\u0631\u0633\u064a\u06a9\u0627\u0646\u064a" },
            { "cs", "\u0686\u06d0\u06a9\u064a" },
            { "cu", "\u062f \u06a9\u0644\u064a\u0633\u0627 \u0633\u0644\u0627\u0648\u064a" },
            { "cv", "\u0686\u0648\u0648\u0627\u0634\u064a" },
            { "cy", "\u0648\u064a\u0644\u0634\u064a" },
            { "da", "\u0689\u0646\u0645\u0627\u0631\u06a9\u064a" },
            { "de", "\u0627\u0644\u0645\u0627\u0646\u064a" },
            { "dv", "\u062f\u064a\u0648\u06cc\u0647\u06cc" },
            { "dz", "\u0698\u0648\u0646\u06af\u06a9\u0647" },
            { "ee", "\u0627\u064a\u0648" },
            { "el", metaValue_el },
            { "en", "\u0627\u0646\u06ab\u0644\u064a\u0633\u064a" },
            { "eo", "\u0627\u0633\u067e\u0631\u0627\u0646\u062a\u0648" },
            { "es", "\u0647\u0633\u067e\u0627\u0646\u0648\u064a" },
            { "et", "\u062d\u0628\u0634\u064a" },
            { "eu", "\u0628\u0627\u0633\u06a9\u064a" },
            { "fa", "\u0641\u0627\u0631\u0633\u064a" },
            { "ff", "\u0641\u0648\u0644\u0627\u062d" },
            { "fi", "\u0641\u06cc\u0646\u0644\u0646\u0689\u064a" },
            { "fj", "\u0641\u062c\u06cc\u0627\u0646" },
            { "fo", "\u0641\u0627\u0631\u0648\u0626\u06d0" },
            { "fr", "\u0641\u0631\u0627\u0646\u0633\u0648\u064a" },
            { "fy", "\u0644\u0648\u06d0\u062f\u064a\u0681 \u0641\u0631\u064a\u0634\u064a" },
            { "ga", "\u0627\u0626\u064a\u0631\u0644\u06d0\u0646\u0689\u064a" },
            { "gd", "\u0633\u06a9\u0627\u067c\u0644\u06d0\u0646\u0689\u064a \u06ab\u06d0\u0644\u06a9" },
            { "gl", "\u06ab\u0644\u06d0\u0634\u064a\u0627\u064a\u064a" },
            { "gn", "\u06ab\u0648\u0631\u0627\u0646\u064a" },
            { "gu", metaValue_gu },
            { "gv", "\u0645\u06cc\u0646\u06a9\u0633" },
            { "ha", "\u0647\u0648\u0633\u0627" },
            { "he", metaValue_he },
            { "hi", "\u0647\u0646\u062f\u064a" },
            { "hr", "\u06a9\u0631\u0648\u0627\u064a\u0634\u064a\u0627\u064a\u064a" },
            { "ht", "\u0647\u064a\u067c\u064a \u06a9\u0631\u064a\u0648\u0644" },
            { "hu", "\u0647\u0646\u06ab\u0631\u064a" },
            { "hy", "\u0622\u0631\u0645\u064a\u0646\u064a\u0627\u064a\u064a" },
            { "hz", "\u0647\u06cc\u0631\u0648\u0631\u0648" },
            { "ia", "\u0627\u0646\u067c\u0631\u0644\u0646\u06ab\u0648\u0627" },
            { "id", "\u0627\u0646\u0689\u0648\u0646\u06d0\u0632\u064a" },
            { "ie", "\u0622\u0633\u0627 \u0646\u0627 \u062c\u0628\u0629" },
            { "ig", "\u0627\u06ab\u0628\u0648" },
            { "ii", "\u0633\u06cc\u0686\u06cc\u0627\u0646 \u06cc\u06cc" },
            { "io", "\u0627\u068a\u0648" },
            { "is", "\u0627\u064a\u0633\u0644\u0646\u0689\u064a" },
            { "it", "\u0627\u06cc\u067c\u0627\u0644\u0648\u064a" },
            { "iu", "\u0627\u0646\u0648\u06a9\u062a\u06cc\u062a\u0648\u062a" },
            { "ja", metaValue_ja },
            { "jv", "\u062c\u0627\u0648\u0627\u064a\u064a" },
            { "ka", "\u062c\u0648\u0631\u062c\u064a\u0627\u0626\u064a" },
            { "ki", "\u06a9\u06a9\u0648\u0624\u0648" },
            { "kj", "\u06a9\u0648\u0627\u0646\u0627\u0645\u0627" },
            { "kk", "\u0642\u0627\u0632\u0642" },
            { "kl", "\u06a9\u0627\u0644\u0627\u0644\u06cc\u0633\u062a" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "\u06a9\u0646\u0648\u0631\u06cc" },
            { "ks", "\u06a9\u0634\u0645\u06cc\u0631\u064a" },
            { "ku", "\u06a9\u0631\u062f\u064a" },
            { "kv", "\u06a9\u0648\u0645\u06cc" },
            { "kw", "\u06a9\u0648\u0631\u0646\u064a\u0634\u064a" },
            { "ky", "\u06a9\u0631\u063a\u064a\u0632\u064a" },
            { "la", "\u0644\u0627\u062a\u06cc\u0646\u064a" },
            { "lb", "\u0644\u0648\u06ab\u0632\u0627\u0645\u0628\u0648\u0631\u06ab\u064a" },
            { "lg", "\u06ab\u0627\u0646\u062f\u0647" },
            { "li", "\u0644\u0645\u0628\u0631\u06af\u06cc\u0627\u0646\u06cc" },
            { "ln", "\u0644\u0646\u06ab\u0627\u0644\u0627" },
            { "lo", "\u0644\u0627\u0648" },
            { "lt", "\u0644\u064a\u062a\u0648\u0627\u0646\u064a" },
            { "lu", "\u0644\u0648\u0628\u0627-\u06a9\u067c\u0646\u06ab\u0627" },
            { "lv", "\u0644\u06d0\u067c\u0648\u0627\u0646\u064a" },
            { "mg", "\u0645\u0644\u063a\u0627\u0633\u064a" },
            { "mh", "\u0645\u0627\u0631\u0634\u0644\u06cc\u0632" },
            { "mi", "\u0645\u0627\u0648\u0631\u064a" },
            { "mk", "\u0645\u0642\u062f\u0648\u0646\u064a" },
            { "ml", "\u0645\u0627\u0644\u0627\u064a\u0627\u0644\u0645" },
            { "mn", "\u0645\u0646\u06ab\u0648\u0644\u06cc\u0627\u06cc\u06cc" },
            { "mr", "\u0645\u0631\u0627\u067c\u0647\u064a" },
            { "ms", "\u0645\u0644\u0627\u06cc\u0627" },
            { "mt", "\u0645\u0627\u0644\u067c\u0627\u064a\u064a" },
            { "my", "\u0628\u0631\u0645\u0627\u06cc\u06cc" },
            { "na", metaValue_NR },
            { "nb", "\u0646\u0627\u0631\u0648\u06d0\u0626\u064a (\u0628\u0648\u06a9\u0645\u0627\u0644)" },
            { "nd", "\u0634\u0645\u0627\u0644\u064a \u0646\u062f\u064a\u0628\u0644" },
            { "ne", "\u0646\u06d0\u067e\u0627\u0644\u064a" },
            { "ng", "\u0646\u062f\u0648\u0646\u06af\u0627" },
            { "nl", "\u0647\u0627\u0644\u06d0\u0646\u0689\u064a" },
            { "nn", "\u0646\u0627\u0631\u0648\u06d0\u0626\u064a (\u0646\u0627\u0626\u0646\u0648\u0631\u0633\u06a9)" },
            { "no", "\u0646\u0627\u0631\u0648\u06d0\u0626\u064a" },
            { "nr", "\u0633\u0648\u064a\u0644\u064a \u0646\u062f\u064a\u0628\u064a\u0644" },
            { "nv", "\u0646\u0648\u0627\u062c\u0648" },
            { "ny", "\u0646\u06cc\u0627\u0646\u062c\u0627" },
            { "oc", "\u0627\u0648\u06a9\u0633\u064a\u067c\u0627\u0646\u064a" },
            { "om", "\u0627\u0648\u0631\u0648\u0645\u0648" },
            { "or", "\u0627\u0648\u068a\u064a\u0627" },
            { "os", "\u0627\u0648\u0633\u064a\u067c\u06a9" },
            { "pa", "\u067e\u0646\u062c\u0627\u0628\u064a" },
            { "pl", "\u067e\u0648\u0644\u0646\u0689\u064a" },
            { "ps", "\u067e\u069a\u062a\u0648" },
            { "pt", "\u067e\u0648\u0631\u062a\u06ab\u0627\u0644\u064a" },
            { "qu", "\u06a9\u06d0\u0686\u0648\u0627" },
            { "rm", "\u0631\u0648\u0645\u0627\u0646\u06cc\u0634" },
            { "rn", "\u0631\u0648\u0646\u0689\u06cc" },
            { "ro", "\u0631\u0648\u0645\u0627\u0646\u06cc\u0627\u06cc\u06cc" },
            { "ru", "\u0631\u0648\u0633\u064a" },
            { "rw", "\u06a9\u06cc\u0646\u06cc\u0627\u0631\u0648\u0646\u0689\u0627" },
            { "sa", "\u0633\u0646\u0633\u06a9\u0631\u06cc\u067c" },
            { "sc", "\u0633\u0627\u0631\u068a\u064a\u0646\u064a" },
            { "sd", "\u0633\u0646\u062f\u0647\u064a" },
            { "se", "\u0634\u0645\u0627\u0644\u064a \u0633\u0627\u0645\u064a" },
            { "sg", "\u0633\u0627\u0646\u06ab\u0648" },
            { "si", "\u0633\u064a\u0646\u0647\u0627\u0644\u064a" },
            { "sk", "\u0633\u0644\u0648\u0648\u0627\u06a9\u064a" },
            { "sl", "\u0633\u0644\u0648\u0648\u0627\u0646\u064a" },
            { "sm", "\u0633\u0627\u0645\u0648\u0622\u0646" },
            { "sn", "\u0634\u0648\u0646\u0627" },
            { "so", "\u0633\u0648\u0645\u0627\u0644\u064a" },
            { "sq", "\u0627\u0644\u0628\u0627\u0646\u064a" },
            { "sr", "\u0633\u0631\u0628\u064a\u0627\u0626\u064a" },
            { "ss", "\u0633\u0648\u0627\u062a\u06cc" },
            { "st", "\u0633\u0648\u064a\u0644\u064a \u0633\u0648\u062a\u0648" },
            { "su", "\u0633\u0648\u0689\u0627\u0646\u064a" },
            { "sv", "\u0633\u0648\u06cc\u0689\u0646\u06cc" },
            { "sw", "\u0633\u0648\u0627\u0647\u06d0\u0644\u064a" },
            { "ta", metaValue_ta },
            { "te", "\u062a\u06d0\u0644\u064a\u06ab\u0648" },
            { "tg", "\u062a\u0627\u062c\u06a9\u064a" },
            { "th", "\u062a\u0627\u064a\u0644\u06d0\u0646\u0689\u064a" },
            { "ti", "\u062a\u064a\u06ab\u0631\u064a\u0646\u064a" },
            { "tk", "\u062a\u0631\u06a9\u0645\u0646\u064a" },
            { "tn", "\u0633\u0648\u0648\u0627\u0646\u0627" },
            { "to", "\u062a\u0648\u0646\u06ab\u0627\u0646" },
            { "tr", metaValue_TR },
            { "ts", "\u0633\u0648\u0646\u06ab\u0627" },
            { "tt", "\u062a\u0627\u062a\u0627\u0631" },
            { "ty", "\u062a\u0627\u0647\u06cc\u062a\u064a" },
            { "ug", "\u0627\u0648\u064a\u063a\u0648\u0631\u064a" },
            { "uk", "\u0627\u0648\u06a9\u0631\u0627\u064a\u0646\u064a" },
            { "ur", "\u0627\u0631\u062f\u0648" },
            { "uz", "\u0627\u0648\u0632\u0628\u06a9\u064a" },
            { "ve", "\u0648\u06cc\u0646\u062f\u0627" },
            { "vi", "\u0648\u06d0\u062a\u0646\u0627\u0645\u064a" },
            { "vo", "\u0648\u0627\u0644\u0627\u067e\u0648\u06a9" },
            { "wa", "\u0648\u0627\u0644\u0648\u0646" },
            { "wo", "\u0648\u0644\u0648\u0641" },
            { "xh", "\u062e\u0648\u0633\u0627" },
            { "yi", "\u064a\u062f\u064a\u0634" },
            { "yo", "\u06cc\u0648\u0631\u0648\u0628\u0627" },
            { "za", "\u0698\u0648\u0627\u0646\u06ab" },
            { "zh", "\u0686\u06cc\u0646\u064a" },
            { "zu", "\u0632\u0648\u0644\u0648" },
            { "ace", "\u0627\u0686\u064a\u0646\u064a" },
            { "ada", "\u0627\u062f\u0627\u0646\u06af\u0645\u064a" },
            { "ady", "\u0627\u062f\u064a\u063a\u064a" },
            { "agq", "\u0627\u063a\u06cc\u0645\u064a" },
            { "ain", "\u0627\u064a\u0646\u0648\u064a\u064a" },
            { "ale", "\u0627\u0644\u064a\u0648\u062a\u064a" },
            { "alt", "\u0633\u0648\u06cc\u0644 \u0627\u0644\u067c\u0627\u06cc" },
            { "ann", "Obo" },
            { "anp", "\u0627\u0646\u06af\u064a\u06a9\u064a" },
            { "arn", "\u0645\u0627\u067e\u0648\u0686\u0647" },
            { "arp", "\u0627\u0631\u0627\u067e\u0627\u0647\u0648\u064a" },
            { "ars", "\u0646\u062c\u062f\u06cc \u0639\u0631\u0628\u06cc" },
            { "asa", "\u0627\u0633\u0648\u064a\u064a" },
            { "ast", "\u0627\u0633\u062a\u0648\u0631\u064a\u0627\u0646\u064a" },
            { "atj", "\u0627\u062a\u06cc\u06a9\u0627\u0645\u06cc\u06a9\u0648" },
            { "awa", "\u0627\u0648\u0627\u062f\u064a" },
            { "bal", "\u0628\u0644\u0648\u0685\u064a" },
            { "ban", "\u0628\u0627\u0644\u0646\u06cc" },
            { "bas", "\u0628\u0627\u0633\u0627" },
            { "bem", "\u0628\u064a\u0645\u0628\u0627" },
            { "bez", "\u0628\u064a\u0646\u0627" },
            { "bgc", "\u0647\u0631\u06cc\u0627\u0646\u0648\u06cc" },
            { "bho", "\u0628\u0647\u0648\u062c\u067e\u0648\u0631\u064a" },
            { "bin", "\u0628\u06cc\u0646\u06cc" },
            { "bla", "\u0633\u06a9\u0633\u064a\u06a9\u0627" },
            { "blo", "\u0627\u0646\u06cd" },
            { "brx", "\u0628\u0648\u062f\u0648" },
            { "bug", "\u0628\u06af\u0646\u064a\u0627\u064a\u064a" },
            { "byn", "\u0628\u0644\u06cc\u0646" },
            { "cay", "Ca" },
            { "ccp", metaValue_ccp },
            { "ceb", "\u0633\u06cc\u0628\u0648\u0627\u0646\u0648\u064a" },
            { "cgg", "\u0686\u064a\u06af\u0627\u064a\u064a" },
            { "chk", "\u0686\u0648\u0627\u0648\u06a9\u064a" },
            { "chm", "\u0645\u0627\u0631\u064a" },
            { "cho", "\u0686\u0648\u06a9\u067c\u0627\u0648\u064a" },
            { "chp", "Ch" },
            { "chr", "\u0686\u06d0\u0631\u0648\u06a9\u064a" },
            { "chy", "\u0634\u064a\u0646\u064a" },
            { "ckb", "\u0645\u0646\u0681\u0646\u06cd \u06a9\u0648\u0631\u062f\u064a" },
            { "clc", "\u0686\u06cc\u0644\u06a9\u0648\u067c\u06cc\u0646" },
            { "crg", "mc" },
            { "crj", "\u0633\u0648\u06cc\u0644 \u062e\u062a\u06cc\u0681 \u06a9\u0631\u06cc" },
            { "crk", "\u067e\u0644\u06cc\u0646\u0632 \u06a9\u0631\u06cc" },
            { "crl", "\u0634\u0645\u0627\u0644\u064a \u062e\u062a\u06cc\u0681 \u06a9\u0631\u06cc" },
            { "crm", "mcr" },
            { "crr", "Car Alg" },
            { "crs", "\u0633\u0633\u064a\u0644\u0648\u0627 \u06aa\u0631\u0648\u0626\u0644 \u0641\u0631\u0627\u0646\u0633\u0648\u064a" },
            { "csw", "\u0633\u0648\u0645\u067e\u06cc \u06a9\u0631\u06cc" },
            { "dak", "\u062f\u0627\u06a9\u0648\u062a\u0627" },
            { "dar", "\u062f\u0631\u06af\u0648\u0627" },
            { "dav", "\u067c\u0627\u06cc\u067c\u0627" },
            { "dgr", "\u062f\u0627\u06af\u0631\u0628" },
            { "dje", "\u0632\u0631\u0645\u0627" },
            { "doi", "\u0689\u0648\u06ab\u0631\u064a" },
            { "dsb", "\u06a9\u069a\u062a\u0647 \u0633\u0631\u0628\u064a\u0627\u064a\u064a" },
            { "dua", "\u062f\u0648\u0627\u0644\u0627" },
            { "dyo", "\u062c\u0648\u0644\u0627 \u0641\u0648\u0646\u064a" },
            { "dzg", "\u0689\u0632\u0627\u06ab\u0627" },
            { "ebu", "\u0627\u064a\u0645\u0628\u0648" },
            { "efi", "\u0627\u0641\u06a9" },
            { "eka", "\u0627\u06a9\u062c\u06a9" },
            { "ewo", "\u0627\u0648\u0648\u0646\u068a\u0648" },
            { "fil", "\u0641\u0644\u06cc\u067e\u06cc\u0646\u064a" },
            { "fon", "\u0641\u0627\u0646" },
            { "frc", "\u06a9\u0627\u062c\u0648\u0646 \u0641\u0631\u0627\u0646\u0633\u0648\u06cc" },
            { "frr", "\u0634\u0645\u0627\u0644\u064a \u0641\u0631\u06cc\u0633\u06cc\u0627\u0646" },
            { "fur", "\u0641\u0631\u0627\u0626\u06cc\u0644\u06cc\u06cc\u0646" },
            { "gaa", "Ga" },
            { "gez", "\u06ab\u06cc\u0632" },
            { "gil", "\u06af\u0644\u0628\u0631\u062a\u064a" },
            { "gor", "\u06ab\u0648\u0631\u0646 \u067c\u0627\u0644\u0648" },
            { "gsw", "\u0633\u0648\u06cc\u0633 \u062c\u0631\u0645\u0646" },
            { "guz", "\u06ab\u0648\u0633\u064a" },
            { "gwi", "\u06ab\u06cc\u0686\u06cc\u0646" },
            { "hai", "ha" },
            { "haw", "\u0647\u0648\u0627\u06cc\u06cc" },
            { "hax", "\u062c\u0646\u0648\u0628\u064a \u0647\u0627\u06cc\u062f\u0627" },
            { "hil", "\u06be\u0644\u06cc\u06ab\u06cc\u0646\u0648\u0646" },
            { "hmn", "\u0647\u0645\u0648\u0646\u06ab" },
            { "hsb", "\u067e\u0648\u0631\u062a\u0647 \u0633\u0631\u0628\u064a\u0627\u064a\u064a" },
            { "hup", "\u06be\u0648\u067e\u0627" },
            { "hur", "\u0647\u0644\u06a9\u0648\u0645\u06cc\u0644\u0645" },
            { "iba", "\u0627\u0628\u0646" },
            { "ibb", "\u0627\u0628\u06cc\u0628\u06cc\u0648" },
            { "ikt", "\u0645\u063a\u0631\u0628\u06cc \u06a9\u06cc\u0646\u06cc\u0689\u06cc\u0646 \u0627\u0646\u0648\u06a9\u067c\u06cc\u067c" },
            { "ilo", "\u0627\u0644\u0648\u06a9\u0648" },
            { "inh", "\u0627\u0646\u06af\u0634" },
            { "jbo", "\u0644\u0648\u062c\u0628\u0627\u0646" },
            { "jgo", "\u0646\u06ab\u0648\u0645\u0628\u0627" },
            { "jmc", "\u0645\u0627\u0686\u0645\u06cc" },
            { "kab", "\u06a9\u06cc\u0628\u06cc\u0644" },
            { "kac", "\u06a9\u0627\u0686\u06cc\u0646" },
            { "kaj", "\u062c\u062c\u0648" },
            { "kam", "\u06a9\u0627\u0645\u0628\u0627" },
            { "kbd", "\u06a9\u0627\u0628\u06cc\u0631\u06cc\u0646" },
            { "kcg", "\u062a\u0627\u06cc\u067e" },
            { "kde", "\u0645\u064a\u06a9\u0648\u0646\u0689\u064a" },
            { "kea", "\u06a9\u0627\u0628\u0648\u0648\u0631\u0689\u06cc\u0627\u0646\u0648" },
            { "kfo", "\u06a9\u0648\u0631\u0648" },
            { "kgp", "\u06a9\u06cc\u0646\u06ab\u0627" },
            { "kha", "\u062e\u0627\u0633\u06d0" },
            { "khq", "\u06a9\u0648\u06cc\u0631\u0627 \u0686\u06cc\u0646\u06cc" },
            { "kkj", "\u06a9\u0627\u06a9\u0648" },
            { "kln", "\u06a9\u0644\u06cc\u0646\u062c\u0646" },
            { "kmb", "\u06a9\u06cc\u0645\u0628\u0648\u0646\u062f\u0648" },
            { "kok", "\u06a9\u0648\u0646\u06a9\u0627\u0646\u064a" },
            { "kpe", "\u06a9\u06cc\u0644\u064a" },
            { "krc", "\u06a9\u0631\u0627\u0686\u06cc \u0628\u0627\u0644\u06a9\u0631" },
            { "krl", "\u06a9\u0627\u0631\u06cc\u0644\u06cc\u0646" },
            { "kru", "\u06a9\u0648\u0631\u062e" },
            { "ksb", "\u0634\u0645\u0628\u0627\u0644\u0627" },
            { "ksf", "\u0628\u0641\u06cc\u0627" },
            { "ksh", "\u06a9\u0648\u0644\u0648\u06ab\u0646\u064a\u0627\u064a\u064a" },
            { "kum", "\u06a9\u0648\u0645\u06a9" },
            { "kwk", "Vote kwk" },
            { "kxv", "\u06a9\u0648\u0648\u0626" },
            { "lad", "\u0644\u0627\u0689\u06cc\u0646\u0648" },
            { "lag", "\u0644\u0646\u06ab\u06cc" },
            { "lez", "\u0644\u06cc\u06ab\u063a\u06cc\u0627\u0646" },
            { "lij", "\u0644\u06cc\u0646\u06ab\u0648\u0631\u06cc\u0646" },
            { "lil", "lill" },
            { "lkt", "\u0644\u06a9\u0648\u067c\u0627" },
            { "lmo", "\u0644\u0648\u0645\u0628\u0627\u0631\u0689" },
            { "lou", "Louis" },
            { "loz", "\u0644\u0648\u0632\u06cc" },
            { "lrc", "\u0634\u0645\u0627\u0644\u064a \u0644\u0648\u0631\u06cc" },
            { "lsm", "\u0633\u0627\u0645\u06cc\u0647" },
            { "lua", "\u0644\u0628\u0627 \u0644\u0648\u0644\u0648\u0627" },
            { "lun", "\u0644\u0646\u062f\u0627" },
            { "luo", "\u0644\u0648" },
            { "lus", "\u0645\u064a\u0632\u0648" },
            { "luy", "\u0644\u0648\u06cc\u0627" },
            { "mad", "\u0645\u062f\u0631\u0627\u0633\u06cc" },
            { "mag", "\u0645\u06ab\u0647\u064a" },
            { "mai", "\u0645\u0627\u06cc\u062a\u06be\u0644\u064a" },
            { "mak", "\u0645\u06a9\u0627\u0633\u0627\u0631" },
            { "mas", "\u0645\u0627\u0633\u0627\u0626\u064a" },
            { "mdf", "\u0645\u0648\u06a9\u0634\u0627" },
            { "men", "\u0645\u06cc\u0646\u068a\u064a" },
            { "mer", "\u0645\u064a\u0631\u0648" },
            { "mfe", "\u0645\u0627\u0631\u06cc\u0633\u06cc\u0633\u0646" },
            { "mgh", "\u0645\u06a9\u06be\u0648\u0627\u0645\u06cc\u062a\u0648" },
            { "mgo", "\u0645\u064a\u067c\u0627" },
            { "mic", "\u0645\u0645\u06a9\u0642" },
            { "min", "\u0645\u064a\u0646\u064a\u06af\u0627\u0628\u0627\u0648" },
            { "mni", "\u0645\u0627\u0646\u06cc \u067e\u0648\u0631\u06cc" },
            { "moe", "mo" },
            { "moh", "\u0645\u062d\u0627\u0648\u0627\u06a9" },
            { "mos", "\u0645\u0627\u0633\u064a" },
            { "mua", "\u0645\u0646\u062f\u0627\u0646\u06ab" },
            { "mul", "\u0645\u062a\u0639\u062f\u062f \u0698\u0628\u06d0" },
            { "mus", "\u06a9\u0631\u064a\u06a9\u064a" },
            { "mwl", "\u0645\u0631\u0627\u0646\u062f\u064a\u0632" },
            { "myv", "\u0627\u0631\u0632\u064a\u0627" },
            { "mzn", "\u0645\u0632\u0627\u0646\u062f\u0631\u0627\u0646\u064a" },
            { "nap", "\u0646\u064a\u067e\u0627\u0644\u064a\u0646" },
            { "naq", "\u0646\u0627\u0645\u0627" },
            { "nds", "\u06a9\u069a\u062a\u0647 \u0622\u0644\u0645\u0627\u0646\u064a" },
            { "new", "\u0646\u064a\u0648\u0627\u0631\u064a" },
            { "nia", "\u0646\u064a\u0627\u0633" },
            { "niu", "\u0646\u06cc\u0627\u0646" },
            { "nmg", "\u06a9\u0648\u0627\u0633\u06cc\u0648" },
            { "nnh", "\u0646\u0627\u06cc\u062c\u06cc\u0645\u0648\u0646" },
            { "nog", "\u0646\u0648\u06ab\u06cc" },
            { "nqo", "\u0646\u06a9\u0648" },
            { "nso", "\u0634\u0645\u0627\u0644\u064a \u0633\u0648\u062a\u0648" },
            { "nus", "\u0646\u0648\u06cc\u0631" },
            { "nyn", "\u0646\u06cc\u0646\u06a9\u0648\u0644" },
            { "ojb", "\u0634\u0645\u0627\u0644 \u0644\u0648\u06cc\u062f\u06cc\u0681 \u0627\u0648\u062c\u06cc\u0628\u0648\u0627" },
            { "ojc", "\u0645\u0631\u06a9\u0632\u064a \u0627\u0648\u062c\u06cc\u0628\u0648\u0627" },
            { "ojs", "\u0627\u0648\u062c\u064a-\u06a9\u0631\u064a" },
            { "ojw", "\u0644\u0648\u06cc\u062f\u06cc\u0681 \u0627\u0648\u062c\u06cc\u0628\u0648\u0627" },
            { "oka", "\u0627\u0648\u06a9\u0627\u06ab\u0627\u0646" },
            { "pag", "\u067e\u0627\u0646\u06ab\u0627\u0633\u06cc\u0646" },
            { "pam", "\u067e\u0645\u067e\u0627\u0646\u06af\u0627" },
            { "pap", "\u067e\u0627\u067e\u064a\u0627\u0645\u064a\u0646\u062a\u0648" },
            { "pau", "\u067e\u0627\u0644\u0627\u0646" },
            { "pcm", "\u0646\u0627\u0626\u062c\u06cc\u0631\u06cc\u0627 \u067e\u06cc\u062f\u062c\u0646" },
            { "pis", "\u067e\u06cc\u062c\u06cc\u0646" },
            { "pqm", "mpq" },
            { "prg", "\u067e\u0631\u0648\u0634\u064a\u0646" },
            { "quc", "\u06a9\u0686\u06cc" },
            { "raj", "\u0631\u0627\u062c\u0633\u062a\u06be\u0627\u0646\u06cc" },
            { "rap", "\u0631\u067e\u0627\u0646\u0648\u0626\u064a" },
            { "rar", "\u0631\u0627\u0631\u0648\u067c\u0627\u0646\u06ab\u0627\u0646" },
            { "rhg", "\u0631\u0648\u0647\u06cc\u0646\u06ab\u06cc\u0627" },
            { "rof", "\u0631\u0648\u0645\u0628\u0648" },
            { "rup", "\u0627\u0631\u0648\u0645\u0627\u0646\u064a" },
            { "rwk", "\u0631\u0648\u0627" },
            { "sad", "\u0633\u0646\u0689\u0627\u0648\u06cc" },
            { "sah", "\u0633\u062e\u0627" },
            { "saq", "\u0633\u0645\u0628\u0648\u0631\u0648" },
            { "sat", "\u0633\u0646\u062a\u0627\u0644\u064a" },
            { "sba", "\u0646\u06ab\u0628\u0627\u06cc" },
            { "sbp", "\u0633\u0627\u0646\u06ab\u0648\u0648" },
            { "scn", "\u0633\u06cc\u0644\u06cc\u0633\u064a" },
            { "sco", "\u0633\u06a9\u0627\u067c\u0633" },
            { "seh", "\u0633\u06cc\u0646\u0627" },
            { "ses", "\u06a9\u0648\u06cc\u06cc\u0631\u0627\u0628\u0648\u0631\u0648 \u0633\u06cc\u0646\u06cc" },
            { "shi", "\u062a\u0627\u06a9\u0644\u0647\u06cc\u067c" },
            { "shn", "\u0634\u0627\u0646" },
            { "slh", "\u0633\u0648\u06cc\u0644\u064a \u0644\u0648\u0634\u0648\u067c\u0633\u06cc\u062f" },
            { "sma", "\u0633\u0648\u06cc\u0644\u064a \u0633\u0627\u0645\u06cc" },
            { "smj", "\u0644\u0648\u0644 \u0633\u0627\u0645\u064a" },
            { "smn", "\u0627\u0646\u0627\u0631\u064a \u0633\u0645\u064a\u0639" },
            { "sms", "\u0633\u06a9\u0648\u0644\u067c \u0633\u0645\u06cc\u0639" },
            { "snk", "\u0633\u0648\u0646\u06cc\u0646\u06ab" },
            { "srn", "\u0633\u0648\u0631\u0627\u0646 \u067c\u0648\u0646\u06ab\u0648" },
            { "ssy", "\u0633\u0647\u0648" },
            { "str", "\u0633\u067c\u0631\u06cc\u067c \u0633\u06cc\u0644\u0634" },
            { "suk", "\u0633\u06a9\u0648\u0645\u0627" },
            { "swb", "\u06a9\u0648\u0645\u0648\u0631\u064a\u0627\u0646\u064a" },
            { "syr", "\u0633\u0648\u0631\u06cc\u0627\u0646\u064a" },
            { "szl", "\u0633\u06cc\u0644\u06cc\u0633\u06cc\u0627\u0646" },
            { "tce", "\u062c\u0646\u0648\u0628\u064a \u062a\u0648\u0686\u0648\u0646" },
            { "tem", "\u062a\u06cc\u0645\u0646\u064a" },
            { "teo", "\u062a\u06cc\u0633\u0648" },
            { "tet", "\u062a\u062a\u0648\u0645" },
            { "tgx", "\u067c\u06ab\u0634" },
            { "tht", "\u0637\u0647\u0644\u062a\u0627\u0646" },
            { "tig", "\u062a\u06cc\u06ab\u0631" },
            { "tlh", "\u06a9\u0644\u064a\u0646\u06ab\u0627\u0646\u064a" },
            { "tli", "\u067c\u0644\u06cc\u0646\u06ab\u06cc\u062a" },
            { "tok", "\u062a\u0648\u06a9\u06cc \u067e\u0648\u0646\u0627" },
            { "tpi", "\u062a\u0648\u06a9 \u067e\u06cc\u0633\u06cc\u0646" },
            { "trv", "\u062a\u0627\u0631\u0648\u06a9\u0648" },
            { "ttm", "\u0634\u0645\u0627\u0644\u064a \u067c\u0686\u0648\u0646" },
            { "tum", "\u062a\u0627\u0645\u0628\u0648\u06a9\u0627" },
            { "tvl", "\u062a\u0648\u0648\u0627\u0644\u0648" },
            { "twq", "\u062a\u0633\u0627\u0648\u0627\u0642" },
            { "tyv", "\u062a\u0648\u06cc\u0646\u06cc\u0627\u0646" },
            { "tzm", "\u0645\u0631\u06a9\u0632\u06cc \u0627\u0637\u0644\u0633 \u062a\u0645\u0627\u0632\u0627\u0626\u064a\u0679" },
            { "udm", "\u0627\u062f\u0645\u0648\u0631\u062a" },
            { "umb", "\u0627\u0645\u0628\u0648\u0646\u062f\u0648" },
            { "und", "\u0646\u0627\u0645\u0639\u0644\u0648\u0645\u0647 \u0698\u0628\u0647" },
            { "vai", metaValue_vai },
            { "vec", "\u0648\u06cc\u0646\u067c\u06cc\u0627\u0646" },
            { "vmw", "\u0645\u06a9\u0648\u0647" },
            { "vun", "\u0648\u0648\u0646\u062c\u0648" },
            { "wae", "\u0648\u0644\u0633\u06cc\u0631" },
            { "wal", "\u0648\u0644\u0627\u06cc\u067c\u0627" },
            { "war", "\u0648\u0627\u0631\u06cd" },
            { "wuu", "\u0648\u0648 \u0686\u06cc\u0646\u0627\u06cc\u06cc" },
            { "xal", "\u06a9\u0627\u0644\u0645\u06a9" },
            { "xnr", "\u06a9\u0627\u0646\u06ab\u0631\u0648" },
            { "xog", "\u0633\u0648\u06ab\u0627" },
            { "yav", "\u06cc\u0646\u06ab\u0628\u06cc\u0646" },
            { "ybb", "\u06cc\u0645\u0628\u0627" },
            { "yrl", "\u0646\u06cc\u0646\u06ab\u0627\u062a\u0648" },
            { "yue", "\u06a9\u0627\u0646\u067c\u0648\u0646\u064a" },
            { "zgh", "\u0645\u0639\u064a\u0627\u0631\u064a \u0645\u0631\u0627\u06a9\u0634\u064a \u062a\u0645\u0627\u0632\u064a\u067c" },
            { "zun", "\u0632\u0648\u0646\u064a" },
            { "zxx", "\u0646\u0647 \u0698\u0628\u0646\u064a \u0645\u0646\u0681\u067e\u0627\u0646\u06ab\u0647" },
            { "zza", "\u0632\u0627\u0632\u0627" },
            { "Adlm", "\u0627\u0689\u0644\u0627\u0645" },
            { "Arab", metaValue_ar },
            { "Aran", "\u0646\u0633\u062a\u0639\u0644\u06cc\u0642" },
            { "Armn", "\u0627\u0631\u0645\u0627\u0646\u06cc\u0627\u06cc\u064a" },
            { "Beng", "\u0628\u0646\u06ab\u0644\u0647" },
            { "Bopo", "\u0628\u0648\u067e\u0648\u0645\u0648\u0641\u0648" },
            { "Brai", "\u0628\u0631\u06cc\u0644\u064a" },
            { "Cakm", metaValue_ccp },
            { "Cans", "\u0645\u062a\u062d\u062f \u06a9\u0627\u0646\u0627\u0689\u0627\u06cc\u06cc \u0627\u0628\u0648\u0631\u06cc\u062c\u06cc\u0646\u0644 \u0633\u0644\u06cc\u0628\u06a9\u0633" },
            { "Cher", "\u0686\u06cc\u0631\u0648\u06a9\u064a" },
            { "Cyrl", "\u0633\u06cc\u0631\u06cc\u0644\u06cc\u06a9" },
            { "Deva", "\u062f\u06cc\u0648\u0627\u0646\u0627\u06ab\u0631\u064a" },
            { "Ethi", "\u0627\u06cc\u062a\u0648\u067e\u064a" },
            { "Geor", "\u06ab\u0631\u062c\u0633\u062a\u0627\u0646\u064a" },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "\u06ab\u0631\u0648\u0645\u064a" },
            { "Hanb", "\u0647\u0646 \u0627\u0648 \u0628\u0648\u067e\u0648\u0641\u0648\u0645\u0648" },
            { "Hang", "\u0647\u0646\u06ab\u0648\u0644\u064a" },
            { "Hani", "\u0647\u0646" },
            { "Hans", "\u0633\u0627\u062f\u0647 \u0634\u0648\u06cc" },
            { "Hant", "\u062f\u0648\u062f\u06cc\u0632\u0647" },
            { "Hebr", metaValue_he },
            { "Hira", "\u0647\u06cc\u0631\u0627\u06ab\u0627\u0646\u0627" },
            { "Hrkt", "\u062f \u062c\u0627\u067e\u0627\u0646\u064a \u0633\u06cc\u0644\u0627\u0628\u0631\u064a" },
            { "Jamo", "\u062c\u0627\u0645\u0648" },
            { "Jpan", metaValue_ja },
            { "Kana", "\u06a9\u0627\u062a\u0627\u06a9\u0627\u0646\u0627" },
            { "Khmr", metaValue_km },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Laoo", "\u0644\u0627\u0648\u0648" },
            { "Latn", "\u0644\u0627\u062a\u064a\u0646/\u0644\u0627\u062a\u064a\u0646\u064a" },
            { "Mlym", "\u0645\u0627\u0644\u0627\u06cc\u0627\u0644\u0645" },
            { "Mong", "\u0645\u0646\u06ab\u0648\u0644\u06cc\u0627\u06cc\u064a" },
            { "Mtei", "\u0645\u06cc\u067c\u064a \u0645\u0627\u06cc\u06a9" },
            { "Mymr", "\u0645\u06cc\u0627\u0646\u0645\u0627\u0631" },
            { "Nkoo", "\u0646\u0627\u06a9\u0648" },
            { "Olck", "\u0627\u0648\u0644 \u0686\u06a9\u06cc\u06d4" },
            { "Orya", "\u0627\u0648\u062f\u064a\u0627" },
            { "Rohg", "\u062d\u0646\u0641\u06cc" },
            { "Sinh", "\u0633\u0646\u0647\u0627\u0644\u0627" },
            { "Sund", "\u0633\u0646\u0688\u0627\u0646\u06cc" },
            { "Syrc", "\u0633\u0631\u06cc\u0627\u0646\u06cc" },
            { "Taml", metaValue_ta },
            { "Telu", "\u062a\u06cc\u0644\u06cc\u06ab\u0648" },
            { "Tfng", "\u0679\u06cc\u0641\u0646\u0627\u06ab" },
            { "Thaa", "\u062a\u0647\u0627\u0646\u0627" },
            { "Thai", "\u062a\u0627\u06cc\u0644\u0646\u0689\u064a" },
            { "Tibt", metaValue_bo },
            { "Vaii", metaValue_vai },
            { "Yiii", "\u06cc\u06cc" },
            { "Zmth", "\u062f \u0631\u06cc\u0627\u0636\u06cc\u0627\u062a\u0648 \u0646\u0648\u067c\u06cc\u0634\u0646" },
            { "Zsye", "\u0627\u06cc\u0645\u0648\u062c\u064a" },
            { "Zsym", "\u0633\u0645\u0628\u0648\u0644\u0648\u0646\u0647" },
            { "Zxxx", "\u0646\u0627\u0644\u064a\u06a9\u0644\u06cc" },
            { "Zyyy", "\u0639\u0627\u0645" },
            { "Zzzz", "\u0646\u0627\u0645\u0639\u0644\u0648\u0645\u0647 \u0633\u06a9\u0631\u06d0\u067e\u067c" },
            { "de_AT", "\u0627\u062a\u0631\u064a\u0634\u064a \u0622\u0644\u0645\u0627\u0646\u064a" },
            { "de_CH", "\u0633\u0648\u06cc\u0633 \u0647\u0627\u06cc \u062c\u0631\u0645\u0646" },
            { "en_AU", "\u0622\u0633\u067c\u0631\u0627\u0644\u064a\u0627\u0648\u064a \u0627\u0646\u06ab\u0644\u064a\u0633\u064a" },
            { "en_CA", "\u06a9\u0627\u0646\u0627\u0689\u0627\u064a\u064a \u0627\u0646\u06ab\u0644\u06cc\u0633\u064a" },
            { "en_GB", "\u0628\u0631\u064a\u062a\u0627\u0646\u0648\u06cc \u0627\u0646\u06ab\u0644\u06cc\u0633\u064a" },
            { "es_ES", "\u0627\u0631\u0648\u067e\u0627\u064a\u064a \u0647\u0633\u067e\u0627\u0646\u0648\u064a" },
            { "es_MX", "\u0645\u064a\u06a9\u0633\u064a\u06a9\u064a \u0647\u0633\u067e\u0627\u0646\u0648\u064a" },
            { "fa_AF", "\u062f\u0631\u06cc (\u0627\u0641\u063a\u0627\u0646\u0633\u062a\u0627\u0646)" },
            { "fr_CA", "\u06a9\u0627\u0646\u0627\u0689\u0627\u064a\u064a \u0641\u0631\u0627\u0646\u0633\u0648\u064a" },
            { "fr_CH", "\u0633\u0648\u064a\u0633\u064a \u0641\u0631\u0627\u0646\u0633\u0648\u064a" },
            { "nl_BE", "\u0641\u0644\u06d0\u0645\u06d0\u0634\u064a" },
            { "pt_BR", "\u0628\u0631\u0627\u0632\u06cc\u0644\u064a \u067e\u0631\u062a\u06ab\u0627\u0644\u064a" },
            { "pt_PT", "\u0627\u0631\u0648\u067e\u0627\u064a\u064a \u067e\u0631\u062a\u06ab\u0627\u0644\u064a" },
            { "ro_MD", "\u0645\u0648\u0644\u062f\u0627\u0648\u06cc\u0627\u06cc\u06cc" },
            { "sw_CD", "\u06a9\u0627\u0646\u06ab\u0648 \u0633\u0648\u0627\u0647\u0644\u06cc" },
            { "ar_001", "\u0646\u0648\u06d0 \u0645\u0639\u064a\u0627\u0631\u064a \u0639\u0631\u0628\u064a" },
            { "es_419", "\u0644\u0627\u062a\u064a\u0646\u064a \u0627\u0645\u0631\u064a\u06a9\u0627\u064a\u064a \u0647\u0633\u067e\u0627\u0646\u0648\u064a" },
            { "key.ca", "\u062c\u0646\u062a\u0631\u064a" },
            { "key.cf", "\u0627\u0633\u0639\u0627\u0631\u0648 \u0628\u06bc\u0647" },
            { "key.co", "\u062a\u0631\u062a\u064a\u0628" },
            { "key.cu", "\u0627\u0633\u0639\u0627\u0631\u0648" },
            { "key.hc", "\u062f \u0633\u0627\u0639\u062a \u0686\u06a9\u0631 (\u06f1\u06f2 \u067e\u0631\u062a\u0644\u0647 \u06f2\u06f4)" },
            { "key.lb", "\u062f \u0645\u0627\u062a\u06d0 \u06a9\u0631\u069a\u06d0 \u0689\u0648\u0644" },
            { "key.ms", "\u062f \u0646\u0627\u067e \u0646\u0638\u0627\u0645" },
            { "key.nu", "\u0634\u0645\u06d0\u0631\u06d0" },
            { "hi_Latn", "\u0647\u0646\u062f\u064a (\u0644\u0627\u062a\u064a\u0646\u064a)" },
            { "zh_Hant", "\u062f\u0648\u062f\u064a\u0632\u0647 \u0686\u064a\u0646\u064a" },
            { "type.ca.roc", "\u0645\u0646\u06af\u0648\u0648 \u062c\u0646\u062a\u0631\u064a" },
            { "type.hc.h11", "\u062f \u06f1\u06f2 \u0633\u0627\u0639\u062a\u0648 \u0646\u0638\u0627\u0645 (\u06f0\u0640\u06f1\u06f1)" },
            { "type.hc.h12", "\u062f \u06f1\u06f2 \u0633\u0627\u0639\u062a\u0648 \u0646\u0638\u0627\u0645 (\u06f1 \u0640 \u06f1\u06f2)" },
            { "type.hc.h23", "\u062f \u06f2\u06f4 \u0633\u0627\u0639\u062a\u0648 \u0646\u0638\u0627\u0645 (\u06f0\u0640\u06f2\u06f3)" },
            { "type.hc.h24", "\u062f \u0633\u0627\u0639\u062a\u0648 \u0646\u0638\u0627\u0645 (\u06f1\u0640\u06f2\u06f4)" },
            { "type.nu.arab", "\u0639\u0631\u0628\u064a - \u0627\u0646\u0689\u06cc\u06a9 \u0639\u062f\u062f\u0648\u0646\u0647" },
            { "type.nu.armn", "\u0622\u0631\u0645\u064a\u0646\u064a\u0627\u064a\u064a \u0627\u0639\u062f\u0627\u062f" },
            { "type.nu.beng", "\u062f \u0628\u0646\u06ab\u0644\u0627 \u0627\u0639\u062f\u0627\u062f" },
            { "type.nu.cakm", "\u062f \u0686\u06a9\u0645\u0627 \u0639\u062f\u062f\u0648\u0646\u0647" },
            { "type.nu.deva", "\u062f\u064a\u0648\u0627\u0646\u06ab\u0631\u064a \u0627\u0639\u062f\u0627\u062f" },
            { "type.nu.ethi", "\u0627\u064a\u062a\u0647\u0648\u067e\u064a\u0627\u064a\u064a \u0627\u0639\u062f\u0627\u062f" },
            { "type.nu.geor", "\u06ab\u0631\u064a\u06ab\u0648\u0631\u064a\u0646 \u0627\u0639\u062f\u0627\u062f" },
            { "type.nu.grek", "\u064a\u0648\u0646\u0627\u0646\u064a \u0627\u0639\u062f\u0627\u062f" },
            { "type.nu.gujr", "\u06ab\u0648\u062c\u0631\u0627\u062a\u064a \u0627\u0639\u062f\u0627\u062f" },
            { "type.nu.guru", "\u06ab\u0631\u0645\u062e\u06d0 \u0627\u0639\u062f\u0627\u062f" },
            { "type.nu.hans", "\u0633\u0627\u062f\u0647 \u0686\u064a\u0646\u064a \u0627\u0639\u062f\u0627\u062f" },
            { "type.nu.hant", "\u062f\u0648\u062f\u064a\u0632 \u0686\u064a\u0646\u064a \u0627\u0639\u062f\u0627\u062f" },
            { "type.nu.hebr", "\u0639\u0628\u0631\u0627\u0646\u064a \u0627\u0639\u062f\u0627\u062f" },
            { "type.nu.java", "\u062c\u0627\u0648\u0627\u0646\u06cc \u0689\u06cc\u062c\u06cc\u067c\u0644" },
            { "type.nu.jpan", "\u062c\u0627\u067e\u0627\u0646\u064a \u0627\u0639\u062f\u0627\u062f" },
            { "type.nu.khmr", "\u062e\u0645\u0631\u064a \u0627\u0639\u062f\u0627\u062f" },
            { "type.nu.knda", "\u06a9\u0627\u0646\u0627\u0689\u0627 \u064a\u064a \u0627\u0639\u062f\u0627\u062f" },
            { "type.nu.laoo", "\u0644\u0627\u0648\u064a \u0627\u0639\u062f\u0627\u062f" },
            { "type.nu.latn", "\u0644\u0648\u064a\u062f\u064a\u0681 \u0639\u062f\u062f\u0648\u0646\u0647" },
            { "type.nu.mlym", "\u0645\u0644\u0627\u064a \u0644\u0627\u0645 \u0627\u0639\u062f\u0627\u062f" },
            { "type.nu.mtei", "\u0645\u06cc\u067c\u06d0 \u0645\u0627\u06cc\u06a9 \u0627\u0639\u062f\u0627\u062f" },
            { "type.nu.mymr", "\u062f \u0645\u064a\u0627\u0646\u0645\u0627\u0631 \u0627\u0639\u062f\u0627\u062f" },
            { "type.nu.olck", "\u0627\u0644 \u0686\u06a9\u064a \u0627\u0639\u062f\u0627\u062f" },
            { "type.nu.orya", "\u062f \u0627\u0648\u0689\u064a\u0627 \u0627\u0639\u062f\u0627\u062f" },
            { "type.nu.taml", "\u062f\u0648\u062f\u064a\u0632 \u062a\u0627\u0645\u0644 \u0627\u0639\u062f\u0627\u062f" },
            { "type.nu.telu", "\u062a\u064a\u0644\u0648\u06ab\u0648 \u0627\u0639\u062f\u0627\u062f" },
            { "type.nu.thai", "\u062a\u0627\u064a\u064a \u0627\u0639\u062f\u0627\u062f" },
            { "type.nu.tibt", "\u062a\u0628\u062a\u064a \u0627\u0639\u062f\u0627\u062f" },
            { "type.nu.vaii", "\u0648\u0627\u06cc \u0627\u0639\u062f\u0627\u062f" },
            { "type.ca.dangi", "\u0689\u0627\u0646\u06ab\u064a \u062c\u0646\u062a\u0631\u064a" },
            { "type.co.ducet", "\u0689\u064a\u0641\u0627\u0644\u067c \u064a\u0648\u0646\u064a\u06a9\u0648\u0689 \u062a\u0631\u062a\u064a\u0628" },
            { "type.lb.loose", "\u062f \u063a\u0693\u0646\u062f\u06d0 \u0645\u0627\u062a\u06d0 \u06a9\u0631\u069a\u06d0 \u0689\u0648\u0644" },
            { "type.nu.roman", "\u0631\u0648\u0645\u0646 \u0627\u0639\u062f\u0627\u062f" },
            { "type.ca.coptic", "\u06a9\u0627\u067e\u067c\u06cc\u06a9 \u06a9\u06cc\u0644\u0646\u0689\u0631" },
            { "type.ca.hebrew", "\u062c\u0648\u0631\u062c\u0648\u06cc\u0627\u0646 \u062c\u0646\u062a\u0631\u064a" },
            { "type.co.search", "\u062f \u0639\u0645\u0648\u0645\u064a \u0645\u0648\u062e\u064a \u0644\u067c\u0648\u0646" },
            { "type.lb.normal", "\u062f \u0639\u0627\u062f\u064a \u0645\u0627\u062a\u06d0 \u06a9\u0631\u069a\u06d0 \u0689\u0648\u0644" },
            { "type.lb.strict", "\u062f \u0633\u062e\u062a\u06d0 \u0645\u0627\u062a\u06d0 \u06a9\u0631\u069a\u06d0 \u0689\u0648\u0644" },
            { "type.ms.metric", "\u0645\u064a\u067c\u0631\u06a9 \u0646\u0638\u0627\u0645" },
            { "type.ca.chinese", "\u062f \u0686\u064a\u0646 \u062c\u0646\u062a\u0631\u064a" },
            { "type.ca.islamic", "\u0627\u0633\u0644\u0627\u0645\u064a \u062c\u0646\u062a\u0631\u064a" },
            { "type.ca.iso8601", "ISO-8601 \u062c\u0646\u062a\u0631\u064a" },
            { "type.ca.persian", "\u0641\u0627\u0631\u0633\u064a \u062c\u0646\u062a\u0631\u064a" },
            { "type.cf.account", "\u0645\u062d\u0627\u0633\u0628\u0647 \u0627\u0633\u0639\u0627\u0631\u0648 \u0628\u06bc\u0647" },
            { "type.nu.arabext", "\u063a\u0681\u06d0\u062f\u0644\u06d0 \u0639\u0631\u0628\u064a \u06d4 \u0627\u064a\u0646\u0689\u064a\u06a9 \u0639\u062f\u062f" },
            { "type.nu.armnlow", "\u0622\u0631\u0645\u064a\u0646\u064a\u0627\u064a\u064a \u06a9\u0648\u0686\u0646\u064a \u0627\u0639\u062f\u0627\u062f" },
            { "type.nu.greklow", "\u064a\u0648\u0646\u0627\u0646\u064a \u06a9\u0648\u0686\u0646\u064a \u0627\u0639\u062f\u0627\u062f" },
            { "type.nu.hanidec", "\u0686\u0627\u064a\u0646\u064a \u0627\u0639\u0634\u0627\u0631\u064a \u0627\u0639\u062f\u0627\u062f" },
            { "type.nu.hansfin", "\u0633\u0627\u062f\u0647 \u0686\u064a\u0646\u064a \u0645\u0627\u0644\u064a \u0627\u0639\u062f\u0627\u062f" },
            { "type.nu.hantfin", "\u062f\u0648\u062f\u064a\u0632 \u0686\u064a\u0646\u064a \u0645\u0627\u0644\u064a \u0627\u0639\u062f\u0627\u062f" },
            { "type.nu.jpanfin", "\u062c\u0627\u067e\u0627\u0646\u064a \u0645\u0627\u0644\u064a \u0627\u0639\u062f\u0627\u062f" },
            { "type.nu.tamldec", "\u062a\u0627\u0645\u0644 \u0627\u0639\u062f\u0627\u062f" },
            { "type.ca.buddhist", "\u0628\u0648\u062f\u0627\u064a\u064a \u062c\u0646\u062a\u0631\u064a" },
            { "type.ca.ethiopic", "\u0627\u06cc\u062a\u0648\u067e\u064a\u06a9 \u062c\u0646\u062a\u0631\u064a" },
            { "type.ca.japanese", "\u062c\u0627\u067e\u0627\u0646\u064a \u062c\u0646\u062a\u0631\u064a" },
            { "type.cf.standard", "\u0645\u0639\u064a\u0627\u0631\u064a \u0627\u0633\u0639\u0627\u0631\u0648 \u0628\u06bc\u0647" },
            { "type.co.standard", "\u062f \u0645\u0639\u06cc\u0627\u0631\u064a \u0644\u067c\u064a \u062a\u0631\u062a\u06cc\u0628" },
            { "type.ms.uksystem", "\u0627\u0645\u067e\u064a\u0631\u064a\u0644 \u062f \u0646\u0627\u067e \u0646\u0638\u0627\u0645" },
            { "type.ms.ussystem", "\u062f \u0645\u062a\u062d\u062f\u0647 \u0622\u064a\u0627\u0644\u0627\u062a\u0648 \u062f \u0646\u0627\u067e \u0646\u0638\u0627\u0645" },
            { "type.nu.fullwide", "\u062f \u0628\u0634\u067e\u0693\u0647 \u067e\u0631\u0627\u062e\u062a\u064a\u0627 \u0627\u0639\u062f\u0627\u062f" },
            { "type.nu.romanlow", "\u0631\u0648\u0645\u0646 \u06a9\u0648\u0686\u0646\u064a \u0627\u0639\u062f\u0627\u062f" },
            { "type.ca.gregorian", "\u06ab\u0631\u064a\u06ab\u0648\u0631\u064a\u0646 \u062c\u0646\u062a\u0631\u064a" },
            { "type.ca.islamic-tbla", "\u0627\u0633\u0644\u0627\u0645\u064a \u062c\u0646\u062a\u0631\u064a (\u062c\u062f\u0648\u0644\u064a\u060c \u0633\u062a\u0648\u0631\u067e\u0648\u0647\u0646\u064a\u0632 \u0639\u0635\u0631)" },
            { "type.ca.islamic-civil", "\u0627\u0633\u0644\u0627\u0645\u064a \u062c\u0646\u062a\u0631\u064a (\u062c\u062f\u0648\u0644\u064a\u060c \u0645\u062f\u0646\u064a \u0639\u0635\u0631)" },
            { "type.ca.islamic-umalqura", "\u0627\u0633\u0644\u0627\u0645\u064a \u06a9\u0644\u06cc\u0632\u0647 (\u0627\u0645 \u0627\u0644\u0642\u0631\u06cc)" },
            { "type.ca.ethiopic-amete-alem", "\u062f \u0627\u06cc\u062a\u0648\u067e\u06cc\u06a9 \u0627\u0645\u06cc\u067c \u0627\u06cc\u0644\u0645 \u062a\u0642\u0648\u06cc\u0645" },
        };
        return data;
    }
}
