/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_sr extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ccp = "чакма";
        final String metaValue_chr = "чероки";
        final String metaValue_nqo = "нко";
        final String metaValue_vai = "ваи";
        final Object[][] data = new Object[][] {
            { "001", "свет" },
            { "002", "Африка" },
            { "003", "Северноамерички континент" },
            { "005", "Јужна Америка" },
            { "009", "Океанија" },
            { "011", "Западна Африка" },
            { "013", "Централна Америка" },
            { "014", "Источна Африка" },
            { "015", "Северна Африка" },
            { "017", "Централна Африка" },
            { "018", "Јужна Африка" },
            { "019", "Северна и Јужна Америка" },
            { "021", "Северна Америка" },
            { "029", "Кариби" },
            { "030", "Источна Азија" },
            { "034", "Јужна Азија" },
            { "035", "Југоисточна Азија" },
            { "039", "Јужна Европа" },
            { "053", "Аустралија и Нови Зеланд" },
            { "054", "Меланезија" },
            { "057", "Микронезијски регион" },
            { "061", "Полинезија" },
            { "142", "Азија" },
            { "143", "Централна Азија" },
            { "145", "Западна Азија" },
            { "150", "Европа" },
            { "151", "Источна Европа" },
            { "154", "Северна Европа" },
            { "155", "Западна Европа" },
            { "202", "Подсахарска Африка" },
            { "419", "Латинска Америка" },
            { "AC", "Острво Асенсион" },
            { "AD", "Андора" },
            { "AE", "Уједињени Арапски Емирати" },
            { "AF", "Авганистан" },
            { "AG", "Антигва и Барбуда" },
            { "AI", "Ангвила" },
            { "AL", "Албанија" },
            { "AM", "Јерменија" },
            { "AO", "Ангола" },
            { "AQ", "Антарктик" },
            { "AR", "Аргентина" },
            { "AS", "Америчка Самоа" },
            { "AT", "Аустрија" },
            { "AU", "Аустралија" },
            { "AW", "Аруба" },
            { "AX", "Оландска Острва" },
            { "AZ", "Азербејџан" },
            { "BA", "Босна и Херцеговина" },
            { "BB", "Барбадос" },
            { "BD", "Бангладеш" },
            { "BE", "Белгија" },
            { "BF", "Буркина Фасо" },
            { "BG", "Бугарска" },
            { "BH", "Бахреин" },
            { "BI", "Бурунди" },
            { "BJ", "Бенин" },
            { "BL", "Свети Бартоломеј" },
            { "BM", "Бермуди" },
            { "BN", "Брунеј" },
            { "BO", "Боливија" },
            { "BQ", "Карипска Холандија" },
            { "BR", "Бразил" },
            { "BS", "Бахами" },
            { "BT", "Бутан" },
            { "BV", "Острво Буве" },
            { "BW", "Боцвана" },
            { "BY", "Белорусија" },
            { "BZ", "Белизе" },
            { "CA", "Канада" },
            { "CC", "Кокосова (Килингова) Острва" },
            { "CD", "Конго - Киншаса" },
            { "CF", "Централноафричка Република" },
            { "CG", "Конго - Бразавил" },
            { "CH", "Швајцарска" },
            { "CI", "Обала Слоноваче (Кот д’Ивоар)" },
            { "CK", "Кукова Острва" },
            { "CL", "Чиле" },
            { "CM", "Камерун" },
            { "CN", "Кина" },
            { "CO", "Колумбија" },
            { "CP", "Острво Клипертон" },
            { "CR", "Костарика" },
            { "CU", "Куба" },
            { "CV", "Зеленортска Острва" },
            { "CW", "Курасао" },
            { "CX", "Божићно Острво" },
            { "CY", "Кипар" },
            { "CZ", "Чешка" },
            { "DE", "Немачка" },
            { "DG", "Дијего Гарсија" },
            { "DJ", "Џибути" },
            { "DK", "Данска" },
            { "DM", "Доминика" },
            { "DO", "Доминиканска Република" },
            { "DZ", "Алжир" },
            { "EA", "Сеута и Мелиља" },
            { "EC", "Еквадор" },
            { "EE", "Естонија" },
            { "EG", "Египат" },
            { "EH", "Западна Сахара" },
            { "ER", "Еритреја" },
            { "ES", "Шпанија" },
            { "ET", "Етиопија" },
            { "EU", "Европска унија" },
            { "EZ", "Еврозона" },
            { "FI", "Финска" },
            { "FJ", "Фиџи" },
            { "FK", "Фокландска Острва" },
            { "FM", "Микронезија" },
            { "FO", "Фарска Острва" },
            { "FR", "Француска" },
            { "GA", "Габон" },
            { "GB", "Уједињено Краљевство" },
            { "GD", "Гренада" },
            { "GE", "Грузија" },
            { "GF", "Француска Гвајана" },
            { "GG", "Гернзи" },
            { "GH", "Гана" },
            { "GI", "Гибралтар" },
            { "GL", "Гренланд" },
            { "GM", "Гамбија" },
            { "GN", "Гвинеја" },
            { "GP", "Гваделуп" },
            { "GQ", "Екваторијална Гвинеја" },
            { "GR", "Грчка" },
            { "GS", "Јужна Џорџија и Јужна Сендвичка Острва" },
            { "GT", "Гватемала" },
            { "GU", "Гуам" },
            { "GW", "Гвинеја-Бисао" },
            { "GY", "Гвајана" },
            { "HK", "САР Хонгконг (Кина)" },
            { "HM", "Острво Херд и Мекдоналдова острва" },
            { "HN", "Хондурас" },
            { "HR", "Хрватска" },
            { "HT", "Хаити" },
            { "HU", "Мађарска" },
            { "IC", "Канарска Острва" },
            { "ID", "Индонезија" },
            { "IE", "Ирска" },
            { "IL", "Израел" },
            { "IM", "Острво Ман" },
            { "IN", "Индија" },
            { "IO", "Британска територија Индијског океана" },
            { "IQ", "Ирак" },
            { "IR", "Иран" },
            { "IS", "Исланд" },
            { "IT", "Италија" },
            { "JE", "Џерзи" },
            { "JM", "Јамајка" },
            { "JO", "Јордан" },
            { "JP", "Јапан" },
            { "KE", "Кенија" },
            { "KG", "Киргистан" },
            { "KH", "Камбоџа" },
            { "KI", "Кирибати" },
            { "KM", "Коморска Острва" },
            { "KN", "Сент Китс и Невис" },
            { "KP", "Северна Кореја" },
            { "KR", "Јужна Кореја" },
            { "KW", "Кувајт" },
            { "KY", "Кајманска Острва" },
            { "KZ", "Казахстан" },
            { "LA", "Лаос" },
            { "LB", "Либан" },
            { "LC", "Света Луција" },
            { "LI", "Лихтенштајн" },
            { "LK", "Шри Ланка" },
            { "LR", "Либерија" },
            { "LS", "Лесото" },
            { "LT", "Литванија" },
            { "LU", "Луксембург" },
            { "LV", "Летонија" },
            { "LY", "Либија" },
            { "MA", "Мароко" },
            { "MC", "Монако" },
            { "MD", "Молдавија" },
            { "ME", "Црна Гора" },
            { "MF", "Свети Мартин (Француска)" },
            { "MG", "Мадагаскар" },
            { "MH", "Маршалска Острва" },
            { "MK", "Северна Македонија" },
            { "ML", "Мали" },
            { "MM", "Мијанмар (Бурма)" },
            { "MN", "Монголија" },
            { "MO", "САР Макао (Кина)" },
            { "MP", "Северна Маријанска Острва" },
            { "MQ", "Мартиник" },
            { "MR", "Мауританија" },
            { "MS", "Монсерат" },
            { "MT", "Малта" },
            { "MU", "Маурицијус" },
            { "MV", "Малдиви" },
            { "MW", "Малави" },
            { "MX", "Мексико" },
            { "MY", "Малезија" },
            { "MZ", "Мозамбик" },
            { "NA", "Намибија" },
            { "NC", "Нова Каледонија" },
            { "NE", "Нигер" },
            { "NF", "Острво Норфок" },
            { "NG", "Нигерија" },
            { "NI", "Никарагва" },
            { "NL", "Холандија" },
            { "NO", "Норвешка" },
            { "NP", "Непал" },
            { "NR", "Науру" },
            { "NU", "Ниуе" },
            { "NZ", "Нови Зеланд" },
            { "OM", "Оман" },
            { "PA", "Панама" },
            { "PE", "Перу" },
            { "PF", "Француска Полинезија" },
            { "PG", "Папуа Нова Гвинеја" },
            { "PH", "Филипини" },
            { "PK", "Пакистан" },
            { "PL", "Пољска" },
            { "PM", "Сен Пјер и Микелон" },
            { "PN", "Питкерн" },
            { "PR", "Порторико" },
            { "PS", "Палестинске територије" },
            { "PT", "Португалија" },
            { "PW", "Палау" },
            { "PY", "Парагвај" },
            { "QA", "Катар" },
            { "QO", "удаљена острва Океаније" },
            { "RE", "Реинион" },
            { "RO", "Румунија" },
            { "RS", "Србија" },
            { "RU", "Русија" },
            { "RW", "Руанда" },
            { "SA", "Саудијска Арабија" },
            { "SB", "Соломонска Острва" },
            { "SC", "Сејшели" },
            { "SD", "Судан" },
            { "SE", "Шведска" },
            { "SG", "Сингапур" },
            { "SH", "Света Јелена" },
            { "SI", "Словенија" },
            { "SJ", "Свалбард и Јан Мајен" },
            { "SK", "Словачка" },
            { "SL", "Сијера Леоне" },
            { "SM", "Сан Марино" },
            { "SN", "Сенегал" },
            { "SO", "Сомалија" },
            { "SR", "Суринам" },
            { "SS", "Јужни Судан" },
            { "ST", "Сао Томе и Принципе" },
            { "SV", "Салвадор" },
            { "SX", "Свети Мартин (Холандија)" },
            { "SY", "Сирија" },
            { "SZ", "Свазиленд" },
            { "TA", "Тристан да Куња" },
            { "TC", "Острва Туркс и Каикос" },
            { "TD", "Чад" },
            { "TF", "Француске Јужне Територије" },
            { "TG", "Того" },
            { "TH", "Тајланд" },
            { "TJ", "Таџикистан" },
            { "TK", "Токелау" },
            { "TL", "Тимор-Лесте (Источни Тимор)" },
            { "TM", "Туркменистан" },
            { "TN", "Тунис" },
            { "TO", "Тонга" },
            { "TR", "Турска" },
            { "TT", "Тринидад и Тобаго" },
            { "TV", "Тувалу" },
            { "TW", "Тајван" },
            { "TZ", "Танзанија" },
            { "UA", "Украјина" },
            { "UG", "Уганда" },
            { "UM", "Удаљена острва САД" },
            { "UN", "Уједињене нације" },
            { "US", "Сједињене Државе" },
            { "UY", "Уругвај" },
            { "UZ", "Узбекистан" },
            { "VA", "Ватикан" },
            { "VC", "Сент Винсент и Гренадини" },
            { "VE", "Венецуела" },
            { "VG", "Британска Девичанска Острва" },
            { "VI", "Америчка Девичанска Острва" },
            { "VN", "Вијетнам" },
            { "VU", "Вануату" },
            { "WF", "Валис и Футуна" },
            { "WS", "Самоа" },
            { "XA", "симулиране дијакритике" },
            { "XB", "Псеудобиди" },
            { "XK", "Косово" },
            { "YE", "Јемен" },
            { "YT", "Мајот" },
            { "ZA", "Јужноафричка Република" },
            { "ZM", "Замбија" },
            { "ZW", "Зимбабве" },
            { "ZZ", "непознат регион" },
            { "aa", "афарски" },
            { "ab", "абхаски" },
            { "ae", "авестански" },
            { "af", "африканс" },
            { "ak", "акански" },
            { "am", "амхарски" },
            { "an", "арагонски" },
            { "ar", "арапски" },
            { "as", "асамски" },
            { "av", "аварски" },
            { "ay", "ајмара" },
            { "az", "азербејџански" },
            { "ba", "башкирски" },
            { "be", "белоруски" },
            { "bg", "бугарски" },
            { "bi", "бислама" },
            { "bm", "бамбара" },
            { "bn", "бенгалски" },
            { "bo", "тибетански" },
            { "br", "бретонски" },
            { "bs", "босански" },
            { "ca", "каталонски" },
            { "ce", "чеченски" },
            { "ch", "чаморо" },
            { "co", "корзикански" },
            { "cr", "кри" },
            { "cs", "чешки" },
            { "cu", "црквенословенски" },
            { "cv", "чувашки" },
            { "cy", "велшки" },
            { "da", "дански" },
            { "de", "немачки" },
            { "dv", "малдивски" },
            { "dz", "џонга" },
            { "ee", "еве" },
            { "el", "грчки" },
            { "en", "енглески" },
            { "eo", "есперанто" },
            { "es", "шпански" },
            { "et", "естонски" },
            { "eu", "баскијски" },
            { "fa", "персијски" },
            { "ff", "фула" },
            { "fi", "фински" },
            { "fj", "фиџијски" },
            { "fo", "фарски" },
            { "fr", "француски" },
            { "fy", "западни фризијски" },
            { "ga", "ирски" },
            { "gd", "шкотски гелски" },
            { "gl", "галицијски" },
            { "gn", "гварани" },
            { "gu", "гуџарати" },
            { "gv", "манкс" },
            { "ha", "хауса" },
            { "he", "хебрејски" },
            { "hi", "хинди" },
            { "ho", "хири моту" },
            { "hr", "хрватски" },
            { "ht", "хаићански" },
            { "hu", "мађарски" },
            { "hy", "јерменски" },
            { "hz", "хереро" },
            { "ia", "интерлингва" },
            { "id", "индонежански" },
            { "ie", "интерлингве" },
            { "ig", "игбо" },
            { "ii", "сечуански ји" },
            { "ik", "инупик" },
            { "io", "идо" },
            { "is", "исландски" },
            { "it", "италијански" },
            { "iu", "инуктитутски" },
            { "ja", "јапански" },
            { "jv", "јавански" },
            { "ka", "грузијски" },
            { "kg", "конго" },
            { "ki", "кикују" },
            { "kj", "квањама" },
            { "kk", "казашки" },
            { "kl", "гренландски" },
            { "km", "кмерски" },
            { "kn", "канада" },
            { "ko", "корејски" },
            { "kr", "канури" },
            { "ks", "кашмирски" },
            { "ku", "курдски" },
            { "kv", "коми" },
            { "kw", "корнволски" },
            { "ky", "киргиски" },
            { "la", "латински" },
            { "lb", "луксембуршки" },
            { "lg", "ганда" },
            { "li", "лимбуршки" },
            { "ln", "лингала" },
            { "lo", "лаоски" },
            { "lt", "литвански" },
            { "lu", "луба-катанга" },
            { "lv", "летонски" },
            { "mg", "малгашки" },
            { "mh", "маршалски" },
            { "mi", "маорски" },
            { "mk", "македонски" },
            { "ml", "малајалам" },
            { "mn", "монголски" },
            { "mr", "марати" },
            { "ms", "малајски" },
            { "mt", "малтешки" },
            { "my", "бурмански" },
            { "na", "науруски" },
            { "nb", "норвешки букмол" },
            { "nd", "северни ндебеле" },
            { "ne", "непалски" },
            { "ng", "ндонга" },
            { "nl", "холандски" },
            { "nn", "норвешки нинорск" },
            { "no", "норвешки" },
            { "nr", "јужни ндебеле" },
            { "nv", "навахо" },
            { "ny", "њанџа" },
            { "oc", "окситански" },
            { "oj", "оџибве" },
            { "om", "оромо" },
            { "or", "одија" },
            { "os", "осетински" },
            { "pa", "пенџапски" },
            { "pi", "пали" },
            { "pl", "пољски" },
            { "ps", "паштунски" },
            { "pt", "португалски" },
            { "qu", "кечуа" },
            { "rm", "романш" },
            { "rn", "кирунди" },
            { "ro", "румунски" },
            { "ru", "руски" },
            { "rw", "кињаруанда" },
            { "sa", "санскрит" },
            { "sc", "сардински" },
            { "sd", "синди" },
            { "se", "северни сами" },
            { "sg", "санго" },
            { "sh", "српскохрватски" },
            { "si", "синхалешки" },
            { "sk", "словачки" },
            { "sl", "словеначки" },
            { "sm", "самоански" },
            { "sn", "шона" },
            { "so", "сомалски" },
            { "sq", "албански" },
            { "sr", "српски" },
            { "ss", "свази" },
            { "st", "сесото" },
            { "su", "сундски" },
            { "sv", "шведски" },
            { "sw", "свахили" },
            { "ta", "тамилски" },
            { "te", "телугу" },
            { "tg", "таџички" },
            { "th", "тајски" },
            { "ti", "тигриња" },
            { "tk", "туркменски" },
            { "tl", "тагалог" },
            { "tn", "цвана" },
            { "to", "тонгански" },
            { "tr", "турски" },
            { "ts", "цонга" },
            { "tt", "татарски" },
            { "tw", "тви" },
            { "ty", "тахићански" },
            { "ug", "ујгурски" },
            { "uk", "украјински" },
            { "ur", "урду" },
            { "uz", "узбечки" },
            { "ve", "венда" },
            { "vi", "вијетнамски" },
            { "vo", "волапик" },
            { "wa", "валонски" },
            { "wo", "волоф" },
            { "xh", "коса" },
            { "yi", "јидиш" },
            { "yo", "јоруба" },
            { "za", "џуаншки" },
            { "zh", "кинески" },
            { "zu", "зулу" },
            { "ace", "ацешки" },
            { "ach", "аколи" },
            { "ada", "адангме" },
            { "ady", "адигејски" },
            { "afh", "африхили" },
            { "agq", "агем" },
            { "ain", "аину" },
            { "akk", "акадијски" },
            { "ale", "алеутски" },
            { "alt", "јужноалтајски" },
            { "ang", "староенглески" },
            { "ann", "оболо" },
            { "anp", "ангика" },
            { "arc", "арамејски" },
            { "arn", "мапуче" },
            { "arp", "арапахо" },
            { "ars", "најдиарапски" },
            { "arw", "аравачки" },
            { "asa", "асу" },
            { "ast", "астуријски" },
            { "atj", "атикамеку" },
            { "awa", "авади" },
            { "bal", "белучки" },
            { "ban", "балијски" },
            { "bas", "баса" },
            { "bej", "беџа" },
            { "bem", "бемба" },
            { "bew", "бетави" },
            { "bez", "бена" },
            { "bgc", "харијански" },
            { "bgn", "западни белучки" },
            { "bho", "боџпури" },
            { "bik", "бикол" },
            { "bin", "бини" },
            { "bla", "сисика" },
            { "blo", "ании" },
            { "bra", "брај" },
            { "brx", "бодо" },
            { "bss", "акосе" },
            { "bua", "бурјатски" },
            { "bug", "бугијски" },
            { "byn", "блински" },
            { "cad", "кадо" },
            { "car", "карипски" },
            { "cay", "кајуга" },
            { "cch", "атсам" },
            { "ccp", metaValue_ccp },
            { "ceb", "себуански" },
            { "cgg", "чига" },
            { "chb", "чипча" },
            { "chg", "чагатај" },
            { "chk", "чучки" },
            { "chm", "мари" },
            { "chn", "чинучки" },
            { "cho", "чоктавски" },
            { "chp", "чипевјански" },
            { "chr", metaValue_chr },
            { "chy", "чејенски" },
            { "cic", "чикасо" },
            { "ckb", "централни курдски" },
            { "clc", "чилкотин" },
            { "cop", "коптски" },
            { "crg", "мичиф" },
            { "crh", "кримскотатарски" },
            { "crj", "југоисточни кри" },
            { "crk", "плаинскри" },
            { "crl", "североисточни кри" },
            { "crm", "музкри" },
            { "crr", "каролиншки алгонквијан" },
            { "crs", "сејшелски креолски француски" },
            { "csb", "кашупски" },
            { "csw", "мочварни кри" },
            { "dak", "дакота" },
            { "dar", "даргински" },
            { "dav", "таита" },
            { "del", "делаверски" },
            { "den", "слејви" },
            { "dgr", "догрипски" },
            { "din", "динка" },
            { "dje", "зарма" },
            { "doi", "догри" },
            { "dsb", "доњолужичкосрпски" },
            { "dua", "дуала" },
            { "dum", "средњехоландски" },
            { "dyo", "џола фоњи" },
            { "dyu", "ђула" },
            { "dzg", "дазага" },
            { "ebu", "ембу" },
            { "efi", "ефички" },
            { "egy", "староегипатски" },
            { "eka", "екаџук" },
            { "elx", "еламитски" },
            { "enm", "средњеенглески" },
            { "ewo", "евондо" },
            { "fan", "фанг" },
            { "fat", "фанти" },
            { "fil", "филипински" },
            { "fon", "фон" },
            { "frc", "кајунски француски" },
            { "frm", "средњефранцуски" },
            { "fro", "старофранцуски" },
            { "frr", "севернофризијски" },
            { "frs", "источнофризијски" },
            { "fur", "фриулски" },
            { "gaa", "га" },
            { "gag", "гагауз" },
            { "gay", "гајо" },
            { "gba", "гбаја" },
            { "gez", "геез" },
            { "gil", "гилбертски" },
            { "gmh", "средњи високонемачки" },
            { "goh", "старонемачки" },
            { "gon", "гонди" },
            { "gor", "горонтало" },
            { "got", "готски" },
            { "grb", "гребо" },
            { "grc", "старогрчки" },
            { "gsw", "немачки (Швајцарска)" },
            { "guz", "гуси" },
            { "gwi", "гвичински" },
            { "hai", "хаида" },
            { "haw", "хавајски" },
            { "hax", "јужни хаида" },
            { "hil", "хилигајнонски" },
            { "hit", "хетитски" },
            { "hmn", "хмоншки" },
            { "hnj", "хмонг нџуа" },
            { "hsb", "горњолужичкосрпски" },
            { "hup", "хупа" },
            { "hur", "халкомелем" },
            { "iba", "ибански" },
            { "ibb", "ибибио" },
            { "ikt", "западноканадски инуктитут" },
            { "ilo", "илоко" },
            { "inh", "ингушки" },
            { "jbo", "ложбан" },
            { "jgo", "нгомба" },
            { "jmc", "мачаме" },
            { "jpr", "јудео-персијски" },
            { "jrb", "јудео-арапски" },
            { "kaa", "кара-калпашки" },
            { "kab", "кабиле" },
            { "kac", "качински" },
            { "kaj", "џу" },
            { "kam", "камба" },
            { "kaw", "кави" },
            { "kbd", "кабардијски" },
            { "kcg", "тјап" },
            { "kde", "маконде" },
            { "kea", "зеленортски" },
            { "kfo", "коро" },
            { "kgp", "каинганг" },
            { "kha", "каси" },
            { "kho", "котанешки" },
            { "khq", "којра чиини" },
            { "kkj", "како" },
            { "kln", "каленџински" },
            { "kmb", "кимбунду" },
            { "koi", "коми-пермски" },
            { "kok", "конкани" },
            { "kos", "косренски" },
            { "kpe", "кпеле" },
            { "krc", "карачајско-балкарски" },
            { "kri", "крио" },
            { "krl", "карелски" },
            { "kru", "курук" },
            { "ksb", "шамбала" },
            { "ksf", "бафија" },
            { "ksh", "келнски" },
            { "kum", "кумички" },
            { "kut", "кутенај" },
            { "kwk", "кваквала" },
            { "kxv", "куви" },
            { "lad", "ладино" },
            { "lag", "ланги" },
            { "lah", "ланда" },
            { "lam", "ламба" },
            { "lez", "лезгински" },
            { "lij", "лигурски" },
            { "lil", "лилут" },
            { "lkt", "лакота" },
            { "lmo", "ломбард" },
            { "lol", "монго" },
            { "lou", "луизијански креолски" },
            { "loz", "лози" },
            { "lrc", "северни лури" },
            { "lsm", "самиа" },
            { "lua", "луба-лулуа" },
            { "lui", "луисењо" },
            { "lun", "лунда" },
            { "luo", "луо" },
            { "lus", "мизо" },
            { "luy", "лујиа" },
            { "mad", "мадурски" },
            { "mag", "магахи" },
            { "mai", "маитили" },
            { "mak", "макасарски" },
            { "man", "мандинго" },
            { "mas", "масајски" },
            { "mdf", "мокша" },
            { "mdr", "мандар" },
            { "men", "менде" },
            { "mer", "меру" },
            { "mfe", "морисјен" },
            { "mga", "средњеирски" },
            { "mgh", "макува-мито" },
            { "mgo", "мета" },
            { "mic", "микмак" },
            { "min", "минангкабау" },
            { "mnc", "манџурски" },
            { "mni", "манипурски" },
            { "moe", "инуајмун" },
            { "moh", "мохочки" },
            { "mos", "моси" },
            { "mua", "мунданг" },
            { "mul", "Више језика" },
            { "mus", "кришки" },
            { "mwl", "мирандски" },
            { "mwr", "марвари" },
            { "myv", "ерзја" },
            { "mzn", "мазандерански" },
            { "nap", "напуљски" },
            { "naq", "нама" },
            { "nds", "нисконемачки" },
            { "new", "невари" },
            { "nia", "ниас" },
            { "niu", "ниуејски" },
            { "nmg", "квасио" },
            { "nnh", "нгиембун" },
            { "nog", "ногајски" },
            { "non", "старонордијски" },
            { "nqo", metaValue_nqo },
            { "nso", "северни сото" },
            { "nus", "нуер" },
            { "nwc", "класични неварски" },
            { "nym", "њамвези" },
            { "nyn", "њанколе" },
            { "nyo", "њоро" },
            { "nzi", "нзима" },
            { "ojb", "северозападни оџибва" },
            { "ojc", "централни оџибва" },
            { "ojs", "оџикри" },
            { "ojw", "западни оџибва" },
            { "oka", "оканган" },
            { "osa", "осаге" },
            { "ota", "османски турски" },
            { "pag", "пангасинански" },
            { "pal", "пахлави" },
            { "pam", "пампанга" },
            { "pap", "папијаменто" },
            { "pau", "палауски" },
            { "pcm", "нигеријски пиџин" },
            { "peo", "староперсијски" },
            { "phn", "феничански" },
            { "pis", "пиџин" },
            { "pon", "понпејски" },
            { "pqm", "малисепасамакводи" },
            { "prg", "пруски" },
            { "pro", "староокситански" },
            { "quc", "киче" },
            { "raj", "раџастански" },
            { "rap", "рапануи" },
            { "rar", "раротонгански" },
            { "rhg", "рохингја" },
            { "rof", "ромбо" },
            { "rom", "ромски" },
            { "rup", "цинцарски" },
            { "rwk", "руа" },
            { "sad", "сандаве" },
            { "sah", "саха" },
            { "sam", "самаријански арамејски" },
            { "saq", "самбуру" },
            { "sas", "сасак" },
            { "sat", "сантали" },
            { "sba", "нгамбај" },
            { "sbp", "сангу" },
            { "scn", "сицилијански" },
            { "sco", "шкотски" },
            { "sdh", "јужнокурдски" },
            { "seh", "сена" },
            { "sel", "селкупски" },
            { "ses", "којраборо сени" },
            { "sga", "староирски" },
            { "shi", "ташелхит" },
            { "shn", "шански" },
            { "sid", "сидамо" },
            { "slh", "јужни лашутсид" },
            { "sma", "јужни сами" },
            { "smj", "луле сами" },
            { "smn", "инари сами" },
            { "sms", "сколт сами" },
            { "snk", "сонинке" },
            { "sog", "согдијски" },
            { "srn", "сранан тонго" },
            { "srr", "серерски" },
            { "ssy", "сахо" },
            { "str", "стреицсалиш" },
            { "suk", "сукума" },
            { "sus", "сусу" },
            { "sux", "сумерски" },
            { "swb", "коморски" },
            { "syc", "сиријачки" },
            { "syr", "сиријски" },
            { "szl", "силежански" },
            { "tce", "јужни тачон" },
            { "tem", "тимне" },
            { "teo", "тесо" },
            { "ter", "терено" },
            { "tet", "тетум" },
            { "tgx", "тагиш" },
            { "tht", "тахлтан" },
            { "tig", "тигре" },
            { "tiv", "тив" },
            { "tkl", "токелау" },
            { "tlh", "клингонски" },
            { "tli", "тлингит" },
            { "tmh", "тамашек" },
            { "tog", "њаса тонга" },
            { "tok", "токипона" },
            { "tpi", "ток писин" },
            { "trv", "тароко" },
            { "tsi", "цимшиан" },
            { "ttm", "северни тучон" },
            { "tum", "тумбука" },
            { "tvl", "тувалу" },
            { "twq", "тасавак" },
            { "tyv", "тувински" },
            { "tzm", "централноатласки тамашек" },
            { "udm", "удмуртски" },
            { "uga", "угаритски" },
            { "umb", "умбунду" },
            { "und", "непознат језик" },
            { "vai", metaValue_vai },
            { "vec", "венецијански" },
            { "vmw", "макува" },
            { "vot", "водски" },
            { "vun", "вунџо" },
            { "wae", "валсерски" },
            { "wal", "волајта" },
            { "war", "варајски" },
            { "was", "вашо" },
            { "wbp", "варлпири" },
            { "wuu", "ву кинески" },
            { "xal", "калмички" },
            { "xnr", "кангри" },
            { "xog", "сога" },
            { "yao", "јао" },
            { "yap", "јапски" },
            { "yav", "јангбен" },
            { "ybb", "јемба" },
            { "yrl", "нингату" },
            { "yue", "кантонски" },
            { "zap", "запотечки" },
            { "zbl", "блисимболи" },
            { "zen", "зенага" },
            { "zgh", "стандардни марокански тамазигт" },
            { "zun", "зуни" },
            { "zxx", "без лингвистичког садржаја" },
            { "zza", "заза" },
            { "Adlm", "адлам" },
            { "Arab", "арапско писмо" },
            { "Aran", "насталик" },
            { "Armi", "империјско арамејско писмо" },
            { "Armn", "јерменско писмо" },
            { "Avst", "авестанско писмо" },
            { "Bali", "балијско писмо" },
            { "Batk", "батак писмо" },
            { "Beng", "бенгалско писмо" },
            { "Blis", "блисимболично писмо" },
            { "Bopo", "бопомофо писмо" },
            { "Brah", "браманско писмо" },
            { "Brai", "брајево писмо" },
            { "Bugi", "бугинско писмо" },
            { "Buhd", "бухидско писмо" },
            { "Cakm", metaValue_ccp },
            { "Cans", "уједињени канадски абориџински силабици" },
            { "Cari", "каријско писмо" },
            { "Cham", "чамско писмо" },
            { "Cher", metaValue_chr },
            { "Cirt", "цирт писмо" },
            { "Copt", "коптичко писмо" },
            { "Cprt", "кипарско писмо" },
            { "Cyrl", "ћирилица" },
            { "Cyrs", "Старословенска црквена ћирилица" },
            { "Deva", "деванагари" },
            { "Dsrt", "Дезерет" },
            { "Egyd", "египатско народно писмо" },
            { "Egyh", "египатско хијератско писмо" },
            { "Egyp", "египатски хијероглифи" },
            { "Ethi", "етиопско писмо" },
            { "Geok", "грузијско кхутсури писмо" },
            { "Geor", "грузијско писмо" },
            { "Glag", "глагољица" },
            { "Goth", "Готика" },
            { "Grek", "грчко писмо" },
            { "Gujr", "гуџаратско писмо" },
            { "Guru", "гурмуки писмо" },
            { "Hanb", "ханб" },
            { "Hang", "хангул" },
            { "Hani", "хан" },
            { "Hano", "хануно" },
            { "Hans", "поједностављено кинеско писмо" },
            { "Hant", "традиционално кинеско писмо" },
            { "Hebr", "хебрејско писмо" },
            { "Hira", "хирагана" },
            { "Hmng", "пахав хмонг писмо" },
            { "Hrkt", "јапанска слоговна писма" },
            { "Hung", "старомађарско писмо" },
            { "Inds", "индушко писмо" },
            { "Ital", "стари италик" },
            { "Jamo", "џамо" },
            { "Java", "јаванско писмо" },
            { "Jpan", "јапанско писмо" },
            { "Kali", "кајах-ли писмо" },
            { "Kana", "катакана" },
            { "Khar", "карошти писмо" },
            { "Khmr", "кмерско писмо" },
            { "Knda", "канада писмо" },
            { "Kore", "корејско писмо" },
            { "Kthi", "каити" },
            { "Lana", "ланна писмо" },
            { "Laoo", "лаошко писмо" },
            { "Latf", "латиница (фрактур варијанта)" },
            { "Latg", "галска латиница" },
            { "Latn", "латиница" },
            { "Lepc", "лепча писмо" },
            { "Limb", "лимбу писмо" },
            { "Lina", "линеарно А писмо" },
            { "Linb", "линеарно Б писмо" },
            { "Lyci", "лисијско писмо" },
            { "Lydi", "лидијско писмо" },
            { "Mand", "мандеанско писмо" },
            { "Mani", "манихејско писмо" },
            { "Maya", "мајански хијероглифи" },
            { "Mero", "мероитик писмо" },
            { "Mlym", "малајаламско писмо" },
            { "Mong", "монголско писмо" },
            { "Moon", "месечево писмо" },
            { "Mtei", "меитеи мајек" },
            { "Mymr", "мијанмарско писмо" },
            { "Nkoo", metaValue_nqo },
            { "Ogam", "огамско писмо" },
            { "Olck", "ол чики" },
            { "Orkh", "орконско писмо" },
            { "Orya", "оријанско писмо" },
            { "Osma", "осмањанско писмо" },
            { "Perm", "старо пермикско писмо" },
            { "Phag", "пагс-па писмо" },
            { "Phli", "писани пахлави" },
            { "Phlp", "псалтер пахлави" },
            { "Phlv", "пахлави писмо" },
            { "Phnx", "Феничанско писмо" },
            { "Plrd", "поралд фонетско писмо" },
            { "Prti", "писани партиан" },
            { "Rjng", "рејанг писмо" },
            { "Rohg", "ханифи" },
            { "Roro", "ронгоронго писмо" },
            { "Runr", "рунско писмо" },
            { "Samr", "самаританско писмо" },
            { "Sara", "сарати писмо" },
            { "Saur", "саураштра писмо" },
            { "Sgnw", "знаковно писмо" },
            { "Shaw", "шавијанско писмо" },
            { "Sinh", "синхалско писмо" },
            { "Sund", "сунданско писмо" },
            { "Sylo", "силоти нагри писмо" },
            { "Syrc", "сиријско писмо" },
            { "Syre", "сиријско естрангело писмо" },
            { "Syrj", "западносиријско писмо" },
            { "Syrn", "писмо источне Сирије" },
            { "Tagb", "тагбанва писмо" },
            { "Tale", "таи ле писмо" },
            { "Talu", "нови таи луе" },
            { "Taml", "тамилско писмо" },
            { "Tavt", "таи виет писмо" },
            { "Telu", "телугу писмо" },
            { "Teng", "тенгвар писмо" },
            { "Tfng", "тифинаг" },
            { "Tglg", "Тагалог" },
            { "Thaa", "тана писмо" },
            { "Thai", "тајландско писмо" },
            { "Tibt", "тибетанско писмо" },
            { "Ugar", "угаритско писмо" },
            { "Vaii", metaValue_vai },
            { "Visp", "видљиви говор" },
            { "Xpeo", "староперсијско писмо" },
            { "Xsux", "сумерско-акадско кунеиформ писмо" },
            { "Yiii", "ји" },
            { "Zinh", "наследно писмо" },
            { "Zmth", "математичка нотација" },
            { "Zsye", "емоџи" },
            { "Zsym", "симболи" },
            { "Zxxx", "неписани језик" },
            { "Zyyy", "заједничко писмо" },
            { "Zzzz", "непознато писмо" },
            { "de_AT", "аустријски немачки" },
            { "de_CH", "швајцарски високи немачки" },
            { "en_GB", "енглески (Велика Британија)" },
            { "en_US", "енглески (Сједињене Америчке Државе)" },
            { "es_ES", "шпански (Европа)" },
            { "fa_AF", "дари" },
            { "nl_BE", "фламански" },
            { "pt_PT", "португалски (Португал)" },
            { "ro_MD", "молдавски" },
            { "sw_CD", "кисвахили" },
            { "%%1901", "Традиционална немачка ортографија" },
            { "%%1994", "Стандарднизована ресијанска ортографија" },
            { "%%1996", "Немачка ортографија из 1996" },
            { "ar_001", "савремени стандардни арапски" },
            { "key.ca", "календар" },
            { "key.cf", "формат валуте" },
            { "key.co", "редослед сортирања" },
            { "key.cu", "валута" },
            { "key.hc", "приказивање времена (12- или 24-часовно)" },
            { "key.lb", "стил прелома реда" },
            { "key.ms", "систем мерних јединица" },
            { "key.nu", "бројеви" },
            { "key.tz", "Временска зона" },
            { "key.va", "Варијанта локалитета" },
            { "nds_NL", "нискосаксонски" },
            { "%%BISKE", "Сан Ђорђио/Била дијалект" },
            { "%%BOONT", "Бунтлинг" },
            { "%%LIPAW", "Липовички дијалект ресијански" },
            { "%%NEDIS", "Натисоне дијалект" },
            { "%%NJIVA", "Гњива/Њива дијалкект" },
            { "%%OSOJS", "Осеако/Осојане дијалект" },
            { "%%POSIX", "Компјутер" },
            { "%%ROZAJ", "Ресијан" },
            { "%%SAAHO", "Сахо" },
            { "%%SOLBA", "Столвица/Солбица дијалект" },
            { "zh_Hans", "поједностављени кинески" },
            { "zh_Hant", "традиционални кинески" },
            { "%%FONIPA", "ИПА фонетика" },
            { "%%FONUPA", "УПА фонетика" },
            { "%%SCOUSE", "Скауз" },
            { "%%TARASK", "Тараскијевичка ортографија" },
            { "%%AREVELA", "Источни арменијски" },
            { "%%AREVMDA", "Западно јерменска" },
            { "%%MONOTON", "Монотоник" },
            { "%%POLYTON", "Политоник" },
            { "%%REVISED", "Ревидирана ортографија" },
            { "%%1606NICT", "Француски из касног средњег века до 1606." },
            { "%%1694ACAD", "Рани модерни француски" },
            { "%%BAKU1926", "Уједињен турски латинични алфабет" },
            { "%%SCOTLAND", "Шкотски стандардни Енглески" },
            { "%%VALENCIA", "Валенцијска" },
            { "type.ca.roc", "календар Републике Кине" },
            { "type.co.eor", "европска правила редоследа" },
            { "type.hc.h11", "12-часовни систем (0-11)" },
            { "type.hc.h12", "12-часовни систем (1-12)" },
            { "type.hc.h23", "24-часовни систем (0-23)" },
            { "type.hc.h24", "24-часовни систем (1-24)" },
            { "type.m0.bgn", "БГН (BGN)" },
            { "type.nu.arab", "арапско-индијске цифре" },
            { "type.nu.armn", "јерменски бројеви" },
            { "type.nu.beng", "бенгалске цифре" },
            { "type.nu.cakm", "чакма цифре" },
            { "type.nu.deva", "девангари цифре" },
            { "type.nu.ethi", "етиопски бројеви" },
            { "type.nu.geor", "грузијски бројеви" },
            { "type.nu.grek", "грчки бројеви" },
            { "type.nu.gujr", "гуџаратске цифре" },
            { "type.nu.guru", "гурмуки цифре" },
            { "type.nu.hans", "поједностављени кинески бројеви" },
            { "type.nu.hant", "традиционални кинески бројеви" },
            { "type.nu.hebr", "хебрејски бројеви" },
            { "type.nu.java", "јаванске цифре" },
            { "type.nu.jpan", "јапански бројеви" },
            { "type.nu.khmr", "кмерске цифре" },
            { "type.nu.knda", "канада цифре" },
            { "type.nu.laoo", "лаошке цифре" },
            { "type.nu.latn", "западне цифре" },
            { "type.nu.mlym", "малајалам цифре" },
            { "type.nu.mong", "монголске цифре" },
            { "type.nu.mtei", "митеи мајек цифре" },
            { "type.nu.mymr", "мијанмарске цифре" },
            { "type.nu.olck", "ол чики цифре" },
            { "type.nu.orya", "орија цифре" },
            { "type.nu.taml", "тамилски бројеви" },
            { "type.nu.telu", "телугу цифре" },
            { "type.nu.thai", "тајске цифре" },
            { "type.nu.tibt", "тибетанске цифре" },
            { "type.nu.vaii", "ваи цифре" },
            { "type.ca.dangi", "данги календар" },
            { "type.co.ducet", "подразумевани Unicode редослед сортирања" },
            { "type.lb.loose", "размакнути стил прелома реда" },
            { "type.nu.roman", "римски бројеви" },
            { "type.ca.coptic", "коптски календар" },
            { "type.ca.hebrew", "хебрејски календар" },
            { "type.ca.indian", "Индијски национални календар" },
            { "type.co.compat", "претходни редослед сортирања, због компатибилности" },
            { "type.co.pinyin", "пинјин сортирање" },
            { "type.co.search", "претрага опште намене" },
            { "type.co.stroke", "сортирање по броју потеза" },
            { "type.co.unihan", "редослед сортирања радикалних потеза" },
            { "type.co.zhuyin", "жујин" },
            { "type.d0.fwidth", "пуна ширина" },
            { "type.d0.hwidth", "пола ширине" },
            { "type.lb.normal", "нормални стил прелома реда" },
            { "type.lb.strict", "строги стил прелома реда" },
            { "type.m0.ungegn", "УНГЕГН (BGN)" },
            { "type.ms.metric", "метрички" },
            { "type.nu.native", "локалне цифре" },
            { "type.ca.chinese", "кинески календар" },
            { "type.ca.islamic", "исламски календар" },
            { "type.ca.iso8601", "ISO-8601 календар" },
            { "type.ca.persian", "персијски календар" },
            { "type.cf.account", "рачуноводствени формат валуте" },
            { "type.co.big5han", "традиционално кинеско сортирање" },
            { "type.d0.npinyin", "Нумеричка" },
            { "type.nu.arabext", "продужене арапско-индијске цифре" },
            { "type.nu.armnlow", "мали јерменски бројеви" },
            { "type.nu.finance", "Финансијски бројеви" },
            { "type.nu.greklow", "мали грчки бројеви" },
            { "type.nu.hanidec", "кинески децимални бројеви" },
            { "type.nu.hansfin", "поједностављени кинески финансијски бројеви" },
            { "type.nu.hantfin", "традиционални кинески финансијски бројеви" },
            { "type.nu.jpanfin", "јапански финансијски бројеви" },
            { "type.nu.tamldec", "тамилске цифре" },
            { "type.ca.buddhist", "будистички календар" },
            { "type.ca.ethiopic", "етиопски календар" },
            { "type.ca.japanese", "јапански календар" },
            { "type.cf.standard", "стандардни формат валуте" },
            { "type.co.phonetic", "фонетски редослед сортирања" },
            { "type.co.searchjl", "Претрага према хангул почетном сугласнику" },
            { "type.co.standard", "стандардни редослед сортирања" },
            { "type.ms.uksystem", "империјални" },
            { "type.ms.ussystem", "амерички" },
            { "type.nu.fullwide", "цифре пуне ширине" },
            { "type.nu.romanlow", "мали римски бројеви" },
            { "type.ca.gregorian", "грегоријански календар" },
            { "type.co.gb2312han", "поједностављено кинеско сортирање" },
            { "type.co.phonebook", "сортирање као телефонски именик" },
            { "type.co.dictionary", "редослед сортирања у речнику" },
            { "type.co.traditional", "традиционално сортирање" },
            { "type.nu.traditional", "Традиционални бројеви" },
            { "type.ca.islamic-tbla", "исламски астрономски календар" },
            { "type.ca.islamic-civil", "исламски цивилни календар" },
            { "type.ca.islamic-umalqura", "исламски календар (Umm al-Qura)" },
            { "type.ca.ethiopic-amete-alem", "етиопски амет алем календар" },
        };
        return data;
    }
}
