/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ce extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "Ӏаьрбийн";
        final String metaValue_hy = "эрмалойн";
        final String metaValue_ka = "гуьржийн";
        final String metaValue_el = "грекийн";
        final String metaValue_gu = "гуджарати";
        final String metaValue_he = "жугтийн";
        final String metaValue_ja = "японийн";
        final String metaValue_km = "кхмерийн";
        final String metaValue_kn = "каннада";
        final String metaValue_ko = "корейн";
        final String metaValue_lo = "лаоссийн";
        final String metaValue_la = "латинан";
        final String metaValue_mn = "монголийн";
        final String metaValue_or = "ори";
        final String metaValue_si = "сингалхойн";
        final String metaValue_ta = "тамилхойн";
        final String metaValue_te = "телугу";
        final String metaValue_th = "тайн";
        final String metaValue_bo = "тибетхойн";
        final String metaValue_fa = "гӀажарийн";
        final Object[][] data = new Object[][] {
            { "001", "Дерригдуьненан" },
            { "002", "Африка" },
            { "003", "Къилбаседа Америка" },
            { "005", "Къилба Америка" },
            { "009", "Океани" },
            { "011", "Малхбузен Африка" },
            { "013", "Юккъера Америка" },
            { "014", "Малхбален Африка" },
            { "015", "Къилбаседа Африка" },
            { "017", "Юккъера Африка" },
            { "018", "Къилба Африка" },
            { "019", "Къилбаседа а, къилба а Америка" },
            { "021", "Къилбаседа Америка – АЦШ а, Канада а" },
            { "029", "Карибаш" },
            { "030", "Юккъера Ази" },
            { "034", "Къилба Ази" },
            { "035", "Къилба-малхбален Ази" },
            { "039", "Къилба Европа" },
            { "053", "Австралази" },
            { "054", "Меланези" },
            { "057", "Микронези" },
            { "061", "Полинези" },
            { "142", "Ази" },
            { "143", "Юккъера Малхбале" },
            { "145", "Юккъера а, Гергара а Малхбале" },
            { "150", "Европа" },
            { "151", "Малхбален Европа" },
            { "154", "Къилбаседа Европа" },
            { "155", "Малхбузен Европа" },
            { "419", "Латинан Америка" },
            { "AC", "Айъадаларан гӀайре" },
            { "AD", "Андорра" },
            { "AE", "Ӏарбийн Цхьанатоьхна Эмираташ" },
            { "AF", "ОвхӀан мохк" },
            { "AG", "Антигуа а, Барбуда а" },
            { "AI", "Ангилья" },
            { "AL", "Албани" },
            { "AM", "Эрмалойчоь" },
            { "AO", "Ангола" },
            { "AQ", "Антарктида" },
            { "AR", "Аргентина" },
            { "AS", "Американ Самоа" },
            { "AT", "Австри" },
            { "AU", "Австрали" },
            { "AW", "Аруба" },
            { "AX", "Аландан гӀайренаш" },
            { "AZ", "Азербайджан" },
            { "BA", "Босни а, Герцеговина а" },
            { "BB", "Барбадос" },
            { "BD", "Бангладеш" },
            { "BE", "Бельги" },
            { "BF", "Буркина- Фасо" },
            { "BG", "Болгари" },
            { "BH", "Бахрейн" },
            { "BI", "Бурунди" },
            { "BJ", "Бенин" },
            { "BL", "Сен-Бартельми" },
            { "BM", "Бермудан гӀайренаш" },
            { "BN", "Бруней-Даруссалам" },
            { "BO", "Боливи" },
            { "BQ", "Бонэйр, Синт-Эстатиус а, Саба а" },
            { "BR", "Бразили" },
            { "BS", "Багаман гӀайренаш" },
            { "BT", "Бутан" },
            { "BV", "Бувен гӀайре" },
            { "BW", "Ботсвана" },
            { "BY", "Белорусси" },
            { "BZ", "Белиз" },
            { "CA", "Канада" },
            { "CC", "Кокосийн гӀайренаш" },
            { "CD", "Демократин Республика Конго" },
            { "CF", "Юккъерчу Африкин Республика" },
            { "CG", "Конго - Браззавиль" },
            { "CH", "Швейцари" },
            { "CI", "Кот-Д’ивуар" },
            { "CK", "Кукан гӀайренаш" },
            { "CL", "Чили" },
            { "CM", "Камерун" },
            { "CN", "Цийчоь" },
            { "CO", "Колумби" },
            { "CP", "Клиппертон" },
            { "CR", "Коста-Рика" },
            { "CU", "Куба" },
            { "CV", "Кабо-Верде" },
            { "CW", "Кюрасао" },
            { "CX", "ГӀайре ӏиса пайхӏамар вина де" },
            { "CY", "Кипр" },
            { "CZ", "Чехи" },
            { "DE", "Германи" },
            { "DG", "Диего-Гарси" },
            { "DJ", "Джибути" },
            { "DK", "Дани" },
            { "DM", "Доминика" },
            { "DO", "Доминикан Республика" },
            { "DZ", "Алжир" },
            { "EA", "Сеута а, Мелилья а" },
            { "EC", "Эквадор" },
            { "EE", "Эстони" },
            { "EG", "Мисар" },
            { "EH", "Малхбузен Саьхьара" },
            { "ER", "Эритрей" },
            { "ES", "Испани" },
            { "ET", "Эфиопи" },
            { "EU", "Евробарт" },
            { "EZ", "еврозона" },
            { "FI", "Финлянди" },
            { "FJ", "Фиджи" },
            { "FK", "Фолклендан гӀайренаш" },
            { "FM", "Микронезин Федеративни штаташ" },
            { "FO", "Фарерийн гӀайренаш" },
            { "FR", "Франци" },
            { "GA", "Габон" },
            { "GB", "Йоккха Британи" },
            { "GD", "Гренада" },
            { "GE", "Гуьржийчоь" },
            { "GF", "Французийн Гвиана" },
            { "GG", "Гернси" },
            { "GH", "Гана" },
            { "GI", "Гибралтар" },
            { "GL", "Гренланди" },
            { "GM", "Гамби" },
            { "GN", "Гвиней" },
            { "GP", "Гваделупа" },
            { "GQ", "Экваторан Гвиней" },
            { "GR", "Греци" },
            { "GS", "Къилба Джорджи а, Къилба Гавайн гӀайренаш а" },
            { "GT", "Гватемала" },
            { "GU", "Гуам" },
            { "GW", "Гвиней-Бисау" },
            { "GY", "Гайана" },
            { "HK", "Гонконг (ша-къаьстина кӀошт)" },
            { "HM", "Херд гӀайре а, Макдональд гӀайренаш а" },
            { "HN", "Гондурас" },
            { "HR", "Хорвати" },
            { "HT", "Гаити" },
            { "HU", "Венгри" },
            { "IC", "Канаран гӀайренаш" },
            { "ID", "Индонези" },
            { "IE", "Ирланди" },
            { "IL", "Израиль" },
            { "IM", "Мэн гӀайре" },
            { "IN", "ХӀинди" },
            { "IQ", "Ӏиракъ" },
            { "IR", "ГӀажарийчоь" },
            { "IS", "Исланди" },
            { "IT", "Итали" },
            { "JE", "Джерси" },
            { "JM", "Ямайка" },
            { "JO", "Урдан" },
            { "JP", "Япони" },
            { "KE", "Кени" },
            { "KG", "Киргизи" },
            { "KH", "Камбоджа" },
            { "KI", "Кирибати" },
            { "KM", "Комораш" },
            { "KN", "Сент-Китс а, Невис а" },
            { "KP", "Къилбаседа Корей" },
            { "KR", "Къилба Корей" },
            { "KW", "Кувейт" },
            { "KY", "Кайман гӀайренаш" },
            { "KZ", "Кхазакхстан" },
            { "LA", "Лаос" },
            { "LB", "Ливан" },
            { "LC", "Сент-Люси" },
            { "LI", "Лихтенштейн" },
            { "LK", "Шри-Ланка" },
            { "LR", "Либери" },
            { "LS", "Лесото" },
            { "LT", "Литва" },
            { "LU", "Люксембург" },
            { "LV", "Латви" },
            { "LY", "Ливи" },
            { "MA", "Марокко" },
            { "MC", "Монако" },
            { "MD", "Молдави" },
            { "ME", "Ӏаьржаламанчоь" },
            { "MF", "Сен-Мартен" },
            { "MG", "Мадагаскар" },
            { "MH", "Маршаллан гӀайренаш" },
            { "ML", "Мали" },
            { "MM", "Мьянма (Бирма)" },
            { "MN", "Монголи" },
            { "MO", "Макао (ша-къаьстина кӀошт)" },
            { "MP", "Къилбаседа Марианан гӀайренаш" },
            { "MQ", "Мартиника" },
            { "MR", "Мавритани" },
            { "MS", "Монтсеррат" },
            { "MT", "Мальта" },
            { "MU", "Маврики" },
            { "MV", "Мальдиваш" },
            { "MW", "Малави" },
            { "MX", "Мексика" },
            { "MY", "Малайзи" },
            { "MZ", "Мозамбик" },
            { "NA", "Намиби" },
            { "NC", "Керла Каледони" },
            { "NE", "Нигер" },
            { "NF", "Норфолк гӀайре" },
            { "NG", "Нигери" },
            { "NI", "Никарагуа" },
            { "NL", "Нидерландаш" },
            { "NO", "Норвеги" },
            { "NP", "Непал" },
            { "NR", "Науру" },
            { "NU", "Ниуэ" },
            { "NZ", "Керла Зеланди" },
            { "OM", "Ӏоман" },
            { "PA", "Панама" },
            { "PE", "Перу" },
            { "PF", "Французийн Полинези" },
            { "PG", "Папуа — Керла Гвиней" },
            { "PH", "Филиппинаш" },
            { "PK", "Пакистан" },
            { "PL", "Польша" },
            { "PM", "Сен-Пьер а, Микелон а" },
            { "PN", "Питкэрн гӀайренаш" },
            { "PR", "Пуэрто-Рико" },
            { "PS", "ПалестӀинан латтанаш" },
            { "PT", "Португали" },
            { "PW", "Палау" },
            { "PY", "Парагвай" },
            { "QA", "Катар" },
            { "QO", "Арахьара Океани" },
            { "RE", "Реюньон" },
            { "RO", "Румыни" },
            { "RS", "Серби" },
            { "RU", "Росси" },
            { "RW", "Руанда" },
            { "SA", "СаӀудийн Ӏаьрбийчоь" },
            { "SB", "Соломонан гӀайренаш" },
            { "SC", "Сейшелан гӀайренаш" },
            { "SD", "Судан" },
            { "SE", "Швеци" },
            { "SG", "Сингапур" },
            { "SH", "Сийлахьчу Еленин гӀайре" },
            { "SI", "Словени" },
            { "SJ", "Шпицберген а, Ян-Майен а" },
            { "SK", "Словаки" },
            { "SL", "Сьерра- Леоне" },
            { "SM", "Сан-Марино" },
            { "SN", "Сенегал" },
            { "SO", "Сомали" },
            { "SR", "Суринам" },
            { "SS", "Къилба Судан" },
            { "ST", "Сан-Томе а, Принсипи а" },
            { "SV", "Сальвадор" },
            { "SX", "Синт-Мартен" },
            { "SY", "Шема" },
            { "SZ", "Свазиленд" },
            { "TA", "Тристан-да- Кунья" },
            { "TC", "Тёркс а, Кайкос а гӀайренаш" },
            { "TD", "Чад" },
            { "TF", "Французийн къилба латтанаш" },
            { "TG", "Того" },
            { "TH", "Таиланд" },
            { "TJ", "Таджикистан" },
            { "TK", "Токелау" },
            { "TL", "Малхбален Тимор" },
            { "TM", "Туркмени" },
            { "TN", "Тунис" },
            { "TO", "Тонга" },
            { "TR", "Туркойчоь" },
            { "TT", "Тринидад а, Тобаго а" },
            { "TV", "Тувалу" },
            { "TW", "Тайвань" },
            { "TZ", "Танзани" },
            { "UA", "Украина" },
            { "UG", "Уганда" },
            { "UM", "АЦШн арахьара кегийн гӀайренаш" },
            { "UN", "Вовшахкхетта Къаьмнийн Организаци" },
            { "US", "Цхьанатоьхна Штаташ" },
            { "UY", "Уругвай" },
            { "UZ", "Узбекистан" },
            { "VA", "Ватикан" },
            { "VC", "Сент-Винсент а, Гренадинаш а" },
            { "VE", "Венесуэла" },
            { "VG", "Виргинийн гӀайренаш (Британи)" },
            { "VI", "Виргинийн гӀайренаш (АЦШ)" },
            { "VN", "Вьетнам" },
            { "VU", "Вануату" },
            { "WF", "Уоллис а, Футуна а" },
            { "WS", "Самоа" },
            { "XK", "Косово" },
            { "YE", "Йемен" },
            { "YT", "Майотта" },
            { "ZA", "Къилба-Африкин Республика" },
            { "ZM", "Замби" },
            { "ZW", "Зимбабве" },
            { "ZZ", "Йоьвзуш йоцу регион" },
            { "aa", "афарийн" },
            { "ab", "абхазхойн" },
            { "af", "африкаанс" },
            { "ak", "акан" },
            { "am", "амхаройн" },
            { "an", "арагонойн" },
            { "ar", metaValue_ar },
            { "as", "ассамийн" },
            { "av", "суьйлийн" },
            { "ay", "аймара" },
            { "az", "азербайджанийн" },
            { "ba", "башкирийн" },
            { "be", "белорусийн" },
            { "bg", "болгарийн" },
            { "bi", "бислама" },
            { "bm", "бамбара" },
            { "bn", "бенгалийн" },
            { "bo", metaValue_bo },
            { "br", "бретонийн" },
            { "bs", "боснийн" },
            { "ca", "каталонийн" },
            { "ce", "нохчийн" },
            { "ch", "чаморро" },
            { "co", "корсиканийн" },
            { "cs", "чехийн" },
            { "cu", "килсславянийн" },
            { "cv", "чувашийн" },
            { "cy", "валлийн" },
            { "da", "датхойн" },
            { "de", "немцойн" },
            { "dv", "мальдивийн" },
            { "dz", "дзонг-кэ" },
            { "ee", "эве" },
            { "el", metaValue_el },
            { "en", "ингалсан" },
            { "eo", "эсперанто" },
            { "es", "испанхойн" },
            { "et", "эстонийн" },
            { "eu", "баскийн" },
            { "fa", metaValue_fa },
            { "ff", "фулах" },
            { "fi", "финнийн" },
            { "fj", "фиджи" },
            { "fo", "фарерийн" },
            { "fr", "французийн" },
            { "fy", "малхбузен-фризийн" },
            { "ga", "ирландхойн" },
            { "gd", "гэлийн" },
            { "gl", "галисийн" },
            { "gn", "гуарани" },
            { "gu", metaValue_gu },
            { "gv", "мэнийн" },
            { "ha", "хауса" },
            { "he", metaValue_he },
            { "hi", "хӀинди" },
            { "hr", "хорватийн" },
            { "ht", "гаитийн" },
            { "hu", "венгрийн" },
            { "hy", metaValue_hy },
            { "hz", "гереро" },
            { "ia", "интерлингва" },
            { "id", "индонезихойн" },
            { "ig", "игбо" },
            { "ii", "сычуань" },
            { "io", "идо" },
            { "is", "исландхойн" },
            { "it", "итальянийн" },
            { "iu", "инуктитут" },
            { "ja", metaValue_ja },
            { "jv", "яванийн" },
            { "ka", metaValue_ka },
            { "ki", "кикуйю" },
            { "kj", "кунама" },
            { "kk", "кхазакхийн" },
            { "kl", "гренландхойн" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "канури" },
            { "ks", "кашмири" },
            { "ku", "курдийн" },
            { "kv", "комийн" },
            { "kw", "корнуоллийн" },
            { "ky", "гӀиргӀизойн" },
            { "la", metaValue_la },
            { "lb", "люксембургхойн" },
            { "lg", "ганда" },
            { "li", "лимбургийн" },
            { "ln", "лингала" },
            { "lo", metaValue_lo },
            { "lt", "литвахойн" },
            { "lu", "луба-катанга" },
            { "lv", "латышийн" },
            { "mg", "малагасийн" },
            { "mh", "маршаллийн" },
            { "mi", "маори" },
            { "mk", "македонхойн" },
            { "ml", "малаялам" },
            { "mn", metaValue_mn },
            { "mr", "маратхи" },
            { "ms", "малайн" },
            { "mt", "мальтойн" },
            { "my", "бирманийн" },
            { "na", "науру" },
            { "nb", "норвегийн букмол" },
            { "nd", "къилбаседа ндебели" },
            { "ne", "непалхойн" },
            { "ng", "ндонга" },
            { "nl", "голландхойн" },
            { "nn", "норвегийн нюнорск" },
            { "nr", "къилба ндебеле" },
            { "nv", "навахо" },
            { "ny", "ньянджа" },
            { "oc", "окситанойн" },
            { "om", "оромо" },
            { "or", metaValue_or },
            { "os", "хӀирийн" },
            { "pa", "панджаби" },
            { "pl", "полякийн" },
            { "ps", "пушту" },
            { "pt", "португалихойн" },
            { "qu", "кечуа" },
            { "rm", "романшийн" },
            { "rn", "рунди" },
            { "ro", "румынийн" },
            { "ru", "оьрсийн" },
            { "rw", "киньяруанда" },
            { "sa", "санскрит" },
            { "sc", "сардинийн" },
            { "sd", "синдхи" },
            { "se", "къилбаседа саамийн" },
            { "sg", "санго" },
            { "si", metaValue_si },
            { "sk", "словакийн" },
            { "sl", "словенийн" },
            { "sm", "самоанойн" },
            { "sn", "шона" },
            { "so", "сомали" },
            { "sq", "албанойн" },
            { "sr", "сербийн" },
            { "ss", "свази" },
            { "st", "къилба сото" },
            { "su", "сунданхойн" },
            { "sv", "шведийн" },
            { "sw", "суахили" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "таджикийн" },
            { "th", metaValue_th },
            { "ti", "тигринья" },
            { "tk", "туркменийн" },
            { "tn", "тсвана" },
            { "to", "тонганийн" },
            { "tr", "туркойн" },
            { "ts", "тсонга" },
            { "tt", "гӀезалойн" },
            { "ty", "таитянойн" },
            { "ug", "уйгурийн" },
            { "uk", "украинийн" },
            { "ur", "урду" },
            { "uz", "узбекийн" },
            { "ve", "венда" },
            { "vi", "вьетнамхойн" },
            { "vo", "волапюк" },
            { "wa", "валлонойн" },
            { "wo", "волоф" },
            { "xh", "коса" },
            { "yi", "идиш" },
            { "yo", "йоруба" },
            { "zh", "цийн" },
            { "zu", "зулу" },
            { "ace", "ачехийн" },
            { "ada", "адангме" },
            { "ady", "адигейн" },
            { "agq", "агхӀем" },
            { "ain", "айнийн" },
            { "ale", "алеутийн" },
            { "alt", "къилба алтайн" },
            { "anp", "ангика" },
            { "arn", "арауканхойн" },
            { "arp", "арапахо" },
            { "asa", "асу" },
            { "ast", "астурийн" },
            { "awa", "авадхи" },
            { "ban", "балийн" },
            { "bas", "баса" },
            { "bem", "бемба" },
            { "bez", "бена" },
            { "bgn", "малхбузен-белуджийн" },
            { "bho", "бходжпури" },
            { "bin", "бини" },
            { "bla", "сиксика" },
            { "brx", "бодо" },
            { "bug", "бугийн" },
            { "byn", "билийн" },
            { "ceb", "себуано" },
            { "cgg", "чига" },
            { "chk", "чукчийн" },
            { "chm", "марийн" },
            { "cho", "чоктавийн" },
            { "chr", "чероки" },
            { "chy", "шайенийн" },
            { "ckb", "юккъерчу курдийн" },
            { "crs", "сейшелийн креолийн" },
            { "dak", "дакота" },
            { "dar", "даьргӀойн" },
            { "dav", "таита" },
            { "dgr", "догриб" },
            { "dje", "зарма" },
            { "dsb", "сорбийн" },
            { "dua", "дуала" },
            { "dyo", "дьола-фоньи" },
            { "dzg", "даза" },
            { "ebu", "эмбу" },
            { "efi", "эфик" },
            { "eka", "экаджук" },
            { "ewo", "эвондо" },
            { "fil", "филиппинийн" },
            { "fon", "фон" },
            { "fur", "фриулийн" },
            { "gaa", "га" },
            { "gag", "гагаузийн" },
            { "gez", "геэз" },
            { "gil", "гильбертийн" },
            { "gor", "горонтало" },
            { "gsw", "швейцарин немцойн" },
            { "guz", "гусии" },
            { "gwi", "гвичин" },
            { "haw", "гавайн" },
            { "hil", "хилигайнон" },
            { "hmn", "хмонг" },
            { "hsb", "лакхара сербийн" },
            { "hup", "хупа" },
            { "iba", "ибанийн" },
            { "ibb", "ибибио" },
            { "ilo", "илоко" },
            { "inh", "гӀалгӀайн" },
            { "jbo", "ложбан" },
            { "jgo", "нгомба" },
            { "jmc", "мачаме" },
            { "kab", "кабилийн" },
            { "kac", "качинийн" },
            { "kaj", "каджи" },
            { "kam", "камба" },
            { "kbd", "гӀебартойн" },
            { "kcg", "тьяп" },
            { "kde", "маконде" },
            { "kea", "кабувердьяну" },
            { "kfo", "коро" },
            { "kha", "кхаси" },
            { "khq", "койра чиини" },
            { "kkj", "како" },
            { "kln", "календжин" },
            { "kmb", "кимбунду" },
            { "koi", "коми-пермякийн" },
            { "kok", "конкани" },
            { "kpe", "кпелле" },
            { "krc", "кхарачойн-балкхаройн" },
            { "krl", "карелийн" },
            { "kru", "курух" },
            { "ksb", "шамбала" },
            { "ksf", "бафиа" },
            { "ksh", "коьлнийн" },
            { "kum", "гӀумкийн" },
            { "lad", "ладино" },
            { "lag", "ланги" },
            { "lez", "лаьзгийн" },
            { "lkt", "лакота" },
            { "loz", "лози" },
            { "lrc", "къилбаседа лури" },
            { "lua", "луба-лулуа" },
            { "lun", "лунда" },
            { "luo", "луо (Кени а, Танзани а)" },
            { "lus", "лушей" },
            { "luy", "лухья" },
            { "mad", "мадурийн" },
            { "mag", "магахи" },
            { "mai", "майтхили" },
            { "mak", "макасарийн" },
            { "mas", "масаи" },
            { "mdf", "мокшанойн" },
            { "men", "менде" },
            { "mer", "меру" },
            { "mfe", "маврикин креолийн" },
            { "mgh", "макуа-меетто" },
            { "mgo", "мета" },
            { "mic", "микмак" },
            { "min", "минангкабау" },
            { "mni", "манипурийн" },
            { "moh", "мохаук" },
            { "mos", "моси" },
            { "mua", "мунданг" },
            { "mul", "тайп-тайпа доьзалан меттанаш" },
            { "mus", "крик" },
            { "mwl", "мирандойн" },
            { "myv", "эрзянийн" },
            { "mzn", "мазандеранхойн" },
            { "nap", "неаполитанойн" },
            { "naq", "нама" },
            { "nds", "лахара германхойн" },
            { "new", "неваройн" },
            { "nia", "ниас" },
            { "niu", "ниуэ" },
            { "nmg", "квасио" },
            { "nnh", "нгиембунд" },
            { "nog", "ногӀийн" },
            { "nqo", "нко" },
            { "nso", "къилбаседа сото" },
            { "nus", "нуэр" },
            { "nyn", "ньянколе" },
            { "pag", "пангасинан" },
            { "pam", "пампанга" },
            { "pap", "папьяменто" },
            { "pau", "палау" },
            { "pcm", "нигерийн-креолийн" },
            { "prg", "пруссийн" },
            { "quc", "киче" },
            { "rap", "рапануйн" },
            { "rar", "раротонга" },
            { "rof", "ромбо" },
            { "rup", "аруминийн" },
            { "rwk", "руанда" },
            { "sad", "сандаве" },
            { "sah", "якутийн" },
            { "saq", "самбуру" },
            { "sat", "сантали" },
            { "sba", "нгамбайн" },
            { "sbp", "сангу" },
            { "scn", "сицилийн" },
            { "sco", "шотландхойн" },
            { "seh", "сена" },
            { "ses", "койраборо сенни" },
            { "shi", "тахелхит" },
            { "shn", "шанойн" },
            { "sma", "саамийн (къилба)" },
            { "smj", "луле-саамийн" },
            { "smn", "инари-саамийн" },
            { "sms", "скольт-саамийн" },
            { "snk", "сонинке" },
            { "srn", "сранан-тонго" },
            { "ssy", "сахо" },
            { "suk", "сукума" },
            { "swb", "коморийн" },
            { "syr", "шемахойн" },
            { "tem", "темне" },
            { "teo", "тесо" },
            { "tet", "тетум" },
            { "tig", "тигре" },
            { "tlh", "клингонин" },
            { "tpi", "ток-писин" },
            { "trv", "седекойн" },
            { "tum", "тумбука" },
            { "tvl", "тувалу" },
            { "twq", "тасавак" },
            { "tyv", "тувинийн" },
            { "tzm", "тамазигхтийн" },
            { "udm", "удмуртийн" },
            { "umb", "умбунду" },
            { "und", "боьвзуш боцу мотт" },
            { "vai", "ваи" },
            { "vun", "вунджо" },
            { "wae", "валлисийн" },
            { "wal", "воламо" },
            { "war", "варай" },
            { "wbp", "варлпири" },
            { "xal", "гӀалмакхойн" },
            { "xog", "сога" },
            { "yav", "янгбен" },
            { "ybb", "йемба" },
            { "yue", "кантонийн" },
            { "zgh", "мороккон стандартан тамазигхтийн" },
            { "zun", "зуньи" },
            { "zxx", "меттан чулацам боцуш" },
            { "zza", "заза" },
            { "Arab", metaValue_ar },
            { "Armn", metaValue_hy },
            { "Beng", "бенгалхойн" },
            { "Bopo", "бопомофо" },
            { "Brai", "брайля" },
            { "Cyrl", "кириллица" },
            { "Deva", "деванагари" },
            { "Ethi", "эфиопин" },
            { "Geor", metaValue_ka },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "гурмукхи" },
            { "Hanb", "ханьб" },
            { "Hang", "хангыль" },
            { "Hani", "китайн" },
            { "Hans", "атта китайн" },
            { "Hant", "ламастан китайн" },
            { "Hebr", metaValue_he },
            { "Hira", "хирагана" },
            { "Hrkt", "катакана я хирагана" },
            { "Jamo", "джамо" },
            { "Jpan", metaValue_ja },
            { "Kana", "катакана" },
            { "Khmr", metaValue_km },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Laoo", metaValue_lo },
            { "Latn", metaValue_la },
            { "Mlym", "малаялийн" },
            { "Mong", metaValue_mn },
            { "Mymr", "мьянманийн" },
            { "Orya", metaValue_or },
            { "Sinh", metaValue_si },
            { "Taml", metaValue_ta },
            { "Telu", metaValue_te },
            { "Thaa", "таана" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Zmth", "математикан маьӀна" },
            { "Zsye", "эмодзи" },
            { "Zsym", "символаш" },
            { "Zxxx", "йоза доцу" },
            { "Zyyy", "массара а тӀеэцна" },
            { "Zzzz", "доьвзуш доцу йоза" },
            { "de_AT", "австрин немцойн" },
            { "de_CH", "швейцарин литературин немцойн" },
            { "en_AU", "Австралин ингалсан" },
            { "en_CA", "канадан ингалсан" },
            { "en_GB", "британин ингалсан" },
            { "en_US", "американ ингалсан" },
            { "es_ES", "европан испанхойн" },
            { "es_MX", "мексикан испанхойн" },
            { "fr_CA", "канадан французийн" },
            { "fr_CH", "швейцарин французийн" },
            { "nl_BE", "фламандийн" },
            { "pt_BR", "бразилин португалихойн" },
            { "pt_PT", "европан португалихойн" },
            { "ro_MD", "молдавийн" },
            { "sw_CD", "суахили (Конго)" },
            { "ar_001", "ХӀинца болу стандартан Ӏаьрбийн" },
            { "es_419", "латинан американ испанхойн" },
            { "key.ca", "Календарь" },
            { "key.cu", "ахча" },
            { "nds_NL", "лахара саксонийн" },
            { "zh_Hans", "атта цийн" },
            { "zh_Hant", "ламастан цийн" },
            { "type.ca.persian", metaValue_fa },
            { "type.ca.japanese", metaValue_ja },
            { "type.ca.gregorian", "григорианан" },
        };
        return data;
    }
}
