/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.jimage.decompressor;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Objects;

public final class CompressedResourceHeader {
    private static final int SIZE = 29;
    public static final int MAGIC = -889259270;
    private static final int MAGIC_OFFSET = 0;
    private static final int COMPRESSED_OFFSET = 4;
    private static final int UNCOMPRESSED_OFFSET = 12;
    private static final int DECOMPRESSOR_NAME_OFFSET = 20;
    private static final int IS_TERMINAL_OFFSET = 28;
    private final long uncompressedSize;
    private final long compressedSize;
    private final int decompressorNameOffset;
    private final boolean isTerminal;

    public CompressedResourceHeader(long compressedSize, long uncompressedSize, int decompressorNameOffset, boolean isTerminal) {
        this.compressedSize = compressedSize;
        this.uncompressedSize = uncompressedSize;
        this.decompressorNameOffset = decompressorNameOffset;
        this.isTerminal = isTerminal;
    }

    public boolean isTerminal() {
        return this.isTerminal;
    }

    public int getDecompressorNameOffset() {
        return this.decompressorNameOffset;
    }

    public long getUncompressedSize() {
        return this.uncompressedSize;
    }

    public long getResourceSize() {
        return this.compressedSize;
    }

    public byte[] getBytes(ByteOrder order) {
        Objects.requireNonNull(order);
        ByteBuffer buffer = ByteBuffer.allocate(29);
        buffer.order(order);
        buffer.putInt(-889259270);
        buffer.putLong(this.compressedSize);
        buffer.putLong(this.uncompressedSize);
        buffer.putInt(this.decompressorNameOffset);
        buffer.putInt(-1);
        buffer.put(this.isTerminal ? (byte)1 : 0);
        return buffer.array();
    }

    public static int getSize() {
        return 29;
    }

    public static CompressedResourceHeader readFromResource(ByteOrder order, byte[] resource) {
        Objects.requireNonNull(order);
        Objects.requireNonNull(resource);
        if (resource.length < CompressedResourceHeader.getSize()) {
            return null;
        }
        ByteBuffer buffer = ByteBuffer.wrap(resource, 0, 29);
        buffer.order(order);
        int magic = buffer.getInt(0);
        if (magic != -889259270) {
            return null;
        }
        long size = buffer.getLong(4);
        long uncompressedSize = buffer.getLong(12);
        int decompressorNameOffset = buffer.getInt(20);
        byte isTerminal = buffer.get(28);
        return new CompressedResourceHeader(size, uncompressedSize, decompressorNameOffset, isTerminal == 1);
    }
}

