/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_ur extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "گرین وچ کا اصل وقت",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "ایپیا سٹینڈرڈ ٹائم",
               "",
               "ایپیا ڈے لائٹ ٹائم",
               "",
               "ایپیا ٹائم",
               "",
            };
        final String[] Cook = new String[] {
               "کک آئلینڈز سٹینڈرڈ ٹائم",
               "",
               "کک آئلینڈز نصف سمر ٹائم",
               "",
               "کک آئلینڈز ٹائم",
               "",
            };
        final String[] Cuba = new String[] {
               "کیوبا اسٹینڈرڈ ٹائم",
               "CST",
               "کیوبا ڈے لائٹ ٹائم",
               "CDT",
               "کیوبا ٹائم",
               "CT",
            };
        final String[] Fiji = new String[] {
               "فجی سٹینڈرڈ ٹائم",
               "",
               "فجی سمر ٹائم",
               "",
               "فجی ٹائم",
               "",
            };
        final String[] Gulf = new String[] {
               "خلیج کا معیاری وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "ہووڈ سٹینڈرڈ ٹائم",
               "",
               "ہووڈ سمر ٹائم",
               "",
               "ہووڈ ٹائم",
               "",
            };
        final String[] Iran = new String[] {
               "ایران کا معیاری وقت",
               "",
               "ایران ڈے لائٹ ٹائم",
               "",
               "ایران کا وقت",
               "",
            };
        final String[] Niue = new String[] {
               "نیئو ٹائم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "اومسک سٹینڈرڈ ٹائم",
               "",
               "اومسک سمر ٹائم",
               "",
               "اومسک ٹائم",
               "",
            };
        final String[] Peru = new String[] {
               "پیرو کا معیاری وقت",
               "",
               "پیرو کا موسم گرما کا وقت",
               "",
               "پیرو کا وقت",
               "",
            };
        final String[] Truk = new String[] {
               "چوک ٹائم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "ویک آئلینڈ ٹائم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "چلی کا معیاری وقت",
               "",
               "چلی کا موسم گرما کا وقت",
               "",
               "چلی کا وقت",
               "",
            };
        final String[] China = new String[] {
               "چین سٹینڈرڈ ٹائم",
               "CST",
               "چینی ڈے لائٹ ٹائم",
               "CDT",
               "چین کا وقت",
               "CT",
            };
        final String[] Cocos = new String[] {
               "کوکوس آئلینڈز ٹائم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "ڈیوس ٹائم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "ہندوستان کا معیاری وقت",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "جاپان سٹینڈرڈ ٹائم",
               "JST",
               "جاپان ڈے لائٹ ٹائم",
               "JDT",
               "جاپان ٹائم",
               "JT",
            };
        final String[] Korea = new String[] {
               "کوریا سٹینڈرڈ ٹائم",
               "KST",
               "کوریا ڈے لائٹ ٹائم",
               "KST",
               "کوریا ٹائم",
               "KST",
            };
        final String[] Nauru = new String[] {
               "ناؤرو ٹائم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "نیپال کا وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "پلاؤ ٹائم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "ساموآ سٹینڈرڈ ٹائم",
               "SST",
               "ساموآ ڈے لائٹ ٹائم",
               "SST",
               "ساموآ ٹائم",
               "SST",
            };
        final String[] Syowa = new String[] {
               "سیووا ٹائم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "ٹونگا سٹینڈرڈ ٹائم",
               "",
               "ٹونگا سمر ٹائم",
               "",
               "ٹونگا ٹائم",
               "",
            };
        final String[] Yukon = new String[] {
               "یوکون ٹائم",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "الاسکا اسٹینڈرڈ ٹائم",
               "AKST",
               "الاسکا ڈے لائٹ ٹائم",
               "AKDT",
               "الاسکا ٹائم",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "ایمیزون کا معیاری وقت",
               "",
               "امیزون کا موسم گرما کا وقت",
               "",
               "امیزون ٹائم",
               "",
            };
        final String[] Anadyr = new String[] {
               "انیدر اسٹینڈرڈ ٹائم",
               "",
               "انیدر سمر ٹائم",
               "",
               "انیدر ٹائم",
               "",
            };
        final String[] Azores = new String[] {
               "ازوریس کا معیاری وقت",
               "",
               "ازوریس کا موسم گرما کا وقت",
               "",
               "ازوریس کا وقت",
               "",
            };
        final String[] Bhutan = new String[] {
               "بھوٹان کا وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "برونئی دارالسلام ٹائم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "ایسٹر آئلینڈ کا معیاری وقت",
               "",
               "ایسٹر آئلینڈ کا موسم گرما کا وقت",
               "",
               "ایسٹر آئلینڈ کا وقت",
               "",
            };
        final String[] Guyana = new String[] {
               "گیانا کا وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "اسرائیل کا معیاری وقت",
               "IST",
               "اسرائیل ڈے لائٹ ٹائم",
               "IDT",
               "اسرائیل کا وقت",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "کوسرے ٹائم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "ماؤسن ٹائم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "ماسکو اسٹینڈرڈ ٹائم",
               "MSK",
               "ماسکو سمر ٹائم",
               "MSK",
               "ماسکو ٹائم",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "پوناپے ٹائم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "سمارا اسٹینڈرڈ ٹائم",
               "",
               "سمارا سمر ٹائم",
               "",
               "سمارا ٹائم",
               "",
            };
        final String[] Tahiti = new String[] {
               "تاہیتی ٹائم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "تائی پیئی اسٹینڈرڈ ٹائم",
               "CST",
               "تئی پیئی ڈے لائٹ ٹائم",
               "CDT",
               "تائی پیئی ٹائم",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "ٹوالو ٹائم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "ووسٹاک کا وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "والیز اور فٹونا ٹائم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "عرب کا معیاری وقت",
               "",
               "عرب ڈے لائٹ ٹائم",
               "",
               "عرب کا وقت",
               "",
            };
        final String[] Armenia = new String[] {
               "آرمینیا کا معیاری وقت",
               "",
               "آرمینیا کا موسم گرما کا وقت",
               "",
               "آرمینیا کا وقت",
               "",
            };
        final String[] Bolivia = new String[] {
               "بولیویا کا وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "چیتھم اسٹینڈرڈ ٹائم",
               "",
               "چیتھم ڈے لائٹ ٹائم",
               "",
               "چیتھم ٹائم",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "کوآرڈینیٹڈ یونیورسل ٹائم",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "ایکواڈور کا وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "گیمبیئر ٹائم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "جارجیا کا معیاری وقت",
               "",
               "جارجیا کا موسم گرما کا وقت",
               "",
               "جارجیا کا وقت",
               "",
            };
        final String[] Irkutsk = new String[] {
               "ارکتسک سٹینڈرڈ ٹائم",
               "",
               "ارکتسک سمر ٹائم",
               "",
               "ارکتسک ٹائم",
               "",
            };
        final String[] Magadan = new String[] {
               "مگادان اسٹینڈرڈ ٹائم",
               "",
               "میگیدن سمر ٹائم",
               "",
               "میگیدن ٹائم",
               "",
            };
        final String[] Myanmar = new String[] {
               "میانمار ٹائم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "نارفوک آئلینڈ کا معیاری وقت",
               "",
               "نارفوک آئلینڈ ڈے لائٹ وقت",
               "",
               "نارفوک آئلینڈ کا وقت",
               "",
            };
        final String[] Noronha = new String[] {
               "فرنانڈو ڈی نورنہا کا معیاری وقت",
               "",
               "فرنانڈو ڈی نورونہا سمر ٹائم",
               "",
               "فرنانڈو ڈی نورنہا کا وقت",
               "",
            };
        final String[] Reunion = new String[] {
               "ری یونین ٹائم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "روتھیرا کا وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "سولمن آئلینڈز ٹائم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "ٹوکیلاؤ ٹائم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "یوروگوئے کا معیاری وقت",
               "",
               "یوروگوئے کا موسم گرما کا وقت",
               "",
               "یوروگوئے کا وقت",
               "",
            };
        final String[] Vanuatu = new String[] {
               "وانوآٹو سٹینڈرڈ ٹائم",
               "",
               "وانوآٹو سمر ٹائم",
               "",
               "وانوآٹو ٹائم",
               "",
            };
        final String[] Yakutsk = new String[] {
               "یکوتسک اسٹینڈرڈ ٹائم",
               "",
               "یکوتسک سمر ٹائم",
               "",
               "یکوتسک ٹائم",
               "",
            };
        final String[] Atlantic = new String[] {
               "اٹلانٹک اسٹینڈرڈ ٹائم",
               "AST",
               "اٹلانٹک ڈے لائٹ ٹائم",
               "AST",
               "اٹلانٹک ٹائم",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "برازیلیا اسٹینڈرڈ ٹائم",
               "",
               "برازیلیا سمر ٹائم",
               "",
               "برازیلیا ٹائم",
               "",
            };
        final String[] Chamorro = new String[] {
               "چامورو سٹینڈرڈ ٹائم",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "کولمبیا کا معیاری وقت",
               "",
               "کولمبیا کا موسم گرما کا وقت",
               "",
               "کولمبیا ٹائم",
               "",
            };
        final String[] Falkland = new String[] {
               "فاک لینڈ آئلینڈز کا معیاری وقت",
               "",
               "فاک لینڈ آئلینڈز کا موسم گرما کا وقت",
               "",
               "فاک لینڈ آئلینڈز کا وقت",
               "",
            };
        final String[] Malaysia = new String[] {
               "ملیشیا ٹائم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "مالدیپ کا وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "یولان بیتور سٹینڈرڈ ٹائم",
               "",
               "یولان بیتور سمر ٹائم",
               "",
               "یولان بیتور ٹائم",
               "",
            };
        final String[] Pakistan = new String[] {
               "پاکستان کا معیاری وقت",
               "PKT",
               "پاکستان کا موسم گرما کا وقت",
               "PKST",
               "پاکستان کا وقت",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "پیراگوئے کا معیاری وقت",
               "",
               "پیراگوئے کا موسم گرما کا وقت",
               "",
               "پیراگوئے کا وقت",
               "",
            };
        final String[] Pitcairn = new String[] {
               "پٹکائرن ٹائم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "سخالین سٹینڈرڈ ٹائم",
               "",
               "سخالین سمر ٹائم",
               "",
               "سخالین ٹائم",
               "",
            };
        final String[] Suriname = new String[] {
               "سورینام کا وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "ارجنٹینا کا معیاری وقت",
               "",
               "ارجنٹینا کا موسم گرما کا وقت",
               "",
               "ارجنٹینا کا وقت",
               "",
            };
        final String[] Christmas = new String[] {
               "کرسمس آئلینڈ ٹائم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "گالاپاگوز کا وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "ہانگ کانگ سٹینڈرڈ ٹائم",
               "HKT",
               "ہانگ کانگ سمر ٹائم",
               "HKST",
               "ہانگ کانگ ٹائم",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "ہند چین ٹائم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "پیٹروپاؤلووسک-کیمچسکی اسٹینڈرڈ ٹائم",
               "",
               "پیٹروپاؤلووسک-کیمچسکی سمر ٹائم",
               "",
               "پیٹروپاؤلووسک-کیمچسکی ٹائم",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "کرغستان کا وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "لارڈ ہووے اسٹینڈرڈ ٹائم",
               "",
               "لارڈ ہووے ڈے لائٹ ٹائم",
               "",
               "لارڈ ہووے ٹائم",
               "",
            };
        final String[] Marquesas = new String[] {
               "مارکیسس ٹائم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "ماریشس سٹینڈرڈ ٹائم",
               "",
               "ماریشس سمر ٹائم",
               "",
               "ماریشس ٹائم",
               "",
            };
        final String[] Singapore = new String[] {
               "سنگاپور سٹینڈرڈ ٹائم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "وینزوئیلا کا وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "وولگوگراد اسٹینڈرڈ ٹائم",
               "MSK",
               "وولگوگراد سمر ٹائم",
               "MSK",
               "وولگوگراد ٹائم",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "آذربائیجان کا معیاری وقت",
               "",
               "آذربائیجان کا موسم گرما کا وقت",
               "",
               "آذربائیجان کا وقت",
               "",
            };
        final String[] Bangladesh = new String[] {
               "بنگلہ دیش کا معیاری وقت",
               "",
               "بنگلہ دیش کا موسم گرما کا وقت",
               "",
               "بنگلہ دیش کا وقت",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "کیپ ورڈی سٹینڈرڈ ٹائم",
               "",
               "کیپ ورڈی سمر ٹائم",
               "",
               "کیپ ورڈی ٹائم",
               "",
            };
        final String[] East_Timor = new String[] {
               "مشرقی تیمور ٹائم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "قازقستان کا وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "سیشلیز ٹائم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "تاجکستان کا وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "ازبکستان کا معیاری وقت",
               "",
               "ازبکستان کا موسم گرما کا وقت",
               "",
               "ازبکستان کا وقت",
               "",
            };
        final String[] Afghanistan = new String[] {
               "افغانستان کا وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "کرسنویارسک سٹینڈرڈ ٹائم",
               "",
               "کریسنویارسک سمر ٹائم",
               "",
               "کریسنویارسک ٹائم",
               "",
            };
        final String[] New_Zealand = new String[] {
               "نیوزی لینڈ کا معیاری وقت",
               "NZST",
               "نیوزی لینڈ ڈے لائٹ ٹائم",
               "NZDT",
               "نیوزی لینڈ کا وقت",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "نوووسیبرسک سٹینڈرڈ ٹائم",
               "",
               "نوووسیبرسک سمر ٹائم",
               "",
               "نوووسیبرسک ٹائم",
               "",
            };
        final String[] Philippines = new String[] {
               "فلپائن سٹینڈرڈ ٹائم",
               "PST",
               "فلپائن سمر ٹائم",
               "PDT",
               "فلپائن ٹائم",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "ولادی ووستک سٹینڈرڈ ٹائم",
               "",
               "ولادی ووستک سمر ٹائم",
               "",
               "ولادی ووستک ٹائم",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "بحر ہند ٹائم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "لائن آئلینڈز ٹائم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "نیو فاؤنڈ لینڈ اسٹینڈرڈ ٹائم",
               "NST",
               "نیو فاؤنڈ لینڈ ڈے لائٹ ٹائم",
               "NDT",
               "نیو فاؤنڈ لینڈ ٹائم",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "ترکمانستان کا معیاری وقت",
               "",
               "ترکمانستان کا موسم گرما کا وقت",
               "",
               "ترکمانستان کا وقت",
               "",
            };
        final String[] French_Guiana = new String[] {
               "فرینچ گیانا کا وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "نیو کیلیڈونیا سٹینڈرڈ ٹائم",
               "",
               "نیو کیلیڈونیا سمر ٹائم",
               "",
               "نیو کیلیڈونیا ٹائم",
               "",
            };
        final String[] South_Georgia = new String[] {
               "جنوبی جارجیا ٹائم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "یکاٹیرِنبرگ اسٹینڈرڈ ٹائم",
               "",
               "یکاٹیرِنبرگ سمر ٹائم",
               "",
               "یکاٹیرِنبرگ ٹائم",
               "",
            };
        final String[] Africa_Central = new String[] {
               "وسطی افریقہ ٹائم",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "مشرقی افریقہ ٹائم",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "مغربی افریقہ سٹینڈرڈ ٹائم",
               "WAT",
               "مغربی افریقہ سمر ٹائم",
               "WAT",
               "مغربی افریقہ ٹائم",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "ڈومونٹ-ڈی’ارویلے ٹائم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "وسطی یورپ کا معیاری وقت",
               "CET",
               "وسطی یورپ کا موسم گرما کا وقت",
               "CEST",
               "وسط یورپ کا وقت",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "مشرقی یورپ کا معیاری وقت",
               "EET",
               "مشرقی یورپ کا موسم گرما کا وقت",
               "EEST",
               "مشرقی یورپ کا وقت",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "مغربی یورپ کا معیاری وقت",
               "WET",
               "مغربی یورپ کا موسم گرما کا وقت",
               "WEST",
               "مغربی یورپ کا وقت",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "میکسیکن پیسفک اسٹینڈرڈ ٹائم",
               "MST",
               "میکسیکن پیسفک ڈے لائٹ ٹائم",
               "MDT",
               "میکسیکن پیسفک ٹائم",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "جنوبی افریقہ سٹینڈرڈ ٹائم",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "سنٹرل اسٹینڈرڈ ٹائم",
               "CST",
               "سنٹرل ڈے لائٹ ٹائم",
               "CDT",
               "سنٹرل ٹائم",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "ایسٹرن اسٹینڈرڈ ٹائم",
               "EST",
               "ایسٹرن ڈے لائٹ ٹائم",
               "EST",
               "ایسٹرن ٹائم",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "پیسفک اسٹینڈرڈ ٹائم",
               "PST",
               "پیسفک ڈے لائٹ ٹائم",
               "PDT",
               "پیسفک ٹائم",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "فرینچ جنوبی اور انٹارکٹک ٹائم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "جلبرٹ آئلینڈز ٹائم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "ہوائی الیوٹیئن اسٹینڈرڈ ٹائم",
               "HST",
               "ہوائی الیوٹیئن ڈے لائٹ ٹائم",
               "HST",
               "ہوائی الیوٹیئن ٹائم",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "فینکس آئلینڈز ٹائم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "سینٹ پیئر اور مکلیئون اسٹینڈرڈ ٹائم",
               "",
               "سینٹ پیئر اور مکلیئون ڈے لائٹ ٹائم",
               "",
               "سینٹ پیئر اور مکلیئون ٹائم",
               "",
            };
        final String[] America_Mountain = new String[] {
               "ماؤنٹین اسٹینڈرڈ ٹائم",
               "MST",
               "ماؤنٹین ڈے لائٹ ٹائم",
               "MST",
               "ماؤنٹین ٹائم",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "مارشل آئلینڈز ٹائم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "پاپوآ نیو گنی ٹائم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "آسٹریلین سنٹرل اسٹینڈرڈ ٹائم",
               "ACST",
               "آسٹریلین سنٹرل ڈے لائٹ ٹائم",
               "ACDT",
               "سنٹرل آسٹریلیا ٹائم",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "آسٹریلین ایسٹرن اسٹینڈرڈ ٹائم",
               "AEST",
               "آسٹریلین ایسٹرن ڈے لائٹ ٹائم",
               "AEDT",
               "ایسٹرن آسٹریلیا ٹائم",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "آسٹریلیا ویسٹرن اسٹینڈرڈ ٹائم",
               "AWST",
               "آسٹریلین ویسٹرن ڈے لائٹ ٹائم",
               "AWDT",
               "ویسٹرن آسٹریلیا ٹائم",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "وسطی انڈونیشیا ٹائم",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "مشرقی انڈونیشیا ٹائم",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "مغربی انڈونیشیا ٹائم",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "آسٹریلین سنٹرل ویسٹرن اسٹینڈرڈ ٹائم",
               "",
               "آسٹریلین سنٹرل ویسٹرن ڈے لائٹ ٹائم",
               "",
               "آسٹریلین سنٹرل ویسٹرن ٹائم",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "گرین وچ کا اصل وقت",
                    "GMT",
                    "برٹش سمر ٹائم",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii_Aleutian },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "کوآرڈینیٹڈ یونیورسل ٹائم",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "گرین وچ کا اصل وقت",
                    "GMT",
                    "آئرش اسٹینڈرڈ ٹائم",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "کوآرڈینیٹڈ یونیورسل ٹائم",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "کوآرڈینیٹڈ یونیورسل ٹائم",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "گرین وچ کا اصل وقت",
                    "GMT",
                    "برٹش سمر ٹائم",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "کوآرڈینیٹڈ یونیورسل ٹائم",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Universal",
                new String[] {
                    "کوآرڈینیٹڈ یونیورسل ٹائم",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Anadyr", Anadyr },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "کوآرڈینیٹڈ یونیورسل ٹائم",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "گرین وچ کا اصل وقت",
                    "GMT",
                    "آئرش اسٹینڈرڈ ٹائم",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "گرین وچ کا اصل وقت",
                    "GMT",
                    "برٹش سمر ٹائم",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "گرین وچ کا اصل وقت",
                    "GMT",
                    "برٹش سمر ٹائم",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "گرین وچ کا اصل وقت",
                    "GMT",
                    "برٹش سمر ٹائم",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "گرین وچ کا اصل وقت",
                    "GMT",
                    "برٹش سمر ٹائم",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "گرین وچ کا اصل وقت",
                    "GMT",
                    "برٹش سمر ٹائم",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "عدن" },
            { "timezone.excity.Asia/Baku", "باکو" },
            { "timezone.excity.Asia/Dili", "ڈلی" },
            { "timezone.excity.Asia/Gaza", "غزہ" },
            { "timezone.excity.Asia/Hovd", "ہووارڈ" },
            { "timezone.excity.Asia/Omsk", "اومسک" },
            { "timezone.excity.Asia/Oral", "اورال" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "امّان" },
            { "timezone.excity.Asia/Aqtau", "اکتاؤ" },
            { "timezone.excity.Asia/Chita", "چیتا" },
            { "timezone.excity.Asia/Dhaka", "ڈھاکہ" },
            { "timezone.excity.Asia/Dubai", "دبئی" },
            { "timezone.excity.Asia/Kabul", "کابل" },
            { "timezone.excity.Asia/Macau", "مکاؤ" },
            { "timezone.excity.Asia/Qatar", "قطر" },
            { "timezone.excity.Asia/Seoul", "سیئول" },
            { "timezone.excity.Asia/Tokyo", "ٹوکیو" },
            { "timezone.excity.Asia/Tomsk", "ٹامسک" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "جوبا" },
            { "timezone.excity.Africa/Lome", "لوم" },
            { "timezone.excity.Asia/Almaty", "الماٹی" },
            { "timezone.excity.Asia/Anadyr", "انیدر" },
            { "timezone.excity.Asia/Aqtobe", "اکٹوب" },
            { "timezone.excity.Asia/Atyrau", "آتیراؤ" },
            { "timezone.excity.Asia/Beirut", "بیروت" },
            { "timezone.excity.Asia/Brunei", "برونئی" },
            { "timezone.excity.Asia/Hebron", "ہیبرون" },
            { "timezone.excity.Asia/Kuwait", "کویت" },
            { "timezone.excity.Asia/Manila", "منیلا" },
            { "timezone.excity.Asia/Muscat", "مسقط" },
            { "timezone.excity.Asia/Riyadh", "ریاض" },
            { "timezone.excity.Asia/Saigon", "ہو چی منہ سٹی" },
            { "timezone.excity.Asia/Taipei", "تائپے" },
            { "timezone.excity.Asia/Tehran", "تہران" },
            { "timezone.excity.Asia/Urumqi", "یورومکی" },
            { "timezone.excity.Etc/Unknown", "نامعلوم شہر" },
            { "timezone.excity.Europe/Kiev", "کیو" },
            { "timezone.excity.Europe/Oslo", "اوسلو" },
            { "timezone.excity.Europe/Riga", "ریگا" },
            { "timezone.excity.Europe/Rome", "روم" },
            { "timezone.excity.Indian/Mahe", "ماہی" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "اکّرا" },
            { "timezone.excity.Africa/Cairo", "قاہرہ" },
            { "timezone.excity.Africa/Ceuta", "سیوٹا" },
            { "timezone.excity.Africa/Dakar", "ڈکار" },
            { "timezone.excity.Africa/Lagos", "لاگوس" },
            { "timezone.excity.Africa/Tunis", "تیونس" },
            { "timezone.excity.America/Adak", "اداک" },
            { "timezone.excity.America/Lima", "لیما" },
            { "timezone.excity.America/Nome", "نوم" },
            { "timezone.excity.Asia/Baghdad", "بغداد" },
            { "timezone.excity.Asia/Bahrain", "بحرین" },
            { "timezone.excity.Asia/Bangkok", "بنکاک" },
            { "timezone.excity.Asia/Barnaul", "برنال" },
            { "timezone.excity.Asia/Bishkek", "بشکیک" },
            { "timezone.excity.Asia/Colombo", "کولمبو" },
            { "timezone.excity.Asia/Irkutsk", "ارکتسک" },
            { "timezone.excity.Asia/Jakarta", "جکارتہ" },
            { "timezone.excity.Asia/Karachi", "کراچی" },
            { "timezone.excity.Asia/Kuching", "کیوچنگ" },
            { "timezone.excity.Asia/Magadan", "میگیدن" },
            { "timezone.excity.Asia/Nicosia", "نکوسیا" },
            { "timezone.excity.Asia/Rangoon", "رنگون" },
            { "timezone.excity.Asia/Tbilisi", "طبلیسی" },
            { "timezone.excity.Asia/Thimphu", "تھمپو" },
            { "timezone.excity.Asia/Yakutsk", "یکوتسک" },
            { "timezone.excity.Asia/Yerevan", "یریوان" },
            { "timezone.excity.Europe/Kirov", "کیروف" },
            { "timezone.excity.Europe/Malta", "مالٹا" },
            { "timezone.excity.Europe/Minsk", "مِنسک" },
            { "timezone.excity.Europe/Paris", "پیرس" },
            { "timezone.excity.Europe/Sofia", "صوفیہ" },
            { "timezone.excity.Europe/Vaduz", "ویڈوز" },
            { "timezone.excity.Indian/Cocos", "کوکوس" },
            { "timezone.excity.Pacific/Apia", "اپیا" },
            { "timezone.excity.Pacific/Fiji", "فجی" },
            { "timezone.excity.Pacific/Guam", "گوآم" },
            { "timezone.excity.Pacific/Niue", "نیئو" },
            { "timezone.excity.Pacific/Truk", "چیوک" },
            { "timezone.excity.Pacific/Wake", "ویک" },
            { "timezone.excity.Africa/Asmera", "اسمارا" },
            { "timezone.excity.Africa/Bamako", "بماکو" },
            { "timezone.excity.Africa/Bangui", "بنگوئی" },
            { "timezone.excity.Africa/Banjul", "بنجول" },
            { "timezone.excity.Africa/Bissau", "بِساؤ" },
            { "timezone.excity.Africa/Douala", "ڈوآلا" },
            { "timezone.excity.Africa/Harare", "ہرارے" },
            { "timezone.excity.Africa/Kigali", "کگالی" },
            { "timezone.excity.Africa/Luanda", "لوانڈا" },
            { "timezone.excity.Africa/Lusaka", "لیوساکا" },
            { "timezone.excity.Africa/Malabo", "ملابو" },
            { "timezone.excity.Africa/Maputo", "مپوٹو" },
            { "timezone.excity.Africa/Maseru", "مسیرو" },
            { "timezone.excity.Africa/Niamey", "نیامی" },
            { "timezone.excity.America/Aruba", "اروبا" },
            { "timezone.excity.America/Bahia", "باہیا" },
            { "timezone.excity.America/Belem", "بیلیم" },
            { "timezone.excity.America/Boise", "بوائس" },
            { "timezone.excity.America/Jujuy", "جوجوئی" },
            { "timezone.excity.America/Sitka", "سیٹکا" },
            { "timezone.excity.America/Thule", "تھولو" },
            { "timezone.excity.Asia/Ashgabat", "اشغبت" },
            { "timezone.excity.Asia/Calcutta", "کولکاتا" },
            { "timezone.excity.Asia/Damascus", "دمشق" },
            { "timezone.excity.Asia/Dushanbe", "دوشانبے" },
            { "timezone.excity.Asia/Jayapura", "جے پورہ" },
            { "timezone.excity.Asia/Katmandu", "کاٹھمنڈو" },
            { "timezone.excity.Asia/Khandyga", "خندیگا" },
            { "timezone.excity.Asia/Makassar", "مکاسر" },
            { "timezone.excity.Asia/Qostanay", "کوستانے" },
            { "timezone.excity.Asia/Sakhalin", "سخالین" },
            { "timezone.excity.Asia/Shanghai", "شنگھائی" },
            { "timezone.excity.Asia/Tashkent", "تاشقند" },
            { "timezone.excity.Asia/Ust-Nera", "اوست-نیرا" },
            { "timezone.excity.Europe/Athens", "ایتھنز" },
            { "timezone.excity.Europe/Berlin", "برلن" },
            { "timezone.excity.Europe/Dublin", "ڈبلن" },
            { "timezone.excity.Europe/Jersey", "جرسی" },
            { "timezone.excity.Europe/Lisbon", "لسبن" },
            { "timezone.excity.Europe/London", "لندن" },
            { "timezone.excity.Europe/Madrid", "میڈرڈ" },
            { "timezone.excity.Europe/Monaco", "موناکو" },
            { "timezone.excity.Europe/Moscow", "ماسکو" },
            { "timezone.excity.Europe/Prague", "پراگ" },
            { "timezone.excity.Europe/Samara", "سمارا" },
            { "timezone.excity.Europe/Skopje", "اسکوپجے" },
            { "timezone.excity.Europe/Tirane", "ٹیرانی" },
            { "timezone.excity.Europe/Vienna", "ویانا" },
            { "timezone.excity.Europe/Warsaw", "وارسا" },
            { "timezone.excity.Europe/Zagreb", "زیگریب" },
            { "timezone.excity.Europe/Zurich", "زیورخ" },
            { "timezone.excity.Indian/Chagos", "چاگوس" },
            { "timezone.excity.Indian/Comoro", "کومورو" },
            { "timezone.excity.Pacific/Efate", "ایفیٹ" },
            { "timezone.excity.Pacific/Nauru", "ناؤرو" },
            { "timezone.excity.Pacific/Palau", "پلاؤ" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "عابدجان" },
            { "timezone.excity.Africa/Algiers", "الجیئرس" },
            { "timezone.excity.Africa/Conakry", "کونکری" },
            { "timezone.excity.Africa/Kampala", "کیمپالا" },
            { "timezone.excity.Africa/Mbabane", "مبابین" },
            { "timezone.excity.Africa/Nairobi", "نیروبی" },
            { "timezone.excity.Africa/Tripoli", "ٹریپولی" },
            { "timezone.excity.America/Belize", "بیلائز" },
            { "timezone.excity.America/Bogota", "بگوٹا" },
            { "timezone.excity.America/Cancun", "کنکیون" },
            { "timezone.excity.America/Cayman", "کیمین" },
            { "timezone.excity.America/Cuiaba", "کوئیابا" },
            { "timezone.excity.America/Dawson", "ڈاؤسن" },
            { "timezone.excity.America/Denver", "ڈینور" },
            { "timezone.excity.America/Guyana", "گیانا" },
            { "timezone.excity.America/Havana", "ہوانا" },
            { "timezone.excity.America/Inuvik", "انووِک" },
            { "timezone.excity.America/Juneau", "جونیئو" },
            { "timezone.excity.America/La_Paz", "لا پاز" },
            { "timezone.excity.America/Maceio", "میسیئو" },
            { "timezone.excity.America/Manaus", "مناؤس" },
            { "timezone.excity.America/Merida", "میریڈا" },
            { "timezone.excity.America/Nassau", "نساؤ" },
            { "timezone.excity.America/Panama", "پنامہ" },
            { "timezone.excity.America/Recife", "ریسائف" },
            { "timezone.excity.America/Regina", "ریجینا" },
            { "timezone.excity.Asia/Famagusta", "فاماگوسٹا" },
            { "timezone.excity.Asia/Hong_Kong", "ہانگ کانگ" },
            { "timezone.excity.Asia/Jerusalem", "یروشلم" },
            { "timezone.excity.Asia/Kamchatka", "کیمچٹکا" },
            { "timezone.excity.Asia/Pontianak", "پونٹیانک" },
            { "timezone.excity.Asia/Pyongyang", "پیونگ یانگ" },
            { "timezone.excity.Asia/Qyzylorda", "کیزیلورڈا" },
            { "timezone.excity.Asia/Samarkand", "سمرقند" },
            { "timezone.excity.Asia/Singapore", "سنگاپور" },
            { "timezone.excity.Asia/Vientiane", "وینٹیانا" },
            { "timezone.excity.Europe/Andorra", "انڈورا" },
            { "timezone.excity.Europe/Saratov", "سیراٹو" },
            { "timezone.excity.Europe/Tallinn", "ٹالن" },
            { "timezone.excity.Europe/Vatican", "واٹیکن" },
            { "timezone.excity.Europe/Vilnius", "وِلنیئس" },
            { "timezone.excity.Indian/Mayotte", "مایوٹ" },
            { "timezone.excity.Indian/Reunion", "ری یونین" },
            { "timezone.excity.Pacific/Easter", "ایسٹر" },
            { "timezone.excity.Pacific/Kanton", "کانٹن" },
            { "timezone.excity.Pacific/Kosrae", "کوسرائی" },
            { "timezone.excity.Pacific/Majuro", "مجورو" },
            { "timezone.excity.Pacific/Midway", "مڈوے" },
            { "timezone.excity.Pacific/Noumea", "نؤمیا" },
            { "timezone.excity.Pacific/Ponape", "پونپیئی" },
            { "timezone.excity.Pacific/Saipan", "سائپین" },
            { "timezone.excity.Pacific/Tahiti", "تاہیتی" },
            { "timezone.excity.Pacific/Tarawa", "ٹراوا" },
            { "timezone.excity.Pacific/Wallis", "ولّیس" },
            { "timezone.excity.Africa/Blantyre", "بلینٹائر" },
            { "timezone.excity.Africa/Djibouti", "جبوتی" },
            { "timezone.excity.Africa/El_Aaiun", "العیون" },
            { "timezone.excity.Africa/Freetown", "فری ٹاؤن" },
            { "timezone.excity.Africa/Gaborone", "گبرون" },
            { "timezone.excity.Africa/Khartoum", "خرطوم" },
            { "timezone.excity.Africa/Kinshasa", "کنشاسا" },
            { "timezone.excity.Africa/Monrovia", "مونروویا" },
            { "timezone.excity.Africa/Ndjamena", "اینجامینا" },
            { "timezone.excity.Africa/Sao_Tome", "ساؤ ٹوم" },
            { "timezone.excity.Africa/Windhoek", "ونڈہوک" },
            { "timezone.excity.America/Antigua", "انٹیگوا" },
            { "timezone.excity.America/Caracas", "کراکاس" },
            { "timezone.excity.America/Cayenne", "کائین" },
            { "timezone.excity.America/Chicago", "شکاگو" },
            { "timezone.excity.America/Cordoba", "کورڈوبا" },
            { "timezone.excity.America/Creston", "کریسٹون" },
            { "timezone.excity.America/Curacao", "کیوراکاؤ" },
            { "timezone.excity.America/Detroit", "ڈیٹرائٹ" },
            { "timezone.excity.America/Godthab", "نوک" },
            { "timezone.excity.America/Grenada", "غرناطہ" },
            { "timezone.excity.America/Halifax", "ہیلیفیکس" },
            { "timezone.excity.America/Iqaluit", "ایکالوئٹ" },
            { "timezone.excity.America/Jamaica", "جمائیکا" },
            { "timezone.excity.America/Managua", "مناگوآ" },
            { "timezone.excity.America/Marigot", "میریگوٹ" },
            { "timezone.excity.America/Mendoza", "مینڈوزا" },
            { "timezone.excity.America/Moncton", "مونکٹن" },
            { "timezone.excity.America/Noronha", "نورونہا" },
            { "timezone.excity.America/Ojinaga", "اوجیناگا" },
            { "timezone.excity.America/Phoenix", "فینکس" },
            { "timezone.excity.America/Tijuana", "تیجوآنا" },
            { "timezone.excity.America/Toronto", "ٹورنٹو" },
            { "timezone.excity.America/Tortola", "ٹورٹولا" },
            { "timezone.excity.America/Yakutat", "یکوٹیٹ" },
            { "timezone.excity.Asia/Phnom_Penh", "پنوم پن" },
            { "timezone.excity.Atlantic/Azores", "ازوریس" },
            { "timezone.excity.Atlantic/Canary", "کینری" },
            { "timezone.excity.Atlantic/Faeroe", "فارو" },
            { "timezone.excity.Australia/Eucla", "ایوکلا" },
            { "timezone.excity.Australia/Perth", "پرتھ" },
            { "timezone.excity.Europe/Belgrade", "بلغراد" },
            { "timezone.excity.Europe/Brussels", "برسلز" },
            { "timezone.excity.Europe/Budapest", "بڈاپسٹ" },
            { "timezone.excity.Europe/Busingen", "بزنجن" },
            { "timezone.excity.Europe/Chisinau", "چیسیناؤ" },
            { "timezone.excity.Europe/Guernsey", "گرنزی" },
            { "timezone.excity.Europe/Helsinki", "ہیلسنکی" },
            { "timezone.excity.Europe/Istanbul", "استنبول" },
            { "timezone.excity.Europe/Sarajevo", "سراجیوو" },
            { "timezone.excity.Indian/Maldives", "مالدیپ" },
            { "timezone.excity.Pacific/Chatham", "چیتھم" },
            { "timezone.excity.Pacific/Fakaofo", "فکاؤفو" },
            { "timezone.excity.Pacific/Gambier", "گامبیئر" },
            { "timezone.excity.Pacific/Norfolk", "نورفوک" },
            { "timezone.excity.Africa/Bujumbura", "بجمبرا" },
            { "timezone.excity.Africa/Mogadishu", "موگادیشو" },
            { "timezone.excity.America/Anguilla", "انگویلا" },
            { "timezone.excity.America/Asuncion", "اسنسیئن" },
            { "timezone.excity.America/Barbados", "بارباڈوس" },
            { "timezone.excity.America/Dominica", "ڈومنیکا" },
            { "timezone.excity.America/Edmonton", "ایڈمونٹن" },
            { "timezone.excity.America/Eirunepe", "ایرونیپ" },
            { "timezone.excity.America/Mazatlan", "میزٹلان" },
            { "timezone.excity.America/Miquelon", "میکلیئون" },
            { "timezone.excity.America/New_York", "نیو یارک" },
            { "timezone.excity.America/Resolute", "ریزولیوٹ" },
            { "timezone.excity.America/Santarem", "سنٹارین" },
            { "timezone.excity.America/Santiago", "سنٹیاگو" },
            { "timezone.excity.America/St_Johns", "سینٹ جانز" },
            { "timezone.excity.America/St_Kitts", "سینٹ کٹس" },
            { "timezone.excity.America/St_Lucia", "سینٹ لوسیا" },
            { "timezone.excity.America/Winnipeg", "ونّیپیگ" },
            { "timezone.excity.Antarctica/Casey", "کیسی" },
            { "timezone.excity.Antarctica/Davis", "ڈیوس" },
            { "timezone.excity.Antarctica/Syowa", "سیووا" },
            { "timezone.excity.Antarctica/Troll", "ٹرول" },
            { "timezone.excity.Asia/Krasnoyarsk", "کریسنویارسک" },
            { "timezone.excity.Asia/Novosibirsk", "نوووسِبِرسک" },
            { "timezone.excity.Asia/Ulaanbaatar", "اولان باتار" },
            { "timezone.excity.Asia/Vladivostok", "ولادی ووستک" },
            { "timezone.excity.Atlantic/Bermuda", "برمودا" },
            { "timezone.excity.Atlantic/Madeira", "مڈیئرا" },
            { "timezone.excity.Atlantic/Stanley", "اسٹینلے" },
            { "timezone.excity.Australia/Darwin", "ڈارون" },
            { "timezone.excity.Australia/Hobart", "ہوبارٹ" },
            { "timezone.excity.Australia/Sydney", "سڈنی" },
            { "timezone.excity.Europe/Amsterdam", "ایمسٹرڈم" },
            { "timezone.excity.Europe/Astrakhan", "استراخان" },
            { "timezone.excity.Europe/Bucharest", "بخارسٹ" },
            { "timezone.excity.Europe/Gibraltar", "جبل الطارق" },
            { "timezone.excity.Europe/Ljubljana", "لیوبلیانا" },
            { "timezone.excity.Europe/Mariehamn", "میریہام" },
            { "timezone.excity.Europe/Podgorica", "پوڈگورسیا" },
            { "timezone.excity.Europe/Stockholm", "اسٹاک ہوم" },
            { "timezone.excity.Europe/Ulyanovsk", "الیانوسک" },
            { "timezone.excity.Europe/Volgograd", "وولگوگراد" },
            { "timezone.excity.Indian/Christmas", "کرسمس" },
            { "timezone.excity.Indian/Kerguelen", "کرگیولین" },
            { "timezone.excity.Indian/Mauritius", "ماریشس" },
            { "timezone.excity.Pacific/Auckland", "آکلینڈ" },
            { "timezone.excity.Pacific/Funafuti", "فیونافیوٹی" },
            { "timezone.excity.Pacific/Honolulu", "ہونولولو" },
            { "timezone.excity.Pacific/Pitcairn", "پٹکائرن" },
            { "timezone.excity.Africa/Casablanca", "کیسا بلانکا" },
            { "timezone.excity.Africa/Libreville", "لبرے ویلے" },
            { "timezone.excity.Africa/Lubumbashi", "لوبمباشی" },
            { "timezone.excity.Africa/Nouakchott", "نواکشوط" },
            { "timezone.excity.Africa/Porto-Novo", "پورٹو نووو" },
            { "timezone.excity.America/Anchorage", "اینکریج" },
            { "timezone.excity.America/Araguaina", "اراگویانا" },
            { "timezone.excity.America/Boa_Vista", "بوآ وسٹا" },
            { "timezone.excity.America/Catamarca", "کیٹامارکا" },
            { "timezone.excity.America/Chihuahua", "چیہوآہوآ" },
            { "timezone.excity.America/Fortaleza", "فورٹالیزا" },
            { "timezone.excity.America/Glace_Bay", "گلیس کی کھاڑی" },
            { "timezone.excity.America/Goose_Bay", "گوس کی کھاڑی" },
            { "timezone.excity.America/Guatemala", "گواٹے مالا" },
            { "timezone.excity.America/Guayaquil", "گوآیاکوئل" },
            { "timezone.excity.America/Matamoros", "میٹاموروس" },
            { "timezone.excity.America/Menominee", "مینومینی" },
            { "timezone.excity.America/Monterrey", "مونٹیری" },
            { "timezone.excity.America/Sao_Paulo", "ساؤ پالو" },
            { "timezone.excity.America/St_Thomas", "سینٹ تھامس" },
            { "timezone.excity.America/Vancouver", "وینکوور" },
            { "timezone.excity.Antarctica/Mawson", "ماؤسن" },
            { "timezone.excity.Antarctica/Palmer", "پلمیر" },
            { "timezone.excity.Antarctica/Vostok", "ووستوک" },
            { "timezone.excity.Asia/Kuala_Lumpur", "کوالا لمپور" },
            { "timezone.excity.Asia/Novokuznetsk", "نوووکیوزنیسک" },
            { "timezone.excity.Europe/Bratislava", "بریٹِسلاوا" },
            { "timezone.excity.Europe/Copenhagen", "کوپن ہیگن" },
            { "timezone.excity.Europe/Luxembourg", "لگژمبرگ" },
            { "timezone.excity.Europe/San_Marino", "سان ماریانو" },
            { "timezone.excity.Europe/Simferopol", "سمفروپول" },
            { "timezone.excity.Pacific/Enderbury", "اینڈربری" },
            { "timezone.excity.Pacific/Galapagos", "گیلاپیگوس" },
            { "timezone.excity.Pacific/Kwajalein", "کواجیلین" },
            { "timezone.excity.Pacific/Marquesas", "مارکیساس" },
            { "timezone.excity.Pacific/Pago_Pago", "پاگو پاگو" },
            { "timezone.excity.Pacific/Rarotonga", "راروٹونگا" },
            { "timezone.excity.Pacific/Tongatapu", "ٹونگاٹاپو" },
            { "timezone.excity.Africa/Addis_Ababa", "عدیس ابابا" },
            { "timezone.excity.Africa/Brazzaville", "برازاویلے" },
            { "timezone.excity.Africa/Ouagadougou", "اؤگاڈؤگوو" },
            { "timezone.excity.America/Costa_Rica", "کوسٹا ریکا" },
            { "timezone.excity.America/Grand_Turk", "عظیم ترک" },
            { "timezone.excity.America/Guadeloupe", "گواڈیلوپ" },
            { "timezone.excity.America/Hermosillo", "ہرموسیلو" },
            { "timezone.excity.America/Kralendijk", "کرالینڈیجک" },
            { "timezone.excity.America/Louisville", "لوئس ویلے" },
            { "timezone.excity.America/Martinique", "مارٹینک" },
            { "timezone.excity.America/Metlakatla", "میٹلا کاٹلا" },
            { "timezone.excity.America/Montevideo", "مونٹی ویڈیو" },
            { "timezone.excity.America/Montserrat", "مونٹسیراٹ" },
            { "timezone.excity.America/Paramaribo", "پراماریبو" },
            { "timezone.excity.America/Rio_Branco", "ریئو برینکو" },
            { "timezone.excity.America/St_Vincent", "سینٹ ونسنٹ" },
            { "timezone.excity.America/Whitehorse", "وہائٹ ہارس" },
            { "timezone.excity.Antarctica/McMurdo", "میک مرڈو" },
            { "timezone.excity.Antarctica/Rothera", "روتھیرا" },
            { "timezone.excity.Asia/Srednekolymsk", "سرہدنیکولیمسک" },
            { "timezone.excity.Asia/Yekaterinburg", "یکاٹیرِنبرگ" },
            { "timezone.excity.Atlantic/Reykjavik", "ریکجاوک" },
            { "timezone.excity.Atlantic/St_Helena", "سینٹ ہیلینا" },
            { "timezone.excity.Australia/Adelaide", "ایڈیلیڈ" },
            { "timezone.excity.Australia/Brisbane", "برسبین" },
            { "timezone.excity.Australia/Lindeman", "لِنڈمین" },
            { "timezone.excity.Europe/Isle_of_Man", "آئل آف مین" },
            { "timezone.excity.Europe/Kaliningrad", "کالينينغراد" },
            { "timezone.excity.Pacific/Kiritimati", "کریتیماٹی" },
            { "timezone.excity.Africa/Johannesburg", "جوہانسبرگ" },
            { "timezone.excity.America/El_Salvador", "ال سلواڈور" },
            { "timezone.excity.America/Fort_Nelson", "فورٹ نیلسن" },
            { "timezone.excity.America/Los_Angeles", "لاس اینجلس" },
            { "timezone.excity.America/Mexico_City", "میکسیکو سٹی" },
            { "timezone.excity.America/Porto_Velho", "پورٹو ویلہو" },
            { "timezone.excity.America/Puerto_Rico", "پیورٹو ریکو" },
            { "timezone.excity.America/Tegucigalpa", "ٹیگوسیگالپے" },
            { "timezone.excity.Arctic/Longyearbyen", "لانگ ایئر بین" },
            { "timezone.excity.Atlantic/Cape_Verde", "کیپ ورڈی" },
            { "timezone.excity.Australia/Lord_Howe", "لارڈ ہووے" },
            { "timezone.excity.Australia/Melbourne", "ملبورن" },
            { "timezone.excity.Indian/Antananarivo", "انٹاناناریوو" },
            { "timezone.excity.Pacific/Guadalcanal", "گواڈل کینال" },
            { "timezone.excity.Africa/Dar_es_Salaam", "دار السلام" },
            { "timezone.excity.America/Blanc-Sablon", "بلانک سبلون" },
            { "timezone.excity.America/Buenos_Aires", "بیونس آئرس" },
            { "timezone.excity.America/Campo_Grande", "کیمپو گرینڈ" },
            { "timezone.excity.America/Danmarkshavn", "ڈنمارک شاون" },
            { "timezone.excity.America/Dawson_Creek", "ڈاؤسن کریک" },
            { "timezone.excity.America/Indiana/Knox", "کنوکس، انڈیانا" },
            { "timezone.excity.America/Indianapolis", "انڈیاناپولس" },
            { "timezone.excity.America/Punta_Arenas", "پنٹا اریناس" },
            { "timezone.excity.America/Rankin_Inlet", "رینکن انلیٹ" },
            { "timezone.excity.America/Scoresbysund", "اسکورز بائی سنڈ" },
            { "timezone.excity.Antarctica/Macquarie", "میکواری" },
            { "timezone.excity.Pacific/Bougainville", "بوگینولے" },
            { "timezone.excity.Pacific/Port_Moresby", "پورٹ موریسبی" },
            { "timezone.excity.America/Cambridge_Bay", "کیمبرج کی کھاڑی" },
            { "timezone.excity.America/Ciudad_Juarez", "سیوداد جیوریز" },
            { "timezone.excity.America/Coral_Harbour", "اٹیکوکن" },
            { "timezone.excity.America/Indiana/Vevay", "ویوے، انڈیانا" },
            { "timezone.excity.America/Lower_Princes", "لوور پرنسس کوارٹر" },
            { "timezone.excity.America/Port_of_Spain", "پورٹ آف اسپین" },
            { "timezone.excity.America/Santo_Domingo", "سانتو ڈومنگو" },
            { "timezone.excity.America/St_Barthelemy", "سینٹ برتھیلمی" },
            { "timezone.excity.America/Swift_Current", "سوِفٹ کرنٹ" },
            { "timezone.excity.Australia/Broken_Hill", "بروکن ہِل" },
            { "timezone.excity.America/Bahia_Banderas", "بہیا بندراز" },
            { "timezone.excity.America/Port-au-Prince", "پورٹ او پرنس" },
            { "timezone.excity.Atlantic/South_Georgia", "جنوبی جارجیا" },
            { "timezone.excity.America/Argentina/Salta", "سالٹا" },
            { "timezone.excity.America/Indiana/Marengo", "مرینگو، انڈیانا" },
            { "timezone.excity.America/Indiana/Winamac", "وینامیک، انڈیانا" },
            { "timezone.excity.America/Argentina/Tucuman", "ٹوکومین" },
            { "timezone.excity.America/Argentina/Ushuaia", "اوشوآئیا" },
            { "timezone.excity.America/Indiana/Tell_City", "ٹیل سٹی، انڈیانا" },
            { "timezone.excity.America/Indiana/Vincennes", "ونسینیز، انڈیانا" },
            { "timezone.excity.Antarctica/DumontDUrville", "ڈومونٹ ڈی ارویلے" },
            { "timezone.excity.America/Argentina/La_Rioja", "لا ریئوجا" },
            { "timezone.excity.America/Argentina/San_Juan", "سان جوآن" },
            { "timezone.excity.America/Argentina/San_Luis", "سان لوئس" },
            { "timezone.excity.America/Indiana/Petersburg", "پیٹرزبرگ، انڈیانا" },
            { "timezone.excity.America/Kentucky/Monticello", "مونٹیسیلو، کینٹوکی" },
            { "timezone.excity.America/North_Dakota/Beulah", "بیولاہ، شمالی ڈکوٹا" },
            { "timezone.excity.America/North_Dakota/Center", "وسط، شمالی ڈکوٹا" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "ریو گالیگوس" },
            { "timezone.excity.America/North_Dakota/New_Salem", "نیو سلیم، شمالی ڈکوٹا" },
        };
        return data;
    }
}
