/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_he extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_TK = "טוקלאו";
        final String metaValue_TV = "טובאלו";
        final String metaValue_bax = "במום";
        final String metaValue_ccp = "צ׳אקמה";
        final String metaValue_chr = "צ׳רוקי";
        final String metaValue_men = "מנדה";
        final String metaValue_ml = "מליאלאם";
        final String metaValue_mer = "מרו";
        final String metaValue_nqo = "נ׳קו";
        final String metaValue_si = "סינהלה";
        final String metaValue_te = "טלוגו";
        final String metaValue_Hans = "פשוט";
        final Object[][] data = new Object[][] {
            { "001", "העולם" },
            { "002", "אפריקה" },
            { "003", "צפון אמריקה" },
            { "005", "דרום אמריקה" },
            { "009", "אוקיאניה" },
            { "011", "מערב אפריקה" },
            { "013", "מרכז אמריקה" },
            { "014", "מזרח אפריקה" },
            { "015", "צפון אפריקה" },
            { "017", "מרכז אפריקה" },
            { "018", "דרום יבשת אפריקה" },
            { "019", "אמריקה" },
            { "021", "אמריקה הצפונית" },
            { "029", "האיים הקריביים" },
            { "030", "מזרח אסיה" },
            { "034", "דרום אסיה" },
            { "035", "דרום־מזרח אסיה" },
            { "039", "דרום אירופה" },
            { "053", "אוסטרלאסיה" },
            { "054", "מלנזיה" },
            { "057", "אזור מיקרונזיה" },
            { "061", "פולינזיה" },
            { "142", "אסיה" },
            { "143", "מרכז אסיה" },
            { "145", "מערב אסיה" },
            { "150", "אירופה" },
            { "151", "מזרח אירופה" },
            { "154", "צפון אירופה" },
            { "155", "מערב אירופה" },
            { "202", "אפריקה שמדרום לסהרה" },
            { "419", "אמריקה הלטינית" },
            { "AC", "האי אסנשן" },
            { "AD", "אנדורה" },
            { "AE", "איחוד האמירויות הערביות" },
            { "AF", "אפגניסטן" },
            { "AG", "אנטיגואה וברבודה" },
            { "AI", "אנגווילה" },
            { "AL", "אלבניה" },
            { "AM", "ארמניה" },
            { "AO", "אנגולה" },
            { "AQ", "אנטארקטיקה" },
            { "AR", "ארגנטינה" },
            { "AS", "סמואה האמריקנית" },
            { "AT", "אוסטריה" },
            { "AU", "אוסטרליה" },
            { "AW", "ארובה" },
            { "AX", "איי אולנד" },
            { "AZ", "אזרבייג׳ן" },
            { "BA", "בוסניה והרצגובינה" },
            { "BB", "ברבדוס" },
            { "BD", "בנגלדש" },
            { "BE", "בלגיה" },
            { "BF", "בורקינה פאסו" },
            { "BG", "בולגריה" },
            { "BH", "בחריין" },
            { "BI", "בורונדי" },
            { "BJ", "בנין" },
            { "BL", "סנט ברתולומיאו" },
            { "BM", "ברמודה" },
            { "BN", "ברוניי" },
            { "BO", "בוליביה" },
            { "BQ", "האיים הקריביים ההולנדיים" },
            { "BR", "ברזיל" },
            { "BS", "איי בהאמה" },
            { "BT", "בהוטן" },
            { "BV", "האי בובה" },
            { "BW", "בוטסואנה" },
            { "BY", "בלארוס" },
            { "BZ", "בליז" },
            { "CA", "קנדה" },
            { "CC", "איי קוקוס (קילינג)" },
            { "CD", "קונגו - קינשאסה" },
            { "CF", "הרפובליקה המרכז-אפריקאית" },
            { "CG", "קונגו - ברזאויל" },
            { "CH", "שווייץ" },
            { "CI", "חוף השנהב" },
            { "CK", "איי קוק" },
            { "CL", "צ׳ילה" },
            { "CM", "קמרון" },
            { "CN", "סין" },
            { "CO", "קולומביה" },
            { "CP", "האי קליפרטון" },
            { "CR", "קוסטה ריקה" },
            { "CU", "קובה" },
            { "CV", "כף ורדה" },
            { "CW", "קוראסאו" },
            { "CX", "אי חג המולד" },
            { "CY", "קפריסין" },
            { "CZ", "צ׳כיה" },
            { "DE", "גרמניה" },
            { "DG", "דייגו גרסיה" },
            { "DJ", "ג׳יבוטי" },
            { "DK", "דנמרק" },
            { "DM", "דומיניקה" },
            { "DO", "הרפובליקה הדומיניקנית" },
            { "DZ", "אלג׳יריה" },
            { "EA", "סאוטה ומלייה" },
            { "EC", "אקוודור" },
            { "EE", "אסטוניה" },
            { "EG", "מצרים" },
            { "EH", "סהרה המערבית" },
            { "ER", "אריתריאה" },
            { "ES", "ספרד" },
            { "ET", "אתיופיה" },
            { "EU", "האיחוד האירופי" },
            { "EZ", "גוש האירו" },
            { "FI", "פינלנד" },
            { "FJ", "פיג׳י" },
            { "FK", "איי פוקלנד" },
            { "FM", "מיקרונזיה" },
            { "FO", "איי פארו" },
            { "FR", "צרפת" },
            { "GA", "גבון" },
            { "GB", "בריטניה" },
            { "GD", "גרנדה" },
            { "GE", "גאורגיה" },
            { "GF", "גיאנה הצרפתית" },
            { "GG", "גרנזי" },
            { "GH", "גאנה" },
            { "GI", "גיברלטר" },
            { "GL", "גרינלנד" },
            { "GM", "גמביה" },
            { "GN", "גינאה" },
            { "GP", "גוואדלופ" },
            { "GQ", "גינאה המשוונית" },
            { "GR", "יוון" },
            { "GS", "ג׳ורג׳יה הדרומית ואיי סנדוויץ׳ הדרומיים" },
            { "GT", "גואטמלה" },
            { "GU", "גואם" },
            { "GW", "גינאה-ביסאו" },
            { "GY", "גיאנה" },
            { "HK", "הונג קונג (אזור מנהלי מיוחד של סין)" },
            { "HM", "איי הרד ומקדונלד" },
            { "HN", "הונדורס" },
            { "HR", "קרואטיה" },
            { "HT", "האיטי" },
            { "HU", "הונגריה" },
            { "IC", "האיים הקנריים" },
            { "ID", "אינדונזיה" },
            { "IE", "אירלנד" },
            { "IL", "ישראל" },
            { "IM", "האי מאן" },
            { "IN", "הודו" },
            { "IO", "הטריטוריה הבריטית באוקיינוס ההודי" },
            { "IQ", "עיראק" },
            { "IR", "איראן" },
            { "IS", "איסלנד" },
            { "IT", "איטליה" },
            { "JE", "ג׳רזי" },
            { "JM", "ג׳מייקה" },
            { "JO", "ירדן" },
            { "JP", "יפן" },
            { "KE", "קניה" },
            { "KG", "קירגיזסטן" },
            { "KH", "קמבודיה" },
            { "KI", "קיריבאטי" },
            { "KM", "קומורו" },
            { "KN", "סנט קיטס ונוויס" },
            { "KP", "קוריאה הצפונית" },
            { "KR", "קוריאה הדרומית" },
            { "KW", "כווית" },
            { "KY", "איי קיימן" },
            { "KZ", "קזחסטן" },
            { "LA", "לאוס" },
            { "LB", "לבנון" },
            { "LC", "סנט לוסיה" },
            { "LI", "ליכטנשטיין" },
            { "LK", "סרי לנקה" },
            { "LR", "ליבריה" },
            { "LS", "לסוטו" },
            { "LT", "ליטא" },
            { "LU", "לוקסמבורג" },
            { "LV", "לטביה" },
            { "LY", "לוב" },
            { "MA", "מרוקו" },
            { "MC", "מונקו" },
            { "MD", "מולדובה" },
            { "ME", "מונטנגרו" },
            { "MF", "סן מרטן" },
            { "MG", "מדגסקר" },
            { "MH", "איי מרשל" },
            { "MK", "מקדוניה הצפונית" },
            { "ML", "מאלי" },
            { "MM", "מיאנמר (בורמה)" },
            { "MN", "מונגוליה" },
            { "MO", "מקאו (אזור מנהלי מיוחד של סין)" },
            { "MP", "איי מריאנה הצפוניים" },
            { "MQ", "מרטיניק" },
            { "MR", "מאוריטניה" },
            { "MS", "מונסראט" },
            { "MT", "מלטה" },
            { "MU", "מאוריציוס" },
            { "MV", "האיים המלדיביים" },
            { "MW", "מלאווי" },
            { "MX", "מקסיקו" },
            { "MY", "מלזיה" },
            { "MZ", "מוזמביק" },
            { "NA", "נמיביה" },
            { "NC", "קלדוניה החדשה" },
            { "NE", "ניז׳ר" },
            { "NF", "האי נורפוק" },
            { "NG", "ניגריה" },
            { "NI", "ניקרגואה" },
            { "NL", "הולנד" },
            { "NO", "נורווגיה" },
            { "NP", "נפאל" },
            { "NR", "נאורו" },
            { "NU", "ניווה" },
            { "NZ", "ניו זילנד" },
            { "OM", "עומאן" },
            { "PA", "פנמה" },
            { "PE", "פרו" },
            { "PF", "פולינזיה הצרפתית" },
            { "PG", "פפואה גינאה החדשה" },
            { "PH", "הפיליפינים" },
            { "PK", "פקיסטן" },
            { "PL", "פולין" },
            { "PM", "סנט פייר ומיקלון" },
            { "PN", "איי פיטקרן" },
            { "PR", "פוארטו ריקו" },
            { "PS", "השטחים הפלסטיניים" },
            { "PT", "פורטוגל" },
            { "PW", "פלאו" },
            { "PY", "פרגוואי" },
            { "QA", "קטאר" },
            { "QO", "טריטוריות באוקיאניה" },
            { "RE", "ראוניון" },
            { "RO", "רומניה" },
            { "RS", "סרביה" },
            { "RU", "רוסיה" },
            { "RW", "רואנדה" },
            { "SA", "ערב הסעודית" },
            { "SB", "איי שלמה" },
            { "SC", "איי סיישל" },
            { "SD", "סודן" },
            { "SE", "שוודיה" },
            { "SG", "סינגפור" },
            { "SH", "סנט הלנה" },
            { "SI", "סלובניה" },
            { "SJ", "סבאלברד ויאן מאיין" },
            { "SK", "סלובקיה" },
            { "SL", "סיירה לאון" },
            { "SM", "סן מרינו" },
            { "SN", "סנגל" },
            { "SO", "סומליה" },
            { "SR", "סורינאם" },
            { "SS", "דרום סודן" },
            { "ST", "סאו טומה ופרינסיפה" },
            { "SV", "אל סלבדור" },
            { "SX", "סנט מארטן" },
            { "SY", "סוריה" },
            { "SZ", "אסוואטיני" },
            { "TA", "טריסטן דה קונה" },
            { "TC", "איי טרקס וקייקוס" },
            { "TD", "צ׳אד" },
            { "TF", "הטריטוריות הדרומיות של צרפת" },
            { "TG", "טוגו" },
            { "TH", "תאילנד" },
            { "TJ", "טג׳יקיסטן" },
            { "TK", metaValue_TK },
            { "TL", "טימור-לסטה" },
            { "TM", "טורקמניסטן" },
            { "TN", "תוניסיה" },
            { "TO", "טונגה" },
            { "TR", "טורקיה" },
            { "TT", "טרינידד וטובגו" },
            { "TV", metaValue_TV },
            { "TW", "טייוואן" },
            { "TZ", "טנזניה" },
            { "UA", "אוקראינה" },
            { "UG", "אוגנדה" },
            { "UM", "האיים המרוחקים הקטנים של ארה״ב" },
            { "UN", "האומות המאוחדות" },
            { "US", "ארצות הברית" },
            { "UY", "אורוגוואי" },
            { "UZ", "אוזבקיסטן" },
            { "VA", "הוותיקן" },
            { "VC", "סנט וינסנט והגרנדינים" },
            { "VE", "ונצואלה" },
            { "VG", "איי הבתולה הבריטיים" },
            { "VI", "איי הבתולה של ארצות הברית" },
            { "VN", "וייטנאם" },
            { "VU", "ונואטו" },
            { "WF", "איי ווליס ופוטונה" },
            { "WS", "סמואה" },
            { "XA", "מבטאים חלקיים" },
            { "XB", "דו-כיווני חלקי" },
            { "XK", "קוסובו" },
            { "YE", "תימן" },
            { "YT", "מאיוט" },
            { "ZA", "דרום אפריקה" },
            { "ZM", "זמביה" },
            { "ZW", "זימבבואה" },
            { "ZZ", "אזור לא ידוע" },
            { "aa", "אפארית" },
            { "ab", "אבחזית" },
            { "ae", "אבסטן" },
            { "af", "אפריקאנס" },
            { "ak", "אקאן" },
            { "am", "אמהרית" },
            { "an", "אראגונית" },
            { "ar", "ערבית" },
            { "as", "אסאמית" },
            { "av", "אווארית" },
            { "ay", "איימארית" },
            { "az", "אזרית" },
            { "ba", "בשקירית" },
            { "be", "בלארוסית" },
            { "bg", "בולגרית" },
            { "bi", "ביסלמה" },
            { "bm", "במבארה" },
            { "bn", "בנגלית" },
            { "bo", "טיבטית" },
            { "br", "ברטונית" },
            { "bs", "בוסנית" },
            { "ca", "קטלאנית" },
            { "ce", "צ׳צ׳נית" },
            { "ch", "צ׳מורו" },
            { "co", "קורסיקנית" },
            { "cr", "קרי" },
            { "cs", "צ׳כית" },
            { "cu", "סלאבית כנסייתית עתיקה" },
            { "cv", "צ׳ובאש" },
            { "cy", "וולשית" },
            { "da", "דנית" },
            { "de", "גרמנית" },
            { "dv", "דיבהי" },
            { "dz", "דזונקה" },
            { "ee", "אווה" },
            { "el", "יוונית" },
            { "en", "אנגלית" },
            { "eo", "אספרנטו" },
            { "es", "ספרדית" },
            { "et", "אסטונית" },
            { "eu", "בסקית" },
            { "fa", "פרסית" },
            { "ff", "פולה" },
            { "fi", "פינית" },
            { "fj", "פיג׳ית" },
            { "fo", "פארואזית" },
            { "fr", "צרפתית" },
            { "fy", "פריזית מערבית" },
            { "ga", "אירית" },
            { "gd", "גאלית סקוטית" },
            { "gl", "גליציאנית" },
            { "gn", "גוארני" },
            { "gu", "גוג׳ארטי" },
            { "gv", "מאנית" },
            { "ha", "האוסה" },
            { "he", "עברית" },
            { "hi", "הינדי" },
            { "ho", "הירי מוטו" },
            { "hr", "קרואטית" },
            { "ht", "קריאולית (האיטי)" },
            { "hu", "הונגרית" },
            { "hy", "ארמנית" },
            { "hz", "הררו" },
            { "ia", "‏אינטרלינגואה" },
            { "id", "אינדונזית" },
            { "ie", "אינטרלינגה" },
            { "ig", "איגבו" },
            { "ii", "סצ׳ואן יי" },
            { "ik", "אינופיאק" },
            { "io", "אידו" },
            { "is", "איסלנדית" },
            { "it", "איטלקית" },
            { "iu", "אינוקטיטוט" },
            { "ja", "יפנית" },
            { "jv", "יאוואית" },
            { "ka", "גאורגית" },
            { "kg", "קונגו" },
            { "ki", "קיקויו" },
            { "kj", "קואניאמה" },
            { "kk", "קזחית" },
            { "kl", "גרינלנדית" },
            { "km", "חמרית" },
            { "kn", "קנאדה" },
            { "ko", "קוריאנית" },
            { "kr", "קאנורי" },
            { "ks", "קשמירית" },
            { "ku", "כורדית" },
            { "kv", "קומי" },
            { "kw", "קורנית" },
            { "ky", "קירגיזית" },
            { "la", "לטינית" },
            { "lb", "לוקסמבורגית" },
            { "lg", "גאנדה" },
            { "li", "לימבורגית" },
            { "ln", "לינגלה" },
            { "lo", "לאו" },
            { "lt", "ליטאית" },
            { "lu", "לובה-קטנגה" },
            { "lv", "לטבית" },
            { "mg", "מלגשית" },
            { "mh", "מרשלית" },
            { "mi", "מאורית" },
            { "mk", "מקדונית" },
            { "ml", metaValue_ml },
            { "mn", "מונגולית" },
            { "mr", "מראטהית" },
            { "ms", "מלאית" },
            { "mt", "מלטית" },
            { "my", "בורמזית" },
            { "na", "נאורית" },
            { "nb", "נורווגית ספרותית" },
            { "nd", "נדבלה צפונית" },
            { "ne", "נפאלית" },
            { "ng", "נדונגה" },
            { "nl", "הולנדית" },
            { "nn", "נורווגית חדשה" },
            { "no", "נורווגית" },
            { "nr", "נדבלה דרומית" },
            { "nv", "נאוואחו" },
            { "ny", "ניאנג׳ה" },
            { "oc", "אוקסיטנית" },
            { "oj", "אוג׳יבווה" },
            { "om", "אורומו" },
            { "or", "אורייה" },
            { "os", "אוסטית" },
            { "pa", "פנג׳אבי" },
            { "pi", "פאלי" },
            { "pl", "פולנית" },
            { "ps", "פאשטו" },
            { "pt", "פורטוגזית" },
            { "qu", "קצ׳ואה" },
            { "rm", "רומאנש" },
            { "rn", "קירונדי" },
            { "ro", "רומנית" },
            { "ru", "רוסית" },
            { "rw", "קנירואנדית" },
            { "sa", "סנסקריט" },
            { "sc", "סרדינית" },
            { "sd", "סינדהית" },
            { "se", "סמי צפונית" },
            { "sg", "סנגו" },
            { "sh", "סרבו-קרואטית" },
            { "si", metaValue_si },
            { "sk", "סלובקית" },
            { "sl", "סלובנית" },
            { "sm", "סמואית" },
            { "sn", "שונה" },
            { "so", "סומלית" },
            { "sq", "אלבנית" },
            { "sr", "סרבית" },
            { "ss", "סאווזי" },
            { "st", "סותו דרומית" },
            { "su", "סונדנזית" },
            { "sv", "שוודית" },
            { "sw", "סווהילי" },
            { "ta", "טמילית" },
            { "te", metaValue_te },
            { "tg", "טג׳יקית" },
            { "th", "תאית" },
            { "ti", "תיגרינית" },
            { "tk", "טורקמנית" },
            { "tl", "טאגאלוג" },
            { "tn", "סוואנה" },
            { "to", "טונגאית" },
            { "tr", "טורקית" },
            { "ts", "טסונגה" },
            { "tt", "טטרית" },
            { "tw", "טווי" },
            { "ty", "טהיטית" },
            { "ug", "אויגורית" },
            { "uk", "אוקראינית" },
            { "ur", "אורדו" },
            { "uz", "אוזבקית" },
            { "ve", "וונדה" },
            { "vi", "וייטנאמית" },
            { "vo", "‏וולאפיק" },
            { "wa", "ולונית" },
            { "wo", "וולוף" },
            { "xh", "קוסה" },
            { "yi", "יידיש" },
            { "yo", "יורובה" },
            { "za", "זואנג" },
            { "zh", "סינית" },
            { "zu", "זולו" },
            { "ace", "אכינזית" },
            { "ach", "אקצ׳ולי" },
            { "ada", "אדנמה" },
            { "ady", "אדיגית" },
            { "afh", "אפריהילי" },
            { "agq", "אע׳ם" },
            { "ain", "אינו" },
            { "akk", "אכדית" },
            { "ale", "אלאוט" },
            { "alt", "אלטאי דרומית" },
            { "ang", "אנגלית עתיקה" },
            { "ann", "אובולו" },
            { "anp", "אנג׳יקה" },
            { "arc", "ארמית" },
            { "arn", "אראוקנית" },
            { "arp", "אראפהו" },
            { "ars", "ערבית - נג׳ד" },
            { "arw", "ארוואק" },
            { "asa", "אסו" },
            { "ast", "אסטורית" },
            { "atj", "אטיקמק" },
            { "awa", "אוואדית" },
            { "bal", "באלוצ׳י" },
            { "ban", "באלינזית" },
            { "bar", "בווארית" },
            { "bas", "בסאא" },
            { "bax", metaValue_bax },
            { "bbj", "גומאלה" },
            { "bej", "בז׳ה" },
            { "bem", "במבה" },
            { "bez", "בנה" },
            { "bfd", "באפוט" },
            { "bgc", "הריאנבי" },
            { "bgn", "באלוצ׳י מערבית" },
            { "bho", "בוג׳פורי" },
            { "bik", "ביקול" },
            { "bin", "ביני" },
            { "bkm", "קום" },
            { "bla", "סיקסיקה" },
            { "blo", "אני" },
            { "bra", "בראג׳" },
            { "brx", "בודו" },
            { "bss", "אקוסה" },
            { "bua", "בוריאט" },
            { "bug", "בוגינזית" },
            { "bum", "בולו" },
            { "byn", "בלין" },
            { "byv", "מדומבה" },
            { "cad", "קאדו" },
            { "car", "קאריב" },
            { "cay", "קאיוגה" },
            { "cch", "אטסם" },
            { "ccp", metaValue_ccp },
            { "ceb", "סבואנו" },
            { "cgg", "צ׳יגה" },
            { "chb", "צ׳יבצ׳ה" },
            { "chg", "צ׳אגאטאי" },
            { "chk", "צ׳וקסה" },
            { "chm", "מארי" },
            { "chn", "ניב צ׳ינוק" },
            { "cho", "צ׳וקטאו" },
            { "chp", "צ׳יפוויאן" },
            { "chr", metaValue_chr },
            { "chy", "שאיין" },
            { "ckb", "כורדית סוראנית" },
            { "clc", "צ׳ילקוטין" },
            { "cop", "קופטית" },
            { "crg", "מצ׳יף" },
            { "crh", "טטרית של קרים" },
            { "crj", "קרי דרום מזרחי" },
            { "crk", "קרי מישורים" },
            { "crl", "קרי צפון מזרחי" },
            { "crm", "מוס קרי" },
            { "crr", "אלגונקוויאן בקרוליינה" },
            { "crs", "קריאולית (סיישל)" },
            { "csb", "קשובית" },
            { "csw", "קרי של אזור הביצות" },
            { "dak", "דקוטה" },
            { "dar", "דרגווה" },
            { "dav", "טאיטה" },
            { "del", "דלאוור" },
            { "den", "סלאבית" },
            { "dgr", "דוגריב" },
            { "din", "דינקה" },
            { "dje", "זארמה" },
            { "doi", "דוגרי" },
            { "dsb", "סורבית תחתית" },
            { "dua", "דואלה" },
            { "dum", "הולנדית תיכונה" },
            { "dyo", "ג׳ולה פונית" },
            { "dyu", "דיולה" },
            { "dzg", "דזאנגה" },
            { "ebu", "אמבו" },
            { "efi", "אפיק" },
            { "egy", "מצרית עתיקה" },
            { "eka", "אקיוק" },
            { "elx", "עילמית" },
            { "enm", "אנגלית תיכונה" },
            { "ewo", "אוונדו" },
            { "fan", "פנג" },
            { "fat", "פאנטי" },
            { "fil", "פיליפינית" },
            { "fon", "פון" },
            { "frc", "צרפתית קייג׳ונית" },
            { "frm", "צרפתית תיכונה" },
            { "fro", "צרפתית עתיקה" },
            { "frr", "פריזית צפונית" },
            { "frs", "פריזית מזרחית" },
            { "fur", "פריולית" },
            { "gaa", "גא" },
            { "gag", "גגאוזית" },
            { "gan", "סינית גאן" },
            { "gay", "גאיו" },
            { "gba", "גבאיה" },
            { "gez", "געז" },
            { "gil", "קיריבטית" },
            { "gmh", "גרמנית בינונית-גבוהה" },
            { "goh", "גרמנית עתיקה גבוהה" },
            { "gon", "גונדי" },
            { "gor", "גורונטאלו" },
            { "got", "גותית" },
            { "grb", "גרבו" },
            { "grc", "יוונית עתיקה" },
            { "gsw", "גרמנית שוויצרית" },
            { "guz", "גוסי" },
            { "gwi", "גוויצ׳ן" },
            { "hai", "האידה" },
            { "hak", "סינית האקה" },
            { "haw", "הוואית" },
            { "hax", "האידה דרומית" },
            { "hil", "היליגאינון" },
            { "hit", "חתית" },
            { "hmn", "המונג" },
            { "hsb", "סורבית עילית" },
            { "hsn", "סינית שיאנג" },
            { "hup", "הופה" },
            { "hur", "הלקומלם" },
            { "iba", "איבאן" },
            { "ibb", "איביביו" },
            { "ikt", "אינוקטיטוט במערב קנדה" },
            { "ilo", "אילוקו" },
            { "inh", "אינגושית" },
            { "jbo", "לוז׳באן" },
            { "jgo", "נגומבה" },
            { "jmc", "מאקאמה" },
            { "jpr", "פרסית יהודית" },
            { "jrb", "ערבית יהודית" },
            { "kaa", "קארא-קלפאק" },
            { "kab", "קבילה" },
            { "kac", "קצ׳ין" },
            { "kaj", "ג׳ו" },
            { "kam", "קמבה" },
            { "kaw", "קאווי" },
            { "kbd", "קברדית" },
            { "kbl", "קנמבו" },
            { "kcg", "טיאפ" },
            { "kde", "מקונדה" },
            { "kea", "קאבוורדיאנו" },
            { "kfo", "קורו" },
            { "kgp", "קיינגאנג" },
            { "kha", "קהאסי" },
            { "kho", "קוטאנזית" },
            { "khq", "קוירה צ׳יני" },
            { "kkj", "קאקו" },
            { "kln", "קלנג׳ין" },
            { "kmb", "קימבונדו" },
            { "koi", "קומי-פרמיאקית" },
            { "kok", "קונקאני" },
            { "kos", "קוסראיאן" },
            { "kpe", "קפלה" },
            { "krc", "קראצ׳י-בלקר" },
            { "krl", "קארלית" },
            { "kru", "קורוק" },
            { "ksb", "שמבאלה" },
            { "ksf", "באפיה" },
            { "ksh", "קולוניאן" },
            { "kum", "קומיקית" },
            { "kut", "קוטנאי" },
            { "kwk", "קוואקוואלה" },
            { "kxv", "קווי" },
            { "lad", "לדינו" },
            { "lag", "לאנגי" },
            { "lah", "לנדה" },
            { "lam", "למבה" },
            { "lez", "לזגית" },
            { "lij", "ליגורית" },
            { "lil", "לילואט" },
            { "lkt", "לקוטה" },
            { "lmo", "לומברדית" },
            { "lol", "מונגו" },
            { "lou", "קריאולית לואיזיאנית" },
            { "loz", "לוזית" },
            { "lrc", "לורית צפונית" },
            { "lsm", "סמיה" },
            { "lua", "לובה-לולואה" },
            { "lui", "לויסנו" },
            { "lun", "לונדה" },
            { "luo", "לואו" },
            { "lus", "מיזו" },
            { "luy", "לויה" },
            { "mad", "מדורזית" },
            { "maf", "מאפאה" },
            { "mag", "מאגאהית" },
            { "mai", "מאיטילית" },
            { "mak", "מקסאר" },
            { "man", "מנדינגו" },
            { "mas", "מסאית" },
            { "mde", "מאבא" },
            { "mdf", "מוקשה" },
            { "mdr", "מנדאר" },
            { "men", metaValue_men },
            { "mer", metaValue_mer },
            { "mfe", "קריאולית מאוריציאנית" },
            { "mga", "אירית תיכונה" },
            { "mgh", "מאקוואה מטו" },
            { "mgo", "מטא" },
            { "mic", "מיקמק" },
            { "min", "מיננגקבאו" },
            { "mnc", "מנצ׳ו" },
            { "mni", "מניפורית" },
            { "moe", "אינו-אמון" },
            { "moh", "מוהוק" },
            { "mos", "מוסי" },
            { "mua", "מונדאנג" },
            { "mul", "מספר שפות" },
            { "mus", "קריק" },
            { "mwl", "מירנדזית" },
            { "mwr", "מרווארי" },
            { "mye", "מאיין" },
            { "myv", "ארזיה" },
            { "mzn", "מאזאנדראני" },
            { "nan", "סינית מין נאן" },
            { "nap", "נפוליטנית" },
            { "naq", "נאמה" },
            { "nds", "גרמנית תחתית" },
            { "new", "נווארי" },
            { "nia", "ניאס" },
            { "niu", "ניואן" },
            { "nmg", "קוואסיו" },
            { "nnh", "נגיאמבון" },
            { "nog", "נוגאי" },
            { "non", "‏נורדית עתיקה" },
            { "nqo", metaValue_nqo },
            { "nso", "סותו צפונית" },
            { "nus", "נואר" },
            { "nwc", "נווארית קלאסית" },
            { "nym", "ניאמווזי" },
            { "nyn", "ניאנקולה" },
            { "nyo", "ניורו" },
            { "nzi", "נזימה" },
            { "ojb", "אוג׳יבווה צפון מערבית" },
            { "ojc", "אוג׳יבווה (מרכז)" },
            { "ojs", "אוג׳י-קרי" },
            { "ojw", "אוביג׳ווה מערבית" },
            { "oka", "אוקאנגן" },
            { "osa", "אוסג׳" },
            { "ota", "טורקית עות׳מנית" },
            { "pag", "פנגסינאן" },
            { "pal", "פלאבי" },
            { "pam", "פמפאניה" },
            { "pap", "פפיאמנטו" },
            { "pau", "פלוואן" },
            { "pcm", "פידגין ניגרי" },
            { "peo", "פרסית עתיקה" },
            { "phn", "פיניקית" },
            { "pis", "פייג׳ין" },
            { "pon", "פונפיאן" },
            { "pqm", "מליסיט-פאסמקוודי" },
            { "prg", "פרוסית" },
            { "pro", "פרובנסאל עתיקה" },
            { "quc", "קיצ׳ה" },
            { "raj", "ראג׳סטאני" },
            { "rap", "רפאנוי" },
            { "rar", "ררוטונגאן" },
            { "rhg", "רוהינגיה" },
            { "rof", "רומבו" },
            { "rom", "רומאני" },
            { "rup", "ארומנית" },
            { "rwk", "ראווה" },
            { "sad", "סנדאווה" },
            { "sah", "סאחה" },
            { "sam", "ארמית שומרונית" },
            { "saq", "סמבורו" },
            { "sas", "סאסק" },
            { "sat", "סאנטאלי" },
            { "sba", "נגמבאי" },
            { "sbp", "סאנגו" },
            { "scn", "סיציליאנית" },
            { "sco", "סקוטית" },
            { "sdh", "כורדית דרומית" },
            { "see", "סנקה" },
            { "seh", "סנה" },
            { "sel", "סלקופ" },
            { "ses", "קויראבורו סני" },
            { "sga", "אירית עתיקה" },
            { "shi", "שילה" },
            { "shn", "שאן" },
            { "shu", "ערבית צ׳אדית" },
            { "sid", "סידאמו" },
            { "slh", "לשוטסיד" },
            { "sma", "סאמי דרומית" },
            { "smj", "לולה סאמי" },
            { "smn", "אינארי סאמי" },
            { "sms", "סקולט סאמי" },
            { "snk", "סונינקה" },
            { "sog", "סוגדיאן" },
            { "srn", "סרנאן טונגו" },
            { "srr", "סרר" },
            { "ssy", "סאהו" },
            { "str", "סאליש מיצרי חואן דה פוקה" },
            { "suk", "סוקומה" },
            { "sus", "סוסו" },
            { "sux", "שומרית" },
            { "swb", "קומורית" },
            { "syc", "סירית קלאסית" },
            { "syr", "סורית" },
            { "szl", "שלזית" },
            { "tce", "טצ׳ון דרומית" },
            { "tem", "טימנה" },
            { "teo", "טסו" },
            { "ter", "טרנו" },
            { "tet", "טטום" },
            { "tgx", "טגישית" },
            { "tht", "טלתנית" },
            { "tig", "טיגרית" },
            { "tiv", "טיב" },
            { "tkl", metaValue_TK },
            { "tlh", "קלינגונית" },
            { "tli", "טלינגיט" },
            { "tmh", "טמאשק" },
            { "tog", "ניאסה טונגה" },
            { "tok", "טוקי פונה" },
            { "tpi", "טוק פיסין" },
            { "trv", "טרוקו" },
            { "tsi", "טסימשיאן" },
            { "ttm", "טצ׳ון צפונית" },
            { "tum", "טומבוקה" },
            { "tvl", metaValue_TV },
            { "twq", "טסוואק" },
            { "tyv", "טובינית" },
            { "tzm", "תמאזיגת של מרכז מרוקו" },
            { "udm", "אודמורט" },
            { "uga", "אוגריתית" },
            { "umb", "אומבונדו" },
            { "und", "שפה לא ידועה" },
            { "vai", "וואי" },
            { "vec", "ונציאנית" },
            { "vmw", "מאקואה" },
            { "vot", "ווטיק" },
            { "vun", "וונג׳ו" },
            { "wae", "וואלסר" },
            { "wal", "ווליאטה" },
            { "war", "ווראי" },
            { "was", "וואשו" },
            { "wbp", "וורלפירי" },
            { "wuu", "סינית וו" },
            { "xal", "קלמיקית" },
            { "xnr", "קאנגרי" },
            { "xog", "סוגה" },
            { "yao", "יאו" },
            { "yap", "יאפזית" },
            { "yav", "יאנגבן" },
            { "ybb", "ימבה" },
            { "yrl", "נינגטו" },
            { "yue", "קנטונזית" },
            { "zap", "זאפוטק" },
            { "zbl", "בליסימבולס" },
            { "zen", "זנאגה" },
            { "zgh", "תמזיע׳ת מרוקאית תקנית" },
            { "zun", "זוני" },
            { "zxx", "ללא תוכן לשוני" },
            { "zza", "זאזא" },
            { "Adlm", "אדלם" },
            { "Aghb", "אלבני קווקזי" },
            { "Ahom", "אהום" },
            { "Arab", "ערבי" },
            { "Aran", "נסתעליק" },
            { "Armi", "ארמית רשמית" },
            { "Armn", "ארמני" },
            { "Avst", "אווסטן" },
            { "Bali", "באלינזי" },
            { "Bamu", metaValue_bax },
            { "Bass", "באסה ואה" },
            { "Batk", "בטק" },
            { "Beng", "בנגלי" },
            { "Bhks", "בהיקסוקי" },
            { "Bopo", "בופומופו" },
            { "Brah", "ברהמי" },
            { "Brai", "ברייל" },
            { "Bugi", "בוגינזי" },
            { "Buhd", "בוהיד" },
            { "Cakm", metaValue_ccp },
            { "Cans", "כתב הברתי קנדי ילידי מאוחד" },
            { "Cari", "קריאן" },
            { "Cham", "צ׳אם" },
            { "Cher", metaValue_chr },
            { "Chrs", "כורזמיאן" },
            { "Copt", "קופטי" },
            { "Cpmn", "ציפרו-מינואן" },
            { "Cprt", "קפריסאי" },
            { "Cyrl", "קירילי" },
            { "Cyrs", "קירילי סלאבוני כנסייתי עתיק" },
            { "Deva", "דוואנגרי" },
            { "Diak", "אותיות אי" },
            { "Dogr", "דוגרה" },
            { "Dsrt", "דסרט" },
            { "Dupl", "קיצור של דובילרן" },
            { "Egyp", "כתב חרטומים" },
            { "Elba", "אלבסאן" },
            { "Elym", "אלימי" },
            { "Ethi", "אתיופי" },
            { "Geor", "גאורגי" },
            { "Glag", "גלגוליטי" },
            { "Gong", "ג’ונג’לה מבולבל" },
            { "Gonm", "מסארם גונדי" },
            { "Goth", "גותי" },
            { "Gran", "גרנתה" },
            { "Grek", "יווני" },
            { "Gujr", "גוג׳רטי" },
            { "Guru", "גורמוקי" },
            { "Hanb", "האן עם בופומופו" },
            { "Hang", "האנגול" },
            { "Hani", "האן" },
            { "Hano", "האנונו" },
            { "Hans", metaValue_Hans },
            { "Hant", "מסורתי" },
            { "Hatr", "חטרן" },
            { "Hebr", "עברי" },
            { "Hira", "הירגאנה" },
            { "Hluw", "הירוגליפים האנטוליים" },
            { "Hmng", "פאהח המונג" },
            { "Hmnp", "ניאקנג פואצ׳ה המונג" },
            { "Hrkt", "הברתי יפני" },
            { "Hung", "הונגרי עתיק" },
            { "Inds", "אינדוס" },
            { "Ital", "איטלקי עתיק" },
            { "Jamo", "ג׳אמו" },
            { "Java", "ג׳אוונזי" },
            { "Jpan", "יפני" },
            { "Kali", "קאי לי" },
            { "Kana", "קטקאנה" },
            { "Khar", "חרושתי" },
            { "Khmr", "חמרי" },
            { "Khoj", "חוג׳קי" },
            { "Kits", "כתב קטן של חיטן" },
            { "Knda", "קאנאדה" },
            { "Kore", "קוריאני" },
            { "Kthi", "קאיתי" },
            { "Lana", "לאנה" },
            { "Laoo", "לאי" },
            { "Latg", "לטיני גאלי" },
            { "Latn", "לטיני" },
            { "Lepc", "לפחה" },
            { "Limb", "לימבו" },
            { "Lina", "ליניארי א" },
            { "Linb", "ליניארי ב" },
            { "Lisu", "פרייזר" },
            { "Lyci", "ליקי" },
            { "Lydi", "לידי" },
            { "Mahj", "מהג׳אני" },
            { "Maka", "מקאסאר" },
            { "Mand", "מנדאית" },
            { "Mani", "מניצ׳י" },
            { "Marc", "מרצ׳ן" },
            { "Maya", "מאיה" },
            { "Medf", "מדפיידרין" },
            { "Mend", metaValue_men },
            { "Merc", "קורסית מרואיטית" },
            { "Mero", "מרואיטית" },
            { "Mlym", metaValue_ml },
            { "Modi", "מודי" },
            { "Mong", "מונגולי" },
            { "Mroo", metaValue_mer },
            { "Mtei", "מאיטי מאייק" },
            { "Mult", "מולטיני" },
            { "Mymr", "מיאנמר" },
            { "Nand", "ננדינאגרי" },
            { "Narb", "ערב צפון עתיק" },
            { "Nbat", "נבטי" },
            { "Newa", "נווארית" },
            { "Nkoo", metaValue_nqo },
            { "Nshu", "נושו" },
            { "Ogam", "אוהם" },
            { "Olck", "אול צ׳יקי" },
            { "Orkh", "אורחון" },
            { "Orya", "אודייה" },
            { "Osge", "אוסייג׳" },
            { "Osma", "אוסמניה" },
            { "Ougr", "אוגורית ישנה" },
            { "Palm", "פלמירן" },
            { "Pauc", "פאו צ׳ין האו" },
            { "Perm", "פרמית ישנה" },
            { "Phag", "פאגס" },
            { "Phli", "פהלווי כתובתי" },
            { "Phlp", "מזמור פהלווי" },
            { "Phnx", "פיניקי" },
            { "Plrd", "פולארד פונטי" },
            { "Prti", "פרטית כתובה" },
            { "Qaag", "זאוגיי" },
            { "Rjng", "רג׳אנג" },
            { "Rohg", "חניפי" },
            { "Runr", "רוני" },
            { "Samr", "שומרונית" },
            { "Sarb", "דרום ערבית" },
            { "Saur", "סאוראשטרה" },
            { "Sgnw", "חתימה" },
            { "Shaw", "שבית" },
            { "Shrd", "שרדה" },
            { "Sidd", "סידהם" },
            { "Sind", "חודוואדי" },
            { "Sinh", metaValue_si },
            { "Sogd", "סוגדית" },
            { "Sogo", "סוגדית עתיקה" },
            { "Sora", "סורה סומפנג" },
            { "Soyo", "סויומבו" },
            { "Sund", "סונדאני" },
            { "Sylo", "סילוטי נגרי" },
            { "Syrc", "סורי" },
            { "Syrj", "סורי מערבי" },
            { "Syrn", "סורי מזרחי" },
            { "Tagb", "טגבנווה" },
            { "Takr", "טאקרי" },
            { "Tale", "טאי לה" },
            { "Talu", "טאי ליו חדש" },
            { "Taml", "טמיל" },
            { "Tang", "טאנגוט" },
            { "Tavt", "טאי וייט" },
            { "Telu", metaValue_te },
            { "Tfng", "טיפינה" },
            { "Tglg", "טגלוג" },
            { "Thaa", "תאנה" },
            { "Thai", "תאי" },
            { "Tibt", "טיבטי" },
            { "Tirh", "תרותא" },
            { "Tnsa", "טנגסה" },
            { "Toto", "טוטו" },
            { "Ugar", "אוגריתי" },
            { "Vaii", "ואי" },
            { "Vith", "ויטוקוקי" },
            { "Wara", "ווראנג סיטי" },
            { "Wcho", "וונצ׳ו" },
            { "Xpeo", "פרסי עתיק" },
            { "Xsux", "כתב היתדות השומרי-אכדי" },
            { "Yezi", "יעזי" },
            { "Yiii", "יי" },
            { "Zanb", "כיכר זנבזר" },
            { "Zinh", "מורש" },
            { "Zmth", "סימון מתמטי" },
            { "Zsye", "אמוג׳י" },
            { "Zsym", "סמלים" },
            { "Zxxx", "לא כתוב" },
            { "Zyyy", "רגיל" },
            { "Zzzz", "כתב שאינו ידוע" },
            { "fa_AF", "דארי" },
            { "nl_BE", "הולנדית (פלמית)" },
            { "ro_MD", "מולדבית" },
            { "sw_CD", "סווהילי קונגו" },
            { "%%1901", "כתיב גרמני מסורתי" },
            { "%%1994", "כתיב רזיאני סטנדרטי" },
            { "%%1996", "כתיב גרמני משנת 1996" },
            { "ar_001", "ערבית ספרותית" },
            { "key.ca", "לוח שנה" },
            { "key.cf", "תבנית מטבע" },
            { "key.co", "סדר מיון" },
            { "key.cu", "מטבע" },
            { "key.hc", "מחזור השעות (12 או 24)" },
            { "key.lb", "סגנון מעבר שורה" },
            { "key.ms", "מערכת מדידה" },
            { "key.nu", "מספרים" },
            { "key.tz", "אזור זמן" },
            { "key.va", "משתנה אזור" },
            { "nds_NL", "סקסונית תחתית" },
            { "%%ALUKU", "ניב אלוקו" },
            { "%%BARLA", "קבוצת ניב ברלבנטו של קבוברדיאנו" },
            { "%%BISKE", "ניב סן ג׳ורג׳יו / בילה" },
            { "%%BOONT", "פונטי" },
            { "%%CORNU", "קורנו" },
            { "%%JAUER", "יאואר" },
            { "%%KKCOR", "כתיב משותף" },
            { "%%KSCOR", "כתיב סטנדרטי" },
            { "%%LIPAW", "ניב ליפובז של רזיאן" },
            { "%%NEDIS", "ניב נטיסון" },
            { "%%NJIVA", "ניב גניבה/נג׳יבה" },
            { "%%NULIK", "וולפוק מודרני" },
            { "%%OSOJS", "ניב אוסאקו/אוסוג׳אן" },
            { "%%PEANO", "פיאנו" },
            { "%%POSIX", "מחשב" },
            { "%%PUTER", "פוטיר" },
            { "%%RIGIK", "וולפוק קלאסי" },
            { "%%ROZAJ", "רזיאן" },
            { "%%RUMGR", "רמגר" },
            { "%%SAAHO", "סהו" },
            { "%%SOLBA", "ניב סטולביצה/סולביקה" },
            { "%%SOTAV", "קבוצת ניב סוטוונטו של קבוברדיאנו" },
            { "%%UCCOR", "כתיב מאוחד" },
            { "zh_Hans", "סינית פשוטה" },
            { "zh_Hant", "סינית מסורתית" },
            { "%%AO1990", "הסכם אורטוגרפי בשפה הפורטוגזית משנת 1990" },
            { "%%ARANES", "ארנס" },
            { "%%ASANTE", "אסאנטי" },
            { "%%AUVERN", "אוברן" },
            { "%%CISAUP", "קיסאופ" },
            { "%%CREISS", "קריס" },
            { "%%DAJNKO", "דז׳נקו" },
            { "%%EKAVSK", "סרבית עם הגייה של האקיבי" },
            { "%%FONIPA", "אלפבית פונטי בינלאומי" },
            { "%%FONUPA", "אלפבית פונטי אוראלי" },
            { "%%GASCON", "גסקון" },
            { "%%GRITAL", "גריטל" },
            { "%%NDYUKA", "ניב נידוקה" },
            { "%%NICARD", "ניקארד" },
            { "%%PAMAKA", "ניב פמקה" },
            { "%%PINYIN", "פיניין, שיטת כתב סיני בתעתיק לטיני" },
            { "%%SCOUSE", "סקוס" },
            { "%%SIMPLE", metaValue_Hans },
            { "%%TARASK", "כתיב טרסקייביקה" },
            { "%%UCRCOR", "כתיב מתוקן מאוחד" },
            { "%%ULSTER", "אלסטר" },
            { "%%UNIFON", "אלפבית פונטי יוניפון" },
            { "%%ABL1943", "ניסוח אורטוגרפי משנת 1943" },
            { "%%AKUAPEM", "אקואפם" },
            { "%%ALALC97", "ALA-LC הרומניזציה, מהדורת 1997" },
            { "%%AREVELA", "מזרח ארמנית" },
            { "%%AREVMDA", "מערב ארמנית" },
            { "%%ARKAIKA", "ארקייקה" },
            { "%%BALANKA", "ניב בלנקה של אניי" },
            { "%%BAUDDHA", "באודה" },
            { "%%BOHORIC", "אלפבית בוהוריץ׳" },
            { "%%EMODENG", "אנגלית מודרנית מוקדמת" },
            { "%%FONNAPA", "פונאפה" },
            { "%%GRCLASS", "גרקלס" },
            { "%%GRMISTR", "גרמיסטר" },
            { "%%HEPBURN", "הרמוניזציה של הפבורן" },
            { "%%ITIHASA", "איטהאסה" },
            { "%%LAUKIKA", "לאוקיקה" },
            { "%%LEMOSIN", "למוסין" },
            { "%%METELKO", "אלפבית מטלקו" },
            { "%%MONOTON", "מונוטונית" },
            { "%%PAHAWH2", "פאהווה2" },
            { "%%PAHAWH3", "פאהווה3" },
            { "%%PAHAWH4", "פאהווה4" },
            { "%%POLYTON", "פוליטונית" },
            { "%%PROVENC", "פרובאנס" },
            { "%%REVISED", "כתיב מתוקן" },
            { "%%SURSILV", "סורסילב" },
            { "%%SUTSILV", "סוצילב" },
            { "%%VAIDIKA", "ויידיקה" },
            { "%%1606NICT", "צרפתית אמצעית מאוחרת עד 1606" },
            { "%%1694ACAD", "צרפתית מודרנית קדומה" },
            { "%%1959ACAD", "אקדמי" },
            { "%%BAKU1926", "אלפבית לטיני טורקי מאוחד" },
            { "%%BASICENG", "באסיקנג" },
            { "%%BISCAYAN", "ביסקאי" },
            { "%%BORNHOLM", "בורנהולם" },
            { "%%COLB1945", "הסכם אורטוגרפי בשפה הפורטוגזית משנת 1945" },
            { "%%FONKIRSH", "פונקירש" },
            { "%%FONXSAMP", "פונקסאמפ" },
            { "%%HOGNORSK", "הונגנורסק" },
            { "%%HSISTEMO", "הסיסטמו" },
            { "%%IJEKAVSK", "סרבית עם הגייה של איג׳קביאן" },
            { "%%IVANCHOV", "איבנשוב" },
            { "%%JYUTPING", "ג׳יוטפינג" },
            { "%%KOCIEWIE", "קוסייווי" },
            { "%%LENGADOC", "לנגדוק" },
            { "%%LUNA1918", "לונה1918" },
            { "%%NEWFOUND", "ניופונד" },
            { "%%OXENDICT", "איות מילון אנגלית של אוקספורד" },
            { "%%PETR1708", "פוטיר1708" },
            { "%%SCOTLAND", "אנגלית סקוטית סטנדרטית" },
            { "%%SPANGLIS", "ספנגליס" },
            { "%%SURMIRAN", "סורמיר" },
            { "%%TONGYONG", "טונגיונג" },
            { "%%TUNUMIIT", "טונומייט" },
            { "%%VALENCIA", "ולנסיה" },
            { "%%VALLADER", "ואלאדר" },
            { "%%VECDRUKA", "וקדרוקה" },
            { "%%VIVARAUP", "ויואראופ" },
            { "%%WADEGILE", "ווייד-גיילס, שיטה לתעתוק סינית לאותיות לטיניות" },
            { "%%XSISTEMO", "קסיסטמו" },
            { "type.ca.roc", "לוח השנה הטייוואני" },
            { "type.co.eor", "חוקי סדר אירופיים" },
            { "type.hc.h11", "מערכת של 12 שעות (‎0–11)" },
            { "type.hc.h12", "מערכת של 12 שעות (‎1–12)" },
            { "type.hc.h23", "מערכת של 24 שעות (0‎–23)" },
            { "type.hc.h24", "מערכת של 24 שעות (1‎–24)" },
            { "type.m0.bgn", "תעתיק BGN ארה״ב" },
            { "type.nu.ahom", "ספרות אהום" },
            { "type.nu.arab", "ספרות הודיות-ערביות" },
            { "type.nu.armn", "ספרות ארמניות" },
            { "type.nu.bali", "ספרות באלינתיות" },
            { "type.nu.beng", "ספרות בנגליות" },
            { "type.nu.brah", "ספרות ברהמי" },
            { "type.nu.cakm", "ספרות של צ׳קמה" },
            { "type.nu.cham", "ספרות צ׳אם" },
            { "type.nu.cyrl", "ספרות קיריליות" },
            { "type.nu.deva", "ספרות של דוונגארי" },
            { "type.nu.diak", "ספרות אקורו דיפס" },
            { "type.nu.ethi", "ספרות אתיופיות" },
            { "type.nu.geor", "ספרות גאורגיות" },
            { "type.nu.gong", "ספרות של ג׳ונג׳לה גונדי" },
            { "type.nu.gonm", "ספרות מסארם גונדי" },
            { "type.nu.grek", "ספרות יווניות" },
            { "type.nu.gujr", "ספרות גוג׳רטיות" },
            { "type.nu.guru", "ספרות גורמוקיות" },
            { "type.nu.hans", "ספרות סיניות פשוטות" },
            { "type.nu.hant", "ספרות סיניות מסורתיות" },
            { "type.nu.hebr", "ספרות עבריות" },
            { "type.nu.hmng", "ספרות פאהח המונג" },
            { "type.nu.hmnp", "ספרות המונג פוצ׳ו יאקנג" },
            { "type.nu.java", "ספרות ג׳אוואניות" },
            { "type.nu.jpan", "ספרות יפניות" },
            { "type.nu.kali", "ספרות קיה ליי" },
            { "type.nu.khmr", "ספרות חמריות" },
            { "type.nu.knda", "ספרות של קאנאדה" },
            { "type.nu.lana", "ספרות טאי תם הורה" },
            { "type.nu.laoo", "ספרות של לאוס" },
            { "type.nu.latn", "ספרות מערביות" },
            { "type.nu.lepc", "ספרות לפחה" },
            { "type.nu.limb", "ספרות לימבו" },
            { "type.nu.mlym", "ספרות של מליאלאם" },
            { "type.nu.modi", "ספרות מודי" },
            { "type.nu.mong", "ספרות מונגוליות" },
            { "type.nu.mroo", "ספרות מרו" },
            { "type.nu.mtei", "ספרות של מיטיי מאייק" },
            { "type.nu.mymr", "ספרות של מיאנמר" },
            { "type.nu.nkoo", "ספרות נקו" },
            { "type.nu.olck", "ספרות אול צ׳יקי" },
            { "type.nu.orya", "ספרות אוריה" },
            { "type.nu.osma", "ספרות אוסמניה" },
            { "type.nu.rohg", "ספרות חניפי רוהינגיה" },
            { "type.nu.saur", "ספרות סאוראשטרה" },
            { "type.nu.shrd", "ספרות שרדה" },
            { "type.nu.sind", "ספרות חודוואדי" },
            { "type.nu.sinh", "ספרות ליטה בסינהלה" },
            { "type.nu.sora", "ספרות סורה סומפנג" },
            { "type.nu.sund", "ספרות סונדאניות" },
            { "type.nu.takr", "ספרות טקרי" },
            { "type.nu.talu", "ספרות טאי לואה חדשות" },
            { "type.nu.taml", "ספרות טמיליות מסורתיות" },
            { "type.nu.telu", "ספרות טלוגו" },
            { "type.nu.thai", "ספרות תאיות" },
            { "type.nu.tibt", "ספרות טיבטיות" },
            { "type.nu.tirh", "ספרות תרחותא" },
            { "type.nu.tnsa", "ספרות טנגסה" },
            { "type.nu.vaii", "ספרות ואי" },
            { "type.nu.wara", "ספרות ווראנג סיטי" },
            { "type.nu.wcho", "ספרות וונצ׳ו" },
            { "type.ca.dangi", "לוח השנה הקוריאני" },
            { "type.co.ducet", "סדר מיון Unicode המוגדר כברירת מחדל" },
            { "type.co.emoji", "סדר מיון אימוג׳י" },
            { "type.lb.loose", "סגנון מעבר שורה גמיש" },
            { "type.nu.roman", "ספרות רומיות" },
            { "type.ca.coptic", "לוח השנה הקופטי" },
            { "type.ca.hebrew", "לוח השנה העברי" },
            { "type.ca.indian", "לוח השנה ההודי הלאומי" },
            { "type.co.compat", "סדר מיון קודם, עבור תאימות" },
            { "type.co.pinyin", "מיון פיניין" },
            { "type.co.search", "חיפוש למטרה כללית" },
            { "type.co.stroke", "סדר מיון לפי ספירת תווים" },
            { "type.co.unihan", "סדר מיון לפי ספירת תווים Radical-Stroke" },
            { "type.co.zhuyin", "סדר מיון של ג׳ואין" },
            { "type.d0.fwidth", "רוחב מלא" },
            { "type.d0.hwidth", "חצי רוחב" },
            { "type.lb.normal", "סגנון מעבר שורה רגיל" },
            { "type.lb.strict", "סגנון מעבר שורה קשיח" },
            { "type.m0.ungegn", "תעתיק GEGN האו״ם" },
            { "type.ms.metric", "מערכת מטרית" },
            { "type.nu.native", "ספרות מקומיות" },
            { "type.ca.chinese", "לוח השנה הסיני" },
            { "type.ca.islamic", "לוח שנה ההיג׳רי" },
            { "type.ca.iso8601", "לוח שנה ISO-8601" },
            { "type.ca.persian", "לוח השנה הפרסי" },
            { "type.cf.account", "תבנית מטבע למטרות חשבונאות" },
            { "type.co.big5han", "מיון סינית מסורתית" },
            { "type.d0.npinyin", "מספרי" },
            { "type.nu.arabext", "ספרות הודיות-ערביות מורחבות" },
            { "type.nu.armnlow", "ספרות ארמניות קטנות" },
            { "type.nu.finance", "ספרות פיננסיות" },
            { "type.nu.greklow", "ספרות יווניות קטנות" },
            { "type.nu.hanidec", "ספרות סיניות עשרוניות" },
            { "type.nu.hansfin", "ספרות פיננסיות סיניות פשוטות" },
            { "type.nu.hantfin", "ספרות פיננסיות סיניות מסורתיות" },
            { "type.nu.jpanfin", "ספרות פיננסיות יפניות" },
            { "type.nu.mathdbl", "ספרות מתמטיות סטרוק כפולות" },
            { "type.nu.tamldec", "ספרות טמיליות" },
            { "type.ca.buddhist", "לוח השנה הבודהיסטי" },
            { "type.ca.ethiopic", "לוח השנה האתיופי" },
            { "type.ca.japanese", "לוח השנה היפני" },
            { "type.cf.standard", "תבנית מטבע רגילה" },
            { "type.co.phonetic", "סדר מיון פונטי" },
            { "type.co.searchjl", "חפש לפי העיצור הראשון באותיות הנגול" },
            { "type.co.standard", "סדר מיון רגיל" },
            { "type.ms.uksystem", "מערכת מדידה אימפריאלית" },
            { "type.ms.ussystem", "מערכת מדידה אמריקאית" },
            { "type.nu.fullwide", "ספרות ברוחב מלא" },
            { "type.nu.lanatham", "ספרות טאי תם תם" },
            { "type.nu.mathbold", "ספרות מודגשות מתמטיות" },
            { "type.nu.mathmono", "ספרות חד-מרחביות מתמטיות" },
            { "type.nu.mathsanb", "ספרות מודגשות מתמטיות של סאנס סריף" },
            { "type.nu.mathsans", "ספרות סאנס סריף מתמטיות" },
            { "type.nu.mymrshan", "ספרות מיאנמר שאן" },
            { "type.nu.mymrtlng", "ספרות טאי לאינג במיאנמר" },
            { "type.nu.romanlow", "ספרות רומיות קטנות" },
            { "type.ca.gregorian", "לוח השנה הגרגוריאני" },
            { "type.co.gb2312han", "סדר מיון סיני פשוט - GB2312" },
            { "type.co.phonebook", "מיון ספר טלפונים" },
            { "ListKeyTypePattern", "{0}:‏ {1}" },
            { "type.co.dictionary", "סדר מיון במילון" },
            { "type.co.traditional", "מיון מסורתי" },
            { "type.nu.traditional", "ספרות מסורתיות" },
            { "type.ca.islamic-rgsa", "לוח השנה המוסלמי (ערב הסעודית)" },
            { "type.ca.islamic-tbla", "לוח השנה המוסלמי האסטרונומי" },
            { "type.ca.islamic-civil", "לוח השנה המוסלמי האזרחי" },
            { "type.ca.islamic-umalqura", "לוח השנה המוסלמי אום אל-קורא" },
            { "type.ca.ethiopic-amete-alem", "לוח השנה אמטה אלם האתיופי" },
        };
        return data;
    }
}
