/*
 * Copyright (c) 2024, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

// Generated by jextract

package jdk.internal.ffi.generated.errno;

import java.lang.foreign.*;
import java.lang.invoke.*;

@SuppressWarnings("restricted")
public class errno_h extends errno_h$shared {

    errno_h() {
        // Should not be called directly
    }

    static final Arena LIBRARY_ARENA = Arena.ofAuto();

    static final SymbolLookup SYMBOL_LOOKUP = SymbolLookup.loaderLookup()
            .or(Linker.nativeLinker().defaultLookup());

    private static final int EINTR = (int)4L;
    /**
     * {@snippet lang=c :
     * #define EINTR 4
     * }
     */
    public static int EINTR() {
        return EINTR;
    }

    private static class strerror_r {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(
                C_INT,
                C_INT,
                C_POINTER,
                C_LONG
        );

        public static final MemorySegment ADDR = SYMBOL_LOOKUP.findOrThrow("strerror_r");

        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC);
    }

    /**
     * Function descriptor for:
     * {@snippet lang=c :
     * int strerror_r(int __errnum, char *__strerrbuf, size_t __buflen)
     * }
     */
    public static FunctionDescriptor strerror_r$descriptor() {
        return strerror_r.DESC;
    }

    /**
     * Downcall method handle for:
     * {@snippet lang=c :
     * int strerror_r(int __errnum, char *__strerrbuf, size_t __buflen)
     * }
     */
    public static MethodHandle strerror_r$handle() {
        return strerror_r.HANDLE;
    }

    /**
     * Address for:
     * {@snippet lang=c :
     * int strerror_r(int __errnum, char *__strerrbuf, size_t __buflen)
     * }
     */
    public static MemorySegment strerror_r$address() {
        return strerror_r.ADDR;
    }

    /**
     * {@snippet lang=c :
     * int strerror_r(int __errnum, char *__strerrbuf, size_t __buflen)
     * }
     */
    public static int strerror_r(int __errnum, MemorySegment __strerrbuf, long __buflen) {
        var mh$ = strerror_r.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("strerror_r", __errnum, __strerrbuf, __buflen);
            }
            return (int)mh$.invokeExact(__errnum, __strerrbuf, __buflen);
        } catch (Error | RuntimeException ex) {
           throw ex;
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }
}
